#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Youngest in Family' => 'Youngest in Family',
	   'Main' => 'Main',
	   'Name' => 'Name',
	   'Parent 1' => 'Parent 1',
	   'Parent 2' => 'Parent 2',
	   'Grade' => 'Grade',
	   'Homeroom' => 'Homeroom',
	   'Sort by' => 'Sort by',
	   'Select' => 'Select',
	   'Error' => 'Error',
	   'Blank=All' => 'Blank=All',
	   'Continue' => 'Continue',

	   );

my $self = 'rptyoungest.pl';

use DBI;
use CGI;

eval require "../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, 
    $iddst) = localtime(time);
$year = $year + 1900;
$mon++;
$wday++;
my $currdate = "$dow[$wday], $month[$mon] $mday, $year";

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



my $sortorder = "lastname, firstname";
if ( $arr{sortorder} eq 'homeroom' ) {
    $sortorder = 'homeroom, lastname, firstname';
} elsif ( $arr{sortorder} eq 'grade' ) {
    $sortorder = 'grade, lastname, firstname';
}


my $select;
if ( $arr{group} or $arr{homeroom} ) {
    if ( $arr{select} eq 'grade' ) { # Find this grade;
	my $grp = $dbh->quote( $arr{group} );
	$select = "and grade = $grp";
    } elsif ( $arr{select} eq 'homeroom' ) {
	my $grp = $dbh->quote( $arr{group} );
	$select = "and homeroom = $grp";
    } else { # must be old homeroom...
	my $homeroom = $dbh->quote($arr{homeroom});
	$select = "and homeroom = $homeroom";
    }
}


# Print Page Header
print qq{$doctype\n<html><head><title>$lex{'Youngest in Family'}</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body>\n};

print qq{<div style="display:inline;">};
print qq{[ <a href="$homepage">$lex{Main}</a> ]\n};


# Start of Form
print qq{<form action="$self" method="post" style="display:inline;">\n};
print qq{<input type="hidden" name="page" value="1">\n};
print qq{<b>$lex{'Sort by'}</b>\n};
print qq{<select name="sortorder">\n};

print qq{<option value="name">$lex{Name}</option>\n};
print qq{<option value="homeroom">$lex{Homeroom}</option>\n};
print qq{<option value="grade">$lex{Grade}</option>\n};

print qq{</select>\n};


print qq{<b>Select by</b> <select name="select">\n};
print qq{<option value="grade">$lex{Grade}</option>\n};
print qq{<option value="homeroom">$lex{Homeroom}</option>\n};
print qq{</select>\n};
print qq{<input type="text" name="group" style="width:4ch;" value="$arr{group}">\n};

print qq{<input type="submit" value="$lex{Continue}">\n};

print qq{</form>$lex{'Blank=All'}</div>\n};


print qq{<h1>$lex{'Youngest in Family'}</h1>\n};
print qq{<h3>$schoolname<br>$currdate</h3>\n};


if ( not $arr{page} ) { # stop if just first entry
    print qq{</body></html>\n};
    exit;
}


# Select Data
my $sth = $dbh->prepare("select lastname, firstname, initial, homeroom, grade, youngest, 
  relation1, name1, hphone1, wphone1, relation2, name2, hphone2, wphone2 from student 
  where ( youngest is not null and youngest <> '' ) $select order by $sortorder");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }



my $curroom = -1;
my $first = 1;

while ( my ($lastname, $firstname, $middlename, $homeroom, $grade, $youngest, 
  $relation1, $parent1, $hphone1, $wphone1, $relation2, $parent2, $hphone2, $wphone2) = $sth->fetchrow) {

    $oldroom = $curroom;
    $curroom = $hroom;
  
    if ($curroom ne $oldroom) {
	if ( not $first) {
	    print qq{</table><p></p>\n};
	} else {
	    $first = 0;
	}
	print qq{<table border="1" cellpadding ="3" cellspacing="0">\n};
	print qq{<tr><th>$lex{Name}</th><th>$lex{'Parent 1'}</th><th>$lex{'Parent 2'}</th></tr>\n};
    } 

    print qq{<tr><td><b>$lastname</b>, $firstname $middlename<br>};
    print qq{<b>Gr:</b> $grade<br><b>Hr:</b> $homeroom</td>\n};
    print qq{<td><b>Rel:</b> $relation1<br>$parent1<br>H:$hphone1<br>W:$wphone1</td>\n};
    print qq{<td><b>Rel:</b> $relation2<br>$parent2<br>H:$hphone2<br>W:$wphone2</td></tr>\n};
  
}

if ( $first ) {
    print qq{<h3>No Youngest Records found</h3>\n};
}

print qq{</body></html>\n};
