#!/usr/bin/perl
# Copyright Les Richardson 2001-2018

# This file is part of Open Administration for Schools. Released under GPL Licensing.

my %lex = ('Reset' => 'Reset',
	   'Course' => 'Course',
	   'Courses' => 'Courses',
	   'Main' => 'Main',
	   'Eoy' => 'Eoy',
	   'Continue' => 'Continue',
	   'Fields' => 'Fields',
	   'Field' => 'Field',
	   'Type' => 'Type',
	   'Enter Values' => 'Enter Values',
	   'Select from List' => 'Select from List',
	   'No Field Selected' => 'No Field Selected',
	   'Field Fill' => 'Field Fill',
	   'Grade' => 'Grade',
	   'Homeroom' => 'Homeroom',
	   'Student Group' => 'Student Group',
	   'Separate with Spaces' => 'Separate with Spaces',
	   'Blank=All' => 'Blank=All',
	   'Student' => 'Student',
	   'Contact' => 'Contact',
	   'Error' => 'Error',
	   'Record(s) Updated' => 'Record(s) Updated',
	   'Blank' => 'Blank',
	   'Students' => 'Students',
	   'Current' => 'Current',
	   'Withdrawn' => 'Withdrawn',
	   'Update' => 'Update',
	   'Select' => 'Select',

	   );


my $self = 'coursedelete.pl';

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}


my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# Show top of page.
my $title = qq{Course Delete};

print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> ]\n};

print qq{<h1>$title</h1>\n};





if ( not $arr{page} ) {
    getGrade();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    showCodes();
    
} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    deleteCodes();
}



#-----------
sub getGrade {  # get the grade for entry.
#-----------

    print qq{<h3>Select Grade</h3>\n};

    my @grades;
    $sth = $dbh->prepare("select distinct grade from student");
    $sth->execute;
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    while ( my $grade = $sth->fetchrow ) {
	push @grades, $grade;
    }

    @grades = sort {$a <=> $b} @grades;

      
    print qq{<table cellpadding="3" cellspacing="0" border="0">\n};
    print qq{<tr><th>Select Grade</th></tr>\n};

    foreach my $grade ( @grades ) {
	print qq{<tr><td>};
	print qq{<form action="$self" method="post">\n};
	print qq{<input type="hidden" name="page" value="1">\n};
	print qq{<input type="hidden" name="grade" value="$grade">\n};
	print qq{<input type="submit" value="$lex{Grade} $grade">\n};
	print qq{</form></td></tr>\n};
    }
    
    print qq{</table>\n};
    print qq{</body></html>\n};

    exit;

}


#--------------
sub deleteCodes {
#--------------
    
    # foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    my $sth = $dbh->prepare("delete from sasked_courses where id = ?");
    
    foreach my $id ( keys %arr ) {
	$sth->execute( $id );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    }

    print qq{<h3>Courses Deleted</h3>\n};

    print qq{<div>[ <a href="$self">Restart</a> ]</div>\n};
    print qq{</body></html>\n};
	
    exit;
    
}




#--------------
sub showCodes {
#--------------
    
    # foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }
    # Passed: Grade

    print qq{<h3>Grade $arr{grade}</h3>\n};
    

    my $sth = $dbh->prepare("select * from sasked_courses where ( enddate is NULL or enddate = '0000-00-00' ) 
      and grade = ? order by code");
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    $sth->execute( $arr{grade} );

    # print which students we're viewing
    print qq{<h3>Sask Ed Courses</h3>\n};

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n};
    
    print qq{<table cellpadding="4" cellspacing="0" border="1" style="background-color:#CCD;">\n};
    print qq{<tr><th>Delete!</th><th>Course</th><th>Code</th><th>Start</th><th>End</th><th>Grade</th>};
    print qq{<th>Type</th></tr>\n};
    print qq{<caption style="font-weight:bold;font-size:120%;">};
    print qq{Courses without end dates are active courses.</caption>\n};
    print qq{<tr><td colspan="10"><input type="submit" value="Update"></td></tr>\n};

    
    # Loop through Courses
    my $count = 1;
    while ( my $ref = $sth->fetchrow_hashref ) {
	my %r = %$ref;
	if ( $r{enddate} eq '0000-00-00' ) { $r{enddate} = ''; }
	
	print qq{<tr><td class="cn"><input type="checkbox" name="$r{id}" value="1"></td>};
	print qq{<td>$count. $r{title}</td><td>$r{code}</td><td>$r{startdate}</td><td>$r{enddate}</td>};
	print qq{<td>$r{grade}</td><td>$r{ctype}</td></tr>\n};
	$count++;
	if ( $count % 20 == 1 ) {
	    print qq{<tr><th>Delete</th><th>Course</th><th>Code</th><th>Start</th><th>End</th><th>Grade</th>};
	    print qq{<th>Type</th></tr>\n};
	    print qq{<tr><td colspan="10"><input type="submit" value="Update"></td></tr>\n};
	}

	
    } # End of Course Loop

    print qq{</table></body></html>\n};

    exit;

} # end of selectChanges

