#!/usr/bin/perl
# Copyright Les Richardson 2001-2019

# This file is part of Open Administration for Schools. Released under GPL Licensing.

my %lex = ('Reset' => 'Reset',
	   'Main' => 'Main',
	   'Eoy' => 'Eoy',
	   'Continue' => 'Continue',
	   'Fields' => 'Fields',
	   'Field' => 'Field',
	   'Type' => 'Type',
	   'Enter Values' => 'Enter Values',
	   'Select from List' => 'Select from List',
	   'No Field Selected' => 'No Field Selected',
	   'Field Fill' => 'Field Fill',
	   'Grade' => 'Grade',
	   'Homeroom' => 'Homeroom',
	   'Student Group' => 'Student Group',
	   'Separate with Spaces' => 'Separate with Spaces',
	   'Blank=All' => 'Blank=All',
	   'Student' => 'Student',
	   'Contact' => 'Contact',
	   'Error' => 'Error',
	   'Record(s) Updated' => 'Record(s) Updated',
	   'Blank' => 'Blank',
	   'Students' => 'Students',
	   'Current' => 'Current',
	   'Withdrawn' => 'Withdrawn',
	   'Update' => 'Update',
	   'Select' => 'Select',

	   );


my $self = 'resetaddress.pl';
my $maxTypeCount = 30; # don't allow more than $maxTypeCount different types in a selection list
my %disallow = qw(studid 1 grade 1 homeroom 1 medical 1 utag 1 owing 1 studnum 1 entry 1); # double since a HASH.


use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# Show top of page.
my $title = qq{$lex{Reset}/Fill $lex{Student} Address};

print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> | \n};
print qq{<a href="$exppage">Export</a> ]\n};

print qq{<h1>$title</h1>\n};


# Select what to do.
if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    selectChanges();

} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    writeChanges();
}


#----------------
sub showStartPage {
#----------------


    # Start the form.
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};
    print qq{<input type="submit" value="$lex{Continue}">\n};

    print qq{<table cellpadding="3" cellspacing="0" border="1" };
    print qq{style="background-color:#CCD;">\n};
    print qq{<tr><th>Blank Fill Field</th><th>Fill Value</th></tr>\n};

    # Address 1
    print qq{<tr><td class="ra">Address 1</td><td>\n};
    print qq{<input type="text" name="address1" style="width:30ch;"></td></tr>\n};

    # City 1
    print qq{<tr><td class="ra">City 1</td><td>\n};
    print qq{<input type="text" name="city1" style="width:30ch;"></td></tr>\n};

    # Postal Code
    print qq{<tr><td class="ra">Postal Code 1</td><td>\n};
    print qq{<input type="text" name="pcode1" style="width:30ch;"></td></tr>\n};


    # Blank Fill?
    print qq{<tr><td class="ra">Blank Fill?</td><td>\n};
    print qq{<input type="checkbox" name="blankfill" value="1"></td></tr>\n};

    my @grades;
    my $sth = $dbh->prepare("select distinct grade from student where grade is not NULL and grade != ''");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $grade = $sth->fetchrow ) {
	push @grades, $grade;
    }

    # Grade
    print qq{<tr><td class="ra">Select Grade</td><td>\n};
    print qq{<select name="grade"><option></option>\n};
    foreach my $grade ( sort {$a<=> $b} @grades ) {
	print qq{<option>$grade</option>\n};
    }
    print qq{</select></td></tr>\n};

    
    # Continue
    print qq{</table>\n};
    print qq{<input type="submit" value="$lex{Continue}">\n};
    print qq{</form></body></html>\n};

    exit; 


} # end of showStartPage


#----------------
sub selectChanges {
#----------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $tableview = "<h3>$lex{Current} $lex{Students}</h3>\n";

    my $grade = $arr{grade};
    delete $arr{grade};
    if ( not $grade ) {
	print qq{<h3>Error: No Grade Selected!</h3>\n};
	print qq{</body></html>\n};
	exit;
    }

    
    $sth = $dbh->prepare("select studnum from student where grade = ? order by lastname, firstname");
    $sth->execute( $grade );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $studnum = $sth->fetchrow ) {
	push @students, $studnum;
    }


    $sth = $dbh->prepare("select * from student where studnum = ?");
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    # print which students we're viewing
    print $tableview, "\n";


    # Start the Form...
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n};

    print qq{<input type="submit" value="$lex{Update}">\n};

    print qq{<table cellpadding="4" cellspacing="0" border="1" style="background-color:#CCD;">\n};
    print qq{<tr><th>$lex{Student}</th><th>$lex{Grade}/$lex{Homeroom}</th>};
    print qq{<th>Address 1</th><th>City 1</th><th>Prov 1</th><th>Postal Code 1</th></tr>\n};


    # Loop through students
    foreach my $studnum ( @students ) {

	# Get Student Info
	$sth->execute( $studnum );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my $ref = $sth->fetchrow_hashref;
	my %r = %$ref;
	my $studid = $r{studid};

	# If no field in current record, and we have default fill set, then put it in...
	if ( $arr{blankfill} ) {
	    if ( not $r{address1} ) { $r{address1} = $arr{address1}; }
	    if ( not $r{city1} ) { $r{city1} = $arr{city1}; }
	    if ( not $r{pcode1} ) { $r{pcode1} = $arr{pcode1}; }
	    if ( not $r{prov1} ) { $r{prov1} = 'SK'; }
	}

	# Print Main Fields
	print qq{<tr><td><b>$r{lastname}</b>, $r{firstname} ($r{studnum})</td>};
	print qq{<td>$r{grade} / $r{homeroom}</td>\n};

	# Address 1
	print qq{<td><input type="text" name="$studid:address1" style="width:30ch;" value="$r{address1}"></td>\n};

	# City 1
	print qq{<td><input type="text" name="$studid:city1" style="width:20ch;" value="$r{city1}"></td>\n};

	# Province
	print qq{<td><input type="text" name="$studid:prov1" style="width:3ch;" value="$r{prov1}"></td>\n};

	# Postal Code 1
	print qq{<td><input type="text" name="$studid:pcode1" style="width:10ch;" value="$r{pcode1}"></td>\n};


	print qq{</tr>\n};
	

    } # End of Student Loop

    print qq{</table><input type="submit" value="$lex{Update}">\n};
    print qq{</form></body></html>\n};

    exit;

} # end of selectChanges




#---------------
sub writeChanges {
#---------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    foreach my $key ( sort keys %arr ) {
	my ($id, $fld ) = split(':', $key);
	my $sth = $dbh->prepare("update student set $fld = ? where studid = ?");
	$sth->execute( $arr{$key}, $id );
	print qq{ID:$id FIELD:$fld VALUE:$arr{$key}<br>\n};
	if ($DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    }

    print qq{<h3>$lex{'Record(s) Updated'}</h3>};
    print qq{</body></html>\n};

    exit;

} # end of writeChanges
