#!/usr/bin/perl

# A program to copy updated scripts into all school folders at one time. 
#  
# School Location Array: full path location of school files.
#  NO trailing / please.

# Read config variables
eval require "./schooldir.conf";
if ( $@ ) {
    print "Error: $@<br>\n";
    die "Error: $@\n";
}

push @schloc, "/opt/openadmin/training";


# ======== No need to change anything below here unless you just 'gotta ====

if (not @ARGV) {
    die "\nUsage: update_admincss  admin.css (containing new CSS values) \n\n";
}

my $filename = $ARGV[0];
my $subdir = 'admin';

if ( $filename ne 'admin.css' ) {
    print "File not admin.css\n";
    exit;
}

# Read in admin.css file
unless (open ( FH,"<", $filename )) {
	print $lex{'Cannot open file'}. ": $!\n";
	die $lex{'Cannot open file'}. ": $!\n";
}
my $newtext;
{ local $/; $newtext = <FH>; close FH;}

$newtext =~ m/<<Color:(.*)>>/;
my $oldcolor = $1;


foreach $directory (@schloc){

#   if ( -l "$directory/$subdir/$filename" ) { # if symbolic link, skip and notify
#      print "\nSKIP SYMBOLIC LINK: $directory/$subdir/$filename\n\n";
#	next; 
#    }

    #open the admin.css there and get the color
    unless ( open ( FH,"<", "$directory/$subdir/admin.css" )) {
	print "$lex{'Cannot open file'} $directory/$subdir/admin.css: $!\n";
	die "$lex{'Cannot open file'} $directory/$subdir/admin.css: $!\n";
    }
    my $text;
    { local $/; $text = <FH>; close FH;}

    $text =~ m/<<Color:(.*)>>/;
    my $newcolor = $1; # new color is the color set by school, and to be added to new admin.css

    my $copytext = $newtext;
    $copytext =~ s/$oldcolor/$newcolor/g;

    print "OLD:$oldcolor NEW:$newcolor\n";


    # open for writing.
    unless (open ( FH,">", "$directory/$subdir/admin.css")) {
	print $lex{'Cannot open file'}. ": $!\n";
	die $lex{'Cannot open file'}. ": $!\n";
    }

    print FH $copytext;
    close FH;


    print "Copied $directory/$subdir/admin.css\n";


}

print qq{Done!\n};
