#!/usr/bin/perl
#  Copyright 2001-2019 Leslie Richardson

#  Based on: rptmonthsummary.pl on central site.

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('School Events' => 'School Events',
	   'Main' => 'Main',
	   'Enrollment' => 'Enrollment',
	   'Current Date' => 'Current Date',
	   'Aging Date' => 'Aging Date',
	   'Current Enrollment' => 'Current Enrollment',
	   'Student' => 'Student',
	   'Grade' => 'Grade',
	   'Date' => 'Date',
	   'Type' => 'Type',
	   'Description' => 'Description',
	   'Enrolled' => 'Enrolled',
	   'Not Found' => 'Not Found',
	   'Error' => 'Error',
	   'Continue' => 'Continue',
	   'Teacher' => 'Teacher',
	   'Walkthrough' => 'Walkthrough',
	   'Curr' => 'Curr',
	   'Prev' => 'Prev',
	   'Staff' => 'Staff',
	   'Day Fraction' => 'Day Fraction',
	   'Days Closed' => 'Days Closed',
	   'Report' => 'Report',
	   'Select Month' => 'Select Month',
	   'Missing' => 'Missing',
	   'Periods per Day' => 'Periods per Day',

	   'Community Events' => 'Community Events',
	   'Upcoming Events' => 'Upcoming Events',
	   'Data Updates' => 'Data Updates',
	   'Resource Spending' => 'Resource Spending',
	   'Facility Updates' => 'Facility Updates',
	   'Other Updates' => 'Other Updates',
	   'Staff Updates' => 'Staff Updates',
	   'Land Based Learning' => 'Land Based Learning',

	   );

use DBI;
use CGI;
use Time::JulianDay;
use Number::Format qw(:all);

my $self = 'rptmonthevent.pl';

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


my $q = new CGI;
print $q->header(-charset, $charset ); 
my %arr = $q->Vars;


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $title = "$lex{'School Events'} $lex{Report}";
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{<meta HTTP-EQUIV="Pragma" CONTENT="no-cache">\n};
print qq{$chartype\n</head><body style="padding:1em 2em;">\n};

print qq{[ <a href="$homepage">$lex{Main}</a> ]\n};
print qq{<h1>$title</h1>\n};

#foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }
# Values passed: page, date, and then any school databases;


if ( not $arr{page} ) {
    showStartPage();
}
delete $arr{page};



my ($currmonthstart, $currmonthend, $prevmonthstart, $prevmonthend, $prevym, $nextym);

my ($y,$m) = split('-', $arr{month});
delete $arr{month};

if ( $m == 12 ) {
    my $nextyear = $y + 1;
    $nextym = $nextyear. '-01';
} else {
    my $nextmonth = $m + 1;
    $nextym = $y. "-$nextmonth";
}

if ( $m == 1 ) {
    my $prevyear = $y - 1;
    $prevym = $prevyear. '-12';
} else {
    my $prevmonth = $m - 1;
    $prevym = $y. '-', $prevmonth;
}

# Now get actual dates.
my $cmstartjd = julian_day($y,$m, '01');
$currmonthstart = "$y-$m-01";

my $nmstartjd = julian_day( split('-',$nextym), '01');
my $cmendjd = $nmstartjd - 1;
$currmonthend = join('-',inverse_julian_day($cmendjd));

my $cmonth = $month[$m];



print qq{<div><span style="font-size:140%;font-weight:bold;">$cmonth $y</span></div>\n};
# print qq{<b>$currmonthstart to $currmonthend</b></div>\n};

print qq{<h2>$schoolname</h2>\n};

my ($curref,$eomref, $somref, $snref) = getEnrollments( $dbh, $dbase, $currmonthend );
my %enrolCUR = %$curref;
my %enrolEOM = %$eomref;
my %enrolSOM = %$somref;
my %students = %$snref;
# reference to enrollment hash and student number hash; $studnum -> grade
# Enrollment hash is: {grade} = count;

# print "Start:$currmonthstart End:$currmonthend<br>\n";
#    print "Students:<br>\n";
#    foreach my $key ( sort {$a <=> $b}  keys %students ) { print "K:$key V:$students{$key}<br>\n"; }


my $aref = getAttendance( $dbh, $dbase, $currmonthstart, $currmonthend, $snref );
my %att = %$aref;


# Enrollment/Attendance by grade
print qq{<table cellpadding="4" cellspacing="0" border="1" style="float:left;margin:0.5em;">\n};
print qq{<tr><th>$lex{Grade}</th><th>Curr<br>Enrol</th><th>Starting<br>Enrol</th>\n};
print qq{<th>Ending<br>Enrol</th><th>Enrol<br>Change</th><th>Attendance</th></tr>\n};
# print qq{<th>Walkthroughs<br>Curr/Prev</th></tr>\n};

my ($ectotal, $estotal, $eetotal, $echange);
my ($totalenrol, $totalattend);
my ($pwcurrtotal, $pwprevtotal);


# Stats by Grade
foreach my $grade ( sort {$a <=> $b} keys %enrolCUR ) {

    # print "Grade:$grade Attend:$att{$grade}{'attend'} Enrol:$att{$grade}{'enrol'}<br>\n";
    my $diff = $enrolEOM{$grade} - $enrolSOM{$grade};
    my $attend = 0;
    if ( $att{$grade}{'enrol'} ) {
	$attend = round( $att{$grade}{'attend'} / $att{$grade}{'enrol'} * 100, 0);
    }
    
    if ( not $pwcurr{$grade} ) { $pwcurr{$grade} = '0'; }
    if ( not $pwprev{$grade} ) { $pwprev{$grade} = '0'; }

    $pwcurrtotal += $pwcurr{$grade};
    $pwprevtotal += $pwprev{$grade};

    print qq{<tr><td>$grade</td><td>$enrolCUR{$grade}</td><td>$enrolSOM{$grade}</td>};
    print qq{<td>$enrolEOM{$grade}</td><td>$diff</td><td>$attend%</td></tr>\n};

    $ectotal += $enrolCUR{$grade};
    $eetotal += $enrolEOM{$grade};
    $estotal += $enrolSOM{$grade};

    $totalenrol += $att{$grade}{'enrol'};
    $totalattend += $att{$grade}{'attend'};
}

$echange = $eetotal - $estotal;

my $totalattendance = 0;
if ( $totalenrol ) {
    $totalattendance = round( $totalattend / $totalenrol * 100, 0);
}

print qq{<tr style="background-color:#DDD;"><td>Total</td><td>$ectotal</td><td>$estotal</td>};
print qq{<td>$eetotal</td><td>$echange</td><td>$totalattendance%</td></tr>\n};
print qq{</table>\n};
# Completed Enrollment/Attendance table.

# Get Staff Names
my %staffname;
my $sth = $dbh->prepare("select lastname, firstname, userid from staff");
$sth->execute;
if ($DBI::errstr) {print $DBI::errstr; die $DBI::errstr; }
while (my ($lastname, $firstname, $userid) = $sth->fetchrow ) {
    $staffname{$userid} = "<b>$lastname</b>, $firstname";
}


# Principal Walkthrough
my ($pwcurr, $pwprev, $pwtch ) = getPwalk( $dbh, $dbase, $currmonthstart, $currmonthend );
my %pwcurr = %$pwcurr;
my %pwprev = %$pwprev;
my %pwtch = %$pwtch;  # teacher list 


#    use Data::Dumper;
#    print Dumper %pwcurr;
#    print Dumper %pwprev;


# Get Staff Absence
my ($abscurr, $absprev, $staffref) = getStaffAbsence( $dbh, $dbase, $currmonthstart, $currmonthend );
my %staffabscurr = %$abscurr;
my %staffabsprev = %$absprev;
my %stafflist = %$staffref;


# Staff Walkthrough / Absences
print qq{<table cellpadding="4" cellspacing="0" border="1" style="float:left;margin:0.5em;">\n};
print qq{<tr><th>$lex{Staff}</th><th colspan="2" class="cn">$lex{Walkthrough}</th>};
print qq{<th colspan="2" class="cn">Absent</th>\n};
print qq{<th colspan="2" class="cn">Late (min)</th></tr>\n};
print qq{<tr><th></th><th>$lex{Curr}</th><th>$lex{Prev}</th><th>$lex{Curr}</th><th>Prev</th>};
print qq{<th>$lex{Curr}</th><th>$lex{Prev}</th></tr>\n};

my %temp = (%stafflist, %pwtch ); # join 2 staff lists
foreach my $userid ( sort keys %temp ) {
    my $name;
    if ( $staffname{$userid} ) {
	$name = $staffname{$userid};
    } elsif ( $stafflist{$userid} ) {
	$name = $stafflist{$userid};
	$staffname{$userid} = $stafflist{$userid};
    } else {
	$name = $userid;
    }
    $sort{"$name$userid"} = $userid;
}


my $firstflag = 1;
foreach my $key ( sort keys %sort ) {
    $firstflag = 0;
    my $userid = $sort{$key};
    my $curr = $pwtch{$userid}{'curr'};
    my $prev = $pwtch{$userid}{prev};
    if ( not $curr ) { $curr = '0'; }
    if ( not $prev ) { $prev = '0'; }

    my $name = $staffname{$userid};
    if ( not $name ) { $name = $userid; }

    # Add zero to blank values
    if (not $staffabscurr{$userid}{absent} ) { $staffabscurr{$userid}{absent} = '0'; }
    if (not $staffabsprev{$userid}{absent} ) {  $staffabsprev{$userid}{absent} = '0'; }
    if (not $staffabscurr{$userid}{late} ) { $staffabscurr{$userid}{late} = '0'; }
    if (not $staffabsprev{$userid}{late} ) { $staffabsprev{$userid}{late} = '0'; }

    print qq{<tr><td class="la">$name</td><td class="cn">$curr</td><td class="cn">$prev</td>};
    print qq{<td class="cn">$staffabscurr{$userid}{absent}</td><td class="cn">$staffabsprev{$userid}{absent}</td>\n}; 
    print qq{<td class="cn">$staffabscurr{$userid}{late}</td><td class="cn">$staffabsprev{$userid}{late}</td></tr>\n}; 
}

if ( $firstflag ) { print qq{<tr><td colspan="7" class="bcn">No Records Found</td></tr>\n}; }
print qq{</table>\n};
print qq{<br clear="left">\n};


#    print "Month Start:$currmonthstart<br>\n";

# Get Closures for the Month
print qq{<table cellpadding="4" cellspacing="0" border="1" style="float:left;margin:0.5em;">\n};
print qq{<caption style="font-size:120%;font-weight:bold;">$lex{'Days Closed'}</caption>\n};
print qq{<tr><th>$lex{Date}</th><th>$lex{Type}</th><th>$lex{Description}</th><th>$lex{'Day Fraction'}</th></tr>\n};

my $sth = $dbh->prepare("select * from dates where month(date) = ? and year(date) = ? order by date");
$sth->execute ($m,$y);
if ($DBI::errstr) {print $DBI::errstr; die $DBI::errstr; }
while (my $dref = $sth->fetchrow_hashref ) {
    my %d = %$dref;
    print qq{<tr><td>$d{date}</td><td>$d{type}</td><td>$d{desc1}</td><td>$d{dayfraction}</td></tr>\n};
}
print qq{</table><p></p>\n};
print qq{<br clear="left">\n};

# Now Get School Events info for this month.
my $sth = $dbh->prepare("select * from schoolevent where date = ?");
$sth->execute ($currmonthstart);
if ($DBI::errstr) {print $DBI::errstr; die $DBI::errstr; }
my $eventref = $sth->fetchrow_hashref;
my %e = %$eventref;

#    foreach my $key ( sort keys %e ) { print "K:$key V:$e{$key}<br>\n"; }

print qq{<table style="border:1px solid gray;margin:1em;"><tr><td style="width:800px;"><ul>};
print qq{<li><b>$lex{'Community Events'}</b> <pre>$e{communityevents}</pre></li>\n};
print qq{<li><b>$lex{'Upcoming Events'}</b> <pre>$e{upcomingevents}</pre></li>\n}; 
print qq{<li><b>$lex{'Land Based Learning'}</b> <pre>$e{landedu}</pre></li>\n}; 
print qq{<li><b>$lex{'Resource Spending'}</b> <pre>$e{resourcespending}</pre></li>\n}; 
print qq{<li><b>$lex{'Staff Updates'}</b> <pre>$e{staffupdates}</pre></li>\n};
print qq{<li><b>$lex{'Facility Updates'}</b> <pre>$e{facilityupdates}</pre></li>\n}; 
print qq{<li><b>$lex{'Data Updates'}</b> <pre>$e{dataupdates}</pre></li>\n}; 
print qq{<li><b>$lex{'Other Updates'}</b> <pre>$e{otherupdates}</pre></li>\n}; 
print qq{</ul></table>\n};

print qq{</body></html>\n};




#------------------
sub getStaffAbsence { # get Staff Absence
#------------------

    # Passed dbh, dbase, start date, end date.
    my ($dbh, $dbase, $startdate, $enddate ) = @_;
    my ($curryear, $currmonth, $startday) = split('-', $startdate);
    my (%curr, %prev, %staff); # current and previous absences  $curr{userid}{late or absent};

    my $sth = $dbh->prepare("select * from staff_absent");
    $sth->execute;
    if ($DBI::errstr) {print $DBI::errstr; die $DBI::errstr; }
    while ( my $ref = $sth->fetchrow_hashref ) {
	my %r = %$ref;
	my $currjd = julian_day(split($r{adate}));

	my $dayfraction;
	if ( $r{daypart} eq 'All Day' ) {
	    $dayfraction = 1; 
	} else { $dayfraction = 0.5; }

	my $userid = $r{userid};
	$staff{$userid} = qq{<b>$r{lastname}</b>, $r{firstname}}; # list of userid's to return

	if ( $currjd >= $cmstartjd and $currjd <= $cmendjd ) { # it's current
	    
	    $curr{$userid}{absent} += $dayfraction;
	    $curr{$userid}{late} += $r{late};

	} else {
	    $prev{$userid}{absent} += $dayfraction;
	    $prev{$userid}{late} += $r{late};
	}
    }


#    print "Current", %prev, "<br>\n";
#    use Data::Dumper;
#     print Dumper %prev;


    return \%curr, \%prev, \%staff;

}


#------------
sub getPwalk { # get principal Walkthrough values
#------------

    # Passed dbh, dbase, start date, end date.
    my ($dbh, $dbase, $startdate, $enddate ) = @_;
    my ($curryear, $currmonth, $startday) = split('-', $startdate);
    my (%currwalk, %prevwalk); # current and previous walkthroughs {grade} = count;

    # Get staff grades, if any
    my %staff;
    my $sth = $dbh->prepare("select userid, field_value from staff_multi
        where field_name = 'grade'");
    $sth->execute;
    if ($DBI::errstr) {print $DBI::errstr; die $DBI::errstr; }
    while ( my ($userid, $grade ) = $sth->fetchrow ) {
	$staff{$userid} = $grade;
    }

    
    # get all principal walkthroughs, for this school year.
    my %teacherwalk; # store info on per teacher basis.
    my $sth = $dbh->prepare("select tuserid, subject, adatetime from pwalk_eval 
      where to_days(adatetime) > to_days('$schoolstart')");
    $sth->execute;
    if ($DBI::errstr) {print $DBI::errstr; die $DBI::errstr; }
    while ( my ($userid,$subjsec, $datetime ) = $sth->fetchrow ) {

	my ($date,$time) = split(/\s+/, $datetime);
	my ($y,$m,$d) = split('-', $date);
	my $grade = $staff{$userid};

	if ( $y == $curryear and $m == $currmonth ) {
	    $teacherwalk{$userid}{'curr'}++;
	    $currwalk{$grade}++;
	} else {
	    $teacherwalk{$userid}{'prev'}++;
	    $prevwalk{$grade}++;
	}
    	
    } # pwalk loop

    return \%currwalk, \%prevwalk, \%teacherwalk;

} # end of getPwalk



#----------------
sub getAttendance {
#----------------
    # Based on mkHTMLReport sub from rptatt2global.pl file

    # Passed dbh, dbase, start date, end date.
    my ($dbh, $dbase, $startdate, $enddate, $snref) = @_;
    
    my %students = %$snref; # list of student numbers to check attendance for. studnum->grade

    eval require "../../lib/libattend.pl";
    if ( $@ ) {
	print $lex{Error}. ": $@<br>\n";
	die $lex{Error}. ": $@\n";
    }

    my %schooldays = mkSchoolDays( $startdate, $enddate, $dbh );
    # returns hash of schooldays in month. key is yyyy-mm and value is schooldays in month
    # print "School Days", %schooldays, "<br>\n";
    my @keys = keys %schooldays;
    my $schooldays = $schooldays{$keys[0]};
    print "School Days:$schooldays<br>\n";


    # Populate student grade $studgrade{grade} = studnum list.
    my %studgrade;
    foreach my $studnum ( keys %students ) {
	my $grade = $students{$studnum};
#	if ( not $studgrade{$grade} ) { $studgrade{$grade} = []; }
	push @{ $studgrade{$grade} }, $studnum;
    }

    #use Data::Dumper;
    # print Dumper %studgrade;


    my %lexi = ('Absent' => 'Absent',
		'Late' => 'Late');

    # Now Loop through all grades
    my %attend;
    my $failflag; # fail before printing.

    foreach my $grade ( sort {$a <=> $b} keys %studgrade ) {

	my $ppd = $g_ppd{ $grade };
	if ( not $ppd ) {
	    print "$lex{Missing} $lex{'Periods per Day'} - $lex{Grade} $grade<br>\n"; 
	    $failflag = 1; # fail before output.
	}

	# Students in this grade
	foreach my $studnum ( @{ $studgrade{$grade} } ) {
    
	    my $ref = calcMonthlyEnrollment( $studnum, $startdate, $enddate, $dbh );
	    my %enrolYM = %$ref;
	    # format:  $enrolYM{yearmonth}-> start, end, days.

	    foreach my $ym ( sort keys %enrolYM ) {

		my $result = calcMonthlyAttendance( $studnum, $ym, $ppd, '',\%lexi, $dbh );
		my ($absent, $late) = split(':', $result);

		my $enrolled = $enrolYM{$ym}->{days};
		my $present = $enrolled - $absent;

		$attend{$grade}{$ym}->{attend} += $present;
		$attend{$grade}{$ym}->{enrol} += $enrolled;

	    }
	}
    }

    # use Data::Dumper;
    # print Dumper %attend;
    # print "<p></p>\n";

    if ( $failflag ) {
	print "</body></html>\n";
	exit;
    }

    my %tmpattend;
    foreach my $gr ( keys %attend ) {
	foreach my $ym ( keys %{ $attend{$gr}} ) {
	    $tmpattend{$gr}{attend} = $attend{$gr}{$ym}{attend};
	    $tmpattend{$gr}{enrol} = $attend{$gr}{$ym}{enrol};
	}
    }

    # use Data::Dumper;
    # print Dumper %tmpattend;
    
    return \%tmpattend;

}



#-----------------
sub getEnrollments {
#-----------------

    # Passed dbh, dbase, date.
    my ($dbh, $dbase, $date) = @_;  # date will be end of month.


    # First count how many currently enrolled (in student table), and their student numbers;
    my (%enrollments, %students);
    my $sth = $dbh->prepare("select studnum, grade from student 
     where grade is not NULL and grade != ''");
    if ($DBI::errstr) {print $DBI::errstr; die $DBI::errstr; }
    $sth->execute;
    if ($DBI::errstr) {print $DBI::errstr; die $DBI::errstr; }
    while ( my ($studnum, $grade) = $sth->fetchrow ) {
	$enrollments{$grade}++;
	$students{$studnum} = $grade;
    }
    my %enrolCUR = %enrollments; # store current enrollment


    # Now count backwards through entry records until we reach date of interest; get records after date.
    my $sth1 = $dbh->prepare("select * from transfer where to_days(date) >= to_days('$date') 
     order by date desc");
    $sth1->execute;
    if ($DBI::errstr) {print $DBI::errstr; die $DBI::errstr; }

    # Setup query to get grade
    my $sth2 = $dbh->prepare("select grade from studentall where studnum = ?");

    while ( my $ref = $sth1->fetchrow_hashref ) {

	my %tr = %$ref;

	$sth2->execute( $tr{studnum} );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	my $grade  = $sth2->fetchrow;
	if ( not $grade ) {
	    print "<div>$lex{Error}: $tr{studnum} $lex{'Not Found'}: $tr{date} - $tr{type}</div>\n";
	    next;
	}

	$students{$tr{studnum}} = $grade;


	# print "<div>$tr{date} - $tr{type} - $tr{studnum} - $grade</div>\n";

	# Change Enrollment Numbers, and %students
	if ( $tr{type} ne 'withdraw' ) { # then was an enrol
	    $enrollments{$grade}--;
	} else { # withdraw
	    $enrollments{$grade}++;
	    delete $students{$tr{studnum}};
	}

    }
    my %enrolEOM = %enrollments;  # EOM - End of Month


    # Now find enrollment changes during the month.
    # Get Year-Month value from date;
    my ($y,$m,$d) = split('-', $date);

    $sth = $dbh->prepare("select * from transfer where year(date) = '$y' and month(date) = '$m'");
    $sth->execute;
    if ($DBI::errstr) {print $DBI::errstr; die $DBI::errstr; }

    while ( my $ref = $sth->fetchrow_hashref ) {

	my %tr = %$ref;

	$sth2->execute( $tr{studnum} );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	my $grade  = $sth2->fetchrow;
	if ( not $grade ) {
	    print "<div>$lex{Error}: $tr{studnum} $lex{'Not Found'}: $tr{date} - $tr{type}</div>\n";
	    next;
	}

	$students{$tr{studnum}} = $grade;

	if ( $tr{type} ne 'withdraw' ) { # then was an enrol
	    $enrollments{$grade}--;
	} else { # withdraw
	    $enrollments{$grade}++;
	}
    }

    my %enrolSOM = %enrollments;  # SOM - Start of Month

    return \%enrolCUR, \%enrolEOM, \%enrolSOM, \%students;

} # end of getEnrollments



#----------------
sub showStartPage {
#----------------

    # foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    # Setup Year-Months.
    my @months;
    my %months;

    my ($sy, $sm, $sd) = split('-', $schoolstart); # schoolstart is global var from config.
    my $yrmo = "$sy-$sm";
    push @months, $yrmo;
    $months{$yrmo} = "$s_month[$sm]-$sy";

    for my $i (1..10) {
	my $mo = $sm + $i;
	my $yr = $sy;
	if ( $mo > 12 ) {
	    $mo = $mo - 12;
	    $yr++;
	}
	my $yrmo = "$yr-$mo";
	push @months, $yrmo;
	$months{$yrmo} = "$s_month[$mo]-$yr";
    }


=head
    my @tim = localtime(time);
    my $year = @tim[5] + 1900;
    my $month = @tim[4] + 1;
    if ( $month == 1 ) {
	$year--;
	$month = 12;
    } else {
	$month--;
    }
    my $prevdate = "$year-$month-01";


    print qq{<link rel="stylesheet" type="text/css" media="all" };
    print qq{href="/js/calendar-blue.css" title="blue">\n};
    print qq{<script type="text/javascript" src="/js/calendar.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/lang/calendar-en.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/calendar-setup.js"></script>\n};
=cut

    print qq{<table cellspacing="0" border="0" cellpadding="3">\n};
    print qq{<tr><th>$lex{'Select Month'}</th></tr>\n};

    foreach my $mo ( @months ) {
	print qq{<tr><td>\n};
	print qq{<form action="$self" method="post">\n};
	print qq{<input type="hidden" name="page" value="1">\n};
	print qq{<input type="hidden" name="month" value="$mo">\n};
	print qq{<input type="submit" value="$months{$mo}"></form>\n};
	print qq{</td></tr>\n};
    }




#    print qq{<tr><td class="bla">Date in Month</td><td class="la">\n};
#    print qq{<input type="text" name="date" size="12" id="date" value="$prevdate">\n};
#    print qq{<button type="reset" id="start_trigger">...</button></td></tr>\n};


#   print qq{<tr><td class="la" colspan="2"><input type="submit" value="$lex{Continue}"></td></tr>\n};
    print qq{</table>\n};


=head
    print qq{<script type="text/javascript">
     Calendar.setup({
        inputField     :    "date", // id of the input field
        ifFormat       :    "%Y-%m-%d", // format of the input field
        button         :    "start_trigger", // trigger for the calendar (button ID)
        singleClick    :    false,        // double-click mode
        step           :    1             // show all years in drop-down boxes 
    }) \n};

    print qq{</script>\n};
=cut

    print qq{</body></html>\n};

    exit;

}
