#!/usr/bin/perl
#  Copyright 2001-2014 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ( 'Delete' => 'Delete',
	    'Staff Absence' => 'Staff Absence',
	    'Edit' => 'Edit',
	    'Main' => 'Main',
	    'Eoy' => 'Eoy',
	    'Are you sure' => 'Are you sure',
	    'Deleted' => 'Deleted',
	    'Name' => 'Name',
	    'Error' => 'Error',
	    'Yes' => 'Yes',
	    'Record' => 'Record',
	    'Date' => 'Date',
	    'Reason' => 'Reason',
	    'Contact' => 'Contact',

	    );

my $self = 'staffabsDelete.pl';

use CGI;
use DBI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

# Load audit write function
eval require "../../lib/libaudit.pl";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;


#foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n" }

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $sth = $dbh->prepare("select * from staff_absent where id = ?"); 
$sth->execute( $arr{id} );
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
my $ref = $sth->fetchrow_hashref;
my %r = %$ref;

my $title = "$lex{Delete} $lex{'Staff Absence'}";
print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> ]\n};
#print qq{<a href="$eoypage">$lex{Eoy}</a> ]\n};

print qq{<h1>$title</h1>\n};


if ( $arr{deleteflag} ) {
    delete $arr{deleteflag};
    deleteRecord();
}

print qq{<table>\n};
print qq{<tr><td class="bra">$lex{Name}</td><td>$r{firstname} $r{lastname} ($r{userid})</td></tr>\n};
print qq{ <tr><td class="bra">$lex{Date}</td><td>$r{adate}</td></tr>\n};
print qq{ <tr><td class="bra">$lex{Reason}</td><td>$r{reason}</td></tr>\n};
print qq{</table>\n};


print qq{<h3>$lex{Delete} $lex{Record}: $lex{'Are you sure'}?</h3>\n};

print qq{<form action="$self" method="post">\n};
print qq{<input type="hidden" name="itemid" value="$arr{id}">\n};
print qq{ <input type="hidden" name="deleteflag" value="1">\n};

print qq{<input type="submit" value="$lex{Yes}, $lex{Delete} $lex{Record}">\n};
print qq{</form></body></html>\n};


#---------------
sub deleteRecord {
#---------------

    #foreach my $key (keys %arr) { print qq{K:$key V:$arr{$key}<br>\n}; }
    my $id = $arr{itemid};
    
    # Load Current Record for audit
    my $sth1 = $dbh->prepare("select * from staff_absent where id = ?");
    $sth1->execute( $id );
    if (DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my  $startref = $sth1->fetchrow_hashref;

    my %audit;
    $audit{userid} = $ENV{REMOTE_USER};
    $audit{ipaddr} = $ENV{REMOTE_ADDR};
    $audit{scriptname} = $self;
    $audit{tablename} = 'staff_absent';
    $audit{tableid} = $startref->{id};
    $audit{startval} = $startref;
    # $audit{endval} = \%arr; # no ending value.

    addAudit( \%audit, $dbh );

    
    my $sth = $dbh->prepare("delete from staff_absent where id = ?");
    $sth->execute( $arr{itemid} );

    if ($DBI::errstr) {
	print qq{<h3>$lex{Error}: $DBI::errstr<br>\n};
	print qq{$lex{Contact}: $adminname</h3>\n};
    } else {
	print qq{<h3>$lex{Record} $lex{Deleted}.</h3>\n};
    }

    print qq{[ <a href="./staffabsview.pl">View Staff Absences</a> ]\n};
    
    print qq{</body></html>\n};

    exit;

}
