#!/usr/bin/perl
#  Copyright 2001-2021 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ( 'Delete' => 'Delete',
	    'Staff Member' => 'Staff Member',
	    'Main' => 'Main',
	    'Eoy' => 'Eoy',
	    'Are you sure' => 'Are you sure',
	    'deleted' => 'deleted',
	    'Name' => 'Name',
	    'User Id' => 'User Id',
	    'Subject' => 'Subject',
	    'Count' => 'Count',
	    'Error' => 'Error',
	    'Yes' => 'Yes',
	    'Edit' => 'Edit',
	    
	    );

my $self = 'staffdel.pl';

use CGI;
use DBI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

$dsn = "DBI:$dbtype:dbname=$dbase";
$dbh = DBI->connect($dsn,$user,$password);



$sth = $dbh->prepare("select lastname, firstname, userid from staffwd where userid = ?"); 
$sth->execute( $arr{userid} );
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
my ( $lastname, $firstname, $userid ) = $sth->fetchrow;

# Count the courses of this teacher.
#$sth = $dbh->prepare("select count(*) from subject where teacher = ?"); 
#$sth->execute( $userid );
#if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
#my $subjectcount = $sth->fetchrow;


print qq{$doctype\n<html><head><title>$lex{Delete} $lex{'Staff Member'}</title>
<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> | \n};
print qq{<a href="$eoypage">$lex{Eoy}</a> ]\n};

print qq{<h1>Permanently $lex{Delete} Withdrawn $lex{'Staff Member'}</h1>\n};

if ( $arr{deleteflag} ) {
    delete $arr{deleteflag};
    deleteRecord();
}

print qq{<table>
 <tr><td class="bra">$lex{Name}</td><td>$firstname $lastname</td></tr>
 <tr><td class="bra">$lex{'User Id'}</td><td>$userid</td></tr>
 </table>\n};

print qq{<h3>$lex{Delete} Withdrawn $lex{'Staff Member'}: $lex{'Are you sure'}?</h3>\n};

print qq{<form action="$self" method="post">
 <input type="hidden" name="name" value="$firstname $lastname">
 <input type="hidden" name="deleteflag" value="1">
 <input type="hidden" name="userid" value="$userid">\n};

print qq{<input type="submit" value="$lex{Yes}, $lex{'Delete'} $lex{'Staff Member'}">\n};
print qq{</form></body></html>\n};


#---------------
sub deleteRecord {
#---------------

    # foreach my $key (keys %arr) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # only useid and name passed.

    my $sth = $dbh->prepare("delete from staffwd where userid = ?");
    $sth->execute( $arr{userid} );


    if ($DBI::errstr) {
	print qq{<h3>$lex{Error}: $DBI::errstr<br>\n};
	print qq{$lex{Contact}: $adminname</h3>\n};
    } else {
	print qq{<h3>$arr{name} $lex{deleted}.</h3>\n};
    }

    print qq{<p>[ <a href="staffdeled.pl">$lex{Edit}/$lex{Delete} };
    print qq{Other Staff Members</a> ]</p>\n};

    print qq{</body></html>\n};

    exit;

}
