#!/usr/bin/perl
#  Copyright 2001-2011 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


my %lex = ('Textbook' => 'Textbook',
	   'Sign In' => 'Sign In',
	   'Main' => 'Main',
	   'Fees' => 'Fees',
	   'Error' => 'Error',
	   'Date' => 'Date',
	   'Grade' => 'Grade',
	   'Homeroom' => 'Homeroom',
	   'Student' => 'Student',
	   'Books' => 'Books',
	   'Continue' => 'Continue',
	   'Record(s) Updated' => 'Record(s) Updated',
	   'Id' => 'Id',
	   'Not Found' => 'Not Found',
	   'Sign Out' => 'Sign Out',

	   );

use DBI;
use CGI;

my $self = 'tb_signin.pl';
my $maxbooks = 39; # max number of books signed in at a time.

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Print Page Header
my $title = "$lex{'Sign In'} $lex{Textbook}";
print "$doctype\n<html><head><title>$title</title>
<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">
$chartype\n</head>\n";

print "<body style=\"padding:1.5em;\">\n";
print "[ <a href=\"$homepage\">$lex{Main}</a> |\n";
print " <a href=\"$feespage\">$lex{Fees}</a> ]\n";
print "<h1>$title</h1>\n";


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    signinBooks();
} 


#----------------
sub showStartPage {
#----------------

    # Start Form
    print qq{<td><form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    # Start Table
    print "<table cellpadding=\"3\" border=\"1\" cellspacing=\"0\" style=\"float:left;\">\n";
  
    # Continue
    print "<tr><td colspan=\"2\" style=\"text-align:center;\">";
    print "<input type=\"submit\" value=\"$lex{Continue}\"></td></tr>\n";

    # Heading
    print "<tr><th></th><th>$lex{Id}</th></tr>\n";

    for  my $i ( 1..$maxbooks ) {

	if ( $i % 10 == 0 ) { 
	    print "</table><table cellpadding=\"3\" border=\"1\" cellspacing=\"0\" style=\"float:left;\">\n";
	}

	print "<tr><td class=\"la\">$i</td><td class=\"la\">";
	print "<input type=\"text\" name=\"$i\" size=\"12\"></td></tr>\n";
    }

    # Continue
    print "<tr><td colspan=\"2\" style=\"text-align:center;\">";
    print "<input type=\"submit\" value=\"$lex{Continue}\"></td></tr>\n";

    print "</table></form>\n";
    print "</body></html>\n";

}


#--------------
sub signinBooks {
#--------------

    # foreach my $key ( sort keys %arr) { print "K:$key V:$arr{$key}<br>\n"; }

    # load all book titles
    my %title = ();
    my $sth = $dbh->prepare("select id, title, author, pubdate from book_title");
    $sth->execute;
    if ( DBI::errstr ) { print $DBI::errstr; die $DBI::errstr }
    while ( my ( $id, $title, $author, $pubdate ) = $sth->fetchrow ) {
	$title{$id} = "$title ($pubdate)";
    }


    # setup queries
    $sth = $dbh->prepare("select lastname, firstname from student where studnum = ?");

    my $sth1 = $dbh->prepare("select id, titleid from book_copy where barcode = ?");

    my $sth2 = $dbh->prepare("select count(*) from book_signout where returndate is NULL and copyid = ?");

    my $sth3 = $dbh->prepare("select * from book_signout where returndate is NULL and copyid = ?");

    my $sth4 = $dbh->prepare("update book_signout set returndate = now() where id = ?");

    # Table
    print "<table cellpadding=\"3\" cellspacing=\"0\" border=\"1\">\n";
    print "<tr><th>$lex{Student}</th><th>$lex{Books}</th><th>$lex{Id}</th></tr>\n";

    foreach my $key ( sort {$a <=> $b} keys %arr ) {

	if ( not $arr{$key} ) { next; } # skip any blanks
	my $code = $arr{$key}; # or barcode

	# Load Copy Info
	$sth1->execute( $code );
	if (DBI::errstr) { print $DBI::errstr; die $DBI::errstr }
	my ( $copyid, $titleid ) = $sth1->fetchrow;

	# print "Code:$code  Copyid:$copyid  Titleid:$titleid<br>\n";

	# Check Signout Numbers.
	$sth2->execute( $copyid );
	if (DBI::errstr) { print $DBI::errstr; die $DBI::errstr }
	my $count = $sth2->fetchrow;
	if ( $count < 1 ) {
	    print "<div>$lex{Error}: $lex{'Sign Out'} $lex{'Not Found'}: $title{$titleid} - $code</div>\n";
	    next;
	} elsif ( $count > 1 ) { # more than a single signout.
	    print "<div>$lex{Error}: $lex{'Sign Out'} $lex{Count}:$count - $title{$titleid} - $code</div>\n";
	    next;
	}


	# Load signout information.
	$sth3->execute( $copyid );
	if (DBI::errstr) { print $DBI::errstr; die $DBI::errstr }
	my $ref = $sth3->fetchrow_hashref;
	my $studnum = $ref->{studnum};


	# Load Student Info
	$sth->execute( $studnum );
	if (DBI::errstr) { print $DBI::errstr; die $DBI::errstr }
	my ( $lastname, $firstname ) = $sth->fetchrow;

	# Write the record.
	$sth4->execute( $ref->{id} );
	if (DBI::errstr) { print $DBI::errstr; die $DBI::errstr }

	# Display Update Info
	print "<tr><td class=\"la\">$lastname, $firstname ($studnum)</td>\n";
	print "<td class=\"la\">$title{$titleid}</td><td>$code</td></tr>\n";

    }

    print "</table>\n";


    if ( not $DBI::errstr ) {
	print "<h3>$lex{'Record(s) Updated'}</h3>\n";
	
    } else {
	print "<h3>$lex{Error}:$DBI::errstr<br>\n";
	print "$lex{Contact} $adminname <a href=\"mailto:$adminemail\">$adminemail</a></h3>\n";
    }

    print "<p>[ <a href=\"$homepage\">$lex{Main}</a> | \n";
    print "<a href=\"$feespage\">$lex{Fees}</a> | \n";
    print "<a href=\"$self\">$title</a> ]\n";
    
    print "</p></body></html>\n";

    exit;
}
