#!/usr/bin/perl
#  Copyright 2001-2011 Leslie Richardson
#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

%lex = ( 'Main' => 'Main',
	 'Fees' => 'Fees',
	 'Add' => 'Add',
	 'Error' => 'Error',
	 'Subject' => 'Subject',
	 'Title' => 'Title',
	 'Author' => 'Author',
	 'Publishing Date' => 'Publishing Date',
	 'Cost' => 'Cost',
	 'Bar Code' => 'Bar Code',
	 'Description' => 'Description',
	 'Textbook' => 'Textbook',
	 'Record(s) Stored' => 'Record(s) Stored',
	 'Contact' => 'Contact',

	 );

use CGI;
use DBI;

my $self = 'tb_textadd.pl';


eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Print Page Header
my $title = "$lex{Add} $lex{Textbook} $lex{Title}";
print "$doctype\n<html><head><title>$title</title>\n";
print "<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">\n";
print "$chartype\n</head><body>\n";

print "[ <a href=\"$homepage\">$lex{Main}</a> |\n";
print "<a href=\"$feespage\">$lex{Fees}</a> ]\n";

print "<h1>$title</h1>\n";

if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    writeRecord();
}


#----------------
sub showStartPage {
#----------------


    # print top of form, then $text, then bottom of page.
    print "<form action=\"$self\" method=\"post\">\n";
    print "<input type=\"hidden\" name=\"page\" value=\"1\">\n";

    print "<table cellpadding=\"3\" cellspacing=\"0\" border=\"0\">\n";

    print "<tr><td class=\"bra\">$lex{Subject}</td><td class=\"la\">\n";
    print "<input type=\"text\" name=\"subject\" size=\"30\"></td></tr>\n";

    print "<tr><td class=\"bra\">$lex{Title}</td><td class=\"la\">\n";
    print "<input type=\"text\" name=\"title\" size=\"30\"></td></tr>\n";

    print "<tr><td class=\"bra\">$lex{Author}</td><td class=\"la\">\n";
    print "<input type=\"text\" name=\"author\" size=\"30\"></td></tr>\n";

    print "<tr><td class=\"bra\">$lex{'Publishing Date'}</td><td class=\"la\">\n";
    print "<input type=\"text\" name=\"pubdate\" size=\"10\"></td></tr>\n";

    print "<tr><td class=\"bra\">$lex{Cost}</td><td class=\"la\">\n";
    print "<input type=\"text\" name=\"cost\" size=\"8\"></td></tr>\n";

    print "<tr><td class=\"bra\">$lex{'Bar Code'}</td><td class=\"la\">\n";
    print "<input type=\"text\" name=\"barcode\" size=\"30\"></td></tr>\n";

    print "<tr><td class=\"bra\">$lex{Description}</td><td class=\"la\">\n";
    print "<textarea name=\"description\" rows=\"6\" cols=\"60\"></textarea></td></tr>\n";


    print "<tr><td colspan=\"2\" style=\"text-align:center;\">\n";
    print "<input type=\"submit\" value=\"$title\"></td></tr>\n";

    print "</table>\n";
    print "</form></body></html>\n";


}



#--------------
sub writeRecord {
#--------------

    # foreach my $key ( sort keys %arr) { print "K:$key V:$arr{$key}<br>\n"; }


    my $sth = $dbh->prepare("insert into book_title ( subject, title, author, pubdate, cost, barcode, description ) 
      values( ?, ?, ?, ?, ?, ?, ? )");
    $sth->execute( $arr{subject}, $arr{title}, $arr{author}, $arr{pubdate}, $arr{cost}, $arr{barcode}, $arr{description} );

    if ( not $DBI::errstr ) {
	print "<h3>$lex{'Record(s) Stored'}</h3>\n";

    } else {
	print "<h3>$lex{Error}:$DBI::errstr<br>\n";
	print "$lex{Contact} $adminname <a href=\"mailto:$adminemail\">$adminemail</a></h3>\n";
    }

    print "<p>[ <a href=\"$homepage\">$lex{Main}</a> | \n";
    print "<a href=\"$feespage\">$lex{Fees}</a> | \n";
    print "<a href=\"$self\">$title</a> ]\n";


    print "</p></body></html>\n";

    exit;

}
