#!/usr/bin/perl
#  Copyright 2001-2011 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


my %lex = ('Subject' => 'Subject',
	   'Title' => 'Title',
	   'Author' => 'Author',
	   'Publishing Date' => 'Publishing Date',
	   'Cost' => 'Cost',
	   'Bar Code' => 'Bar Code',
	   'Description' => 'Description',
	   'Textbook' => 'Textbook',
	   'Main' => 'Main',
	   'Fees' => 'Fees',
	   'Edit' => 'Edit',
	   'Delete' => 'Delete',
	   'Error' => 'Error',
	   'Record(s) Updated' => 'Record(s) Updated',
	   'Date' => 'Date',
	   'Deleted' => 'Deleted',
	   'Copies' => 'Copies',

	   );

use DBI;
use CGI;

my $self = 'tb_textdeled.pl';

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Print Page Header
my $title = "$lex{Edit}/$lex{Delete} $lex{Textbook} $lex{Title}";

print "$doctype\n<html><head><title>$title</title>
<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">
$chartype\n</head>\n";

print "<body style=\"padding:1.5em;\">\n";
print "[ <a href=\"$homepage\">$lex{Main}</a> |\n";
print " <a href=\"$feespage\">$lex{Fees}</a> ]\n";
print "<h1>$title</h1>\n";


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    editRecord();

} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    updateRecord();

} elsif ( $arr{page} == 3 ) {
    delete $arr{page};
    confirmDelete();

} elsif ( $arr{page} == 4 ) {
    delete $arr{page};
    deleteRecord();
}


#----------------
sub showStartPage {
#----------------

    # select values from textbook title table.
    $sth = $dbh->prepare("select id, title, author, pubdate, description
      from book_title order by title, author");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    $sth1 = $dbh->prepare("select count(*) from book_copy where titleid = ?");


    print "<table cellpadding=\"3\" border=\"1\" cellspacing=\"0\">\n";

    print "<tr><th>$lex{Title}</th><th>$lex{Author}</th>";
    print "<th>$lex{Date}</th><th>$lex{Description}</th><th>$lex{Copies}</th>\n";
    print "<th>$lex{Edit}</th><th>$lex{Delete}</th></tr>\n";
    
    while ( my ( $id, $title, $author, $pubdate, $description ) = $sth->fetchrow ) {

	# Get Copy Count
	$sth1->execute( $id ) ;
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my $count = $sth1->fetchrow;

	
	print "<tr><td class=\"la\">$title</td><td class=\"la\">$author</td>\n";
	print "<td class=\"la\">$pubdate</td><td class=\"la\">$description</td>\n";
	print "<td class=\"cn\">$count</td>\n";

	# Edit Button
	print qq{<td><form action="$self" method="post">\n};
	print qq{<input type="hidden" name="id" value="$id">\n};
	print qq{<input type="hidden" name="page" value="1">\n};
	print qq{<input type="submit" value="$lex{Edit}"></form></td>\n};
	
	# Delete Button
	if ( not $count ) { # can't delete if we have copies depending....
	    print qq{<td><form action="$self" method="post">\n};
	    print qq{<input type="hidden" name="id" value="$id">\n};
	    print qq{<input type="hidden" name="page" value="3">\n};
	    print qq{<input type="submit" value="$lex{Delete}"></form>\n};
	} else { print "<td></tr>"; }
	print qq{</td></tr>\n};

    }

    print "</table></body></html>\n";

}


# show record to edit
#-------------
sub editRecord {
#-------------

    # select values from textbook title table.
    $sth = $dbh->prepare("select * from book_title where id = ?");
    $sth->execute( $arr{id} );
    if (DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    my $ref = $sth->fetchrow_hashref;

    # print top of form, then $text, then bottom of page.
    print "<form action=\"$self\" method=\"post\">\n";
    print "<input type=\"hidden\" name=\"page\" value=\"2\">\n";
    print "<input type=\"hidden\" name=\"id\" value=\"$arr{id}\">\n";

    print "<table cellpadding=\"3\" cellspacing=\"0\" border=\"0\">\n";

    print "<tr><td class=\"bra\">$lex{Subject}</td><td class=\"la\">\n";
    print "<input type=\"text\" name=\"subject\" size=\"30\" value=\"$ref->{subject}\"></td></tr>\n";

    print "<tr><td class=\"bra\">$lex{Title}</td><td class=\"la\">\n";
    print "<input type=\"text\" name=\"title\" size=\"30\" value=\"$ref->{title}\"></td></tr>\n";

    print "<tr><td class=\"bra\">$lex{Author}</td><td class=\"la\">\n";
    print "<input type=\"text\" name=\"author\" size=\"30\" value=\"$ref->{author}\"></td></tr>\n";

    print "<tr><td class=\"bra\">$lex{'Publishing Date'}</td><td class=\"la\">\n";
    print "<input type=\"text\" name=\"pubdate\" size=\"10\" value=\"$ref->{pubdate}\"></td></tr>\n";

    print "<tr><td class=\"bra\">$lex{Cost}</td><td class=\"la\">\n";
    print "<input type=\"text\" name=\"cost\" size=\"8\" value=\"$ref->{cost}\"></td></tr>\n";

    print "<tr><td class=\"bra\">$lex{'Bar Code'}</td><td class=\"la\">\n";
    print "<input type=\"text\" name=\"barcode\" size=\"30\" value=\"$ref->{barcode}\"></td></tr>\n";

    print "<tr><td class=\"bra\">$lex{Description}</td><td class=\"la\">\n";
    print "<textarea name=\"description\" rows=\"6\" cols=\"60\">$ref->{description}</textarea></td></tr>\n";


    print "<tr><td colspan=\"2\" style=\"text-align:center;\">\n";
    print "<input type=\"submit\" value=\"$title\"></td></tr>\n";

    print "</table>\n";
    print "</form></body></html>\n";


}


# write update into table
#---------------
sub updateRecord {
#---------------

    # foreach my $key ( sort keys %arr) { print "K:$key V:$arr{$key}<br>\n"; }

    my $id = $arr{id};
    delete $arr{id};

    foreach my $key ( keys %arr ) {
	my $sth = $dbh->prepare("update book_title set $key = ? where id = ?");
	$sth->execute($arr{$key}, $id );
	if (DBI::errstr) { print $DBI::errstr; }
    }


    if ( not $DBI::errstr ) {
	print "<h3>$lex{'Record(s) Updated'}</h3>\n";
	
    } else {
	print "<h3>$lex{Error}:$DBI::errstr<br>\n";
	print "$lex{Contact} $adminname <a href=\"mailto:$adminemail\">$adminemail</a></h3>\n";
    }

    print "<p>[ <a href=\"$homepage\">$lex{Main}</a> | \n";
    print "<a href=\"$feespage\">$lex{Fees}</a> | \n";
    print "<a href=\"$self\">$title</a> ]\n";
    
    print "</p></body></html>\n";

    exit;
}



#----------------
sub confirmDelete {
#----------------

    #foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    my $sth = $dbh->prepare("select * from book_title where id = ?");
    $sth->execute( $arr{id} );
    if ( DBI::errstr ) { print $DBI::errstr; die $DBI::errstr }
    my $ref = $sth->fetchrow_hashref;

    print "<form action=\"$self\" method=\"post\">\n";
    print "<input type=\"hidden\" name=\"page\" value=\"4\">\n";
    print "<input type=\"hidden\" name=\"id\" value=\"$arr{id}\">\n";

    print "<table cellpadding=\"3\" border=\"1\" cellspacing=\"0\">\n";

    print "<tr><td class=\"bra\">$lex{Title}</td><td class=\"la\">\n";
    print "$ref->{title}</td></tr>\n";
    
    print "<tr><td class=\"bra\">$lex{Author}</td><td class=\"la\">\n";
    print "$ref->{author}</td></tr>\n";

    print "<tr><td class=\"bra\">$lex{Date}</td><td class=\"la\">\n";
    print "$ref->{pubdate}</td></tr>\n";

    print "<tr><td class=\"bra\">$lex{Description}</td><td class=\"la\">\n";
    print "$ref->{description}</td></tr>\n";

    print "<tr><td colspan=\"2\" style=\"text-align:center;\">\n";
    print "<input type=\"submit\" value=\"$lex{Delete}\">\n";
    print "</td></tr>\n";

    print "</table></form>\n";
    print "</center></body></html>\n";

    exit;

}


#---------------
sub deleteRecord {
#---------------

    # foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    my $sth = $dbh->prepare("select * from book_title where id = ?");
    my $sth1 = $dbh->prepare("delete from book_title where id = ?");

    # Load the record
    $sth->execute( $arr{id} );
    if (DBI::errstr) { print $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref;

    # Delete the record
    $sth1->execute( $arr{id} );
    if ( not $DBI::errstr ) {
	print "<p>$ref->{title} ($ref->{author}) ";
	print "$lex{Deleted}</p>\n";

    } else {
	print "<p>$lex{Error} $DBI::errstr<br>$lex{Contact} $adminname</p>\n";
    }


    print "<p>[ <a href=\"$self\">$lex{Edit}/$lex{Delete} $lex{Title}</a>\n";
    print "| <a href=\"$homepage\">$lex{Main}</a> | <a href=\"$feespage\">$lex{Fees}</a> ]</p>\n";

    print "</center></body></html>\n";

    exit;

}
