# Functions:

# 1) parseGradesPeriod() - passed a grades field (from dates_periods table), return the grades.
# 2) getGradesPeriod() - returns a hash ref to gradeperiod{Grades} = period.
# 3) checkDate(date) returns 255 if error in format; 1 if outside school year; Ok returns 0


#--------------------
sub parseGradesPeriod { # passed a date, return a data struct of grades, periods (%pclosed)
#--------------------

    my ($currdate, $dbh) = @_;

    my %pmap = ( 'P3' => '0', 'PK' => '1', 'K' => '2' );
    my @pmap = ('P3','PK','K');
    
    my %pclosed; #{grade}{period};

    my $sth = $dbh->prepare("select grades,period from dates_periods where date = ?");
    $sth->execute( $currdate );
    if ($DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    while ( my ( $grades, $period ) = $sth->fetchrow ) {
#	print "Record - Grades: $grades Period:$period<br>\n";
	my @grades;
	my @cgroup = split(',',$grades); # split into comma groups
	foreach my $cgroup ( @cgroup ) { # run through comma separated grades.
#	    print "CGROUP:$cgroup<br>\n";
	    my @dgroup = split('-', $cgroup); # split by dash group.
	    my $start = $dgroup[0];
	    my $end = $dgroup[-1];
#	    print "Start:$start End:$end<br>\n";
		    
	    if ( exists $pmap{$start} and exists $pmap{$end} ) { # member of P3,PK,K
		my $sidx = $pmap{$start};
		my $eidx = $pmap{$end};
		for my $idx ($sidx..$eidx) {
		    push @grades, $pmap[$idx];
		}
	    } elsif ( exists $pmap{$start} ) {
		for my $idx ( $start..2 ) { # only have idx values of 0,1,2 for P3,PK,K
		    push @grades, $pmap[$idx];
		} # done entering the text values.
		my $start = 1; # reset to grade 1
		foreach my $gr ( $start..$end ) {
		    push @grades, $gr;
		}
		# end of section where it starts in text (PK, etc) and ends in numbers.
		
	    } else { # numeric only.
		foreach my $gr ( $start..$end ) {
		    push @grades, $gr;
		}
	    }
	    
	} # end of this comma separated cgroup (normally with dashes(-) inside).
	
	foreach my $gr ( @grades ) {
	    $pclosed{$gr}{$period} = 1;
	}
	
    } # record fetching loop for different ppd values and associated grades.

#    foreach my $grade ( sort keys %pclosed ) {
#	foreach my $period ( sort keys %{ $pclosed{$grade} } ) {
#	    print qq{Grade:$grade Period:$period<br>\n};
#	} }
	    
    
    return \%pclosed;

}



#------------------
sub getGradesPeriod {  # from %g_ppd value in configuration system.
#------------------
    
    # Get Attendance Periods from configuration value global hash %g_ppd.

    my %ppdData; # {period}{grade};

    my %pmap = ( 'K' => '3', 'PK' => '2', 'P3' => '1' ); # map text grades to digits.
    my %revpmap = reverse %pmap; # do this here, since added to below.
    

    foreach my $grade (keys %g_ppd ) {
	$grade = uc $grade; # incase of lowercase K, PK, etc. in the configuration

	if ( $g_GradeMap{$grade} ) {
	    next; # skip non standard grades.
	}
	
	my $periods = $g_ppd{$grade};
	
	if ( $grade =~ m/^\d/ ) { # is a digit
	    $grade += 3; # so we have no negative values.
	    
	} elsif ( $pmap{$grade} ) {  # text based grades. P3 to K
	    $grade = $pmap{$grade};  # convert K,PK, etc. to digits.

	} else { # unknown grade
	    print qq{<h3>Unknown Grade. Please add nonstandard grade to g_GradeMap config</h3>\n};
	    print qq{</body></html>\n};
	    exit;
	}
	
	$ppdData{$periods}{$grade} = 1;
    }

    
#    foreach my $period ( sort keys %ppdData ) {
#	foreach my $grade ( sort {$a <=> $b} keys %{ $ppdData{$period} } ) {
#	    print qq{Period:$period Grade:$grade<br>\n};
#	}
#    }

    
    my %periodgroup; # grade group with minimum and max for each attendance periods.
    foreach my $p ( keys %ppdData ) {
	my @gr = sort {$a <=> $b} keys %{ $ppdData{$p} };
	
	if ( scalar @gr == 1 ) { # single element.
	    $periodgroup{$p} = $gr[0];
	    next; # $p
	}
				 
	my $val = $gr[0]; # put in first element.
	foreach my $idx (1..$#gr ) { # loop through rest of elements.
	    my $prev = $idx - 1;
	    if ( $gr[$idx] - $gr[$prev] > 1 ) { # we have a hole, put in a comma.
		$val .= qq{,$gr[$idx]};
	    } else { # we are contiguous
		$val .= qq{-$gr[$idx]};
	    }
	}
	$periodgroup{$p} = $val;
    }

#    foreach my $p ( sort keys %periodgroup ) { print "Periods:$p Group:$periodgroup{$p}<br>\n"; }
    
    # downsize
    foreach my $p ( sort keys %periodgroup ) {
#	print "Period:$p Group:$periodgroup{$p}<br>\n";
	my @temp;
	if ( $periodgroup{$p} =~ m/\-|\,/ ) { # downsize, if we have commas or periods.
	    my @cgroup = split(',', $periodgroup{$p} );
	    foreach my $cgroup ( @cgroup ) { # a 'comma' group
		if ( $cgroup =~ m/\-/ ) { # we have hyphens, so make into A-B format.
#		    print "CGROUP:$cgroup<br>\n";
		    my @dgroup = split('-',$cgroup);

		    # Convert grades back from numbers to letters, if 1,2, or 3.
		    if ( $revpmap{$dgroup[0]} ) {
			$dgroup[0] = $revpmap{$dgroup[0]};
		    } else { # numeric
			$dgroup[0] -= 3;
		    }
		    if ( $revpmap{$dgroup[-1]} ) {
			$dgroup[-1] = $revpmap{$dgroup[-1]};
		    } else { # numeric
			$dgroup[-1] -= 3;
		    }
		    
		    push @temp, qq{$dgroup[0]-$dgroup[-1]};
		    
		} else { # no hyphens, a single value.
		    if ( $revpmap{$cgroup} ) {
			$cgroup = $revpmap{$cgroup};
		    } else {
			$cgroup -= 3;
		    }
		    push @temp, $cgroup;
		}
	    }
#	    print "TEMP:@temp:<br>\n";
	    my $newval = join(',', @temp);
	    $periodgroup{$p} = $newval;
	    
	} else {  #a single value already; convert back if PK,K, etc.
	    if ( $revpmap{$periodgroup{$p} } ) { $periodgroup{$p} = $revpmap{$periodgroup{$p}}; }
	}

    }

    # Check Data
    # foreach my $p ( sort keys %periodgroup ) { print "Periods:$p Group:$periodgroup{$p}<br>\n"; }
    
    return \%periodgroup;
    
}




#------------
sub checkDate {
#------------

    use Time::JulianDay;
    
    my $date = shift;

    my ($y,$m,$d) = split('-',$date);
    
    if ( not $d ) { return 255; }  # wrong format.
    if ( $m > 12 or $m < 1 ) { return 255; }
    if ( $d > 31 or $d < 1 ) { return 255; }

    my $datejd = julian_day( $y, $m, $d );

    my $startjd = julian_day( split('-', $schoolstart ));
    my $endjd = julian_day( split('-', $schoolend ));
    
#    print "DATE:$date - $datejd Start:$schoolstart - $startjd  End:$schoolend - $endjd<br>\n";

    if ( $datejd > $endjd  or $datejd < $startjd ) {
	return 1; # different code for date outside of current year;
    }
    
    return 0;

}

# Do Not Remove
1;
