# Audit System calls

#-------------------
sub addAudit {
#-------------------

    # For Storing Data Structures.
    use Data::Dumper;
    $Data::Dumper::Purity = 1;
    $Data::Dumper::Indent = 0;

    use Encode qw(decode encode);
    
    my ($ref, $dbh) = @_;
    
    my %v = %$ref;
    # $userid, $ipaddr, $scriptname, $table, $tableid, $startval, $endval

    my $dataname = '*'. $v{tablename};
    my ($startval, $endval);
    if ( $v{startval} ) {
	$startval = Data::Dumper->Dump([$v{startval}], ['*startval']);

    }
    if ( $v{endval} ) {
	$endval = Data::Dumper->Dump([$v{endval}], ['*endval']);
    }

    
    my $startvalutf8 = encode('utf8',$startval);
    my $endvalutf8 = encode('utf8',$endval);

   
    my $sth = $dbh->prepare("insert into audit ( userid, ipaddr, scriptname, tablename, tableid, startval, endval ) 
      values (?,?,?,?,?,?,?)");
    $sth->execute( $v{userid}, $v{ipaddr},$v{scriptname}, $v{tablename},$v{tableid}, $startvalutf8, $endvalutf8 );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

#    print "Lib Audit OK<br>\n";
    
    return;

}



# Do Not Remove the 1
1;
