#---------------
sub latex_filter {  # Escape those funny LaTeX Characters.
#---------------

    use utf8;
    foreach my $value ( @_ ){

	$value =~ s/\000//g; # remove nulls.

	$value =~ s/\x{2019}|\x{2018}/'/g; # convert left/right single quotation mark
	$value =~ s/\x{201C}|\x{201D}/"/g; # convert left/right double quotation mark
	$value =~ s/\x{012B}/i/g; # convert i with macron to normal i

	$value =~ s/\222/'/g; # replace single quote 
	$value =~ s/\005|\221|\223|\224|\225|\226|\227/ /g; # remove high MS Characters
	$value =~ s/\205/.../g;
	$value =~ s/\$/\\\$/g;
	$value =~ s/#/\\#/g;
	$value =~ s/&/\\&/g;
	$value =~ s/%/\\%/g;
	$value =~ s/\{/\\\{/g;
	$value =~ s/\}/\\\}/g;
	$value =~ s/\^/\\^/g;
	$value =~ s/_/\\_/g;
	$value =~ s/>/\$>\$/g; # > and < put into math mode
	$value =~ s/</\$<\$/g;
    }
    return @_;

    no utf8;

} # end of sub latex_filter;

# Older Methods; Any Merit?
#$value =~ s/([^\\])#/$1\\#/g;
#$value =~ s/\$/\Q\\$\E/g;
# Match any &, not having a leading backslash to escape it.
# $value =~ s/([^\\])&/$1\\&/g;
1; #true
