#!/usr/bin/perl
#  Copyright 2001-2022 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


my %lex = ('Student' => 'Student',
	   'Parent' => 'Parent',
	   'Site' => 'Site',
	   'No Announcements' => 'No Announcements',
	   'Announcements' => 'Announcements',
	   'View All' => 'View All',
	   'Hover=Full View' => 'Hover on Title to see Full Text',
	   'Closed' => 'Closed',

	   );

my $self = 'pindex.pl';


my $defaultfile = 'parent.html';
my $defaultpath = '.';
my $textlength = 205;

use DBI;
use CGI;
use CGI::Session;
use Time::JulianDay;

my $q = CGI->new;
my %arr = $q->Vars;


eval require "../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

# contains DayInCycle function
eval require "../lib/libschedule.pl";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}


# Set Date
my @tim = localtime(time);
my $year = @tim[5] + 1900;
my $month = @tim[4] + 1;
my $day = @tim[3];
my $currdate = "$year-$month-$day";

# Database setup
my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


print $q->header;

# Display Day In Cycle. - from libSchedule.pl
my $cycleday = findDayInCycle($currdate, $dbh);

# check if closed.
my $sth = $dbh->prepare("select * from dates where date = ?");
$sth->execute( $currdate );
if ( $DBI::errstr ) { print DBI::errstr; die $DBI::errstr; }
my $ref = $sth->fetchrow_hashref;
my %r = %$ref;

if ( $r{dayfraction} > 0.99 or $cycleday == 0 ) { # closed all day
    $cycleday = qq{<i>$lex{'Closed'}</i>};
}


my $title1 = "Open Administration for Schools $g_OpenadminVersion";
my $title2= "$lex{Parent}/$lex{Student} $lex{Site}";
# Both titles and $cycleday used in the parent.html file.

print qq{<!DOCTYPE html>\n};
print qq{<html><head><title>$title1 &ndash; $title2</title>\n};
print qq{<meta name="viewport" content="width=device-width,initial-scale=1.0">};
print qq{<meta charset="utf-8">\n};
print qq{<link rel="stylesheet" type="text/css" href="padmin.css">\n};
print qq{</head><body>\n};

print <<"FRAGMENT";
<!--
  Copyright 2001-2022 Leslie Richardson
  This file is part of Open Admin for Schools.
  Freely Available under GNU General Public License 
-->

<img src="images/logo.gif" height="150" style="float:left;margin:0;padding:0;">

<div style="margin:0;padding:3em;">
<h1 style="padding:0.2em;display:inline;margin:0;">$title2</h1><br>
<h1 style="font-size:90%;display:inline;padding:0.2em;margin:0;">$title1</h1><br>
<div style="font-size:90%;display:inline;font-weight:bold;padding:0.4em;margin-left:1em;">
Day $cycleday in School Cycle</div>
</div>
<br clear="left">

FRAGMENT


my $path = "$defaultpath/$defaultfile";
open(FH,'<', $path) || die "Cannot open:\n";
my $htmlfile;
{ local $/; $htmlfile = <FH>; close FH; }

print qq{<div style="float:left;padding:0.5em;">\n};
print $htmlfile;
print qq{</div>\n};

print qq{<div style="float:left;padding:0.5em;width:80ch;">\n};
viewAnnouncements(); # returns a div of announcements
print qq{</div>\n};

print qq{</body></html>\n};


#--------------------
sub viewAnnouncements {
#--------------------

    print qq{<h2 style="text-align:left;">$lex{Announcements}</h2>\n};

    print qq{<div style="text-align:left;">};
    print qq{$lex{'Hover=Full View'} | };
    print qq{<form action="/pcgi-bin/announce/announceview.pl" method="post" };
    print qq{target="_blank" style="display:inline;">};
    print qq{<input type="submit" value="$lex{'View All'}"></form>\n};
    print qq{</div><hr>\n};


    # Load Top Announcements
    my $topselect = qq{where topstay = 1 and ( atype = 'parent' or atype = 'both')};
    my $sth = $dbh->prepare("select * from announce $topselect order by adate desc");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my %topstay;
    my $first = 1;

    while ( my $ref = $sth->fetchrow_hashref ) {
	$ref->{atopic} = qq{<span style="color:red;">*</span>}. $ref->{atopic}; # mark top
	my $id = $ref->{id};
	$topstay{$id} = 1; # holds records already displayed.
	prAnnounce( $ref );
	$first = 0;
    }

    # Rest of Page Announcements
    my $select = qq{where atype = 'parent' or atype = 'both'};

    $sth = $dbh->prepare("select * from announce $select order by adate desc");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    while ( my $ref = $sth->fetchrow_hashref ) {
	if ( $topstay{ $ref->{id} } ) { next; } # skip if already displayed on top.
	prAnnounce( $ref );
	$first = 0;
    }

    if ( $first ) {
	print qq{<h3>$lex{'No Announcements'}</h3>\n};
    }

    return;

} # end of viewAnnouncements


#-------------
sub prAnnounce {
#-------------

    my $ref = shift;
    my $date = fmtdate( $ref->{adate} );
    my $text = substr( $ref->{adesc}, 0, $textlength );
    $text =~ m/(^.+\b)/;
    $text = $1;
    my $titleattr = $q->escapeHTML( $ref->{adesc} );

    print qq{<div class="annce" title="$titleattr">};
    print qq{<b>$ref->{atopic}</b><br><i>$date</i></div>\n};
    print qq{<div>$text ...</div><hr>\n\n};
}

#----------
sub fmtdate {
#----------

    my $date = shift;
    my ($yr, $mo, $da) = split(/-/, $date);

    my $month = $month[$mo];

    my $jd = julian_day( split(/-/,$date) );
    my $dayindex = day_of_week( $jd )+ 1;
    my $day = $dow[$dayindex];

    my $rv = "$day, $month $da, $yr";

    return $rv;

}
