#!/usr/bin/perl
#  Copyright 2001-2020 Leslie Richardson

#  This file is part of Open Admin for Schools.


# entry box sizes for input
my $homeworklength = 20;
my $topiclength = 15;
my $maxBlankCounter = 6; # more than 6 blank periods, skip doing back lookups.
my $daylimit = 4; # number of school days to look forward or back.

my %lex = ('Not Assigned' => 'Not Assigned',
	   'Daybook' => 'Daybook',
	   'Main' => 'Main',
	   'Today is a non-cycle Day' => 'Today is a non-cycle Day',
	   'Day' => 'Day',
	   'Term' => 'Term',
	   'Homework Due' => 'Homework Due',
	   'Desc' => 'Desc',
	   'Update' => 'Update',
	   'Please Log In' => 'Please Log In',
	   'User Id' => 'User Id',
	   'Password' => 'Password',
	   'Not Found' => 'Not Found',
	   'Please check configuration file' => 'Please check configuration file',
	   'Error' => 'Error',
	   'Topic' => 'Unit',
	   'Category' => 'Strand',
	   'Period' => 'Period',
	   'Time' => 'Time',

	   'Track' => 'Track',
	   'Term' => 'Term',
	   'Previous Week' => 'Previous Week',
	   'Next Week' => 'Next Week',
	   'Select' => 'Select',
	   'Date' => 'Date',
	   'Go' => 'Go',

	   'Cycle' => 'Cycle',
	   

	   );

my $self = 'dbook.pl';

use DBI;
use CGI;
use Time::JulianDay;


my $q = CGI->new;
my %arr = $q->Vars; # Get passed values


eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


eval require "../../lib/libschedule.pl";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

print $q->header(-charset, $charset);

my $dsn = "DBI:$dbtype:dbname=$dbase";
$dbh = DBI->connect($dsn,$user,$password);



# Set limits for school year: startjd and endjd
my $schoolstart = $g_MTrackTerm{1}{1}{'start'}; #override global
my $startjd = julian_day( split('-',$schoolstart));
my $endjd = julian_day( split('-', $schoolend));

my (@tim, $year,$month,$day);
@tim = localtime(time);
$year = $tim[5] + 1900;
$month = $tim[4] + 1;
$day = $tim[3];

my $currjd = julian_day($year,$month,$day);
if ( $currjd < $startjd ) {
    $currjd = $startjd;
    ($year, $month, $day) = inverse_julian_day( $currjd );
    
} elsif ( $currjd > $endjd ) {
    $currjd = $endjd;
    ($year, $month, $day) = inverse_julian_day( $currjd );
}


my $userid = $ENV{'REMOTE_USER'};
my $sth = $dbh->prepare("select lastname, firstname from staff where userid = ?");
$sth->execute( $userid );
if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
my ($lastname, $firstname) = $sth->fetchrow;


# Write Updates to Database.
if ( $arr{writeflag} ){  # update records.
    delete $arr{writeflag};
    updateRecords();
}


# Get Periods and their times
my %ptime; # period times
my $sth = $dbh->prepare("select timeset from period_map where timetype = 'userid' and timeval = ?");
$sth->execute( $userid );
if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
my $timeset = $sth->fetchrow;

if ( $timeset ) {
    $sth = $dbh->prepare("select * from period_data where timeset = ?");
    $sth->execute( $timeset );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    while ( my $ref = $sth->fetchrow_hashref ) {
	my %r = %$ref;
	#    $r{starttime} =~ s/:\d\d$//; # strip the seconds
	#    $r{endtime} =~ s/:\d\d$//;
    
	$ptime{ $r{period} }{starttime} = conv24to12( $r{starttime} );
	$ptime{ $r{period} }{endtime} = conv24to12( $r{endtime} );
    }
}

if ( not %ptime ) { # use system times. $g_PeriodTime and g_PeriodMap
    my @tmp = keys %g_PeriodTime; 
    my %p = %{ $g_PeriodTime{$tmp[0]} }; # only use the first ID for period mapping.
    foreach my $period ( keys %p ) {
	$ptime{$period}{starttime} = conv24to12( $p{$period}{s} );
    	$ptime{$period}{endtime} = conv24to12( $p{$period}{e} );
    }
}


# Display Date Selections at top of the page.
my ($currdate,$currsdate, $mondayjd, $currjd, $dow );
if ( $arr{date} ) {

    # Generate a list from those dates.
    ($year,$month,$day) = split('-',$arr{date});
    
    $currjd = julian_day($year,$month,$day);
    $dow = day_of_week($currjd);
    $mondayjd = $currjd - ($dow-1);

    if ( $dow == 0 or $dow == 6 ) { # weekend, change to next monday;
	$nextmondayjd = $currjd - ($dow-1) + 7;
	$currjd = $nextmondayjd;
	($year,$month,$day) = inverse_julian_day( $currjd );
	$dow = day_of_week($currjd);
    }
    
    if (length($month) == 1){ $month = "0".$month;}
    if (length($day) == 1){ $day = "0".$day;}
    $currsdate = "$year$month$day"; 
    $currdate = "$year-$month-$day";

} else {

    @tim = localtime(time);
    $year = $tim[5] + 1900;
    $month = $tim[4] + 1;
    $day = $tim[3];

    $currjd = julian_day($year,$month,$day);
    $dow = day_of_week($currjd); # for consumption below also; subj att entry
    $mondayjd = $currjd - ($tim[6]-1); #This will now give Monday of that week.
    if (length($month) == 1){ $month = "0".$month;}
    if (length($day) == 1){ $day = "0".$day;}
    $currdate = "$year-$month-$day";
    $currsdate = "$year$month$day";

} 


# Figure out the current term(s) for each track.
my ($currterm, %terms, %grade2terms );

foreach my $trk ( sort {$a <=> $b} keys %g_MTrackTerm ) {
    for my $trm ( sort {$a <=> $b} keys %{ $g_MTrackTerm{$trk}} ) {

	my $startjd = julian_day( split('-', $g_MTrackTerm{$trk}{$trm}{start}) );
	my $endjd =  julian_day( split('-', $g_MTrackTerm{$trk}{$trm}{end}) );
	if ( $currjd >= $startjd and $currjd <= $endjd ) { # we have the term.
	    $terms{$trk} = $trm;
	    last; # done with this track.
	}
    }
}

# Testing: foreach my $key ( sort keys %terms ) { print "K:$key V:$terms{$key}<br>\n"; }

foreach my $gr ( keys %g_MTrackTermType ) {
    my $track = $g_MTrackTermType{$gr};
    $grade2terms{$gr} = $terms{$track};
}


# Get the grade(s) of this teacher
my %myterms; # for this teacher.
$sth = $dbh->prepare("select field_value from staff as s, staff_multi as sm
  where s.userid = sm.userid and s.userid = ? and field_name = 'grade'");
$sth->execute( $userid );
if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
while ( my $grade = $sth->fetchrow ) {
    my $term = $grade2terms{$grade};
    $myterms{$grade} = $term;
}

if ( not %myterms ) { # nothing in staff_multi.... check grades from courses.
    my $sth = $dbh->prepare("select distinct grade from subject where teacher = ?");
    $sth->execute( $userid );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    while ( my $grade = $sth->fetchrow ) {
	my $term = $grade2terms{$grade};
	$myterms{$grade} = $term;
    }
}
    

# Testing: foreach my $key ( sort keys %grade2terms ) { print "Grade:$key Term:$grade2terms{$key}<br>\n"; }


# Setup Array and Hash to hold Dates and DOW Dates (Multi-Day Method)
my ($ddref, $dayref) = mkDateData($mondayjd,$weekcount);
my @days = @$dayref;
my %datedata = %$ddref;
    

# Push Teacher Rooms into array
$sth = $dbh->prepare("select field_value from staff as s, staff_multi as sm
  where s.userid = sm.userid and s.userid = ? and field_name = 'homeroom'");
$sth->execute( $userid );
if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
while ( my $homeroom = $sth->fetchrow ) {
    push @hroom, $homeroom;
}


# Load non-school days, if any for these homerooms.
my %nonschoolday;
my $sth = $dbh->prepare("select date, period from dates_homeroom where homeroom = ?");
foreach my $hr ( @hroom ) {
    $sth->execute( $hr );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    while ( my ($date,$period) = $sth->fetchrow ) {
	$nonschoolday{$hr}{$date}{$period} = 1;
#  print "HR:$hr Date:$date Period:$period<br>\n";
    }
}


# Heading of Document
print qq{$doctype\n<html><head><title>$lex{Daybook}</title>\n};
print qq{<link rel="stylesheet" href="$tchcss" type="text/css" media="screen">\n};

# Setup for Calendar popup.
print qq{<link rel="stylesheet" type="text/css" media="all" href="/js/calendar-blue.css" title="blue">\n};
print qq{<script type="text/javascript" src="/js/calendar.js"></script>\n};
print qq{<script type="text/javascript" src="/js/lang/calendar-en.js"></script>\n};
print qq{<script type="text/javascript" src="/js/calendar-setup.js"></script>\n};

print qq{$chartype\n};

print qq{<script language="javascript" type="text/javascript">
function win1() {
  winName=window.open('timetableset.pl',
  'ScheduleWindow','height=700,width=1000,screenX=50,screenY=50');
  winName.focus();
}

window.onbeforeunload = function() {
  return true;
}
</script>\n};
# winName=window.open('../tchschedview.pl?userid=$userid&term=$term',

print qq{</head><body>\n};


print qq{<div style="display:inline;float:left;padding:0.5em;">\n};
print qq{[ <a href="$tchpage">$lex{Main}</a> | \n};
print qq{<a href="javascript:win1()">myTimetable</a> ]\n};


print qq{<span style="font-weight:bold;font-size:120%;">Day Book</span> <i>};
my $firstview = 1;

foreach my $trk ( sort keys %terms ) { 
    my $trm = $terms{$trk};
    if ( not $firstview ) { print qq{ | }; }
    print qq{<b>$lex{Term}</b> $trm \n};
    # <b>$lex{Track}</b> $trk 
    $firstview = 0;
}
print qq{\n<b>$firstname $lastname</b></i></div>\n};



# Weekly Date Calcs - Previous Week / Next Week.
my $prevjd = $mondayjd - 7;
if ( $prevjd < $startjd ){ $prevjd = $startjd;}
my ($prevyear, $prevmonth, $prevday) = inverse_julian_day($prevjd);
my $prevdate = "$prevyear-$prevmonth-$prevday";

print qq{<div style="display:inline;float:right;padding:0.3em;">\n};
print qq{<form action="$self" method="post" style="display:inline;">\n};
print qq{<input type="hidden" name="date" value="$prevdate">\n};
#print qq{<input type="hidden" name="method" value="$method">\n};
print qq{<input type="hidden" name="page" value="1">\n};
print qq{<input type="submit" value="<= $lex{'Previous Week'}"></form>\n};

my $nextjd = $mondayjd + 7; 
if ($nextjd > $endjd){ $nextjd = $endjd;}
my ($nextyear, $nextmonth, $nextday) = inverse_julian_day($nextjd);
my $nextdate = "$nextyear-$nextmonth-$nextday";

print qq{<form action="$self" method="post" style="display:inline;">\n};
#print qq{<input type="hidden" name="method" value="$method">\n};
print qq{<input type="hidden" name="date" value="$nextdate">\n};
print qq{<input type="hidden" name="page" value="1">\n};
print qq{<input type="submit" value="$lex{'Next Week'} =>"></form>\n\n};


# Pop Up Calendar Date Selector
print qq{<form action="$self" method="post" };
print qq{style="display:inline;background-color:yellow;padding:0.3em 0.5em;border:1px solid gray;">\n};
# print qq{<input type="hidden" name="method" value="$method">\n};
print qq{<input type="hidden" name="page" value="1">\n};
print qq{<button type="reset" id="date_trigger">$lex{Select} $lex{Date}</button>\n};
print qq{<input type="text" name="date" id="date" size="10">\n};
print qq{<input type="submit" value="$lex{Go}">\n};
print qq{</form><br>\n\n};


my $sth = $dbh->prepare("select id, dayfraction from dates where date = ?");

for my $i ( 1..5 ) { # five days of this week.

    my ($wkyear, $wkmonth, $wkday) = inverse_julian_day($mondayjd);
    my $dow = day_of_week($mondayjd) + 1;
    my $tmpdate = qq{$wkyear-$wkmonth-$wkday};

    # Check for date being fully closed or not (ie ALL DAy).
    # Skip if closed all day.
    $sth->execute( $tmpdate );
    my ( $id, $dayfrac ) = $sth->fetchrow;
    # Logic: Skip for attendance if closed all day.
    if ( $dayfrac > 0.99 ) { # ie. only 1.000, closed all day, skip
	$mondayjd++;
	next;
    }

#    if ( $i == 4 ) { print qq{<br>\n}; }
    print qq{<form action="$self" method="post" style="display:inline;">\n};
    print qq{<input type="hidden" name="date" value="$tmpdate">\n};
    print qq{<input type="hidden" name="page" value="1">\n};
    print qq{<input type="submit" value="$dow[$dow] $month[$wkmonth] $wkday"></form>\n};
    $mondayjd++;
}
print qq{</div>\n};


# Find DayInCycle
my $dayInCycle = findDayInCycle($currdate, $dbh);


print qq{<br clear="left"><div style="float:left;padding:0.4em;">\n};
my $localdow = $dow + 1;
print qq{<span style="font-weight:bold;font-size:120%;">$dow[$localdow], $currdate</span>\n};
print qq{<span style="font-weight:bold;padding:1em;">$lex{Cycle} $lex{Day}: $dayInCycle</span>\n};

print qq{</div><br clear="left">\n};


# Halt if dayInCycle undefined. (ie. due to being a non-cycle day) ... just above
if ( not $dayInCycle ) {
    print qq{<h3>$lex{'Today is a non-cycle Day'}</h3>\n};
    print qq{</body></html>\n};
    exit;
}


# Test to make sure we only have a single term.
my $termtest;
foreach my $grade ( keys %myterms ) {
    if ( not $termtest ) { $termtest = $myterms{$grade}; }
#    print qq{Grade:$grade Term:$myterms{$grade}<br>\n};
    if ( $termtest != $myterms{$grade} ) {
	print qq{<h3>Error: We have multiple terms for this userid. Contact Les Richardson</h3>};
	print qq{</body></html>\n};
	exit;
    }
}
my $term = $termtest; 


# Get Courses, PeriodMap from system or from personal values
my (%attendancetype, $periodmap) ;
foreach my $grade ( keys %myterms ) {
    my $type = $g_AttendanceEntryMethod{$grade};
    $attendancetype{$type} = 1;
    $periodmap = $g_PeriodMap{$grade};
}


my %courseact; # course or activity


if ( $attendancetype{homeroom} ) { # load personal
 
    # Get the Teachers Subjects/Activities
    my $sth = $dbh->prepare("select * from dbktimetable where userid = ? and term = ? and day = ?");
    $sth->execute( $userid, $term, $dayInCycle );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $ref = $sth->fetchrow_hashref ) {
	my %r = %$ref;
	$courseact{ $r{period} }{ $r{courseact} } = 1;
#	print qq{ACT: User:$userid TRM:$term Day:$dayInCycle Per:$r{period} ACT:$r{courseact}<br>\n};
	
    }
    
    
    
} else { # subject attendance for these

    # Get the Teachers Subjects/Activities (either from personal or from system);
    my $sth = $dbh->prepare("select description,smdesc,subjsec from subject 
       where teacher = ? and startrptperiod <= ? and endrptperiod >= ? order by description");
    $sth->execute( $userid , $term, $term );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    # Prep for loop finding the periods course/activity is offered.
    my $sth1 = $dbh->prepare("select period from schedat where term = ? and subjsec = ? and day = ? ");

    # Put current term courses into 2D hash.
    while ( my ( $description,$smdesc,$subjsec ) = $sth->fetchrow ){
	
	$sth1->execute($term, $subjsec, $dayInCycle);
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	while ( my  $period = $sth1->fetchrow ) {
	    $courseact{$period}{$subjsec} = 1;
	}
    }
}


#foreach my $period ( sort keys %courseact ) {
#    foreach my $courseact ( sort keys %{ $courseact{$period} } ) {
#	print qq{Period:$period CourseAct:$courseact<br>\n};
#    }
#}


# Start the main form.
print qq{<!--  Main Form Entry Starts Here!  -->\n};
print qq{<form action="$self" method="post">\n};

print qq{<input type="submit" value="$lex{Update}" style="font-size:85%;margin:0.2em;">\n};
print qq{<input type="hidden" name="date" value="$currdate">\n};
print qq{<input type="hidden" name="writeflag" value="1">\n};


# Setup Selects for use inside loop.
my $sth2 = $dbh->prepare("select description from subject where subjsec = ?");

my $sth3 = $dbh->prepare("select distinct topic from dbkdata 
 where subjsec = ? and topic != '' order by date desc");

my $sth4 = $dbh->prepare("select distinct category from dbkdata 
 where subjsec = ? and category != '' order by category");

my $sth5 = $dbh->prepare("select * from dbkdata 
 where userid = ? and date = ? and period = ?");

# Activity values
my $sth6 = $dbh->prepare("select * from dbkactivity where id = ?");



# We need to do this since there may be missing values in the keys (periods) not scheduled. (prep)
my $maxperiods;
foreach my $per ( keys %courseact ) {
    if ( $per > $maxperiods ) { $maxperiods = $per; }
}
    
my ( %course, %activity );
my $bgcolor;

# Loop through each course/activity
for my $period ( 1 .. $maxperiods ){
    
    if ( $bgcolor eq '#CCC' ) { 
	$bgcolor = '#CCF';
    } else {
	$bgcolor = '#CCC';
    }

    print qq{<div style="background-color:$bgcolor;border:2px solid black;margin:0.4em;">\n};
    
    my $first = 1;
    foreach my $crsact ( keys %{ $courseact{$period} } ) {

	if ( $first ) { $first = 0; } # turn off inside course loop

	# Course Type (activity,course)
	my ($ctype,$title,$description );
	my ($id, $subjsec);

	# doesn't work since activity has a dash, not a colon.
#	if ( $crsact =~ m/ACTIV/ ) {
#	    ($dud,$id) = split(':', $crsact);
#	    $crsact = qq{ACTIV-$id};
#	}
	
	my ($course,$section) = split('-', $crsact);
	if ($course eq 'ACTIV' ) { # we have an activity
	    $id = $section;
	}
	$subjsec = $crsact;
	
	if ( $id ) { # get activity record;
	    $sth6->execute($id);
	    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	    my $ref = $sth6->fetchrow_hashref;
	    $activity{$id} = $ref;

	    $ctype = 'Activity';
	    $title = $ref->{title};
	    $description = $ref->{description};
	    
	} else { # Get Subject Description
	    $sth2->execute( $subjsec );
	    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	    my $desc = $sth2->fetchrow;
	    $course{$subjsec} = $desc;

	    $ctype = 'Course';
	    $title = $desc;
	    # Description is blank, since no values.
	}

	
	# Get previous topics for this course/activity
	my @topics;
	$sth3->execute( $crsact );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	while ( my $topic = $sth3->fetchrow ) {
	    push @topics,$topic;
	}

	# Get previous categories
	my @categories;
	$sth4->execute( $crsact );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr;}
	while ( my $cat = $sth4->fetchrow ) {
	    push @categories, $cat;
	}
	

	# Get Previous Period (not in current day...)
	my $pn; # previous note
	$sth1 = $dbh->prepare("select notes, date, period from dbkdata 
         where subjsec = ?  and to_days(date) < to_days('$currdate')
         order by date desc, period desc");
	$sth1->execute( $subjsec );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	my $blankCounter = 0;

	my $previousPeriod; 
NOTE:
	while ( my ($prevnote, $prevdate, $prevperiod) = $sth1->fetchrow) {
	    if ( not $prevnote ) { 
		$blankCounter++;
		if ($blankCounter > $maxBlankCounter) { last; }
		next NOTE; 
	    }

	    # Get dow for prevdate;
	    my ($year,$month,$day) = split '-',$prevdate;
	    my $jd = julian_day($year,$month,$day);
	    my $dow = day_of_week($jd) + 1;
	    my $prevdow = $s_dow[$dow]; # @sdow (short days of week) defined in admin.conf

	    my $prevsdate = "$month-$day";
	    $previousPeriod = "<b>$prevdow, $prevsdate:</b> $prevnote\n";
	    last;

	}


	# get current data, access by userid, date, period, crsact
	my %currdata;
	my $sth1 = $dbh->prepare("select * from dbkdata 
          where userid = ? and period = ? and date = ? and subjsec = ?");

	$sth1->execute( $userid, $period, $currdate, $crsact );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	# removed the while loop
	my $ref = $sth1->fetchrow_hashref;
	
	my $topic = $ref->{topic};
	my $notes = $ref->{notes};
	my $homework = $ref->{homework};
	my $hwdate = $ref->{hwdate};
	my $category = $ref->{category};

	# Display the current subject and period.
	print qq{<div style="padding:2px; background-color:#46F; color:white;};
	print qq{margin:2px; border:1px solid black;">};

    
	# Period and Time.
	print qq{$lex{Period} <b>$period</b> };
	print qq{$lex{Time}: <b>$ptime{$period}{starttime}-$ptime{$period}{endtime}</b>\n};
	if ( not $title ) { $title = $lex{'Not Assigned'}; }
	print qq{ <b>$title</b> ($crsact)</div>\n};


	# Topic
	print qq{$lex{Topic} <select name="$period:$subjsec:topic">};
	if ( $topic ){ 
	    print qq{<option>$topic</option>\n}; 
	} else { 
	    print qq{<option value=""></option>\n}; 
	}
	foreach my $tp ( @topics ){ 
	    if ( $tp eq $topic ){ next; } # skip topic already shown
	    print qq{<option>$tp</option>};
	}
	print qq{</select><input type="text" name="$period:$subjsec:newtopic" };
	print qq{size="$topiclength">\n};


	# Show Category Section
	print qq{$lex{Category} <select name="$period:$subjsec:category">};
	if ( $category ){ 
	    print qq{<option>$category</option>\n};
	} else { 
	    print qq{<option value=""></option>\n}; 
	}
    
	foreach my $ct ( @categories ){ 
	    if ($category eq $ct){ next;} # skip category already shown.
	    print qq{<option>$ct</option>};
	}
    
	print qq{</select>\n};
	print qq{<input type="text" name="$period:$subjsec:newcategory" };
	print qq{size="$topiclength">\n};

	# print $lex{'Homework Due'}. ": <input type="text" name="$period:$subjsec:hwd" };
	# print qq{size="10" value="$hwdate" >};
	# print qq{$lex{Desc}: <input type="text" name="$period:$subjsec:hwk" };
	# print qq{value="$homework" size="$homeworklength" maxlength="255"><br>\n};

	if ( $previousPeriod ) {
	    print qq{<div style="padding:0.5em;"><b>Previously</b> $previousPeriod</div>\n};
	}

	# Note Section
	print qq{<div><textarea name="$period:$subjsec:note" rows="6" cols="120">};
	print qq{$notes</textarea></div>\n};

    } # end of course/activity loop for this period

    if ( $first ) { # no course assigned.
	# Display the current subject and period.
	print qq{<div style="padding:2px; background-color:#46F; color:white;};
	print qq{margin:2px; border:1px solid black;">};

    	# Period and Time.
	print qq{$lex{Period} <b>$period</b> };
	print qq{$lex{Time}: <b>$ptime{$period}{starttime}-$ptime{$period}{endtime}</b>\n};
	if ( not $title ) { $title = $lex{'Not Assigned'}; }
	print qq{ <b>$title</b></div>\n};
    }

    
    print qq{</div>\n};
    
} # end of periods loop

print qq{<input type="submit" value="$lex{Update}" style="font-size:85%;margin:0.2em;">\n};
print qq{</form>\n};

print qq{<script type="text/javascript">
 Calendar.setup({
   inputField  : "date",
   ifFormat    : "%Y-%m-%d",
   button      : "date_trigger",
   singleClick : false,
   step : 1
 });
 </script>\n};


print qq{</body></html>\n};



#-----------
sub findTerm {
#-----------

    my $date = shift; # Passed Date. 
    my $jd = julian_day( split('-', $date));

#    print qq{Passed Date:$date<br>\n};
    
    my %terms;

    foreach my $trk ( sort keys %g_MTrackTerm ) {
	foreach my $trm ( keys %{ $g_MTrackTerm{$trk} } ) {

#	    print qq{Track:$trk - Term:$trm<br>};
	    my $ref = $g_MTrackTerm{$trk}{$trm};

	    my $startjd = julian_day( split('-', $ref->{'start'}) );
	    my $endjd = julian_day( split('-', $ref->{'end'}) );

	    if ( $jd >= $startjd and $jd <= $endjd ) {
#		print qq{Match: TRK:$trk TRM:$trm<br>\n};
		$terms{ $trm } = $trk;
	    }

#	    print qq{Start: $ref->{'start'} - $startjd<br>\n};
#	    print qq{End: $ref->{'end'} - $endjd<br>\n};

	}
    }


    my @temp = keys %terms;
    return @temp;


} # End of findTerm



#----------------
sub updateRecords {
#----------------
    
    my %rec = %arr;
    # Don't mess with %arr hash since this is passed through to display functions.

#    foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    
    my $date = $rec{date};
    delete $rec{date};
    # print "Date:$date<br>\n";

    # Create Data hash, based on period and subjsec
    foreach my $key ( keys %rec ){
	# $type is whether a note, topic, category, newtopic, newcategory
	my ($period, $subjsec, $field) = split(':',$key);
	$subjsec =~ s/\s+//g; # strip space

	$data{"$period:$subjsec"}{$field} = $rec{$key};
     
    }

=head    
    # Test Data;
    foreach my $key ( sort keys %data ) {
	my ($period,$subjsec) = split(':',$key);
	print qq{Period:$period Subjsec:$subjsec<br>\n};
	my %r = %{ $data{$key} };
	foreach my $key ( sort keys %r ) {
	    print qq{K:$key V:$r{$key}<br>\n};
	}
	print "<br>\n";
    }
=cut
    

    # Check for existing record
    my $sth = $dbh->prepare("select id from dbkdata 
      where subjsec = ? and userid = ? and period = ? and date = ?"); 
    
    # Update the record
    my $sth1 = $dbh->prepare("update dbkdata set 
       topic = ?, notes = ?, homework = ?, hwdate = ?, category = ?  where id = ?"); 

    # Insert a new record
    my $sth2 = $dbh->prepare("insert into dbkdata (userid, date, subjsec, period, topic, 
       notes, homework, hwdate, category)  values (?,?,?,?,?,?,?,?,?)");
    

    # Now update it, loop through data hash.
    foreach my $key ( keys %data ) {
	my ($period,$subjsec) = split(':',$key);

	# Check for existing record
	$sth->execute( $subjsec, $userid, $period, $date );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	my $id = $sth->fetchrow;

	my %r = %{ $data{$key} };

	# Check for a new category
	if ( $r{newcategory} ) { 
	   $r{category} = $r{newcategory};
        }

	# Check for a new topic
	if ( $r{newtopic} ) { 
	   $r{topic} = $r{newtopic};
        }

#	print "RECORD<br>\n";
#	foreach my $key ( sort keys %r ) {
#	    print qq{K:$key V:$r{$key}<br>\n};
#	}

	# New homework date
#        if ( $r{hwdate} =~ m/^\+\S+/){
#            # Find future date of this class.
#            $r{hwdate} = $dbh->quote( findFutureClass($date,$period,$userid,$term,
#						   $subjsec,$r{hwdate} ) );
#        }

        if ( $id ) { # update the existing record
	    $sth1->execute( $r{topic}, $r{note}, $r{homework}, $r{hwdate}, $r{category}, $id );
	    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

	} else { # add a record
	    if ( $r{note} or $r{topic} ) {
		$sth2->execute( $userid, $date, $subjsec, $period, $r{topic},
				$r{note}, $r{homework}, $r{hwdate}, $r{category} );
		if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	    }
	}

    }

    return;
    
} # End of updateRecords


#-------------
sub mkDateData {
#-------------

    my ($jd, $weeks) = @_;
    my (%datedata, @days);
    
    # Build an array of ISO dates (YYYY-MM-DD) and a hash using them
    # as keys to hash values of 'Mon Jan 6' format.
    # If one week, then just 5 values, if two wk then 10, etc.
    my $counter = 7;
    if ( $weeks == 2 ) { $counter = 14; };

    
    for ( 1..$counter ){
	my ($yr,$mon,$day) = inverse_julian_day($jd);
	if ( length( $mon ) == 1 ) { $mon = '0'. $mon; }
	if ( length( $day ) == 1 ) { $day = '0'. $day; }
	
	my $dow = day_of_week($jd) + 1;
	if ( $dow == 1 or $dow == 7 ) {  # dow function returns 0 and 6
	    $jd++;
	    next; 
	} # skip Saturday, Sunday.
	my $date = qq{$yr-$mon-$day};
	    
	# Check if the school is closed.
	my $sth = $dbh->prepare("select id, dayfraction from dates where date = ?");
	$sth->execute( $date );
	my ( $id, $dayfrac ) = $sth->fetchrow;
	if ( $dayfrac > 0.99 ) {
	    $jd++;
	    next; 
	} # skip if closed all day
	    
	push @days, $date;
	$datedata{"$yr-$mon-$day"} = qq{$s_dow[$dow], $s_month[$mon] $day};
	$jd++;
    }

    # print "DAYS:", @days, "<br>\n";

    return \%datedata, \@days;
    
} # end of mkDateData



#-------------
sub conv24to12 {  # also strips seconds now
#-------------

    my $time = shift;
    if ( not $time ) { return }
    my ($hr, $min, $sec ) = split(':', $time);
    my $ampm = 'AM';
    if ( $hr == 12 ) { $ampm = 'PM'; }
    if ( $hr == 0 ) { $hr = 12; };

    if ( $hr > 12 ) { 
	$hr -= 12;
	$ampm = 'PM';
    }

    return qq{$hr:$min $ampm};

}
