#!/usr/bin/perl
#  Copyright 2001-2022 Leslie Richardson

#  This file is part of Open Admin for Schools.

my %lex = ('Delete' => 'Delete',
	   'Assessment Items' => 'Assessment Items',
	   'GB Main' => 'GB Main',
	   'Main' => 'Main',
	   'Date' => 'Date',
	   'Name' => 'Name',
	   'Description' => 'Description',
	   'Group' => 'Group',
	   'No Course Found' => 'No Course Found',
	   'Error' => 'Error',
	   'Please Log In' => 'Please Log In',
	   'Scores' => 'Scores',

	   );

use DBI;
use CGI;
use CGI::Session;

my $self = 'gbTestDelete.pl';

my $q = new CGI;
my %arr = $q->Vars;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@<br>\n";
}

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Get Session Information...
my $session = new CGI::Session("driver:mysql;serializer:FreezeThaw",
 undef,{Handle => $dbh}) or die CGI::Session->errstr;

my $logged_in = $session->param(logged_in);
if ( not $logged_in ) {
    print $q->header( -charset, $charset );
    print qq{[ <a href="gbmain.pl">$lex{'GB Main'}</a> ]\n};
    print qq{<h3>$lex{'Please Log In'}</h3>\n};
    exit;
}

my $subjsec = $session->param('subjsec');
print $q->header( -charset, $charset ); 


# Load Course Info
my $sth = $dbh->prepare("select description from subject where subjsec = ?");
$sth->execute( $subjsec );
if ($DBI::errstr){ print $DBI::errstr; die "$DBI::errstr:$!\n";}
my $desc = $sth->fetchrow;

my $title = qq{$lex{Delete} $lex{'Assessment Items'}};
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$tchcss" type="text/css">
$chartype\n</head><body style="padding:1em;">\n};

print qq{[ <a href="$tchpage">$lex{Main}</a> |\n};
print qq{<a href="gbmain.pl">$lex{'GB Main'}</a> ]\n};
print qq{<h1>$title - $desc</h1>\n};

if ( not $arr{page} ) {
    showStartPage();
    
} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    deleteTests();
}


#----------------
sub showStartPage {
#----------------

    if ( not $subjsec ){
	print qq{<h3>$lex{'No Course Found'}</h3>\n};
	print qq{</body></html>\n};
	exit;
    }

    
    # Load Tests Info
    $sth = $dbh->prepare("select id, tdate, name, description, grp from gbtest 
			 where subjsec = ? order by tdate, grp");
    $sth->execute( $subjsec );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

    my $sth1 = $dbh->prepare("select count(*) from gbscore where testid = ?");

    
    # Start Form
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};
    print qq{<input type="hidden" name="subjsec" value="$subjsec">\n};

    # print qq{<div><input type="submit" value="$lex{Delete}"></div>\n};
    

    my $first = 1;
    while ( my ($id, $tdate, $name, $desc, $grp) = $sth->fetchrow ){

	# Table
	if ( $first ) {
	    print qq{<table cellpadding="3" border="1" cellspacing="0">};
	    print qq{<caption style="font-weight:bold;">};
	    print qq{Only Assessments with no scores can deleted</caption>\n};
	    print qq{<tr><th>$lex{Name}</th><th>$lex{Description}</th><th>$lex{Date}</th>\n};
	    print qq{<th>$lex{Group}</th><th>$lex{Scores}</th><th>$lex{Delete}</th></tr>\n};
	    $first = 0;
	}
	
	# Get Score Count
	$sth1->execute( $id );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my $scount = $sth1->fetchrow;
	
	print qq{<tr><td>$name</td><td>$desc</td><td>$tdate</td><td>$grp</td>\n};
	print qq{<td class="cn">$scount</td>};
	if ( not $scount ) {
	    print qq{<td class="cn"><input type="checkbox" name="$id" value="1"></td></tr>\n};
	} else {
	    print qq{<td></td></tr>\n};
	}

    }

    if ( $first ) { # no test items
	print qq{<h3>No Assessment Items!</h3>\n};
	print qq{</body></html>\n};
	exit;
    } else {
	print qq{</table>\n};
    }

	
    print qq{<div><input type="submit" value="$lex{Delete}"></div>\n};
    print qq{<h3>No Confirmation of Deletion is Done!</h3>\n};
    
    print qq{</form></body></html>\n};
    
    exit;

}



#--------------
sub deleteTests {
#--------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key VAL:$arr{$key}<br>\n}; }

    my $subjsec = $arr{subjsec};
    delete $arr{subjsec};

    my $sth1 = $dbh->prepare("select * from gbtest where id = ?");
    my $sth = $dbh->prepare("delete from gbtest where id = ?");
    
    foreach my $id ( sort keys %arr ) {
    
	# first get data about item to delete.
	$sth1->execute( $id );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my $ref = $sth1->fetchrow_hashref;
	my %r = %$ref;


	$sth->execute( $id );
	if ( $DBI::errstr ){
	    print qq{<div>Delete $lex{Error} - $r{name} - $r{description} -  $DBI::errstr</div>\n}; 
	    exit;
	} else {
	    print qq{<div>Deleted $r{name} - $r{description}</div>\n}; 
	}
    }

    print qq{</body></html>\n};

    exit;

}
