#!/usr/bin/perl
#  Copyright 2001-2022 Leslie Richardson

#  This file is part of Open Admin for Schools.

# rptStudPwd.pl - Report Web Student Passwords, local student numbers

my $self = qq{rptStudPwd.pl};

my %lex = ('View/Print Student Passwords' => 'View/Print Student Passwords',
	   'Main' => 'Main',
	   'GB Main' => 'GB Main',
	   'Report Menu' => 'Report Menu',
	   'Grade' => 'Grade',
	   'Error' => 'Error',
	   'Select' => 'Select',
	   'Grades' => 'Grades',
	   'Homeroom' => 'Homeroom',
	   'Continue' => 'Continue',
	   
	   );

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@<br>\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;


my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $iddst) = localtime(time);
$year = $year + 1900;
$mon++;
$wday++;
$currdate = "$dow[$wday], $month[$mon] $mday, $year";

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $title = $lex{'View/Print Student Passwords'};
print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$tchcss" type="text/css">
</head><body>\n};

print qq{[ <a href="$tchpage">$lex{Main}</a> |\n};
print qq{<a href="gbmain.pl">$lex{'GB Main'}</a> |\n};
print qq{<a href="rptMenu.pl">$lex{'Report Menu'}</a> ]\n};

print qq{<h1>$title</h1>};
print qq{<h3 style="width:60ch;">Printed Large for cutting apart. };
print qq{Allow Students/Parent access to the separate Student/Parent site };
print qq{to see their gradebook marks (if allowed), report card and attendance</h3>\n};

if ( not $arr{page} ) {
    showStartPage();
    
} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    printReport();
}


#----------------
sub showStartPage {
#----------------

    my $sth = $dbh->prepare("select distinct grade from student where 
			    grade is not NULL and grade != ''");
    $sth->execute;
    my @grades;
    while ( my $gr = $sth->fetchrow ) {
	push @grades, $gr;
    }
    @grades = sort { $a <=> $b } @grades;


    my $sth = $dbh->prepare("select distinct homeroom from student 
			    where homeroom is not NULL and homeroom != ''");
    $sth->execute;
    my @hroom;
    while ( my $hr = $sth->fetchrow ) {
	push @hroom, $hr;
    }
    @hroom = sort  @hroom;

    
    # Select Homerooms / Grades to print
    print qq{<form action="$self" method="post"> \n};
    print qq{<input type="hidden" name="page" value="1">\n};
    
    print qq{<table cellpadding="3" cellspacing="0" border="0" };
    print qq{style="padding:0.5em;border:1px solid gray;">\n};

    print qq{<tr><td class="bla">$lex{Select} $lex{Grades}</td></tr>\n};
    foreach my $grade ( sort {$a <=> $b} @grades ) {
	print qq{<tr><td><input type="checkbox" name="G:$grade" value="1"> $grade</td></tr>\n};
    }

    # Homerooms
    print qq{<tr><td class="bla">and/or $lex{Homerooms}</td></tr>\n};
    foreach my $hr ( sort {$a <=> $b} @hroom ) {
	print qq{<tr><td><input type="checkbox" name="H:$hr" value="1"> $hr</td></tr>\n};
    }

    print qq{<tr><td><input type="submit" value="$lex{Continue}"></td></tr>\n};
    print qq{</table></form>\n};

    print qq{</body></html>\n};
    
    exit;
    
} # end of showStartPage


#--------------
sub printReport {
#--------------

    # foreach my $key ( sort keys %arr ) { print qq{<div>K:$key V:$arr{$key}</div>\n}; }

    print qq{<style>\n};
    print "bigpwd {font-size:150%;font-weight:bold;";
    print "font-family:'Times New Roman','Times', serif;}";
    print qq{</style>\n};

    
    my (@homerooms, @grades);
    foreach my $key ( keys %arr ) {
	my ($type,$val) = split(':', $key);
	if ( $type eq 'H' ) {
	    push @homerooms, $val;
	} elsif ( $type eq 'G' ) {
	    push @grades, $val;
	}
    }


    if ( @grades ) {
	my $type = 'Grade';
	my $sortorder = 'lastname, firstname';
	my $sth = $dbh->prepare("select lastname, firstname, studnum, grade, homeroom, password 
				from student where grade = ? order by $sortorder");

        foreach my $grade ( sort {$a <=> $b} @grades ) {
	    $sth->execute($grade);
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }


	    print qq{<table border="1" cellspacing="0" cellpadding="14" };
	    print qq{style="float:left;margin:1em;">};
	    print qq{<caption style="font-weight:bold;font-size:120%;">$lex{Grade} $grade</caption>\n};
	    print qq{<tr><th>Name</th><th>Stud #</th><th>Password</th>\n};

	    while ( my $ref = $sth->fetchrow_hashref ){
		my %r = %$ref;
		print qq{<tr class="bigpwd"><td><b>$r{lastname}</b>, $r{firstname}</td>};
		print qq{<td>$r{studnum}</td><td>$r{password}</td></tr>\n};
	    }
	    print qq{</table>\n};	    
	}
	# end of grades
	
    } else { # homeroom
	my $type = 'Homeroom';
	my $sortorder = 'lastname, firstname';
	my $sth = $dbh->prepare("select lastname, firstname, studnum, grade, homeroom, password 
				from student where homeroom = ? order by $sortorder");

        foreach my $hr ( sort {$a <=> $b} @homerooms ) {
	    $sth->execute($hr);
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

	    print qq{<table border="1" cellspacing="0" cellpadding="14" };
	    print qq{style="float:left;margin:1em;">};
	    print qq{<caption style="font-weight:bold;font-size:120%;">$lex{Homeroom} $hr</caption>\n};
	    print qq{<tr><th>Name</th><th>Stud #</th><th>Password</th>\n};

	    while ( my $ref = $sth->fetchrow_hashref ){
		my %r = %$ref;
		print qq{<tr class="bigpwd"><td><b>$r{lastname}</b>, $r{firstname}</td>};
		print qq{<td>$r{studnum}</td><td>$r{password}</td></tr>\n};
	    }
	    print qq{</table>\n};	    
	}
    } # end of homerooms

    
    print qq{</body></html>\n};
    exit;
    
} # end of printReport
