#!/usr/bin/perl
#  Copyright 2001-2018 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Main' => 'Main',
	   'Error' => 'Error',
	   'View' => 'View',
	   'Name' => 'Name',
	   'Author' => 'Author',
	   'Scores' => 'Scores',
	   'Score' => 'Score',
	   'Age' => 'Age',
	   'Grade' => 'Grade',
	   'No Records Found' => 'No Records Found',
	   'Continue' => 'Continue',
	   'Select' => 'Select',
	   'Students' => 'Students',
	   'Check' => 'Check',
	   'Homeroom' => 'Homeroom',
	   'Blank=All' => 'Blank=All',
	   'Edit' => 'Edit',
	   'Tests' => 'Tests',
	   'Delete' => 'Delete',
	   'Start Date' => 'Start Date',
	   'End Date' => 'End Date',
	   'Next Page' => 'Next Page',
	   'No Blanks Allowed' => 'No Blanks Allowed',
	   'Student' => 'Student',
	   'Date' => 'Date',
	   'Type' => 'Type',
	   'Outcome' => 'Outcome',
	   'Yes' => 'Yes',
	   'More' => 'More',
	   'Update' => 'Update',
	   'Records Updated' => 'Records Updated',
	   'Month' => 'Month',
	   
	   );

use DBI;
use CGI;
use Time::JulianDay;

my $self = 'ilangView.pl';

eval require "../../etc/admin.conf";
if ( $@ ) {
    print "$lex{Error}: $self: $@<br>\n";
    die "$lex{Error}: $self: $@\n";
}


my $q = new CGI;
print $q->header;
my %arr = $q->Vars;

my @tim = localtime(time);
my $year = $tim[5] + 1900;
my $month = $tim[4] + 1;
my $day = $tim[3];
if ( length( $month) == 1 ) { $month = '0'. $month; }
if ( length( $day) == 1 ) { $day = '0'. $day; }
my $currdate = "$year-$month-$day";


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Page Header
my $title = "$lex{View} Indigenous Language $lex{Scores}";
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$tchcss" type="text/css">\n};


if ( not $arr{page} ) { # calendar popup.
    print qq{<link rel="stylesheet" type="text/css" media="all" };
    print qq{href="/js/calendar-blue.css" title="blue">\n};
    print qq{<script type="text/javascript" src="/js/calendar.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/lang/calendar-en.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/calendar-setup.js"></script>\n};
}

print qq{$chartype\n</head><body style="padding:1em 2em;">\n};

print qq{[ <a href="$tchpage">$lex{Main}</a> ]\n};
print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    selectStudents();

} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    showTests();

} elsif ( $arr{page} == 3 ) {
    delete $arr{page};
    
    if ( $arr{delete} ) {
	delete $arr{delete};
	confirmDelete();

    } else {
	delete $arr{edit};
	editRecords();
    }
    
} elsif ( $arr{page} == 4 ) {
    delete $arr{page};
    updateRecords();

} elsif ( $arr{page} == 5 ) {
    delete $arr{page};
    deleteRecords();
}


#--------------
sub updateRecords {
#--------------

    # print qq{Update Records<br>\n};
    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    foreach my $key ( keys %arr ) {

	my ($id, $field) = split(':', $key);

	# Check if a date.
	if ( $field eq 'tdate' ) {
	    my $err = checkDate( $arr{$key} );
	    if ( $err == 1 ) {
		print qq{<h3>$lex{Error}: Date Outside School Year: $arr{$key}</h3>\n};
		print qq{</body></html>\n};
		exit;
	    
	    } elsif ( $err == 255 ) {
		print qq{<h3>Date Format Error: $err</h3>\n};
		print qq{</body></html>\n};
		exit;
		
	    } elsif ( $err ) {
		print qq{<h3>Date Error: $err</h3>\n};
		print qq{</body></html>\n};
		exit;
	    }
	}
	
	my $sth;
	if ( $arr{$key} eq '' or not defined $arr{$key} ) {
	    $sth = $dbh->prepare("update cree_scores set $field = NULL where id = ?");
	    $sth->execute( $id);
	} else {
	    $sth = $dbh->prepare("update cree_scores set $field = ? where id = ?");
	    $sth->execute( $arr{$key}, $id);
	}


	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

    }
    
    print qq{<h3>$lex{'Records Updated'}</h3>\n};

    print qq{[ <a href="$tchpage">$lex{Main}</a> ]\n};

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="submit" value="$lex{More}"></form></p>\n};

    print qq{</body></html>\n};

    exit;

} # end of updateRecords



#--------------
sub editRecords {
#--------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }


    print qq{<h1>$lex{Edit} $lex{Scores}</h1>\n};

    # Start Form
    print qq{<form action="$self" method="post"> \n};
    print qq{<input type="hidden" name="page" value="4">\n};

    print qq{<p><input type="submit" value="$lex{Update}"></p>\n};

    # Prepare Queries
    my $sth = $dbh->prepare("select * from cree_scores where id = ?");
    my $sth1 = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");
    

    foreach my $id ( keys %arr ) {

	# Get iLang Record
	$sth->execute( $id );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my $ref = $sth->fetchrow_hashref;
	my %r = %$ref;
	my $id = $r{id};

	# Get Student Name
	$sth1->execute( $ref->{studnum} );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my ($lastname, $firstname ) = $sth1->fetchrow;

	# Start Table
	print qq{<table cellpadding="3" cellspacing="0" border="0" };
	print qq{style="padding:0.5em;border:1px solid gray;margin-bottom:1em;">\n};

	# Student Name
	print qq{<tr><td class="la" colspan="2" style="font-weight:bold;">$firstname $lastname</td></tr>\n};

	# Pre/Post
	my %pplex = ('pretest' => 'Pre-Test', 'posttest' => 'Post-Test' );
	print qq{<tr><td class="bra">Pretest or Posttest</td>};
	print qq{<td><select name="$id:prepost"><option value="$r{prepost}">$pplex{$r{prepost}}</option>\n};
	print qq{<option value="pretest">Pre-Test</option><option value="posttest">Post-Test</option>\n};
	print qq{</select></td></tr>\n};


	# Score Month
	print qq{<tr><td class="bra">Scoring Month</td>\n};
	print qq{<td><select name="$id:scoremonth"><option value="$r{scoremonth}">$month[$r{scoremonth}]</option>\n};
	foreach my $monthval ( 9, 10, 11, 12, 1, 2, 3, 4, 5, 6 ) {
	    if ( $monthval == $r{scoremonth} ) { next; }
	    print qq{<option value="$monthval">$month[$monthval]</option>\n};
	}
	print qq{</select> Only one pretest/posttest per month allowed</td></tr>\n};

	# Score
	print qq{<tr><td class="bra">Score</td>\n};
	print qq{<td><input type="text" style="width:2em;" name="$id:score" value="$r{score}"></td></tr>\n};

	# Date
	print qq{<tr><td class="bra">Test Date</td>\n};
	print qq{<td><input type="text" name="$id:tdate" style="width:6em;" value="$r{tdate}">};
	print qq{ YYYY-MM-DD</td></tr>\n};

	# End Table
	print qq{</table>\n\n};
	
    }	

    print qq{<p><input type="submit" value="$lex{Update}"></p>\n};
    print qq{</form>\n};

    print qq{[ <a href="$tchpage">$lex{Main}</a> ]\n};
    print qq{</body></html>\n};

    exit;

} # end of editRecords



#----------------
sub confirmDelete {
#----------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $sth = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");
    my $sth1 = $dbh->prepare("select * from cree_scores where id = ?");

    # print qq{<h1>$lex{Confirm} $lex{Delete}</h1>\n};

    print qq{<form action="$self" method="post"> \n};
    print qq{<input type="hidden" name="page" value="5">\n};

    print qq{<table cellpadding="3" cellspacing="0" border="0">\n};
    print qq{<tr><th>$lex{Confirm} $lex{Delete}</th></tr>\n};

    foreach my $id ( keys  %arr ) { 

	# Get iLang Record
	$sth1->execute( $id );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my $ref = $sth1->fetchrow_hashref;
	my $studnum = $ref->{studnum};

	# Get student name
	$sth->execute( $studnum );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my ( $lastname, $firstname ) = $sth->fetchrow;

	print qq{<tr><td><input type="hidden" name="$id" value="1">$firstname $lastname</td></tr>\n };

    }

     print qq{</table>};
     print qq{<p><input type="submit" value="$lex{Yes}, $lex{Delete} $lex{Students}"></p>\n};

     print qq{</form>\n};
     print qq{</body></html>\n};

    exit;

}


#----------------
sub deleteRecords { # delete student records
#----------------

    # foreach my $key ( sort keys %arr) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $sth = $dbh->prepare("delete from cree_scores where id = ?");

    foreach my $key ( keys %arr) {
	$sth->execute( $key );
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    }
    
    print qq{<p>$lex{'Record(s) Deleted'}</p>\n};
    
    # print qq{<p>[ <a href="$tchpage">$lex{Main}</a> ]\n};

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="submit" value="$lex{More}"></form></p>\n};

    print qq{</body></html>\n}; 

    exit;

}




#----------------
sub showStartPage {
#----------------

    my $sth = $dbh->prepare("select distinct grade from student where grade is not NULL and grade != ''");
    $sth->execute;
    my @grades;
    while ( my $gr = $sth->fetchrow ) {
	push @grades, $gr;
    }
    @grades = sort { $a <=> $b } @grades;


    my $sth = $dbh->prepare("select distinct homeroom from student where homeroom is not NULL and homeroom != ''");
    $sth->execute;
    my @hroom;
    while ( my $hr = $sth->fetchrow ) {
	push @hroom, $hr;
    }
    @hroom = sort  @hroom;
    
    
    # Find Tests by Student Group
    print qq{<form action="$self" method="post"> \n};
    print qq{<input type="hidden" name="page" value="1">\n};
    print qq{<table cellpadding="3" cellspacing="0" border="0" };
    print qq{style="padding:0.5em;border:1px solid gray;">\n};

    print qq{<tr><td class="bra">$lex{Select} $lex{Grade}</td>\n};
    print qq{<td><select name="grade"><option></option>\n};
    foreach my $grade ( @grades ) {
	print qq{<option>$grade</option>\n};
    }
    print qq{</select></td></tr>\n};
    
    print qq{<tr><td class="bra">OR $lex{Select} $lex{Homeroom}</td>\n};
    print qq{<td><select name="homeroom"><option></option>\n};
    foreach my $hr ( @hroom ) {
	print qq{<option>$hr</option>\n};
    }
    print qq{</select></td></tr>\n};
      
    
    print qq{<tr><td class="bra">$lex{Check} $lex{'Next Page'}</td>\n};
    print qq{<td><input type="checkbox" name="chk" value="1">\n};
    print qq{</td></tr>\n};

    print qq{<tr><td class="bra">$lex{'Start Date'}</td><td><input type="text" };
    print qq{name="startdate" id="sdate" size="10" value="$schoolstart">};
    print qq{<button type="reset" id="start_trigger">...</button>\n};
    print qq{</td></tr>\n};

    print qq{<tr><td class="bra">$lex{'End Date'}</td><td><input type="text" };
    print qq{name="enddate" id="edate" size="10" value="$currdate">};
    print qq{<button type="reset" id="end_trigger">...</button></td></tr>\n};


    print qq{<tr><td></td><td>\n<input type="submit" value="$lex{Continue}"></td></tr>\n};

    print qq{</table></form>\n};

    print qq{<script type="text/javascript">
     Calendar.setup({
        inputField     :    "sdate", 
        ifFormat       :    "%Y-%m-%d",
        button         :    "start_trigger",
        singleClick    :    false,
        step           :    1
    });

    Calendar.setup({
        inputField     :    "edate",
        ifFormat       :    "%Y-%m-%d",
        button         :    "end_trigger",
        singleClick    :    false,
        step           :    1
    });
   </script>\n};

    print qq{</body></html>\n};

    exit;

} # end of showStartPage



#----------------
sub selectStudents {
#----------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }    
    
    my $chk;
    if ( $arr{chk} ) {
	$chk = 'CHECKED';
    }
    delete $arr{chk};

    # Check for any Blanks
    if ( not $arr{grade} and not $arr{homeroom} ) {
	print qq{<h3>$lex{'No Blanks Allowed'}</h3>\n};
	print qq{</body></html>\n};
	exit;
    }

    my $sth;
    if ( $arr{grade} ) {
	$sth = $dbh->prepare("select lastname, firstname, studnum from student
          where grade = ? order by lastname, firstname");
	$sth->execute( $arr{grade} );
	
    } else { # homeroom
	$sth = $dbh->prepare("select lastname, firstname, studnum from student
          where homeroom = ? order by lastname, firstname");
	$sth->execute( $arr{homeroom} );
    }

    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

    
    # Form Header
    print qq{<form action="$self" method="post"> \n};
    print qq{<input type="hidden" name="page" value="2">\n};
    print qq{<input type="hidden" name="startdate" value="$arr{startdate}">\n};
    print qq{<input type="hidden" name="enddate" value="$arr{enddate}">\n};

    print qq{<table cellpadding="3" cellspacing="0" border="0">\n};

    print qq{<tr><td class="la" colspan="3">\n};
    print qq{<input type="submit" value="$lex{Continue}"></td><td></td></tr>\n};


    my $sth1 = $dbh->prepare("select count(*) from cree_scores where studnum = ?");
    
    print qq{<tr><th></th><th>$lex{Student}</th><th>$lex{Tests}</th></tr>\n};

    while ( my ( $lastname, $firstname, $studnum ) = $sth->fetchrow ) {
	
	$sth1->execute( $studnum );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my $count = $sth1->fetchrow;

	print qq{<tr><td class="cn">};
	if ( $count ) {
	    print qq{<input type="checkbox" name="$studnum" value="1" $chk>};
	}

	print qq{</td><td class="la">$lastname, $firstname ($studnum)</td>\n};
	print qq{<td class="cn">$count</td></tr>\n};

    }

    print qq{<tr><td class="la" colspan="3">\n};
    print qq{<input type="submit" value="$lex{Continue}"></td><td></td></tr>\n};
    print qq{</table></form></body></html>\n};

    exit;

} # end of selectStudents



#------------
sub showTests {
#------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $startdate = $arr{startdate};
    my $enddate = $arr{enddate};
    delete $arr{startdate};
    delete $arr{enddate};


    # Searching by Student Number
    my $sth1 = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");

    
    # sort by name.
    my %sort;
    foreach my $studnum ( keys %arr ) { 
	$sth1->execute( $studnum );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my ( $lastname, $firstname ) = $sth1->fetchrow;
	$sort{"$lastname$firstname$studnum"} = $studnum;
    }


    my $first = 1;

    print qq{<style>td.blue { background-color:blue;color:white; } };
    print qq{td.red { background-color:#F00;color:white; }</style>\n};

    # Start the Form
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="3">\n};

    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
    print qq{<tr><th>$lex{Edit}</th><th>$lex{Name}</th><th>$lex{Age}</th><th>$lex{Grade}</th>\n};
    print qq{<th>$lex{Score}</th><th>$lex{Score}<br>$lex{Month}</th><th>$lex{Type}</th>};
    print qq{<th>$lex{Date}</th><th>$lex{Author}</th></tr>\n};

    print qq{<tr><td colspan="10" class="la"><input type="submit" name="edit" value="$lex{Edit}">\n};
    print qq{<input type="submit" name="delete" value="$lex{Delete}"></td></tr>\n};

    foreach my $key ( sort keys %sort ) {

	my $studnum = $sort{$key};

	# Get Student Name
	$sth1->execute( $studnum );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my ( $lastname, $firstname ) = $sth1->fetchrow;


	# Display Existing Tests (if any)
	my $sth = $dbh->prepare("select * from cree_scores
         where studnum = ? and to_days( tdate ) >= to_days( '$startdate' ) 
         and to_days( tdate ) <= to_days( '$enddate') order by tdate, id");

	$sth->execute( $studnum );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	while ( my $ref = $sth->fetchrow_hashref ) {
	    my %r = %$ref;

	    $first = 0;

	    my ($yr,$mo) = split(/:/, $r{tage});
	    my $age = $yr. 'y'. $mo. 'm';
	    
	    my $color;
	    if ( $yr < $min ) { $color = 'blue'; }
	    if ( $yr > $max ) { $color = 'red'; }

	    # Edit Checkbox.
	    print qq{<tr><td><input type="checkbox" name="$r{id}" value="1"></td>\n};

	    # Rest of Fields
	    print qq{<td class="la"><b>$lastname</b>, $firstname</td>\n};
	    print qq{<td class="cn">$age</td>\n};
	    print qq{<td class="cn">$r{tgrade}</td>\n};
	    print qq{<td class="bcn">$r{score}</td>\n};
	    print qq{<td class="bla">$month[$r{scoremonth}]</td>\n};
	    print qq{<td class="la">$r{prepost}</td>\n};
	    print qq{<td class="la">$r{tdate}</td>\n};
	    print qq{<td>$r{tauthor}</td>\n};

	    print qq{</tr>\n\n};


	} # end of student loop.

	if ( $first ) {
	    print qq{<div style="font-weight:bold;">};
	    print qq{$lex{'No Records Found'}</div>\n};
	}

    } # end of student number loop


    print qq{<tr><td colspan="10" class="la"><input type="submit" value="$lex{Edit}">\n};
    print qq{<input type="submit" name="delete" value="$lex{Delete}"></td></tr>\n};
    print qq{</table>\n};

    print qq{</form></body></html>\n};
    
    exit;

}


#------------
sub checkDate {
#------------
   
    my $date = shift;

    my ($y,$m,$d) = split('-',$date);
    
    if ( not $d ) { return 255; }  # wrong format.
    if ( $m > 12 or $m < 1 ) { return 255; }
    if ( $d > 31 or $d < 1 ) { return 255; }

    my $datejd = julian_day( $y, $m, $d );

    my $startjd = julian_day( split('-', $schoolstart ));
    my $endjd = julian_day( split('-', $schoolend ));
    
    # print "DATE:$date - $datejd Start:$schoolstart - $startjd  End:$schoolend - $endjd<br>\n";

    if ( $datejd > $endjd  or $datejd < $startjd ) {
	return 1; # different code for date outside of current year;
    }
    
    return 0;

}
