#! /usr/bin/perl
#  Copyright 2001-2011 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Main' => 'Main',
	   'View Log File' => 'View Log File',
	   'Student' => 'Student',
	   'Name' => 'Name',
	   'Locker Report' => 'Locker Report',
           'View/Print Report' => 'View/Print Report',
           'Name' => 'Name',
           'Comments' => 'Comments',
	   'Homeroom' => 'Homeroom',
	   'Grade' => 'Grade',
	   'Error' => 'Error',
	   'Fees' => 'Fees',
	   'Continue' => 'Continue',
	   'Paper Size' => 'Paper Size',
	   'Font Size' => 'Font Size',
	   'Blank=All' => 'Blank=All',
	   'Letter' => 'Letter',
	   'Legal' => 'Legal',
	   'A4' => 'A4',
	   'PDF' => 'PDF',
	   'HTML' => 'HTML',
	   'Format' => 'Format',
	   'Unassigned Lockers/Locks' => 'Unassigned Lockers/Locks',
	   'Select by' => 'Select by',
	   'Separate with Spaces' => 'Separate with Spaces',
	   'Blank=All' => 'Blank=All',
	   'Location' => 'Location',
	   'Sort by' => 'Sort by',
	   'Locker' => 'Locker',
	   'Lock' => 'Lock',
	   'Clean' => 'Clean',
	   'Pool' => 'Pool',
	   'Combination' => 'Combination',
	   'No Record(s) Found' => 'No Record(s) Found',
	   'Partner' => 'Partner',
	   'No Lock' => 'No Lock',
	   'Hover=View' => 'Hover=View',

	    );

my $self = 'rptlocker.pl';


my $logfile = "pdflog$$.txt";
my $shortname = "locker$$";
my $filename = "$shortname.tex";


use DBI;
use CGI;
use Cwd;


# Read config variables
eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Get current dir so know what CSS to display;
my $runmode = 'main';
if ( getcwd() =~ /tcgi/){ # we are in tcgi
    $homepage = $tchpage;
    $css = $tchcss;
    $downloaddir = $tchdownloaddir;
    $webdownloaddir = $tchwebdownloaddir;
    $runmode = 'teacher';
}


my ($sec, $min, $hour, $mday, $mon, $year, $wday, 
 $yday, $iddst) = localtime(time);
$year = $year + 1900;
$wday++; $mon++;
my $currdate = "$dow[$wday], $month[$mon] $mday, $year";

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;


print "$doctype\n<html><head><title>". $lex{'Locker Report'}. "</title>
<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">
$chartype\n</head><body>\n";

print "[ <a href=\"$homepage\">". $lex{Main}. "</a> |\n";
if ( $runmode eq 'main' ) {
    print " <a href=\"$feespage\">". $lex{Fees}. "</a> ]\n";
}

print "<center><h1>". $lex{'Locker Report'}. "</h1></center>\n";


if ( not $arr{page} ) {
    showStartPage();
} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    setupReport();
} elsif ( $arr{page} == 5 ) {
    delete $arr{page};
    showUnassigned();
}


#----------------
sub showStartPage {
#----------------

    # Find all the grades
    my @grades = ();
    my $sth = $dbh->prepare("select distinct grade from student");
    $sth->execute;
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    while ( my $grade = $sth->fetchrow ) {
	push @grades, $grade;
    }
    my $gradestring;
    foreach my $grade ( sort { $a <=> $b} @grades ) {
	$gradestring .= $grade. q{ };
    }

    # Find all the homerooms
    my @homerooms = ();
    $sth = $dbh->prepare("select distinct homeroom from student");
    $sth->execute;
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    while ( my $homeroom = $sth->fetchrow ) {
	push @homerooms, $homeroom;
    }
    my $hrstring;
    foreach my $hr ( sort { $a <=> $b} @homerooms ) {
	$hrstring .= $hr. q{ };
    }

    # Find all the locker locations
    my $locationstring;
    $sth = $dbh->prepare("select distinct location from lok_locker order by location");
    $sth->execute;
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    while ( my $loc = $sth->fetchrow ) {
	$locationstring .= $loc. q{ / };
    }


    # Main Form
    print "<center><form action=\"$self\" method=\"post\">\n";
    print "<input type=\"hidden\" name=\"page\" value=\"1\">\n";
    print "<table cellspacing=\"0\" cellpadding=\"4\" border=\"0\">\n";


    # Select by
    print "<tr><td align=\"right\"><b>". $lex{'Select by'}. "</b></td>\n<td align=\"left\">";
    print "<select name=\"group\">\n";
    print "<option title=\"$gradestring\">". $lex{Grade}. "</option>\n";
    print "<option title=\"$hrstring\">". $lex{Homeroom}. "</option>\n";
    print "<option title=\"$locationstring\">". $lex{Location}. "</option>\n";
    print "</select> ". $lex{'Hover=View'}. "<br>\n";
    print "<input type=\"input\" name=\"groupid\" size=\"12\">\n";
    print $lex{'Separate with Spaces'}. q{, }. $lex{'Blank=All'}. "</td></tr>\n";

    # ~~ Sort Example    foreach my $grade ( sort { $a <=> $b} @grades ) {

    # Sort by
    print "<tr><td align=\"right\"><b>". $lex{'Sort by'}. "</b></td>\n<td align=\"left\">";
    print "<select name=\"sort\" ><option>". $lex{Name}. "</option>\n";
    print "<option title=\"$gradestring\">". $lex{Grade}. "</option>\n";
    print "<option title=\"$hrstring\">". $lex{Homeroom}. "</option>\n";
    print "<option title=\"$locationstring\">". $lex{Location}. "</option>\n";
    print "<option>". $lex{Locker}. "</option><option>\n";
    print $lex{Lock}. "</option></select></td></tr>\n";

    # Output Format
    print "<tr><td align=\"right\"><b>". $lex{Format}. "</b></td><td>";
    print "<select name=\"output\" ><option>". $lex{HTML}. "</option>\n";
    print "<option>". $lex{PDF}. "</option></select>\n";
    print "</td></tr>\n";

    # Paper Size
    print "<tr><td align=\"right\"><b>". $lex{'Paper Size'}. "</b></td><td>\n";
    print "<select name=\"papersize\" ><option></option>\n";
    print "<option>". $lex{Letter}. "</option>\n";
    print "<option>". $lex{Legal}. "</option>\n";
    print "<option>". $lex{A4}. "</option>\n";
    print "</select></td></tr>\n";

    # Font Size
    print "<tr><td align=\"right\"><b>". $lex{'Font Size'}. "</b></td><td>\n";
    print "<select name=\"fontsize\"><option>12pt</option><option>11pt</option>\n";
    print "<option>10pt</option></select></td></tr>\n";

    # End of Form / Submit
    print "<tr><td align=\"center\" colspan=\"2\">";
    print "<input type=\"submit\" value=\"". $lex{Continue}. "\"></td></tr>\n";
    print "</table></form>\n\n";

    # Unassigned Locks / Lockers
    print "<hr width=\"50%\">\n";
    print "<form action=\"$self\" method=\"post\">\n";
    print "<input type=\"hidden\" name=\"page\" value=\"5\">\n";
    print "<input type=\"submit\" value=\"". $lex{'Unassigned Lockers/Locks'}. "\">\n";
    print "</form></center>\n";

    print "</body></html>\n";

    exit;
}



#--------------
sub setupReport {
#--------------

    #foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    my $mode;
    if ( $arr{output} eq $lex{PDF} ) {
	$mode = 'pdf';
    } else {
	$mode = 'html';
    }


    if ( $arr{group} eq $lex{Grade} or $arr{group} eq $lex{Homeroom} ) {

	if ( $arr{group} eq $lex{Grade} ) { 
	    $group = 'grade'; 
	} else {
	    $group = 'homeroom';
	}

	# Do the selects first; first find students from grouping
	my @groups = split /\s/, $arr{groupid};

	if ( not @groups ) { # select all students 
	    my $sth = $dbh->prepare("select lastname, firstname, studnum, $group from student
              order by lastname, firstname");
	    $sth->execute;
	    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	    while ( my ( $lastname, $firstname, $studnum, $grp ) = $sth->fetchrow ) {
		push @students, $studnum;
		$students{$studnum} = "$lastname, $firstname ($grp)";
	    }

	} else { # we have groups of students

	    my $sth = $dbh->prepare("select lastname, firstname, studnum, $group from student
             where $group = ? order by lastname, firstname");

	    foreach my $grp ( @groups ) {
		$sth->execute( $grp );
		if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
		while ( my ( $lastname, $firstname, $studnum, $grp ) = $sth->fetchrow ) {
		    push @students, $studnum;
		    $students{$studnum} = "$lastname, $firstname ($grp)";
		}
	    } # done loop through @groups
	}
	# We now have student @students and %students, now get their lockers.

	# Find the student's lockers (may be more than 1 student per locker)
	$sth = $dbh->prepare("select locker_num from lok_rlink where studnum = ?");
	foreach my $studnum ( @students ) {
	    $sth->execute( $studnum );
	    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	    $locker_num = $sth->fetchrow;
	    if ( $locker_num ) {
		push @lockers, $locker_num;
	    }
	}

    } else { # find lockers by location.

	my @locations = split /\s/, $arr{groupid};
	if ( not @locations ) { # select all lockers 
	    my $sth = $dbh->prepare("select locker_num from lok_rlink order by locker_num");
	    $sth->execute;
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	    while ( my $locker_num = $sth->fetchrow ) {
		push @lockers, $locker_num;
	    }

	} else { # we have groups of lockers by location
	    my $sth = $dbh->prepare("select link.locker_num from lok_rlink as link, 
              lok_locker as l
              where link.locker_num = l.locker_num and l.location = ?");

	    foreach my $location ( @locations ) {
		$sth->execute( $location );
		if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
		while ( my $locker_num = $sth->fetchrow ) {
		    push @lockers, $locker_num;
		}
	    } # done loop through @locations
	} # done location 

    } # we now have locker_num in @lockers

    if ( not @lockers ) { # no lockers found
	print "<h1>". $lex{'No Record(s) Found'}. "</h1>\n";
	print "</body></html>\n";
	exit;
    }

    # print "Lockers", @lockers, "<br>\n";

    my $grouping; # whether to do a grouping process; separate tables.
    my $sth;

    if ( $arr{sort} eq $lex{Name} ) {

	$grouping = 0;
	$sth = $dbh->prepare("select s.lastname, s.firstname, s.studnum from 
          student as s, lok_rlink as l 
          where s.studnum = l.studnum and l.locker_num = ?");
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	foreach my $locker_num ( @lockers ) {
	    $sth->execute( $locker_num );
	    while ( my ( $lastname, $firstname, $studnum ) = $sth->fetchrow ) {
		if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
		$lockers{"$lastname$firstname:$studnum"} = $locker_num;
	    }
	}

    } elsif ( $arr{sort} eq $lex{Grade} ) {

	$grouping = $lex{Grade};
	$sth = $dbh->prepare("select s.lastname, s.firstname, s.grade, s.studnum 
          from student as s, lok_rlink as l 
          where s.studnum = l.studnum and l.locker_num = ?");
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	foreach my $locker_num ( @lockers ) {
	    $sth->execute( $locker_num );
	    while ( my ( $lastname, $firstname, $grade, $studnum ) = $sth->fetchrow ) {
		if ( length( $grade ) == 1 ){ $grade = '0'. $grade; }
		if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
		$lockers{"$grade$lastname$firstname:$studnum"} = $locker_num;
	    }
	}

    } elsif ( $arr{sort} eq $lex{Homeroom} ) {
	$grouping = $lex{Homeroom};
	$sth = $dbh->prepare("select s.lastname, s.firstname, s.homeroom, s.studnum
          from student as s, lok_rlink as l 
          where s.studnum = l.studnum and l.locker_num = ?");
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	foreach my $locker_num ( @lockers ) {
	    $sth->execute( $locker_num );
	    while ( my ( $lastname, $firstname, $homeroom, $studnum ) = $sth->fetchrow ) {
		if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
		$lockers{"$homeroom$lastname$firstname:$studnum"} = $locker_num;
	    }
	}

    } elsif ( $arr{sort} eq $lex{Location} ) {
	$grouping = $lex{Location};

	$sth = $dbh->prepare("select s.lastname, s.firstname, s.studnum
          from student as s, lok_rlink as l 
          where s.studnum = l.studnum and l.locker_num = ?");

	my $sth1 = $dbh->prepare("select location from lok_locker where locker_num = ?");
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }

	foreach my $locker_num ( @lockers ) {
	    # Get Location
	    $sth1->execute( $locker_num );
	    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	    my $location = $sth1->fetchrow;

	    $sth->execute( $locker_num );
	    while ( my ( $lastname, $firstname, $studnum ) = $sth->fetchrow ) {
		if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
		$lockers{"$location$lastname$firstname:$studnum"} = $locker_num;
	    }
	}


    } elsif ( $arr{sort} eq $lex{Lock} ) {

	$grouping = 0; # just as a reminder.

	$sth = $dbh->prepare("select s.lastname, s.firstname, s.studnum
          from student as s, lok_rlink as l 
          where s.studnum = l.studnum and l.locker_num = ?");

	my $sth1 = $dbh->prepare("select lock_num from lok_link where locker_num = ?");
	
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }

	foreach my $locker_num ( @lockers ) {

	    # Get Lock Number
	    $sth1->execute( $locker_num );
	    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	    my $lock_num = $sth1->fetchrow;
	    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }

	    $sth->execute( $locker_num );
	    my ( $lastname, $firstname, $studnum ) = $sth->fetchrow; # ignore others
	    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	    $lockers{"$lock_num:$studnum"} = $locker_num;

	}


    } elsif ( $arr{sort} eq $lex{Locker} ) {

	$grouping = 0; # just as a reminder.

	$sth = $dbh->prepare("select s.lastname, s.firstname, s.studnum
          from student as s, lok_rlink as l 
          where s.studnum = l.studnum and l.locker_num = ?");
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }

	foreach my $locker_num ( @lockers ) {
	    $sth->execute( $locker_num );
	    my ( $lastname, $firstname, $studnum ) = $sth->fetchrow; # ignore others
	    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	    $lockers{"$locker_num:$studnum"} = $locker_num;
	}


    }

    # we should now have a %lockers hash with correct sorting value and locker numbers
    # print "Locker:", %lockers, "<br>\n";

    # get locker info and print it...
    my $sth1 = $dbh->prepare("select cleaned, location, comment from lok_locker 
      where locker_num = ?");
    my $sth2 = $dbh->prepare("select lock_num from lok_link where locker_num = ?");
    my $sth3 = $dbh->prepare("select combination, pool, comment from lok_lock 
      where lock_num = ?");
    my $sth4 = $dbh->prepare("select studnum from lok_rlink where locker_num = ?");
    my $sth5 = $dbh->prepare("select lastname, firstname, grade, homeroom from studentall
      where studnum = ?");
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }

    if ( $mode eq 'html' ) {
	print "<center><table cellspacing=\"0\" cellpadding=\"3\" border=\"1\">\n";
	print "<tr><th>". $lex{Locker}. "</th><th>". $lex{Student}. "</th><th>";
	print $lex{Lock}. "</th><th>". $lex{Partner}. "</th></tr>\n";

    } else { # print equivalent in LaTeX

	# Do LaTeX Setup
	printTexHeader();

	print TEX "\\begin{tabular}{|p{15mm}|p{60mm}|p{35mm}|p{60mm}|}\\hline\n";
	print TEX "\\rowcolor[gray]{0.80} \\hfil ". $lex{Locker}. "\\hfil & \\hfil ";
	print TEX $lex{Student}. "\\hfil & \\hfil ";
	print TEX $lex{Lock}. " \\hfil & \\hfil ". $lex{Partner}. " \\hfil\\\\ \n";

    }

    my $currgroup = -1;
    my $oldgroup;

    foreach my $key ( sort keys %lockers ) {

	my $locker_num = $lockers{$key};

	# Get Locker Info.
	$sth1->execute( $locker_num );
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	my ( $cleaned, $location, $comment ) = $sth1->fetchrow;


	# Get Lock Info
	my $lockinfo;
	$sth2->execute( $locker_num );
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	my $lock_num = $sth2->fetchrow;

	if ( $lock_num ) {
	    $sth3->execute( $lock_num );
	    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	    my ( $combination, $pool, $comment ) = $sth3->fetchrow;
	    $lockinfo = "$lock_num ($combination)";
	} else {
	    $lockinfo = $lex{'No Lock'};
	}

	# Get Student Info
	my ( $dud, $mainstudnum ) = split /:/, $key;

	$sth4->execute( $locker_num );
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	
	my %students = ();
	my ( $curr_lastname, $curr_firstname, $curr_grade ); # current main info for locker 
	while ( my $studnum = $sth4->fetchrow ) {

	    $sth5->execute( $studnum );
	    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	    my ( $lastname, $firstname, $grade, $homeroom ) = $sth5->fetchrow;

	    if ( $studnum == $mainstudnum ) {
		$curr_lastname = $lastname;
		$curr_firstname = $firstname;
		$curr_grade = $grade;
		$curr_homeroom = $homeroom;
	    } else {
		$students{$studnum} = "$lastname, $firstname ($grade)";
	    }
	
	} # end of student loop

	$prevgroup = $currgroup;
	if ( $grouping eq $lex{Grade} ) {
	    $currgroup = $curr_grade;
	} elsif ( $grouping eq $lex{Homeroom} ) {
	    $currgroup = $curr_homeroom;
	} elsif ( $grouping  eq $lex{Location} ) {
	    $currgroup = $location;
	}

	if ( $currgroup ne $prevgroup ) {
	    # print a row
	    if ( $mode eq 'html' ) {
		print "<tr><td colspan=\"4\" style=\"font-size:150%;text-align:center;\">";
		print "$grouping $currgroup</td></tr>\n";
	    } else { # do pdf
		# ~~

	    }

	}

	if ( $mode eq html ) {
	    print "<tr><td>$locker_num</td>\n";
	    print "<td><b>$curr_lastname</b>, $curr_firstname ($curr_grade)</td>";
	    print "<td>$lockinfo</td>\n<td>";
	    foreach my $studnum ( keys %students ) {
		print "$students{$studnum} $studnum<br>";
	    }
	    print "</td></tr>\n";


	} else { # pdf output

	    print TEX "$locker_num & $curr_lastname, $curr_firstname ($curr_grade) &";
	    print TEX " $lockinfo & ";
	    foreach my $studnum ( keys %students ) {
		print TEX "$students{$studnum} $studnum";
	    }
	    print TEX " \\\\ \\hline\n";

	    $count++;
	    if ( $count % 5 == 0 ) {
		print TEX "\\end{tabular}\n\n";
		print TEX "\\begin{tabular}{|p{15mm}|p{60mm}|p{35mm}|p{60mm}|} \\hline\n";
	    }
	    
	}

    } # end of locker loop.

    if ( $mode eq 'html' ) {
	print "</table></center>\n";
    } else {

	print TEX "\\end{tabular}\n";
	print TEX "\\end{document}\n";
	close TEX;

	system("$pdflatex $filename >$logfile");
	system("mv $shortname.pdf $downloaddir");
	system("mv $logfile $downloaddir");
	system("rm $shortname.*");

	print "<center><h3><a href=\"$webdownloaddir/$shortname.pdf\">";
	print $lex{'View/Print Report'}. "</a></h3>\n";

	print "[ <a href=\"$webdownloaddir/pdflog$$.txt\">". $lex{'View Log File'}. "</a> ]\n";

    }


    print "</body></html>\n";

    exit;

} # end of setupReport



#-----------------
sub showUnassigned {
#-----------------
    # Show Unassigned Locks / Lockers

    # foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }
    print "<h1>". $lex{'Unassigned Lockers/Locks'}. "</h1>\n";

    # Find the Lockers First
    my %lockers = ();
    my $sth = $dbh->prepare("select locker_num from lok_locker");
    $sth->execute;
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    while ( my $locker_num = $sth->fetchrow ) {
	$lockers{$locker_num} = 1;
    }
    # Remove the assigned lockers
    $sth = $dbh->prepare("select distinct locker_num from lok_rlink");
    $sth->execute;
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    while ( my $locker_num = $sth->fetchrow ) {
	delete $lockers{$locker_num};
    }
    # remaining values in %locker are unassigned lockers....


    # Now find unassigned locks
    my %locks = ();
    my $sth = $dbh->prepare("select lock_num from lok_lock");
    $sth->execute;
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    while ( my $lock_num = $sth->fetchrow ) {
	$locks{$lock_num} = 1;
    }
    # Remove the assigned locks
    $sth = $dbh->prepare("select distinct lock_num from lok_link");
    $sth->execute;
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    while ( my $lock_num = $sth->fetchrow ) {
	delete $locks{$lock_num};
    }
    # remaining values in %lock are unassigned locks....


    # print Floated Locker Table
    print "<table cellspacing=\"0\" cellpadding=\"3\" border=\"1\" ";
    print "style=\"float:left;margin:1em;\">\n<tr><th>". $lex{Locker};
    print "</th><th>". $lex{Comments}. q{/}. $lex{Clean}. "</th></tr>\n";

    $sth = $dbh->prepare("select cleaned, location, comment from lok_locker 
      where locker_num = ?");

    foreach my $locker_num ( sort keys %lockers ) {
	$sth->execute( $locker_num );
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	my ( $cleaned, $location, $comment ) = $sth->fetchrow;

	print "<tr><td>$locker_num ($location)</td><td>$comment ($cleaned)</td></tr>\n";

    }
    print "</table>\n";


    # Now Floated Locks Table
    print "<table cellspacing=\"0\" cellpadding=\"3\" border=\"1\" ";
    print "style=\"float:left;margin:1em;\">\n<tr><th>". $lex{Lock}. q{/}. $lex{Pool};
    print "</th><th>". $lex{Comments}. q{/}. $lex{Combination}. "</th></tr>\n";

    $sth = $dbh->prepare("select combination, pool, comment from lok_lock 
      where lock_num = ?");

    foreach my $lock_num ( sort keys %locks ) {
	$sth->execute( $lock_num );
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	my ( $combination, $pool, $comment ) = $sth->fetchrow;

	print "<tr><td>$lock_num ($pool)</td><td>$comment ($combination)</td></tr>\n";

    }
    print "</table>\n";
    # End of Floated Lock Table


    print "</body></html>\n";

    exit;

}



#-----------------
sub printTexHeader {
#-----------------

    # Adjust as desired.
    $hoffset = '-10mm';
    $voffset = '-36mm';

    open(TEX,">$filename") || die "Can't open tex file";

    my $fontsize = $arr{fontsize};

    my ( $papersize, $textwidth, $textheight );

    if ( $arr{papersize} eq $lex{Letter} or not $arr{papersize} ) {
	$papersize = 'letterpaper';
	$textwidth = $g_letterpaper_textwidth;
	$textheight = $g_letterpaper_textheight;
    } elsif ( $arr{papersize} eq $lex{Legal} ) {
	$papersize = 'legalpaper';
	$textwidth = $g_legalpaper_textwidth;
	$textheight = $g_legalpaper_textheight;
    } elsif ( $arr{papersize} eq $lex{A4} ) {
	$papersize = 'a4paper';
	$textwidth = $g_a4paper_textwidth;
	$textheight = $g_a4paper_textheight;
    } 
    delete $arr{papersize}; # no longer needed.



    print TEX "\\documentclass[$fontsize,$papersize]{article}
\\usepackage{array,colortbl,inputenc}
$a_latex_header
\\renewcommand{\\familydefault}{\\sfdefault}
\\pagestyle{empty}
\\setlength{\\textwidth}{$textwidth}
\\setlength{\\textheight}{$textheight}
\\setlength{\\evensidemargin}{0mm}
\\setlength{\\oddsidemargin}{0mm}
\\setlength{\\hoffset}{$hoffset}
\\setlength{\\voffset}{$voffset}
\\setlength{\\parindent}{0pt}
\\setlength{\\extrarowheight}{1pt}
\\setlength{\\tabcolsep}{3.5pt}\n";

    print TEX "\\begin{document}\n";

}
