#! /usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

# Outline: This prints a full report of evaluations for a group of
#  students. These student numbers are passed in the %arr hash.

my %lex = ('Student Marks' => 'Student Marks',
	   'No Course Enrollments' => 'No Course Enrollments',
	   'Error' => 'Error',
	   'Term' => 'Term',
	   
	   );

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

# Passed Values: studnum, subjsec, term
my $studnum = $arr{studnum};
my $term = $arr{term};


# Print the Page Header
print qq{$doctype\n<html><head><title>$lex{'Student Marks'}</title>\n};
print qq{<link rel="stylesheet" href="$tchcss" type="text/css">\n};
print qq{$chartype\n</head><body>\n};

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Get student name...
my $sth = $dbh->prepare("select lastname, firstname from student where studnum = ?");
$sth->execute($studnum);
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
my ($lastname, $firstname) = $sth->fetchrow;

print qq{<h2>$firstname $lastname <span style="font-size:80%;">};
print qq{$lex{Term}:$term</span></h2>\n};
print qq{<table cellpadding="3" cellspacing="0" border="1">\n};


# Find student subjects and eval.id in order by subject description.
my $sth = $dbh->prepare("select distinct subject.description, eval.subjcode, 
 eval.id from eval, subject
 where eval.subjcode = subject.subjsec and eval.studnum = ? and eval.term = ?
 order by subject.description, eval.subjcode");
$sth->execute($studnum, $term);
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }


my $sth1 = $dbh->prepare("select * from eval where id = ?");
my $subjflag = 0; # flag in case of no subj enrollments.

while ( my ( $desc, $subjsec, $id ) = $sth->fetchrow ){ # Loop through each subject.

    $subjflag = 1; # we have at least one subject

    # Get eval record.
    $sth1->execute( $id );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    my @eval = $sth1->fetchrow;

    print qq{<tr><td><b>$desc</b> };

    if ( $eval[8] ) { # We have more than 1 entry... load descriptors from subject.

	# Load Subject
	my $sth2 = $dbh->prepare("select * from subject where subjsec = ?");
	$sth2->execute( $subjsec );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my @subject = $sth2->fetchrow;

	print '[ ';
	foreach my $i (10..29) {
	    if ( $subject[$i] ) {
		print qq}$subject[$i] &ndash; $eval[ $i - 3 ] | \n};
	    } else {
		last; # done
	    }
	}
	if ( $eval[6] ) { print qq{<br><i>$eval[6]</i>\n}; }
    } else {
	if ($eval[7]) { print qq{&ndash; $eval[7] }; }
	if ($eval[6]) { print qq{&ndash; $eval[6] }; }
    }

    print "</td></tr>\n";


} # Next Subject


if (not $subjflag){ # No subject enrollments for this student.
    my $colcount = $maxterm + 1;
    print qq{<tr><td colspan="$colcount"><b>$lex{'No Course Enrollments'}</b></td></tr>\n};
}

print qq{</table></body></html>\n};
