#!/usr/bin/perl
#  Copyright 2001-2012 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Main' => 'Main',
	   'Error' => 'Error',
	   'View' => 'View',
	   'PPVT Scores' => 'PPVT Scores',
	   'Name' => 'Name',
	   'Score' => 'Score',
	   'Raw Score' => 'Raw Score',
	   'Standard Score' => 'Standard Score',
	   'Confidence' => 'Confidence',
	   'Percentile' => 'Percentile',
	   'Stanine' => 'Stanine',
	   'Normal Curve Equivalent' => 'Normal Curve Equivalent',
	   'Growth Scale Value' => 'Growth Scale Value',
	   'Equivalent' => 'Equivalent',
	   'Age' => 'Age',
	   'Grade' => 'Grade',

	   'No Records Found' => 'No Records Found',
	   'Continue' => 'Continue',
	   'Select' => 'Select',
	   'Student' => 'Student',
	   'Chk' => 'Chk',
	   'Homeroom' => 'Homeroom',
	   'Grade' => 'Grade',
	   'Blank=All' => 'Blank=All',
	   'Edit' => 'Edit',
	   'Tests' => 'Tests',
	   'Delete' => 'Delete',
	   'Start Date' => 'Start Date',
	   'End Date' => 'End Date',
	   'Equivalent' => 'Equivalent',
	   'Next Page' => 'Next Page',
	   'No Blanks Allowed' => 'No Blanks Allowed',

	   );

use DBI;
use CGI;

my $self = 'pvTestView.pl';
my $editscript = 'pvTestEdit.pl';
my $deletescript = 'pvTestDelete.pl';

eval require "../../etc/admin.conf";
if ( $@ ) {
    print "$lex{Error}: $self: $@<br>\n";
    die "$lex{Error}: $self: $@\n";
}

my $q = new CGI;
print $q->header;
my %arr = $q->Vars;

my @tim = localtime(time);
my $year = $tim[5] + 1900;
my $month = $tim[4] + 1;
my $day = $tim[3];
if ( length( $month) == 1 ) { $month = '0'. $month; }
if ( length( $day) == 1 ) { $day = '0'. $day; }
my $currdate = "$year-$month-$day";


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Page Header
print "$doctype\n<html><head><title>$lex{View} $lex{'PPVT Scores'}";
print "</title><link rel=\"stylesheet\" href=\"$tchcss\" type=\"text/css\">
<style type=\"text/css\">td.ra {text-align:right;}
td.cn { text-align:center;}</style>\n";

if ( not $arr{page} ) { # calendar popup.
    print "<link rel=\"stylesheet\" type=\"text/css\" media=\"all\" ";
    print "href=\"/js/calendar-blue.css\" title=\"blue\">\n";
    print "<script type=\"text/javascript\" src=\"/js/calendar.js\"></script>\n";
    print "<script type=\"text/javascript\" src=\"/js/lang/calendar-en.js\"></script>\n";
    print "<script type=\"text/javascript\" src=\"/js/calendar-setup.js\"></script>\n";
}

print "$chartype\n</head><body style=\"padding:1em 2em;\">\n";

print "[ <a href=\"$tchpage\">$lex{Main}</a> ]\n";
print "<h1>$lex{View} $lex{'PPVT Scores'}</h1>\n";


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    selectStudents();

} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    showTests();
} 


#----------------
sub showStartPage {
#----------------

    # Find Tests by Student Group
    print "<form action=\"$self\" method=\"post\"> \n";
    print "<input type=\"hidden\" name=\"page\" value=\"1\">\n";
    print "<table cellpadding=\"3\" cellspacing=\"0\" border=\"0\" ";
    print "style=\"padding:0.5em;border:1px solid gray;\">\n";

    print "<tr><td class=\"ra\">". $lex{Select}. q{ }. $lex{Student}. "\n";
    print "</td><td class=\"la\"><select name=\"groupname\">";
    print "<option>". $lex{Homeroom}. "</option>\n";
    print "<option>". $lex{Grade}. "</option>\n";
    print "</select>\n";
    print "<input type=\"text\" name=\"groupvalue\" size=\"10\"> ". $lex{'Blank=All'}. "</td></tr>\n";

    print "<tr><td class=\"ra\">$lex{Chk} $lex{'Next Page'}</td>\n";
    print "<td><input type=\"checkbox\" name=\"chk\" value=\"1\">\n";
    print "</td></tr>\n";

    print "<tr><td class=\"ra\">". $lex{'Start Date'}. "</td><td><input type=\"text\" ";
    print "name=\"startdate\" id=\"sdate\" size=\"10\" value=\"$schoolstart\">";
    print "<button type=\"reset\" id=\"start_trigger\">...</button>\n";
    print "</td></tr>\n";

    print "<tr><td class=\"ra\">". $lex{'End Date'}. "</td><td><input type=\"text\" ";
    print "name=\"enddate\" id=\"edate\" size=\"10\" value=\"$currdate\">";
    print "<button type=\"reset\" id=\"end_trigger\">...</button></td></tr>\n";


    print "<tr><td></td><td>\n<input type=\"submit\" value=\"". $lex{Continue};
    print "\"></td></tr>\n";

    print "</table></form></div>\n";

    print "<script type=\"text/javascript\">
     Calendar.setup({
        inputField     :    \"sdate\", 
        ifFormat       :    \"%Y-%m-%d\",
        button         :    \"start_trigger\",
        singleClick    :    false,
        step           :    1
    });

    Calendar.setup({
        inputField     :    \"edate\",
        ifFormat       :    \"%Y-%m-%d\",
        button         :    \"end_trigger\",
        singleClick    :    false,
        step           :    1
    });
   </script>\n";


    print "</body></html>\n";

    exit;

} # end of showStartPage



#----------------
sub selectStudents {
#----------------

    # foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }    

    my $groupvalue = $arr{groupvalue};
    delete $arr{groupvalue};

    my $chk;
    if ( $arr{chk} ) {
	$chk = 'CHECKED';
    }
    delete $arr{chk};

    # Check for any Blanks
    foreach my $key ( sort keys %arr ) { 
	if ( not $arr{$key} ) {
	    print "<h3>$lex{'No Blanks Allowed'}</h3>\n";
	    print "</body></html>\n";
	    exit;
	}
    }

    my $select;
    if ( $groupvalue ) { # we're picking a group
	if ( $arr{groupname} eq $lex{Grade} ) {
	    $select = 'where grade = ?';
	} else {
	    $select = 'where homeroom = ?';
	}
    }

    my $sth = $dbh->prepare("select lastname, firstname, studnum from student
      $select order by lastname, firstname");
    if ( $select ) {
	$sth->execute( $groupvalue );
    } else {
	$sth->execute;
    }
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

    # Form Header
    print "<form action=\"$self\" method=\"post\"> \n";
    print "<input type=\"hidden\" name=\"page\" value=\"2\">\n";
    print "<input type=\"hidden\" name=\"startdate\" value=\"$arr{startdate}\">\n";
    print "<input type=\"hidden\" name=\"enddate\" value=\"$arr{enddate}\">\n";

    print "<table cellpadding=\"3\" cellspacing=\"0\" border=\"0\">\n";

    print "<tr><td class=\"ra\"><input type=\"submit\" value=\"$lex{Continue}\">";
    print "</td><td></td></tr>\n";

    my $sth1 = $dbh->prepare("select count(*) from ppvt_test where studnum = ?");

    my $sth2 = $dbh->prepare("select count(*) from ppvt_test where studnum = ? and 
      to_days( tdate ) >= to_days( '$arr{startdate}' ) 
      and to_days( tdate ) <= to_days( '$arr{enddate}')");
    
    
    print "<tr><th>$lex{Student}</th><th>$lex{Tests}</th><th></th></tr>\n";

    while ( my ( $lastname, $firstname, $studnum ) = $sth->fetchrow ) {

	# Count of All Tests	
	$sth1->execute( $studnum );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my $overallcount = $sth1->fetchrow;

	# Count - Date Limited
	$sth2->execute( $studnum );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my $count = $sth2->fetchrow;


	print "<tr><td class=\"ra\">$lastname, $firstname ($studnum)</td>\n";
	print "<td class=\"cn\">$count / $overallcount</td><td>";
	if ( $count ) {
	    print "<input type=\"checkbox\" name=\"$studnum\" value=\"1\" $chk>";
	}
	print "</td></tr>\n";
    }

    print "<tr><td class=\"ra\"><input type=\"submit\" value=\"". $lex{Continue};
    print "\"></td><td></td></tr>\n";

    print "</table></form></body></html>\n";

    exit;

} # end of selectStudents



#------------
sub showTests {
#------------

    #foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    my $startdate = $arr{startdate};
    my $enddate = $arr{enddate};
    delete $arr{startdate};
    delete $arr{enddate};


    # Searching by Student Number

    my $sth1 = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");
    my $first = 1;

    foreach my $studnum ( sort keys %arr ) {

	# Get Student Name
	$sth1->execute( $studnum );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my ( $lastname, $firstname ) = $sth1->fetchrow;


	# Display Existing Tests (if any)
	my $sth = $dbh->prepare("select * from ppvt_test 
         where studnum = ? and to_days( tdate ) >= to_days( '$startdate' ) 
         and to_days( tdate ) <= to_days( '$enddate') order by tdate, id");

	$sth->execute( $studnum );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	while ( my $ref = $sth->fetchrow_hashref ) {

		$first = 0;

		print "<div style=\"font-size:100%; font-weight:bold;\">$firstname $lastname<div>\n";
		print "<div style=\"font-weight:normal;\">$ref->{tauthor} / $ref->{tdate}\n";

		# Edit Button
		print "<form action=\"$editscript\" method=\"post\" target=\"_blank\" ";
		print "style=\"display:inline;\">\n";
		print "<input type=\"hidden\" name=\"testid\" value=\"$ref->{id}\">\n";
		print "<input type=\"submit\" value=\"$lex{Edit}\">\n";
		print "</form>\n";

		# Delete Button
		print "<form action=\"$deletescript\" method=\"post\" target=\"_blank\" ";
		print "style=\"display:inline;\">\n";
		print "<input type=\"hidden\" name=\"testid\" value=\"$ref->{id}\">\n";
		print "<input type=\"submit\" value=\"$lex{Delete}\">\n";
		print "</form></div>\n";

		print "<table cellpadding=\"3\" cellspacing=\"0\" border=\"1\">\n";
		print "<tr><th>$lex{Name}</th><th>$lex{Score}</th></tr>\n";

		print "<tr><td class=\"bra\">$lex{'Raw Score'}</td><td class=\"la\">$ref->{rawscore}</td></tr>\n";
		print "<tr><td class=\"bra\">$lex{'Standard Score'}</td><td class=\"la\">$ref->{stdscore}</td></tr>\n";
#		print "<tr><td class=\"bra\">$lex{Confidence}</td><td class=\"la\">$ref->{confstart} &ndash; $ref->{confend}</td></tr>\n";
		print "<tr><td class=\"bra\">$lex{Percentile}</td><td class=\"la\">$ref->{percentile}</td></tr>\n";
#		print "<tr><td class=\"bra\">$lex{'Normal Curve Equivalent'}</td><td class=\"la\">$ref->{normalce}</td></tr>\n";
#		print "<tr><td class=\"bra\">$lex{Stanine}</td><td class=\"la\">$ref->{stanine}</td></tr>\n";
#		print "<tr><td class=\"bra\">$lex{'Growth Scale Value'}</td><td class=\"la\">$ref->{growthsv}</td></tr>\n";
		print "<tr><td class=\"bra\">$lex{Age} $lex{Equivalent}</td><td class=\"la\">$ref->{equivage}</td></tr>\n";
#		print "<tr><td class=\"bra\">$lex{Grade} $lex{Equivalent}</td><td class=\"la\">$ref->{equivgrade}</td></tr>\n";


		print "</table><p></p>\n";

	} # end of student loop.

	if ( $first ) {
	    print "<div style=\"font-weight:bold;\">";
	    print $lex{'No Records Found'}. "</div>\n";
	}

    } # end of student number loop

    print "</body></html>\n";
    
    exit;

}
