#! /usr/bin/perl
#  Copyright 2001-2014 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


my %lex = ('Main' => 'Main',
	   'Walkthrough' => 'Walkthrough',
	   'Viewer' => 'Viewer',
	   'Description' => 'Description',
	   'Type' => 'Type',
	   'Select' => 'Select',
	   'Fields' => 'Fields',
	   'Error' => 'Error',
	   'Continue' => 'Continue',
	   'Column' => 'Column',
	   'Number' => 'Number',
	   'Width' => 'Width',
	   'Order' => 'Order',
	   'Tabular' => 'Tabular',
	   'Multicolumn' => 'Multicolumn',
	   'Reorder' => 'Reorder',
	   'Student Roster' => 'Student Roster',
	   'Report' => 'Report',
	   'Created' => 'Created',
	   'Delete' => 'Delete',
	   'Select' => 'Select',
	   'Deleted' => 'Deleted',
	   'Save' => 'Save',
	   'Drag' => 'Drag',
	   'Change' => 'Change',
	   'Order' => 'Order',
	   'View' => 'View',
	   'New' => 'New',
	   'Missing' => 'Missing',
	   'Category' => 'Category',
	   'Sequence' => 'Sequence',
	   'Template' => 'Template',
	   'Evaluation' => 'Evaluation',
	   'Subject' => 'Subject',
	   'Records' => 'Records',
	   'Not Found' => 'Not Found',
	   'Not Complete' => 'Not Complete',
	   'Areas of Strength' => 'Areas of Strength',
	   'Areas for Improvement' => 'Areas for Improvement',
	   'Please Log In' => 'Please Log In',
	   
	   );

my $self = 'pwalkevalview_tch.pl';


use DBI;
use CGI;
use Data::UUID;
use CGI::Session;


# Current Date
my @tim = localtime(time);
my $year = @tim[5] + 1900;
my $month = @tim[4] + 1;
my $day = @tim[3];
if (length($month) == 1) { $month = '0'.$month; }
if (length($day) == 1) { $day = '0'.$day; }
my $currdate = "$year-$month-$day";


eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $dbtype = 'mysql';
my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Get Session
my $session = new CGI::Session("driver:mysql;serializer:FreezeThaw",
 undef,{Handle => $dbh}) or die CGI::Session->errstr;

if ( not $session->param('logged_in') ){
    my $userid = $session->param('userid');
    print $session->header( -charset, $charset );
    print qq{$doctype\n<html><body>\n};
    print qq{<h1>$lex{'Please Log In'}</h1>\n};
    print qq{[ <a href="$tchpage">$lex{Main}</a> ]\n};
    exit;
}

my $userid = $session->param('userid');
my $duration = $session->param('duration');
$session->expire('logged_in', $duration );

print $session->header( -charset, $charset );


my $q = new CGI;
my %arr = $q->Vars;
# print $q->header( -charset, $charset );


# Page Header
my $title = qq{$lex{Walkthrough} Evaluation $lex{Viewer} };

print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$tchcss" type="text/css">\n};

if ( $arr{page} == 1 ) { # load jQuery libs
    print qq{<script type="text/javascript" src="$g_jquery_url">};
    print qq{</script>\n};

    print qq{<script type="text/javascript" src="$g_jquery_ui_url">};
    print qq{</script>\n};
}



print qq{$chartype\n</head><body style="padding:1em 3em;">\n};
print qq{<div>[ <a href="$tchpage">$lex{Main}</a> ]</div>\n};

print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    showEvaluation();
}



#-----------------
sub showEvaluation {
#-----------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    # Get Master Record
    my $sth = $dbh->prepare("select * from pwalk_eval where id = ?");
    $sth->execute( $arr{id} );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my $mref = $sth->fetchrow_hashref;
    my %mst = %$mref;
    my $mstid = $mst{id};


    # Loop through all template records
    my $sth = $dbh->prepare("select * from pwalk_score where mstid = ? order by sequence");
    $sth->execute( $mstid );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    print qq{<h3>$mst{tfirstname} $mst{tlastname}\n};
    print qq{ <span style="font-size:80%;">($mst{title} &ndash; $mst{description}) $mst{adatetime}</span></h3>\n};
    print qq{<div style="font-weight:bold;margin:0.3em;">$lex{Subject} $mst{subject}</div>\n};

    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
    print qq{<tr><th colspan="2">$lex{Evaluation}</th></tr>\n};

    while ( my $ref = $sth->fetchrow_hashref ) {
	%r = %$ref;

	print qq{<tr><td class="bla" colspan="2">$r{description} ($r{category})</td></tr>\n};
	print qq{<tr><td class="bra">Score</td><td class="la">$r{score}</td></tr>\n};
	print qq{<tr><td class="bra">$lex{'Areas of Strength'}</td><td class="la">$r{strengths}</td></tr>\n};
	print qq{<tr><td class="bra">$lex{'Areas for Improvement'}</td><td class="la">$r{weaknesses}</td></tr>\n};
    }

    print qq{<tr><td class="bra">General Comments</td><td class="la">$mst{comment}</td></tr>\n};
    print qq{</table>\n};
    print qq{</body></html>\n};

    exit;

} # end of showTemplate



#----------------
sub showStartPage {
#----------------

    # Get Staff Member Name
    my $sth = $dbh->prepare("select lastname, firstname from staff where userid = ?");
    $sth->execute( $userid );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my ($lastname, $firstname) = $sth->fetchrow;

    print qq{<h3>$firstname $lastname</h3>\n};


    # Get the Evaluations
    my $sth = $dbh->prepare("select * from pwalk_eval where tuserid = ? 
       order by adatetime desc");
    $sth->execute( $userid );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    my $first = 1;

    while ( my $ref = $sth->fetchrow_hashref ) {

	if ($first ) {
	    # Start Form
	    print qq{<form action="$self" method="post">\n};
	    print qq{<input type="hidden" name="page" value="1">\n};

	    # Start Table
	    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
	    print qq{<caption style="font-size:120%;font-weight:bold;">Select Evaluation</caption>\n};
	    $first = 0;
	}


	my %r = %$ref;
	if ( $r{continueedit} ) {
	    print qq{<tr><td><b>$lex{'Not Complete'}</b>\n};
	    print qq{$r{adatetime} $r{title} ($r{description})</td></tr>\n};
	} else {
	    print qq{<tr><td><input type="radio" name="id" value="$r{id}">\n};
	    print qq{$r{adatetime} $r{title} ($r{description})</td></tr>\n};
	}
    }

    if ( $first ) {
	print qq{<h3>$lex{Records} $lex{'Not Found'}</h3>\n};
	print qq{</body></html>\n};
	exit;
    }

    print qq{</table>\n};


    # Continue Button
    print qq{<p><input type="submit" value="$lex{Continue}"></p>\n};
    print qq{</form>\n};

    print qq{</body></html>\n};

    exit;

}
