#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

use DBI;
use CGI;
use FreezeThaw qw(thaw);

my %lex = ( 'Error' => 'Error',
	    'View Sessions' => 'View Sessions',
	    'Session Values' => 'Session Values',
	    'Id' => 'Id',
	    'Main' => 'Main',

	    );


eval require "../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


$sth = $dbh->prepare("select * from sessions");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr;}
$rows = $sth->rows;

print qq{$doctype\n<html><head><title>$lex{'View Sessions'}</title>\n};
print qq{<link rel="stylesheet" href="$tchcss" type="text/css">
 </head><body><a name="top"></a>[ <a href="$tchpage">$lex{Main}</a> ]\n};

print qq{<table border="1" cellpadding="2" cellspacing="0">\n};
print qq{<tr><th>$lex{Id}</th><th>$lex{'Session Values'}</th></tr>\n};

while (my ($id,$session) = $sth->fetchrow){
    @sess = thaw $session;
    print qq{<tr><td>$id</td><td>};
    foreach my $sess (@sess){
	foreach my $key (keys %{$sess}){
	    print qq{K:$key V:${$sess}{$key}<br>\n};
	    if ($key eq "_SESSION_EXPIRE_LIST"){
		my $expref = \%{ ${$sess}{$key} };
        	foreach my $k (keys %{$expref}){ print qq{<b>K:$k V:${$expref}{$k}</b><br>\n};}
	    }
	}
    }
    print qq{</td></tr>\n};
}

print qq{</table>};
print qq{</body></html>\n};
