#!/usr/bin/perl
#  Copyright 2001-2019 Leslie Richardson

#  This file is part of Open Admin for Schools.


my %lex = ('Student Report' => 'Student Report',
	   'Responsibility' => 'Responsibility',
	   'Strategies, Resources, Activities' => 'Strategies, Resources, Activities',
	   'Objectives' => 'Objectives',
	   'Student' => 'Student',
	   'Student Team' => 'Student Team',
	   'Name' => 'Name',
	   'Position' => 'Position',
	   'Assessments' => 'Assessments',
	   'Dates' => 'Dates',
	   'Category' => 'Category',
	   'Comments' => 'Comments',
	   'Back to Special Needs Students' => 'Back to Special Needs Students',
	   'Student IEP' => 'Student IEP',
	   'Identification' => 'Identification',
	   'Name' => 'Name',
	   'Gender' => 'Gender',
	   'Birthdate' => 'Birthdate',
	   'Grade' => 'Grade',
	   'Designation Date' => 'Designation Date',
	   'DDPF Level' => 'DDPF Level',
	   'Designation' => 'Designation',
	   'Medical(other)' => 'Medical(other)',
	   'School' => 'School',
	   'Parent/Guardian' => 'Parent/Guardian',
	   'Address' => 'Address',
	   'Home Phone' => 'Home Phone',
	   'Emergency Contact' => 'Emergency Contact',
	   'Error' => 'Error',

	   );

use DBI;
use CGI;
use Cwd;


# Set prepath for config file: (/tcgi or cgi/schedule)
my $prepath = '../..';
if ( getcwd() =~ /tcgi/){ # we are in tcgi
    $prepath = '..';
}

# Read config variables
eval require "$prepath/etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

if ( getcwd() =~ /tcgi/){ # we are in tcgi
    $css = $tchcss;
    $homepage = $tchpage;
}


my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

#foreach my $key ( sort keys %arr ) {
#    print qq{K:$key VAL:$arr{$key}<br>\n};
#}


# These MUST be passed in order to find student.
my $studnum = $arr{studnum};
my $database = $arr{school};
#my $schoolname = $dbase{$database}; # from global.conf dbase hash.

# print "Studnum:$studnum<br>\n";

# Print Page Header
my $title = $lex{'Student IEP'};

print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">$chartype\n};
print qq{</head><body>\n};


my $dsn = "DBI:$dbtype:$database";
my $dbh = DBI->connect($dsn,$user,$password);


# Load Student Info from the local school database.
my $sth = $dbh->prepare("select * from student where studnum = ?");
$sth->execute( $studnum );
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }  
my $sref = $sth->fetchrow_hashref;
# my %sr = %$sref;

# Set Current Date
my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $iddst) = localtime(time);
$year = $year + 1900;
$mon++;
$wday++;
$currdate = "$dow[$wday], $month[$mon] $mday, $year";


eval require "$iepdir/cgi/ppp.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}
# Loads userid, password, dbase for IEP db.


# Now get handle to IEP database.
my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# Get Category name (ie subject area for these goals)
my %catdesc;
my $sth = $dbh->prepare("select distinct category, catnum from subject");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
while ( my ($category, $catnum) = $sth->fetchrow ) {
    if ( not $category or not $catnum ) {
	print "Missing Category: $category - $catnum<br>\n";
    }
    $catdesc{$catnum} = $category;
}


# Look for student
my %sp;
my $sth = $dbh->prepare("select * from special where studnum = ?");
$sth->execute( $studnum );
if ($DBI::errstr) { print "Error: $DBI::errstr"; die $DBI::errstr; }
my $spref = $sth->fetchrow_hashref;
%sp = %$spref; 

# foreach my $key ( sort keys %sp ) { print qq{K:$key Val:$sp{$key}<br>\n}; }


$studname = "$sp{firstname} $sp{lastname}";
$shortschool = $database;


# Print the heading section 
print qq{<div>[ <a href="specedview.pl">$lex{'Back to Special Needs Students'}</a> ] $currdate</div>\n};
print qq{<h1>$title</h1>\n};

print qq{<div style="font-size:140%;font-weight:bold;">$studname</div>\n};

print qq{<h2>$lex{Identification}</h2>\n};
print qq{<table cellspacing="0" cellpadding="3" border="0">\n};

print qq{<tr><td class="bra">$lex{Name}</td><td>$studname </td></tr>\n};
print qq{<tr><td class="bra">$lex{Gender}</td><td>$sp{sex}</td></tr>\n};
print qq{<tr><td class="bra">$lex{Birthdate}</td><td>$sp{birthdate}</td></tr>\n};
print qq{<tr><td class="bra">$lex{Grade}</td><td>$sp{grade}</td></tr>\n};


print qq{<tr><td class="bra">$lex{Designation}</td><td> $sp{designation}</td></tr>\n};

print qq{<tr><td class="bra">$lex{'Medical(other)'}</td><td> $sp{medical}</td></tr>\n};
print qq{<tr><td class="bra">$lex{School}</td><td class="la">$schoolname</td></tr>\n};
print qq{<tr><td class="bra">$lex{'Parent/Guardian'}</td><td>$sr{par1_firstname} $sr{par1_lastname}</td></tr>\n};

print qq{<tr><td class="bra">$lex{Address}</td><td>$sr{address1} $sr{city1} $sr{prov1}</td></tr>\n};
print qq{<tr><td class="bra">$lex{'Home Phone'}</td><td>$sr{hphone1}</td></tr>\n};

print qq{<tr><td class="bra">$lex{'Emergency Contact'}</td>};
print qq{<td>$sr{emname} };
if ( $sr{emhphone} ) { print qq{Home:$sr{emhphone} }; }
if ( $sr{emwphone} ) { print qq{Work:$sr{emwphone} }; }
if ( $sr{emcell} ) { print qq{Cell:$sr{emcell} }; }
print qq{</td></tr></table>\n\n};


# Now lets do the team.
$sth1 = $dbh->prepare("select * from team where studnum = ?");
$sth1->execute( $studnum );
if ($DBI::errstr) { print $DBI::errstr; die;}

print qq{<h2>$lex{'Student Team'}</h2>\n};
print qq{<table cellspacing="0" cellpadding="4" border="1" style="margin:1em;">\n};
print qq{<tr><th>$lex{Name}</th><th>$lex{Position}</th></tr>\n};

my %teamname;
while ( my $tref = $sth1->fetchrow_hashref ) {
    my %t = %$tref;
    print qq{<tr><td>$t{firstname} $t{lastname}</td><td>$t{jobtitle}</td></tr>\n}; # ($t{userid})
    $teamname{$t{userid}} = qq{$t{firstname} $t{lastname}};
}
print qq{</table>\n\n};


# Load evmst_staff records
my $sth1 = $dbh->prepare("select * from evmst_staff where mainid = ?");
my $sth2 = $dbh->prepare("select * from evmst_goal where mainid = ? order by idnum");
my $sth3 = $dbh->prepare("select mastery,term from evmst_mastery where goalid = ? order by term");


# Goals
my $sth = $dbh->prepare("select * from evmst_main where studnum = ?");
$sth->execute( $studnum );
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }


# Setup the table.
print qq{<h2>Student Goals</h2>\n};

# Subjects Loop; once for each subject; they come out of evmst_* tables

while ( my $ref = $sth->fetchrow_hashref ) {
    my %em = %$ref;  # was @evalmst
    # %em = latex_filter( %em );
    my $catnum = $em{catnum};
    my $mainid = $em{id};

    
    # Get Category Name (from %catdesc at top of student loop
    my $category = $catdesc{$catnum};
    
    # Table
    print qq{<table cellspacing="0" cellpadding="4" border="1" style="margin-bottom:2em;">\n};    
    print qq{<tr><th style="text-align:left;">$category</th></tr>\n};


    # 4 fields in main evmst_main record
    print qq{<tr><td class="la"><b>Target Skill</b> $em{targetskill}</td></tr>\n};
    print qq{<tr><td class="la"><b>Performance Level</b> $em{currperform}</td></tr>\n};
    print qq{<tr><td class="la"><b>Long Term Objective</b> $em{longtermobjective}</td></tr>\n};
    print qq{<tr><td class="la"><b>Evaluation Method</b> $em{evalmethod}</td></tr>\n};

    
    # Load Staff/Team responsibility stuff from evmst_staff;
    $sth1->execute( $mainid );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my $first = 1;
    while ( my $ref = $sth1->fetchrow_hashref ) {

	if ( $first ) { 
	    print qq{<tr><td><b>Responsibility</b><ul>\n};
	    $first = 0;
	}
	
	my %r = %$ref;
	print qq{<li><b>$teamname{$r{userid}}</b> $r{strategy}</li>\n};
    }
    if ( not $first ) {
	print qq{</ul></td></tr>\n};
    }
    
        
    # Now print the goals;
    print qq{<tr><td><b>Goals / Mastery Level</b><ul>\n};

    # Load the goals from evmst_goal
    $sth2->execute( $mainid );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my $first = 1;
    while (my $ref = $sth2->fetchrow_hashref ) {
	my %g = %$ref; # goal record (id, mainid, description, idnum)
	# (%g) = latex_filter(%g);
	print qq{<li>$g{description} };

	$sth3->execute( $g{id} );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	while ( my ($mastery, $term ) = $sth3->fetchrow ) {
	    # ($mastery) = latex_filter( $mastery );
	    print qq{Term $term - Mastery $mastery / };
	}
	print qq{</li>\n};

    }
    print qq{</ul></td></tr>\n};
    print qq{</table>\n\n};

   
} # End of Goals Loop

print qq{<div>[ <a href="specedview.pl">$lex{'Back to Special Needs Students'}</a> ]</div>\n};

print qq{</body></html>\n};
