#!/usr/bin/perl
#  Copyright 2001-2014 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Main' => 'Main',
	   'Error' => 'Error',
	   'View' => 'View',
	   'Name' => 'Name',
	   'Author' => 'Author',
	   'Scores' => 'Scores',
	   'Score' => 'Score',
	   'Age' => 'Age',
	   'Grade' => 'Grade',
	   'No Records Found' => 'No Records Found',
	   'Continue' => 'Continue',
	   'Select' => 'Select',
	   'Students' => 'Students',
	   'Check' => 'Check',
	   'Homeroom' => 'Homeroom',
	   'Blank=All' => 'Blank=All',
	   'Edit' => 'Edit',
	   'Tests' => 'Tests',
	   'Delete' => 'Delete',
	   'Start Date' => 'Start Date',
	   'End Date' => 'End Date',
	   'Next Page' => 'Next Page',
	   'No Blanks Allowed' => 'No Blanks Allowed',
	   'Student' => 'Student',
	   'Date' => 'Date',
	   'Needs Assessment' => 'Needs Assessment',
	   'Type' => 'Type',
	   'Outcome' => 'Outcome',

	   );

use DBI;
use CGI;

my $self = 'needsView.pl';

my %recommend = ( 'EDPSY' => 'Ed Psych',
		  'SLP' => 'Speech Language',
		  'MH' => 'Mental Health',
		  'SPEC' => 'Special Ed',
		  'OT' => 'Occupational Therapy',
		  'TB' => 'Targeted Behaviour',
    );

#my $editscript = 'cmathEdit.pl';
#my $deletescript = 'cmathDelete.pl';

eval require "../../etc/admin.conf";
if ( $@ ) {
    print "$lex{Error}: $self: $@<br>\n";
    die "$lex{Error}: $self: $@\n";
}


my $q = new CGI;
print $q->header;
my %arr = $q->Vars;

my @tim = localtime(time);
my $year = $tim[5] + 1900;
my $month = $tim[4] + 1;
my $day = $tim[3];
if ( length( $month) == 1 ) { $month = '0'. $month; }
if ( length( $day) == 1 ) { $day = '0'. $day; }
my $currdate = "$year-$month-$day";


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Page Header
my $title = qq{$lex{View} $lex{Student} $lex{'Needs Assessment'}};
print "$doctype\n<html><head><title>$title</title>\n";
print "<link rel=\"stylesheet\" href=\"$tchcss\" type=\"text/css\">
<style type=\"text/css\">td.ra {text-align:right;}
td.cn { text-align:center;}</style>\n";

if ( not $arr{page} ) { # calendar popup.
    print "<link rel=\"stylesheet\" type=\"text/css\" media=\"all\" ";
    print "href=\"/js/calendar-blue.css\" title=\"blue\">\n";
    print "<script type=\"text/javascript\" src=\"/js/calendar.js\"></script>\n";
    print "<script type=\"text/javascript\" src=\"/js/lang/calendar-en.js\"></script>\n";
    print "<script type=\"text/javascript\" src=\"/js/calendar-setup.js\"></script>\n";
}

print "$chartype\n</head><body style=\"padding:1em 2em;\">\n";

print "[ <a href=\"$tchpage\">$lex{Main}</a> ]\n";
print "<h1>$title</h1>\n";


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    selectStudents();

} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    showNeeds();
} 


#----------------
sub showStartPage {
#----------------

    # Find Tests by Student Group
    print "<form action=\"$self\" method=\"post\"> \n";
    print "<input type=\"hidden\" name=\"page\" value=\"1\">\n";
    print "<table cellpadding=\"3\" cellspacing=\"0\" border=\"0\" ";
    print "style=\"padding:0.5em;border:1px solid gray;\">\n";

    print "<tr><td class=\"ra\">$lex{Select} $lex{Students}\n";
    print "</td><td class=\"la\"><select name=\"groupname\">";
    print "<option value=\"grade\">$lex{Grade}</option>\n";
    print "<option value=\"homeroom\">$lex{Homeroom}</option>\n";
    print "</select>\n";
    print "<input type=\"text\" name=\"groupvalue\" size=\"10\"> $lex{'Blank=All'}</td></tr>\n";

    print "<tr><td class=\"ra\">$lex{Check} $lex{'Next Page'}</td>\n";
    print "<td><input type=\"checkbox\" name=\"chk\" value=\"1\">\n";
    print "</td></tr>\n";

    print "<tr><td class=\"ra\">$lex{'Start Date'}</td><td><input type=\"text\" ";
    print "name=\"startdate\" id=\"sdate\" size=\"10\" value=\"$schoolstart\">";
    print "<button type=\"reset\" id=\"start_trigger\">...</button>\n";
    print "</td></tr>\n";

    print "<tr><td class=\"ra\">$lex{'End Date'}</td><td><input type=\"text\" ";
    print "name=\"enddate\" id=\"edate\" size=\"10\" value=\"$currdate\">";
    print "<button type=\"reset\" id=\"end_trigger\">...</button></td></tr>\n";


    print "<tr><td></td><td>\n<input type=\"submit\" value=\"$lex{Continue}\"></td></tr>\n";

    print "</table></form></div>\n";

    print "<script type=\"text/javascript\">
     Calendar.setup({
        inputField     :    \"sdate\", 
        ifFormat       :    \"%Y-%m-%d\",
        button         :    \"start_trigger\",
        singleClick    :    false,
        step           :    1
    });

    Calendar.setup({
        inputField     :    \"edate\",
        ifFormat       :    \"%Y-%m-%d\",
        button         :    \"end_trigger\",
        singleClick    :    false,
        step           :    1
    });
   </script>\n";

    print "</body></html>\n";

    exit;

} # end of showStartPage



#----------------
sub selectStudents {
#----------------

    # foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }    
    

    my $groupvalue = $arr{groupvalue};
    delete $arr{groupvalue};

    my $chk;
    if ( $arr{chk} ) {
	$chk = 'CHECKED';
    }
    delete $arr{chk};

    # Check for any Blanks
    foreach my $key ( sort keys %arr ) { 
	if ( not $arr{$key} ) {
	    print "<h3>$lex{'No Blanks Allowed'}</h3>\n";
	    print "</body></html>\n";
	    exit;
	}
    }

    my $select;
    if ( $groupvalue ) { # we're picking a group
	if ( $arr{groupname} eq 'grade' ) {
	    $select = 'where grade = ?';
	} else {
	    $select = 'where homeroom = ?';
	}
    }

    my $sth = $dbh->prepare("select lastname, firstname, studnum from student
      $select order by lastname, firstname");
    if ( $select ) {
	$sth->execute( $groupvalue );
    } else {
	$sth->execute;
    }
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

    # Form Header
    print "<form action=\"$self\" method=\"post\"> \n";
    print "<input type=\"hidden\" name=\"page\" value=\"2\">\n";
    print "<input type=\"hidden\" name=\"startdate\" value=\"$arr{startdate}\">\n";
    print "<input type=\"hidden\" name=\"enddate\" value=\"$arr{enddate}\">\n";

    print "<table cellpadding=\"3\" cellspacing=\"0\" border=\"0\">\n";

    print qq{<tr><td class="la" colspan="3">\n};
    print qq{<input type="submit" value="$lex{Continue}"></td><td></td></tr>\n};


    my $sth1 = $dbh->prepare("select count(*) from student_needs where studnum = ?");
    
    print "<tr><th></th><th>$lex{Student}</th><th>$lex{Tests}</th></tr>\n";

    while ( my ( $lastname, $firstname, $studnum ) = $sth->fetchrow ) {
	
	$sth1->execute( $studnum );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my $count = $sth1->fetchrow;

	print qq{<tr><td class="cn">};
	if ( $count ) {
	    print qq{<input type="checkbox" name="$studnum" value="1" $chk>};
	}

	print qq{</td><td class="la">$lastname, $firstname ($studnum)</td>\n};
	print qq{<td class="cn">$count</td></tr>\n};

    }

    print qq{<tr><td class="la" colspan="3">\n};
    print qq{<input type="submit" value="$lex{Continue}"></td><td></td></tr>\n};
    print qq{</table></form></body></html>\n};

    exit;

} # end of selectStudents



#------------
sub showNeeds {
#------------

    # foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    my $startdate = $arr{startdate};
    my $enddate = $arr{enddate};
    delete $arr{startdate};
    delete $arr{enddate};

    my $sth1 = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");

    # sort by name.
    my %sort = ();
    foreach my $studnum ( keys %arr ) { 
	$sth1->execute( $studnum );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my ( $lastname, $firstname ) = $sth1->fetchrow;
	$sort{"$lastname$firstname$studnum"} = $studnum;
    }


    foreach my $key ( sort keys %sort ) {

	my $studnum = $sort{$key};

	# Get Student Name
	$sth1->execute( $studnum );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my ( $lastname, $firstname ) = $sth1->fetchrow;


	# Get Needs Record
	my $sth = $dbh->prepare("select * from student_needs
         where studnum = ? and to_days( date ) >= to_days( '$startdate' ) 
         and to_days( date ) <= to_days( '$enddate') order by date, id");


	$sth->execute( $studnum );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	while ( my $ref = $sth->fetchrow_hashref ) {

	    my %r = %$ref;
	    my $studnum = $r{studnum};

	    print qq{<div style="text-align:left;font-size:140%;font-weight:bold;"><b>$lastname</b>, $firstname</div>\n};

	    print qq{<table cellpadding="6" cellspacing="0" border="1">\n};
	    print qq{<tr><td class="bra">Strengths</td><td>$r{strengths}</td></tr>\n};

	    print qq{<tr><td class="bra">Challenges</td><td>$r{challenges}</td></tr>\n};

	    print qq{<tr><td class="bra">Support<br>Received</td><td>$r{support}</td></tr>\n};

	    print qq{<tr><td class="bra">Recommendations</td>};
	    print qq{<td>};

	    my @rmd = split(';', $r{recommendations});

	    for my $key ( @rmd ) {
		print qq{$recommend{$key}<br>\n};
	    }
	    print qq{</td></tr>\n};

	    print qq{<tr><td class="bra">Other Recommendations</td><td>$r{rec_other}</td></tr>\n};

	    print qq{<tr><td class="bra">Classroom<br>Recommendations</td><td>$r{rec_classroom}</td></tr>\n};

	    print qq{<tr><td class="bra">$lex{Date}</td><td>$r{date} ($r{tstamp})</td></tr>\n};

	    print qq{</table><p></p>\n};

	} # end of recommendations loop

	
=head
	    print "<td><form action=\"$editscript\" method=\"post\" target=\"_blank\" ";
	    print "style=\"display:inline;\">\n";
	    print "<input type=\"hidden\" name=\"testid\" value=\"$ref->{id}\">\n";
	    print "<input type=\"submit\" value=\"$lex{Edit}\">\n";
	    print "</form></td>\n";

	    # Delete Button
	    print "<td><form action=\"$deletescript\" method=\"post\" target=\"_blank\" ";
	    print "style=\"display:inline;\">\n";
	    print "<input type=\"hidden\" name=\"testid\" value=\"$ref->{id}\">\n";
	    print "<input type=\"submit\" value=\"$lex{Delete}\">\n";
	    print "</form></td>\n";

	    print "</tr>\n\n";
=cut


    } # end of student loop.


    print "</body></html>\n";

    exit;

}
