<!DOCTYPE html>
<html>
<!--
#  Copyright 2001-2022 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.
-->
<head>
<title><#Student Attendance#></title>
<link rel="stylesheet" href="admin.css" type="text/css">
<link rel="stylesheet" type="text/css" media="all" href="js/calendar-blue.css" title="blue">
<script type="text/javascript" src="js/calendar.js"></script>
<script type="text/javascript" src="js/lang/calendar-en.js"></script>
<script type="text/javascript" src="js/calendar-setup.js"></script>

<style type="text/css">
  input, button, select { padding:0; margin:0;font-size:100%; }
  div.fmt {margin:0.4em;border:1px solid gray;padding:4px;}
  form { margin:0.4em; }
</style>

<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
</head><body>

<ul class="nav" style="border-top:1px solid black; margin: 0.5em; 
 position: fixed; top:0; bottom:auto;">
<li><a href="index.shtml"><#Main#></a></li>
<li class="active"><a href="attendance.html" class="active"><#Attendance#></a></li>
<li><a href="discipline.html"><#Discipline#></a></li>
<li><a href="fees.html"><#Fees#></a></li>
<li><a href="repcard.html"><#Report Cards#></a></li>
<li><a href="timetable.html"><#Timetable#></a></li>
<li><a href="export.html"><#Export/Xfer#></a></li>
<li><a href="eoy.html"><#Start/End of Year#></a></li>
<li><a href="ssp.html"><#SSP#></a></li>
</ul>
<div style="height:24px;"></div>

<table border = "0" cellpadding="4" cellspacing="0">
<tr><td style="vertical-align:top;">

<!-- Left Column -->

<table cellpadding="4" cellspacing="0" border="0">
<tr><td><img src="images/logotn.gif" alt="logo"></td>
<td><hr><h1 style="padding:0; margin:0;"><#Attendance#></h1><hr></td></tr>
</table>

<h2><#Attendance#> <#Documentation#></h2>

<div style="margin:0.5em 0;">
  [ <a href="/userdoc/attendance.pdf" target="_blank">Attendance Documentation - New Tab</a> ]

</div>



<h2><#Edit#>/<#View#>/<#Check#> <#Attendance#></h2>

<div style="margin:0.5em 0;">
<form action="/cgi-bin/attendance/attdeled.pl" method="post" style="display:inline;">
<input type="submit" title="Edit attendance by date, date range or by student" value="<#Edit#>">
</form>

<form action="/cgi-bin/attendance/attview.pl" method="post" style="display:inline;">
  <input type="submit"
	 title="View attendance by date, date range, course/homeroom or by student" value="<#View#>">
</form>

<form action="/cgi-bin/attendance/attrsnreset.pl" method="post" style="display:inline;">
<input type="submit" title="Reset Absence reasons on a particular date" value="<#Reset Reason#>">
</form>

<form action="/cgi-bin/attendance/attpwrdel.pl" method="post" style="display:inline;">
  <input type="submit" title="Quickly delete attendance records by date" value="<#Power Delete#>">
</form>
</div>

<div style="margin:0.5em 0;">
<form action="/cgi-bin/attendance/attmovecourse.pl" method="post" style="display:inline;">
  <input type="submit" title="Move student attendance records from one course to another"
	 value="<#Move Course Records#>">
</form>

<form action="/cgi-bin/attendance/attcheck.pl" method="post">
  <input type="submit" title="<#Check for duplicates, empty reasons and dates#>"
	 value="<#Check Attendance Records#>"></form>

<form action="/cgi-bin/attendance/attenrolfix.pl" method="post">
  <input type="submit" title="<#Check for Attendance Absences outside of Enrollments#>"
	 value="<#Check Attendance #> Outside of Enrollment"></form>

<form action="/cgi-bin/configure/confedit.pl" method="post"  style="display:inline;">
  <input type="hidden" name="page" value="1">
  <input type="hidden" name="filename" value="admin">
  <input type="hidden" name="sectionname" value="attendance">
  <input type="submit" value="<#Configure Attendance#>">
</form>
<span style="color:red;font-weight:bold;">New!</span>

</div>


<h2><#Add Attendance#></h2>


<form action="/cgi-bin/attendance/attaddall.pl" method="post" style="display:inline;margin:0.5em;">
  <input type="submit"
	 title="Add Homeroom or Subject Attendance for a single day for teachers who are away"
	 value="<#Single Day#>"></form>

<div style="font-weight:bold;display:inline;">Week</div> 
<form action="/cgi-bin/attendance/attadd_multiday.pl" method="post" style="display:inline;">
<input type="submit" title="Add Homeroom Attendance for multiple days" value="<#Homeroom#>">
</form>

<form action="/cgi-bin/attendance/attAddCrsWeek.pl" method="post" style="display:inline;">
  <input type="submit"
	 title="Add Course/Subject Attendance for multiple days" value="<#Course/Subject#>">
</form>


<h2><#Check#> <#Teacher#> <#Attendance Entry#></h2> 

<div style="margin:0.5em 0;">
<form action="/cgi-bin/attendance/rptatttch2.pl" method="post" style="display:inline;">
  <input type="submit"
	 title="Report showing days that teachers have not entered their homeroom attendance"
	 value="<#Homeroom#> <#Absence Report#>"></form>

<form action="/cgi-bin/attendance/rptatttch3.pl" method="post" style="display:inline;">
  <input type="submit"
	 title="Report showing dates and periods teachers have not entered their course attendance"
	 value="<#Course#> <#Absence Report#>"></form>
</div>


<div style="margin:0.5em 0;">
<form action="/cgi-bin/attendance/chkattend.pl" method="post" style="display:inline;">
  <input type="submit" value="<#Current Check#>"
	 title="<#Ensure that teachers have entered their attendance for today.#>">
</form>
<form action="/cgi-bin/attendance/rptatttch.pl" method="post" style="display:inline;">
  <input type="submit"
	 title="Detailed report of dates and times that teachers have entered their attendance"
  value="<#Teacher#> <#Entry#> <#Report#>"></form>
</div>


<h2><#Check#> <#Student Attendance#></h2> 

<div style="margin:0.5em 0;">
<form action="/cgi-bin/attendance/rptattstuday.pl" method="post" style="display:inline;">
<input type="submit" title="A daily report that also includes attendance for the last 2 weeks 
  and also discipline values" value="<#Daily Attendance Report#>">
</form>

<form action="/cgi-bin/attendance/rptlate.pl" method="post" style="display:inline;">
  <input type="submit" title="A report of student lates to see if any problems are developing"
	 value="<#Late Report#>">
</form>
</div>

<div style="margin:0.5em 0;">
<b>Scan</b> 
<form action="/cgi-bin/attendance/attscanlite.pl" method="post" style="display:inline;">
  <input type="submit" title="A scan of student attendance to check for students exceeding a 
  certain maximum days missing value" value="<#Simple#>">
</form>

<form action="/cgi-bin/attendance/attscan.pl" method="post" style="display:inline;">
<input type="submit" title="A scan of student attendance to check for configured triggered values of lates 
  and absences, and leading to generated form letters for mailing to parents" value="<#Complex#>">
</form>

<form action="/cgi-bin/attendance/attscan2.pl" method="post" style="display:inline;">
<input type="submit" title="A scan of student attendance based on %attendance values" value="<#Scan#> 2">
</form>
</div>



</td><td style="vertical-align:top;">
<!-- ********* RIGHT COLUMN ********** -->

<h2><#Course Attendance#></h2>


<form action="/cgi-bin/attendance/rptattstudsubj.pl" method="post" style="display:inline;">
<input type="submit" title="Student course attendance selected by terms" value="<#Student#>"></form>

<form action="/cgi-bin/attendance/rptattsubj.pl" method="post" style="display:inline;">
<input type="submit" title="Course attendance overall selected by terms" value="<#Course#>">
</form>


<h2><#Monthly Attendance Reports#> &#9405;</h2>

<form action="/cgi-bin/attendance/rptattmonth.pl" method="post" style="display:inline;">
  <input type="submit" title="Monthly attendance report (PDF possible) 1 "
	 value="<#Report#> 1">
</form>

<form action="/cgi-bin/attendance/rptinac.pl" method="post" style="display:inline;">
  <input type="submit"
	 title="PDF All Year Report showing attendance; one student by line"
	 value="<#Report#> 2">
</form>

<form action="/cgi-bin/attendance/rptinac2.pl" method="post" style="display:inline;">
  <input type="submit"
	 title="HTML report with summative data by grade for the current year by month"
	 value="<#Report#> 3">
</form>

<form action="/cgi-bin/attendance/rptmonth4.pl" method="post" style="display:inline;">
  <input type="submit"
	 title="Monthly Report - detailed homeroom/course report that includes missing 
		attendance entries"
	 value="<#Report 4#>">
</form>

<div style="margin:0.5em 0;">
<form action="/cgi-bin/attendance/rptAttHomeroom.pl" method="post"
      style="display:inline;line-height:120%;">
  <input type="submit"
	 title="Monthly Homeroom Report - summary attendance values for each homeroom for each month"
	 value="<#Homeroom#>">

</form>

<form action="/cgi-bin/attendance/rptPresent.pl" method="post" style="display:inline;">
  <input type="submit"
	 title="Daily Report of the students present during a Month for each homeroom"
	 value="<#Present#>">
</form>
</div>


<h2><#Attendance Reports#> &#9405;</h2>

<div style="margin:0.5em 0;">
<form action="/cgi-bin/attendance/rptattdaily.pl" method="post" style="display:inline;">
  <input type="submit"
	 title="A summative report with enrollment, absences, and percents for a date range"
	 value="<#Daily Report#>"></form>

<form action="/cgi-bin/attendance/rptattphone.pl" method="post" style="display:inline;">
<input type="submit" title="Find Phone Numbers for Students Absent on a particular day"
       value="<#Phone Report#>">
</form>


<form action="/cgi-bin/attendance/rptattstud1.pl" method="post" style="display:inline;">
  <input type="submit" title="An HTML report summarizing yearly attendance in a single table 
  for each selected student." value="<#Yearly Student Report#>">
</form>
</div>


<div style="margin:0.5em 0;">
<form action="/cgi-bin/attendance/rptattprof.pl" method="post" style="display:inline;">
  <input type="submit" title="A PDF report with complete attendance and enrollment data for a child"
	 value="<#Student Profiles#>">
</form>

<form action="/cgi-bin/attendance/rptcohort.pl" method="post" style="display:inline;">
  <input type="submit" title="A summative report with enrollment changes and retention rate"
	 value="<#Cohort Report#>"></form>

<form action="/cgi-bin/attendance/rptAttPerf.pl" method="post" style="display:inline;">
  <input type="submit"
	 title="A report showing students with perfect attendance based on skipped attendance reasons and selected by a start and end date"
	 value="<#Perfect Attendance#>">
</form>
</div>

<div style="margin:0.5em 0;">
<form action="/cgi-bin/attendance/rptattyear.pl" method="post" style="display:inline;">
<input type="submit" title="A year end PDF report including all enrollment/attendance records for each child, 
  similar to attendance profiles report" value="<#Year End Attendance#>"></form>

<form style="display:inline;" action="/cgi-bin/attendance/rptattyear2.pl"  method="post">
<input type="submit" title="A report showing missing attendance entries for the year the same as 
  the Homeroom Absence Report" value="Year End 2 (Homeroom)"></form>

<form style="display:inline;" action="/cgi-bin/attendance/rptattyear3.pl"  method="post">
  <input type="submit" title="A year end PDF course report showing monthly summary attendance values"
	 value="Year End 3 (Course)"></form>
</div>


<div style="margin:0.5em 0;">
<form action="/cgi-bin/attendance/attethview.pl" method="post" style="display:inline;">
<input type="submit" title="A summary report showing ethnic attendance values using a date range 
  and days open values" value="<#Ethnic#> <#Attendance Report#>">
</form>

<form action="/cgi-bin/attendance/sdsexport.pl" method="post" style="display:inline;">
<input type="submit" title="A compressed zip file containing monthly attendance in csv format 
  for Following Your Voices program" value="<#Following Your Voices#> SDS <#Attendance Export#>">
</form>
</div>


<div style="margin:0.5em 0;">
<form action="/cgi-bin/attendance/rptCreditsEarned.pl" method="post" style="display:inline;">
  <input type="submit" title="A summary report showing student credit attainments grouped by their attendance"
	 value="Attendance/Credits Earned Report">
</form>
</div>

<hr style="width:60ch;">

<div style="margin:0.5em 0;">
<form action="/cgi-bin/attendance/rptAttStat2.pl" method="post" style="display:inline;">
  <input type="submit" title="A statistical attendance report for all grades including gender attendance, attendance by division, by percentage as well as raw results."
	 value="Statistical Attendance Report - Current">
</form>

<form action="/cgi-bin/attendance/rptAttStat3.pl" method="post" style="display:inline;">
  <input type="submit" title="A statistical attendance report for previous years including all grades including gender attendance, attendance by division, by percentage as well as raw results."
	 value="Statistical Attendance Report - Previous">
</form>
</div>

<!--<span style="font-weight:bold;color:red;">New!</span> -->

</td></tr></table>

</body></html>
