<!DOCTYPE html>
<!--
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.
-->
<html><head>
<title>Open Administration 18 - <#School Administration#></title>
<link rel="stylesheet" href="admin.css" type="text/css">
<style type="text/css">
 form, input, button, select { padding:1px;margin:1px;font-size:100%; }
</style>

<script src="//ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
  $(function() {
    $('div.heading').click(function(){
      $(this).closest('div.section').find('div.body').toggle('normal');
    });
  });
</script>

<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
</head><body>
<!--#config timefmt="%A %B %e, %Y" -->

<ul class="nav" style="border-top:1px solid gray; margin: 0.5em;
 position: fixed; top:0; bottom:auto;">
<li class="active"><a href="index.shtml" class="active"><#Main#></a></li>
<li><a href="attendance.html"><#Attendance#></a></li>
<li><a href="discipline.html"><#Discipline#></a></li>
<li><a href="fees.html"><#Fees#></a></li>
<li><a href="repcard.html"><#Report Cards#></a></li>
<li><a href="timetable.html"><#Timetable#></a></li>
<li><a href="export.html"><#Export/Xfer#></a></li>
<li><a href="eoy.html"><#Start/End of Year#></a></li>
<li><a href="ssp.html"><#SSP#></a></li>
</ul>
<div style="height:24px;"></div>

<table cellpadding="4" cellspacing="0" border="0">
<tr><td style="padding:0;margin:0;vertical-align:top;;">
<!--   **** Left Column **** -->


<table cellpadding="0" cellspacing="0" border="0" align="center">
<tr><th style="padding:0.3em;"><!--#echo var="DATE_LOCAL"--></th></tr>
<tr><td class="cn"><img src="images/logo.gif" alt=" "></td></tr>
<tr><th style="padding:0.3em;">Open Administration for Schools 18</th></tr>
</table>

<div style="font-weight:bold;font-size:130%;margin:1em;background-color:#EEE;border:1px solid black;padding:1em;">
  [ <a href="/userdoc/newyearmaster.pdf" target="_blank">Starting the New Year - What To Do</a> ]
</div>


<!--
<div style="font-weight:bold;font-size:120%;margin:1em;background-color:#EEE;border:1px solid black;padding:1em;width:40ch;">
  <span style="color:red;">Do NO updates/changes in preparation for
  the next school year.</span>  I will do a copy of all data to our
  backup server in mid-July so that you can look up what happened in
  the 2023-2024 school year. If you do updates now, this information
  will be lost. <span style="color:red;">Please wait until August</span>.
</div>
-->

<div class="section">
<div class="heading" title="Click to Show/Hide"><#Edit#> / <#View#> / <#Search#> <#Students#>
<span style="float:right;">
<img src="images/rollup.gif" alt="rollup" title="Click to Show/Hide"></span></div>
<div class="body" style="display:block;">

<form action="/cgi-bin/studeled.pl" method="post" style="display:inline;">
<input type="submit" value="<#Edit#>"></form>

<form action="/cgi-bin/editFamily.pl" method="post" style="display:inline;">
  <input type="submit" value="<#Edit Family#>"></form>

<form action="/cgi-bin/studview.pl" method="post" style="display:inline;">
<input type="submit" value="<#View#>">
</form>

<form action="/cgi-bin/rptcumefile.pl" method="post" style="display:inline;">
<input type="submit" value="<#Cume#>">
</form>
<br>

<form action="/cgi-bin/studsearch.pl" method="post" style="display:inline;">
<input type="text" name="student" style="width:40ch;">
<input type="submit" value="<#Search#>">
<span style="font-weight:bold;"><#Last,First/Last/First/Initials/Studnum#></span>
</form>

</div></div>



<div class="section">
<div class="heading" title="Click to Show/Hide"><#Student Reports#>
<span style="float:right;">
<img src="images/rollup.gif" alt="rollup" title="Click to Show/Hide"></span></div>
<div class="body" style="display:block;">


<form action="/cgi-bin/rptemail.pl" method="post" style="display:inline;"
      title="A Report generated from your local email program to send to parents/students.
	       You can select by grade/homeroom and then student/parent1/2. The emails are 
	       placed Bcc (Blind Carbon Copy) section of the email.">
<input type="submit" value="<#Email#>">
<span style="color:red;font-weight:bold;">New!</span>
</form>
All reports are hoverable. <span style="font-weight:bold;font-size:150%;">&#9405;</span>
<br>

<form action="/cgi-bin/rptbirthday.pl" method="post" style="display:inline;"
      title="A Report by grade or homeroom sorted by date in the school year">
<input type="submit" value="<#Birthdays#>">
</form>

<form action="/cgi-bin/rpthouseleague.pl" method="post" style="display:inline;"
      title="A report listing students in each intramural house, if the house field
	    is populated in the student records.">
<input type="submit" value="<#House Leagues#> <#PDF#>"></form>

<form action="/cgi-bin/rptfamily.pl" method="post" style="display:inline;"
      title="A report of students by 'Family' where a family is grouped together by having
	     the same phone number or another field (ie. extra Field 8). This field
	     can be selected in the report.">
<input type="submit" value="<#Families#>"></form>

<form action="/cgi-bin/rptbillet.pl" method="post" style="display:inline;"
      title="A billet is a home location where a student may stay in the event of inclement
	     weather that stops the buses from taking students home">
<input type="submit" value="<#Billet#>"></form>

<form action="/cgi-bin/rptphone.pl" method="post" style="display:inline;"
      title="Lists phone numbers of parents/emergency by grade or homeroom">
<input type="submit" value="<#Phone#>"></form>
<br>


<form action="/cgi-bin/rptbusroute.pl" method="post" style="display:inline;"
      title="PDF report of students name,grade, address, parents grouped by bus route. 
	     Sorted by name or family within bus route">
<input type="submit" value="<#Bus Route#>"></form>

<form action="/cgi-bin/rptbusroute1.pl" method="post" style="display:inline;"
      title="Family Bus report - Monday/Friday PDF format - for attendance/temperature 
	     checking - grouped by Bus Route">
<input type="submit" value="<#Bus Route#> 1"></form>

<form action="/cgi-bin/rptbusroute2.pl" method="post" style="display:inline;"
      title="Family Bus report 2 - PDF format - family name, student name, 
	     bus route and house # -  sorted by family name, student">
  <input type="submit" value="<#Bus Route#> 2 <#Alphabetized#>"></form>
<!--  <span style="font-weight:bold;font-size:150%;">&#9405;</span>-->
<br>


<form action="/cgi-bin/rptreserve.pl" method="post" style="display:inline;"
      title="Lists reserve of student and whether they are resident on that reserve">
<input type="submit" value="<#Reserve#>">
</form>

<form action="/cgi-bin/rpttrack.pl" method="post" style="display:inline;"
      title="A report to group students into age groups in preparation for the annual track day">
<input type="submit" value="<#Track#>"></form>

<form action="/cgi-bin/rptyoungest.pl" method="post" style="display:inline;"
      title="Report to show the youngest in a family, so that newsletters can be distributed,
	     one to each family. Teachers typically tuck the newsletter into the student
	     backpack as they leave the school!">
<input type="submit" value="<#Youngest#>"></form>


<form action="/cgi-bin/iep/specedview.pl" method="post" style="display:inline;"
      title="Report to view Special Ed Report of students">
<input type="submit" value="<#Spec Ed IEP#>"></form>

</div></div>
<!-- End of Student Reports Section -->


<div class="section">
<div class="heading" title="Click to Show/Hide"><#Medical System#>
<span style="float:right;">
<img src="images/rollup.gif" alt="rollup" title="Click to Show/Hide"></span></div>
<div class="body" style="display:none;">

<form action="/cgi-bin/medical/medadd.pl" method="post" style="display:inline;">
<input type="submit" value="<#Add#>"></form>

<form action="/cgi-bin/medical/meddeled.pl" method="post" style="display:inline;">
<input type="submit" value="<#Edit#>/<#Delete#>"></form>

<form action="/cgi-bin/medical/rptmedtemplate.pl" method="post" style="display:inline;">
<input type="submit" value="<#Template#> <#Report#>"></form>
<br>

<form action="/cgi-bin/medical/rptmedstudent.pl" method="post" style="display:inline;">
<input type="submit" value="<#Student#> <#Report#>"></form>

<form action="/cgi-bin/medical/rptmedcategory.pl" method="post" style="display:inline;">
<input type="submit" value="<#Category#> <#Report#>"></form>

<!--
<form action="/cgi-bin/medical/medcopy.pl" method="post" style="display:inline;">
<input type="submit" value="Copy Old Med Field"></form>
-->
</div></div><!-- End of Section Divs -->


<div class="section">
<div class="heading" title="Click to Show/Hide"><#Announcements#>
<span style="float:right;">
<img src="images/rollup.gif" alt="rollup" title="Click to Show/Hide"></span></div>
<div class="body" style="display:block;">

<form action="/cgi-bin/announce/announceadd.pl" method="post" style="display:inline;">
<input type="submit" value="<#Add#>"></form>

<form action="/cgi-bin/announce/announcedeled.pl" method="post" style="display:inline;">
<input type="submit" value="<#Edit#>"></form>

<form action="/cgi-bin/announce/announcedelete.pl" method="post" style="display:inline;">
<input type="submit" value="<#Delete#>"></form>

<form action="/cgi-bin/announce/announceview.pl" method="post" style="display:inline;">
<input type="submit" value="<#View#>"></form>
<div>Please delete old announcements!</div>
</div></div>

<iframe src="/cgi-bin/announce/announceview.pl?mode=main" 
 width="350" height="300" style="margin:0;padding:0;" 
 frameborder="0" marginheight="3" marginwidth="8"></iframe>



<!--   **** Right Column ****  -->
</td><td style="margin:0;padding:0 1em;vertical-align:top;">

<h2 style="margin-bottom:0;"><#Status#></h2>

<iframe src="cgi-bin/showstatus.pl" 
 width="480" height="140" style="margin:0;padding:0;" 
 frameborder="0" marginheight="3" marginwidth="8"></iframe>


<div class="section">
<div class="heading" title="Click to Show/Hide"><#Student Rosters#>
<span style="float:right;">
<img src="images/rollup.gif" alt="rollup" title="Click to Show/Hide"></span></div>
<div class="body" style="display:block;">

<form action="/cgi-bin/rptstudrost.pl" method="post" style="display:inline;">
 <input type="submit" value="<#Student Roster#>"></form>

<form action="/cgi-bin/templatecreator.pl" method="post" style="display:inline;"
 title="Create Templates for the Student Rosters report engine">
 <input type="submit" value="<#Templates#>"></form>

<form action="/cgi-bin/rptdemoconf.pl" method="post" style="display:inline;">
<input type="submit" value="<#Confirm Data#>"></form>

<form action="/cgi-bin/labels.pl" method="post" style="display:inline;">
<input type="submit" value="<#Print Labels#>">
</form>
<br>

<form action="/cgi-bin/rptcustomclasslist.pl" method="post" style="display:inline;">
<input type="submit" value="<#Classlist#>"></form>

<form action="/cgi-bin/rptcustomcourselist.pl" method="post" style="display:inline;">
<input type="submit" value="<#Courselist#>"></form>

<form action="/cgi-bin/rptcustomstafflist.pl" method="post" style="display:inline;">
<input type="submit" value="<#Stafflist#>">
</form>

</div></div>



<div class="section">
<div class="heading" title="Click to Show/Hide"><#Student Enrollment/Withdrawal#>
<span style="float:right;">
<img src="images/rollup.gif" alt="rollup" title="Click to Show/Hide"></span></div>
<div class="body" style="display:block;">
<span style="font-weight:bold;font-size:150%;">&#9405;</span>
  <form action="/cgi-bin/entry/enrol.pl" method="post" style="display:inline;"
	title="Enrol a student in the school. If re-enrolling a student, use their local student number 
	       in the lastname field.">
<input type="submit" value="<#Enrol#>"></form>

<form action="/cgi-bin/entry/withdraw.pl" method="post" style="display:inline;"
      title="Withdraw student from the school. Their demographic record moved to withdrawn student table">
<input type="submit" value="<#Withdraw#>">
</form>

<!-- <form action="/cgi-bin/entry/remove.pl" method="post" style="display:inline;" 
title="Remove enrollments entered by mistake">
<input type="submit" value="<#Remove#>">
</form>
-->

<form action="/cgi-bin/sasked/getStudentEnrollmentHistory.pl" method="post" style="display:inline;" 
      title="get Student School Enrollment records from Sask Ed (SDS System)">
<input type="submit" value="<#Sask Ed Enrollment History#>">
</form>
<br>

<form action="/cgi-bin/entry/transview.pl" method="post" style="display:inline;"
      title="View / Edit school enrollment records (withdraw/enrol)">
<input type="submit" value="<#View/Edit Transfers#>">
</form>

<!--
<form action="/cgi-bin/entry/waitview.pl" method="post" style="display:inline;">
<input type="submit" value="<#View/Edit Waiting List#>">
</form>

<form action="/cgi-bin/studview.pl" method="post" style="display:inline;">
<input type="hidden" name="table" value="wd">
<input type="submit" value="<#Withdrawn Students - Local#>"></form>
-->

<form action="/cgi-bin/entry/globview.pl" method="post" style="display:inline;"
      title="View withdrawn students in all/selected schools in our organizational group">
<input type="submit" value="<#Withdrawn Students#>"></form>
</div></div>



<div class="section">
<div class="heading" title="Click to Show/Hide"><#Enrollment Reports#>
<span style="float:right;">
<img src="images/rollup.gif" alt="rollup" title="Click to Show/Hide"></span></div>
<div class="body" style="display:block;">

<form action="/cgi-bin/rptenrolhroom.pl" method="post" style="display:inline;">
<input type="submit" value="<#Homeroom#>"></form>

<form action="/cgi-bin/rptenrolage.pl" method="post" style="display:inline;">
<input type="submit" value="<#Age#>"></form>

<form action="/cgi-bin/rptenroldate.pl" method="post" style="display:inline;">
  <input type="submit" value="<#Date#>"></form>
<span style="color:red;font-weight:bold;">New!</span>

<form action="/cgi-bin/rptethnic.pl" method="post" style="display:inline;">
<input type="submit" value="<#Ethnic#>"></form>
<br>

<form action="/cgi-bin/rpttransmon.pl" method="post" style="display:inline;">
<input type="submit" value="<#Monthly Transfers#>">
</form>

<form action="/cgi-bin/rptenrolmon.pl" method="post" style="display:inline;">
<input type="submit" value="<#Monthly Enrollment Change#>">
</form>
<br>
<form action="/cgi-bin/rptenrol1.pl" method="post" style="display:inline;">
  <input type="submit" title="Summary Enrollment Report for Onion Lake Schools, includes attendance"
	 value="<#Enrollment#> <#Report#> 1">
</form>

<form action="/cgi-bin/rptenrol2.pl" method="post" style="display:inline;">
  <input type="submit" title="Enrollment Report 2 - Homeroom"
	 value="<#Enrollment#> <#Report#> 2">
</form>
<!-- <span style="color:red;font-weight:bold;">New!</span> -->


</div></div>



<div class="section">
<div class="heading" title="Click to Show/Hide"><#Principal Walkthrough#> / <#Contact Log#>
<span style="float:right;">
<img src="images/rollup.gif" alt="rollup" title="Click to Show/Hide"></span></div>
<div class="body" style="display:block;">

<form action="/cgi-bin/pwalk/pwalkeval.pl" method="post" style="display:inline;">
<input type="submit" value="<#Add#>"></form>

<form action="/cgi-bin/pwalk/pwalkevalview.pl" method="post" style="display:inline;">
<input type="submit" value="<#View#>"></form>

<form action="/cgi-bin/pwalk/pwalkrpt1.pl" method="post" style="display:inline;">
<input type="submit" value="<#Report 1#>"></form>

<form action="/cgi-bin/rptContactLog.pl" method="post" style="display:inline;">
<input type="submit" value="<#Contact Log#>"></form>
<br>

<form action="/cgi-bin/rptWorkSchool.pl" method="post" style="display:inline;">
<input type="submit" value="<#Contract Report#>"></form>

<form action="/cgi-bin/dbook/dbkViewTimetable.pl" method="post" style="display:inline;">
<input type="submit" value="<#Daybook Timetables#>"></form>

<form action="/cgi-bin/dbook/dbkViewPlanning.pl" method="post" style="display:inline;">
<input type="submit" value="<#Daybook Planning#>"></form>


</div></div>


<div class="section">
<div class="heading" title="Click to Show/Hide"><#School Events#>
<span style="float:right;">
<img src="images/rollup.gif" alt="rollup" title="Click to Show/Hide"></span></div>
<div class="body" style="display:block;">

<form action="/cgi-bin/schoolevent/event_add.pl" method="post" style="display:inline;">
<input type="submit" value="<#Add#>/<#Edit#>"></form>

<form action="/cgi-bin/schoolevent/rptmonthevent.pl" method="post" style="display:inline;">
<input type="submit" value="<#Monthly Report#>"></form>

</div></div>


<div class="section">
<div class="heading" title="Click to Show/Hide"><#Staff Absence Tracking#>
<span style="float:right;">
<img src="images/rollup.gif" alt="rollup" title="Click to Show/Hide"></span></div>
<div class="body" style="display:block;">

Add  
<form action="/cgi-bin/staff/staffabsadd.pl" method="post" style="display:inline;">
<input type="submit" value="<#Daily#>"></form>

<form action="/cgi-bin/staff/staffAbsWeekly.pl" method="post" style="display:inline;">
<input type="submit" value="<#Weekly#>"></form>


<form action="/cgi-bin/staff/staffabsview.pl" method="post" style="display:inline;">
<input type="submit" value="<#View#>"></form>

<form action="/cgi-bin/staff/staffabsRpt1.pl" method="post" style="display:inline;"
      title="PDF Report for Individual Staff Absences">
  <input type="submit" value="<#Report#> 1"></form>

<form action="/cgi-bin/staff/staffabsRpt2.pl" method="post" style="display:inline;"
      title="A Quick Summary report in html table form showing days absent for all reasons">
  <input type="submit" value="<#Report#> 2">
</form>


</div></div>


<div class="section">
<div class="heading" title="Click to Show/Hide"><#Staff Leave/Pay#>
<span style="float:right;">
<img src="images/rollup.gif" alt="rollup" title="Click to Show/Hide"></span></div>
<div class="body" style="display:block;">

<form action="/cgi-bin/staffpay/addTransaction.pl" method="post" style="display:inline;">
<input type="submit" value="<#Add#>/<#Edit#> <#Transactions#>"></form>

<form action="/cgi-bin/staffpay/viewStaffPayTch.pl" method="post" style="display:inline;">
  <input type="submit" value="<#View#> <#Staff#> <#Hours#>"></form>
<br>

<form action="/cgi-bin/staffpay/rptStaffPay.pl" method="post" style="display:inline;">
  <input type="submit" value="Hourly Worksheet Report"></form>

<form action="/cgi-bin/staffpay/rptStaffPaySummary.pl" method="post" style="display:inline;">
  <input type="submit" value="Summary Report"></form>

<br>
<form action="/cgi-bin/staffpay/updateStaffLeave.pl" method="post" style="display:inline;">
<input type="submit" value="<#Update#> Staff Leave"></form>

<form action="/cgi-bin/staffpay/addStaffLeave.pl" method="post" style="display:inline;">
  <input type="submit" value="<#Set#> Staff Leave"></form>

<form action="/cgi-bin/configure/confedit.pl" method="post"  style="display:inline;">
  <input type="hidden" name="page" value="1">
  <input type="hidden" name="filename" value="admin">
  <input type="hidden" name="sectionname" value="staffpay">
  <input type="submit" value="<#Configure#>">
</form>
</div></div>



<div class="section">
<div class="heading" title="Click to Show/Hide"><#First Nations Nominal Roll#>
<span style="float:right;">
<img src="images/rollup.gif" alt="rollup" title="Click to Show/Hide"></span></div>
<div class="body" style="display:block;">

<#Records#>
<form action="/cgi-bin/nomroll/nrsync.pl" method="post" style="display:inline;">
<input type="submit" value="<#Sync#>"></form>

<form action="/cgi-bin/nomroll/nrdeled.pl" method="post" style="display:inline;">
<input type="submit" value="<#Edit#>"></form>

<form action="/cgi-bin/nomroll/nradd.pl" method="post" style="display:inline;">
<input type="submit" value="<#Add#>"></form>

<form action="/cgi-bin/nomroll/resetnomroll.pl" method="post" style="display:inline;">
<input type="submit" value="<#Reset#>"></form>

<form action="/cgi-bin/nomroll/confnomroll.pl" method="post" style="display:inline;">
<input type="submit" value="<#Configure#>"></form>
<br>
<#Reports#>
<form action="/cgi-bin/nomroll/nrview1.pl" method="post" style="display:inline;">
<input type="submit" value="<#View 1#>"></form>

<form action="/cgi-bin/nomroll/nrview2.pl" method="post" style="display:inline;">
<input type="submit" value="<#View 2#>"></form>

<form action="/cgi-bin/nomroll/rptnomrollconf.pl" method="post" style="display:inline;">
<input type="submit" value="<#Student Report#>"></form>

<form action="/cgi-bin/nomroll/nomroll.pl" method="post" style="display:inline;">
<input type="submit" value="<#Create File#>"></form>

</div></div><!-- End of Section Divs -->


<div class="section">
<div class="heading" title="Click to Show/Hide"><#Help#>
<span style="float:right;">
<img src="images/rollup.gif" alt="rollup" title="Click to Show/Hide"></span></div>
<div class="body" style="display:none;">

  <ul>
<li><a href="/userdoc/newyearmaster.pdf" target="_blank">What to do when Starting the New Year</a></li>
<li><a href="http://www.openadmin.ca/docs/" target="_blank"><#Documentation Page#></a></li>
<li><a href="http://www.openadmin.ca/docs/userdoc" target="_blank"><#User Documentation#></a></li>
<li><a href="http://www.openadmin.ca/docs/admindoc" target="_blank"><#Administrator Documentation#></a></li>
</ul>
</div></div>



<div class="section">
<div class="heading" title="Click to Show/Hide"><#External User Management#>
<span style="float:right;">
<img src="images/rollup.gif" alt="rollup" title="Click to Show/Hide"></span></div>
<div class="body" style="display:none;">

<div style="padding:0.3em 0.5em;">
<#Workstation/Terminal Users#>:
<form action="/cgi-bin/usermanage/addexternal.pl" method="post" 
style="display:inline;"><input type="submit" value="<#Add#>"></form>

<form action="/cgi-bin/usermanage/resetexternal.pl" method="post" 
style="display:inline;"><input type="submit" value="<#Reset#>"></form>
</div>

<div style="padding:0.3em 0.5em;">
Google Apps <#Users#>: 
<form action="/cgi-bin/usermanage/googleview.pl" method="post" style="display:inline;">
<input type="submit" value="<#View#>"></form>

<form action="/cgi-bin/usermanage/googleupdate.pl" method="post" style="display:inline;">
<input type="submit" value="<#Update#>"></form><br>
</div>

<div style="padding:0.3em 0.5em;">
<#LDAP Users#>: 
<form action="/cgi-bin/ldap/syncstudent.pl" method="post" style="display:inline;">
<input type="submit" value="<#Student Sync#>"></form>

<form action="/cgi-bin/ldap/syncstaff.pl" method="post" style="display:inline;">
<input type="submit" value="<#Staff Sync#>"></form>

<form action="/cgi-bin/ldap/resetldap.pl" method="post" style="display:inline;">
<input type="submit" value="<#Reset#>"></form>

<form action="/cgi-bin/ldap/ldapmanage.pl" method="post" style="display:inline;">
<input type="submit" value="<#Field Fill#>"></form>
</div>

</div></div><!-- End of Section Divs -->


</td></tr></table>
</body></html>
