#! /usr/bin/perl
#  Copyright Les Richardson 2007
#  This file is part of Open Admin for Schools

# Outline: Read in a template file, strip tags <# *> and write to a new file.
# 

my ($taggedfile) = @ARGV;
if (not $taggedfile) {
    print "Usage: extracttags.pl taggedfile\n";
    exit 1;
}

# Slurp in tagged file.
unless (open (FH,"<$taggedfile")) {
    print 'Unable to open tagged file:',"$!\n";
    die 'Unable to open tagged file:',"$!\n";
}
my $text;
{ local $/; $text = <FH>; close FH;}

$text =~ s/\<\#//g;
$text =~ s/\#\>//g;

$taggedfile =~ s/^.*\///;
$taggedfile =~ s/\.tpl$//;
my $shortname = $taggedfile;

$counter = 1;
if (-e $taggedfile) { 
    $taggedfile .= $counter; 
    $counter++; 
}

open(F,">",$taggedfile);
print F $text;
close F;

print "Done! Created $shortname\n";
