#!/usr/bin/perl
#  Copyright 2001-2021 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Eoy' => 'Eoy',
	   'Configuration' => 'Configuration',
	   'Error' => 'Error',
	   'Edit' => 'Edit',
	   'View' => 'View',
	   'Name' => 'Name',
	   'Value' => 'Value',
	   'Description' => 'Description',
	   'File' => 'File',
	   'Record' => 'Record',
	   'Update' => 'Update',
	   'Updated' => 'Updated',
	   'Key' => 'Key',
	   'New' => 'New',
	   'Yes' => 'Yes',
	   'No' => 'No',
	   'Main' => 'Main',
	   'Start' => 'Start',
	   'Section' => 'Section',
	   'Files' => 'Files',
	   'Not Found' => 'Not Found',
	   'Path' => 'Path',
	   'Area' => 'Area',
	   
	   'Discipline' => 'Discipline',

	   );




my $self = 'confedit.pl';
my $g_EtcPath = '../../school/etc';

my @types = qw( scalar scalaronoff hash hashofarray array); # data types
my $maxarrayidx = 20; # 8 array entries 0..7
my $scalar_min_length = 30; # smallest size for scalar input.
my $scalar_text_rows = 10;
my $scalar_text_cols = 65;

my %filenames = ( 'Main' => 'admin',
		  'First Nation' => 'first_nation',
		  'Report Card' => 'repcard',
		  'Grade Book' => 'gbook',
		  'Pictures' => 'image',
		  'Timetable' => 'schedule',
		  'Fees' => 'fees',
		  'LDAP' => 'ldap',
		  'User Management' => 'usermanage',
		  'Transcript' => 'transcript',
    );
		  

my @filenames = ('Main', 'Report Card', 'First Nation',
		 'Grade Book', 'Pictures', 'Timetable',
		 'Fees', 'LDAP', 'Transcript', 'User Management');


use DBI;
use CGI;

eval require "./admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = CGI->new;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);
$dbh->{mysql_enable_utf8} = 1;


# Page Header
print qq{$doctype\n<html><head><title>$lex{Edit} $lex{Configuration}</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body style="margin:1em;">\n};

print qq{[ <a href="$self">$lex{Start}</a> ]\n};

print qq{<h1>$lex{Edit} $lex{Configuration}</h1>\n};


# if called only to update files from conf_system table;
if ( $arr{fileupdate} or $ARGV[0] eq 'fileupdate') {
    updateFiles();
}


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    showValues();

} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    editValues();

} elsif ( $arr{page} == 3 ) {
    delete $arr{page};
    writeValues();

} elsif ( $arr{page} == 4 ) {
    delete $arr{page};
    updateFiles();
}



#----------------
sub showStartPage {
#----------------

    # Select Main Filename Sections to Display
    print qq{<table cellpadding="6" cellspacing="0" border="1" style="margin:1em;">\n};

    foreach my $fileview ( @filenames ) {
	my $filename = $filenames{$fileview};
	print qq{<tr><td><form action="$self"  method="post">\n};
	print qq{<input type="hidden" name="filename" value="$filename">\n};
	print qq{<input type="hidden" name="page" value="1">\n};
	print qq{<input type="submit" value="$fileview"></form></td></tr>\n};

    }

    # Update Files
    print qq{<tr><td><form action="$self"  method="post">\n};
    print qq{<input type="hidden" name="page" value="4">\n};
    print qq{<input type="submit" value="$lex{Update} $lex{Files}"></form></td></tr>\n};


    print qq{</table></div></body></html>\n};

    exit;
}



#-------------
sub showValues {
#-------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # Normally, only passed filename.

    my $sth;
    if ( $arr{sectionname} ) {
	$sth = $dbh->prepare("select id, dataname, datavalue, description, sectionname 
          from conf_system where filename = ? and sectionname = ? order by sequenceval, dataname");
	$sth->execute( $arr{filename}, $arr{sectionname} );
    } else {
	$sth = $dbh->prepare("select id, dataname, datavalue, description, sectionname 
          from conf_system where filename = ? order by sectionname, sequenceval, dataname");
	$sth->execute( $arr{filename} );
    }
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    
    my %views = reverse %filenames;

    my $fileview = $views{ $arr{filename} };
    print qq{<h3 style="font-size:120%;font-weight:bold;margin:0.5em 1em;">};
    print qq{$lex{Configuration} $lex{Area}: $fileview</h3>\n};

    # Print Table Heading.
    print qq{<table cellpadding="3" cellspacing="0" border="1" style="margin:0 1em;">\n};

    my ($prevsection, $currsection);
    my $first = 1;

    while ( my ( $id, $dataname,$datavalue, $description, $sectionname ) = $sth->fetchrow ) {

	# Skip date values, since set by confyear.pl script.	
	if ( $arr{filename} eq 'admin' and $sectionname eq 'schoolyear' ) { next; } #skip

	$prevsection = $currsection;
	$currsection = $sectionname;

	if ( $currsection ne $prevsection ) {
	    print qq{<tr><th></th><th>$lex{Name}</th><th>$lex{Section}</th>};
	    print qq{<th>$lex{Description}</th><th>$lex{Value}</th></tr>\n};
	}


	$dataname =~ s/^r\_//; # strip r_
	my ( $dud, $val ) = split("= ", $datavalue);
	$val =~ s/\</&lt;/g;
	$val =~ s/\>/&gt;/g;

	print qq{<tr><td><form action="$self"  method="post">\n};
	print qq{<input type="hidden" name="id" value="$id">\n};
	print qq{<input type="hidden" name="page" value="2">\n};
	print qq{<input type="submit" value="$lex{Edit}"></form></td>\n};

	print qq{<td>$dataname</td><td>$sectionname</td><td>$description</td><td>$val</td></tr>\n};
	
    }

    print qq{</table></body></html>\n};

    exit;

}  # end of showValues



#-------------
sub editValues { # edit record whose is id passed
#-------------

    #foreach my $key ( sort keys %arr) { print "K:$key V:$arr{$key}<br>\n"; }
    # just id is passed.
    
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="3">\n};
    print qq{<input type="hidden" name="id" value="$arr{id}">\n};

    # Get the Record
    my $sth = $dbh->prepare("select * from conf_system where id = ?");
    $sth->execute( $arr{id} );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref;
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    my %rec = %$ref;

    
    # Convert any double quotes to an entity.
    $rec{datavalue} =~ s/"/&#34;/g;

    my $type = $ref->{datatype};
    my $hashvar = $ref->{hashvar};
    my $sectionname = $ref->{sectionname};

    eval $rec{datavalue};
    if ( $@ ) {
	print $lex{Error}. " $@<br>\n";
	die $lex{Error}. " $@\n";
    }


    print qq{<table cellpadding="3" cellspacing="0" border="0" width="600">\n};


    print qq{<tr><td></td><td style="text-align:left;">\n};
    print qq{<input type="submit" value="$lex{Update} $lex{Record}"></td></tr>\n};

    print qq{<tr><td class="ra">$lex{Update} $lex{File}</td>\n};
    print qq{<td><input type="checkbox" name="updatefile" value="$rec{filename}" };
    print qq{checked="checked"></td></tr>\n};

    # File Name
    print qq{<tr><td class="ra">$lex{File}</td><td>$rec{filename}</td></tr>\n};

    # Description
    print qq{<tr><td class="ra">$lex{Description}</td>\n<td>};
    print qq{$rec{description}</td></tr>\n};

    # Data Name
    my $dataname = $rec{dataname};
    $dataname =~ s/^r\_//; # strip leading r_
    print qq{<tr><td class="ra">$lex{Name}</td>\n<td>};
    print qq{$dataname</td></tr>\n};


    #Data Value 
    print qq{<tr><td class="ra">$lex{Value}</td>\n<td>};

    # SQL setup for getting hash values.
    $sth = $dbh->prepare("select * from conf_system where dataname = ?");

    # Now the various data types.
    if ( $type eq 'scalar' ) {

	my $varname = $rec{dataname};
	my $varvalue = $$varname; # watch $$.

	if ( $sectionname eq 'Notes' ) { # use a text area for input, edit.
	    print qq{<textarea rows="$scalar_text_rows" cols="$scalar_text_cols" name="$varname">};
	    print qq{$varvalue</textarea></td></tr>\n};

	} else {
	    my $size = length( $varvalue ) + 3;
	    if ( $size < $scalar_min_length ) { $size = $scalar_min_length; }
	    my $style = qq{style="width:$size}. q{ch;"};
	    print qq{<input type="text" $style name="$varname" };
	    print qq{value="$varvalue"></td></tr>\n};
	}

    } elsif ( $type eq 'scalaronoff' ) {

	my $varname = $rec{dataname};
	my $varvalue = $$varname; # watch $$.

	print qq{<select name="$varname"><option>$varvalue</option>\n};
	foreach my $val ( 0 .. 1 ) {
	    if ( $val == $varvalue ) { next; }
	    print qq{<option>$val</option>\n};
	}
	print qq{</select> 1=$lex{Yes}, 0=$lex{No}</td></tr>\n};


    } elsif ( $type eq 'array' ) {

	my $varname = $rec{dataname};
        print qq{<table cellpadding="3" cellspacing="0" border="0">\n};

	my $maxsize; # biggest value for characters in values
	my $counter = 1;

	# Get largest value length in array
	my $size;
	foreach my $val ( @{ $varname } ) {
	    my $tempsize = length( $val );
	    if ( $tempsize > $size ) {
		$size = $tempsize;
	    }
	}
	$size += 5; # expand it a bit 
	
	foreach my $val ( @{ $varname } ) {
	    if ( not $val ) { next; } # skip any blank values
	    
	    print qq{<tr><td>};

	    if ( $size < 40 ) { # use input method
		my $style = qq{style="width:$size}. q{ch;"};
		print qq{<input type="text" $style name="$counter" value="$val">\n};
	    } else { # use textarea method
		print qq{<textarea name="$counter" rows="6" cols="80">$val</textarea>\n};
	    }
	    print qq{</td></tr>\n};
	    $counter++;
	}
	print qq{</table>\n};
	print qq{</td></tr>\n};

	# blank row
	print qq{<tr><td colspan="2">&nbsp;</td></tr>\n};

	# New Value	
	print qq{<tr><td class="ra">$lex{New} $lex{Value}</td>\n<td>};
	if ( $maxsize > 30 ) { # use textarea 
	    print qq{<textarea name="newvalue" rows="6" cols="80">$varname->{$key}</textarea>\n};
	} else { # normal input field
	    my $style = qq{style="width:$size}. q{ch;"};
	    print qq{<input type="text" name="newvalue" $style>\n};
	}
	print qq{</td></tr>\n};


    } elsif ( $type eq 'hash' ) {

	# Check for a source hash for keys
	my $sourcehash = $rec{hashvar};
	if ( $sourcehash ) { # load that variable to get the keys.
	    # Get the related hashofarray Record
	    $sth->execute( $sourcehash );
	    my $ref = $sth->fetchrow_hashref;
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	    eval $ref->{datavalue}; # evaluate $sourcehash.
	}

	my @keys;
	foreach my $key ( sort {$a <=> $b} keys %{ $sourcehash } ) {
	    push @keys, $key;
	}


	my $varname = $rec{dataname};
        print qq{<table cellpadding="3" cellspacing="0" border="0">\n};

	my $maxsize; # biggest value for characters in values
	foreach my $key ( sort keys %{ $varname } ) {

	    # print the key
	    print qq{<tr><td>$key</td><td>\n};
	    

	    # decide on entry method
	    if ( @keys ) { # use the select method
		print qq{<select name="$key"><option>$varname->{$key}</option>\n};
		foreach my $skey ( @keys ) { 
		    if ( $skey ne $varname->{$key} ) { # don't show duplicates
			print qq{<option>$skey</option>};
		    }
		}
		print qq{<option></option></select>\n};

	    } else {
		my $size = length( $varname->{$key} ) + 5;
		if ( $size > $maxsize ) { $maxsize = $size; } 
		if ( $size < 30 ) { # use input method
		    my $style = qq{style="width:$size}. q{ch;"};
		    print qq{<input type="text" $style name="$key" value="$varname->{$key}">\n};
		} else { # use textarea method
		    print qq{<textarea name="$key" rows="6" cols="80">$varname->{$key}</textarea>\n};
		}
	    }

	    print qq{</td></tr>\n};
	}
	print qq{</table>\n};

	print qq{</td></tr>\n};

	# New Key/Value
	print qq{<tr><td colspan="2">&nbsp;</td></tr>\n}; # blank row
	
	print qq{<tr><td class="ra">$lex{New} $lex{Key}</td>\n};
	print qq{<td><input type="text" name="newkey" style="width:15ch;"></td></tr>\n};

	print qq{<tr><td class="ra">$lex{New} $lex{Value}</td>\n<td>};
	if ( $maxsize > 40 ) { # use textarea 
	    print qq{<textarea name="newvalue" rows="6" cols="80">$varname->{$key}</textarea>\n};
	} else { # normal input field
	    my $style = qq{style="width:$size}. q{ch;"};
	    print qq{<input type="text" name="newvalue" $style>\n};
	}
	print qq{</td></tr>\n};


    } elsif ( $type eq 'hashofarray' ) {

	# Get the related hash values
	$sth->execute( $hashvar );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my $sourceref = $sth->fetchrow_hashref;
	eval $sourceref->{datavalue};
	
	# Loop Through all Hash values.
	my $varname = $rec{dataname};
        print qq{<table cellpadding="3" cellspacing="0" border="0">\n};
	foreach my $key ( sort { $a <=> $b } keys %{ $varname } ) {

	    my $arrayref = $varname->{$key};

	    print qq{<tr><td>$key</td>\n<td>};
	    my $arrayidx = 0;
	    foreach my $val ( @$arrayref ) {
		my $size = length( $val ) + 5;
		my $style = qq{style="width:$size}. q{ch;"};
		print qq{$arrayidx.<input type="text" $style name="$key:$arrayidx" value="$val"><br>\n};
		$arrayidx++;
	    }
	    print qq{</td></tr>\n};
	}

	print qq{</table>\n};
	print qq{</td></tr>\n};


	# New Key/Value
	print qq{<tr><td colspan="2">&nbsp;</td></tr>\n}; # blank row

	print qq{<tr><td class="ra">$lex{New} $lex{Key}</td>\n};
	print qq{<td><input type="text" name="newkey" style="width:15ch;"></td></tr>\n};

	print qq{<tr><td class="ra">$lex{New} $lex{Value}</td><td>\n};
	for my $i ( 0 .. $maxarrayidx ) {
	    print qq{$i.<input type="text" name="NEW:$i" style="width:20ch;"><br>\n};
	}
	print qq{</td></tr>\n};


    } elsif ( $type eq 'arrayofhash' ) {

	# Get the related hash values
	$sth->execute( $hashvar );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my $sourceref = $sth->fetchrow_hashref;
	eval $sourceref->{datavalue};
	
	# Loop Through all Hash values.
	my $varname = $rec{dataname};
        print qq{<table cellpadding="3" cellspacing="0" border="0">\n};
	foreach my $key ( sort { $a <=> $b } keys %{ $varname } ) {

	    my $arrayref = $varname->{$key};

	    print qq{<tr><td>$key</td>\n<td>};
	    my $arrayidx = 0;
	    foreach my $val ( @$arrayref ) {
		my $size = length( $val ) + 5;
		my $style = qq{style="width:$size}. q{ch;"};
		print qq{$arrayidx.<input type="text" $style name="$key:$arrayidx" value="$val"><br>\n};
		$arrayidx++;
	    }
	    print qq{</td></tr>\n};
	}

	print qq{</table>\n};
	print qq{</td></tr>\n};


	# New Key/Value
	print qq{<tr><td colspan="2">&nbsp;</td></tr>\n}; # blank row

	print qq{<tr><td class="ra">$lex{New} $lex{Key}</td>\n};
	print qq{<td><input type="text" name="newkey" style="width:15ch;"></td></tr>\n};

	print qq{<tr><td class="ra">$lex{New} $lex{Value}</td><td>\n};
	for my $i ( 0 .. $maxarrayidx ) {
	    print qq{$i.<input type="text" name="NEW:$i" style="width:20ch;"><br>\n};
	}
	print qq{</td></tr>\n};


    } # end of arrayofhash type


    print qq{<tr><td></td><td style="text-align:left;">\n};
    print qq{<input type="submit" value="$lex{Update} $lex{Record}"></td></tr>\n};
    print qq{</table><p></p>\n};
    print qq{</form></body></html>\n};

    exit;


} # end of editValues



#--------------
sub writeValues {
#--------------
    
    use Data::Dumper;
    $Data::Dumper::Purity = 1;
    $Data::Dumper::Indent = 0;

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    # Get the Id value
    my $id = $arr{id};
    delete $arr{id};

    my $updatefile = $arr{updatefile};
    delete $arr{updatefile};

    # Check for key/value additions to hashes.
    my $newkey = $arr{newkey};
    my $newvalue = $arr{newvalue};
    delete $arr{newkey};
    delete $arr{newvalue};


    # Get the original record
    my $sth = $dbh->prepare("select * from conf_system where id = ?");
    $sth->execute( $id );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref;

    my $type = $ref->{datatype};
    my $dataname = $ref->{dataname};
    my $value_ref = [ ];
    my $name_ref = [ ];


    my $sth = $dbh->prepare("update conf_system set datavalue = ? where id = ?");


    if ( $type eq 'scalar' or $type eq 'scalaronoff' ) {

	foreach my $key ( keys %arr ) { # should only be 1
	    push @$name_ref, $key;
	    push @$value_ref, $arr{$key};
	}
	
	my $d = Data::Dumper->new( $value_ref, $name_ref );
	my $datavalue = $d->Dump;
	$sth->execute( $datavalue, $id );

    } elsif ( $type eq 'array' ) {

	my @newarray = ();
	foreach my $key ( sort { $a <=> $b } keys %arr ) { #
	    if ( defined $arr{$key} ) { # need a value...
		push @newarray, $arr{$key};
	    }
	}
	if ( $newvalue ) {
	    push @newarray, $newvalue;
	}

	$dataname = '*'. $dataname;
	push @$name_ref, $dataname;
	push @$value_ref, \@newarray;

	my $d = Data::Dumper->new( $value_ref, $name_ref );
	my $datavalue = $d->Dump;

	# print qq{Datavalue:$datavalue<br>\n};
	$sth->execute( $datavalue, $id );


    } elsif ( $type eq 'hash' ) {

	my %newhash = ();
	foreach my $key ( keys %arr ) {
	    if ( $arr{$key} ) {
		$newhash{$key} = $arr{$key};
	    }
	}
	if ( $newkey and defined $newvalue ) {
	    $newhash{$newkey} = $newvalue;
	}

	$dataname = '*'. $dataname;
	push @$name_ref, $dataname;
	push @$value_ref, \%newhash;

	my $d = Data::Dumper->new( $value_ref, $name_ref );
	my $datavalue = $d->Dump;

	#print qq{Datavalue:$datavalue<br>\n};
	$sth->execute( $datavalue, $id );


    } elsif ( $type eq 'hashofarray' ) {


	my %newhash = ();

	# Put in an NEW values and remove values from %arr;
	for my $idx ( 0 .. $maxarrayidx ) {
	    my $key = qq{NEW:$idx};
	    if ( $arr{$key} and $newkey ) {
		$newhash{$newkey}[$idx] = $arr{$key};
	    }
	    delete $arr{$key};
	}


	# Loop through all keys and update the hash of arrays
	foreach my $key ( sort keys %arr ) {
	    my ( $hkey, $idx ) = split(/:/, $key);
	    $newhash{$hkey}[$idx] = $arr{$key};
	}

	$dataname = '*'. $dataname;
	push @$name_ref, $dataname;
	push @$value_ref, \%newhash;

	my $d = Data::Dumper->new( $value_ref, $name_ref );
	my $datavalue = $d->Dump;

	$sth->execute( $datavalue, $id );

    } # end of hashofarrays


    if ( not $DBI::errstr  ) {
	print qq{<h3>$lex{Record} $lex{Updated}</h3>\n};
    } else {
	print qq{<h3>$lex{Error}:$DBI::errstr;</h3>\n};
    }


    # Now write the file update, if requested.
    if ( $updatefile ) {
	print qq{Updating File<br>\n};
	updateFiles( $updatefile );

    }

    print qq{<p>[ <a href="$eoypage">$lex{Eoy}</a> ]</p>\n};
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="submit" value="$lex{Edit}"></form>\n};

    print qq{</body></html>\n};

    exit;

} # End of writeValues;



#--------------
sub updateFiles {
#--------------

    # Note: needs file path: $g_EtcPath to write files to.

    if ( not -e $g_EtcPath ) {
	print qq{<h3>$lex{Path} $lex{'Not Found'}</h3>\n};
    }

    my $singlefile = shift;

    my @files;
    if ( $singlefile ) {
	push @files, $singlefile;

    } else { # do them all
	my $sth = $dbh->prepare("select distinct filename from conf_system 
         where filename is not NULL and filename != ''  order by filename");
	$sth->execute;
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	while ( my $filename = $sth->fetchrow ) {
	    push @files, $filename;
	}
    }


    foreach my $updatefile ( @files ) {

	my $filename = qq{$g_EtcPath/$updatefile.conf};
	
	print qq{<div>$lex{Update}: $filename</div>\n};

	# special case for admin.conf
	if ( $updatefile eq 'admin' ) { # use the admin.conf.root file.
	    unless ( -e "$g_EtcPath/admin.conf.root" ) {
		print qq{<h3>$g_EtcPath". '/admin.conf.root'. " $lex{'Not Found'}</h3>\n};
	    }
	    system("cp -f $g_EtcPath/admin.conf.root $g_EtcPath/admin.conf");
	    # print qq{Result:", $? >> 8, "<br>\n};

	    open(FH,">>$filename") or
		die qq{Cannot open file $filename: $!\n}; # open for append
	} else {
	    open(FH,">$filename") or
		die qq{Cannot open file $filename: $!\n};
	}


	my $sth = $dbh->prepare("select id, datavalue from conf_system 
         where filename = ? order by dataname");
	$sth->execute( $updatefile );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

	while ( my ($id, $value) = $sth->fetchrow ) {
	    print FH $value, qq{\n};
	}

	print FH qq{\n1;\n};
	close FH;

	print qq{<h3>$lex{File} $lex{Updated}: $updatefile</h3>\n};
    }

    if ( $singlefile ) { 
	return; 
    } else { # did them all
	print qq{</body></html>\n};
	exit;
    }
}
