#!/usr/bin/perl
#  Copyright 2001-2017 Leslie Richardson

#  Compare variables in the conf_system from 2 different DB's.

use DBI;

my ($password, $db1, $db2) = @ARGV;

if ( not $password ) {
    print "Usage: ./compareconfsystem.pl rootDBpassword db1 db2\n";
    exit;
}

my $user = 'root';
my $dbtype = 'mysql';

my $dsn1 = "DBI:$dbtype:dbname=$db1";
my $dbh1 = DBI->connect($dsn1,$user,$password);

my $dsn2 = "DBI:$dbtype:dbname=$db2";
my $dbh2 = DBI->connect($dsn2,$user,$password);


# Get  conf_system data - db1
my (%conf1, %confdata1 );

my $sth = $dbh1->prepare("select * from conf_system");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
while ( my $ref = $sth->fetchrow_hashref ) {
    $conf1{$ref->{dataname}} = $ref->{filename};
    $confdata1{$ref->{dataname}} = $ref;
}


# Get  conf_system data - db2
my (%conf2, %confdata2 );

my $sth = $dbh2->prepare("select * from conf_system");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
while ( my $ref = $sth->fetchrow_hashref ) {
    $conf2{$ref->{dataname}} = $ref->{filename};
    $confdata2{$ref->{dataname}} = $ref;
}



# Assemble master hash to iterate over
my %master = %conf1;
foreach my $key ( keys %conf2 ) {
    if ( not $master{$key} ) {
	$master{$key} = $tempconf{$key};
    }
}



# Loop over all hash values
foreach my $key ( keys %master ) {
    if ( $conf1{$key} eq $conf2{$key} ) {

	# Compare sectionname, sequenceval, datatype
	if ( $confdata1{$key}->{sectionname} ne $confdata2{$key}->{sectionname} ) {
	    print "K:$key $conf1{$key}: Sectionname differs: DB1: $confdata1{$key}->{sectionname} DB2: $confdata2{$key}->{sectionname}\n";
	}
	if ( $confdata1{$key}->{sequenceval} ne $confdata2{$key}->{sequenceval} ) {
	    print "K:$key $conf1{$key}: SequenceVal differs: DB1: $confdata1{$key}->{sequenceval} DB2: $confdata2{$key}->{sequenceval}\n";
	}
	if ( $confdata1{$key}->{datatype} ne $confdata2{$key}->{datatype} ) {
	    print "K:$key $conf1{$key}: Datatype differs: DB1: $confdata1{$key}->{datatype} DB2: $confdata2{$key}->{datatype}\n";
	}

	# Remove identical records
	delete $conf1{$key};
	delete $conf2{$key};
    }
}


if ( %conf1 ) {
    print "\nDB1 Remaining Configuration Keys:\n";
    foreach my $key ( sort keys %conf1 ) {
	print "$key\n";
    }
} else {
    print "DB1 No Remaining Configuration Keys\n";
}

if ( %conf2 ) {
    print "\nDB2 Remaining Configuration Keys:\n";
    foreach my $key ( sort keys %conf2 ) {
	print "$key\n";
    }
} else {
    print "DB2 No Remaining Configuration Keys\n";
}


print"Done!\n";
