#!/usr/bin/perl

use DBI;

my $user = 'root';
my ($password, $db1, $db2) = @ARGV;

if ( not $password ) {
    print "Usage: ./comparedatabase.pl password db1 db2\n";
    exit;
}


my $database = 'information_schema';
my $dsn = "DBI:mysql:$database";
my $dbh = DBI->connect($dsn,$user,$password);

my (%master, %db1, %db2);

my $sth = $dbh->prepare("select table_name, column_name, data_type, 
 character_maximum_length, column_type from columns where table_schema = ?");


# DB 1
$sth->execute( $db1 );
while ( my  ($tname, $cname, $ctype, $clength ) = $sth->fetchrow ) {
    $db1{$tname}{$cname} = "$ctype:$clength";
    $master{$tname}{$cname} = 1;
}

# DB 2
$sth->execute( $db2 );
while ( my  ($tname, $cname, $ctype, $clength ) = $sth->fetchrow ) {
    $db2{$tname}{$cname} = "$ctype:$clength";
    $master{$tname}{$cname} = 1;
}


# Now remove the common fields to leave the differences.
foreach my $tbl ( keys %master ) {
    foreach my $col ( keys %{ $master{$tbl} } ) {
	my $db1val = $db1{$tbl}{$col};
	my ($db1_type,$db1_length) = split(':', $db1val );

	my $db2val = $db2{$tbl}{$col};
	my ($db2_type,$db2_length) = split(':', $db2val );

	if ( $db1val eq $db2val ) { # delete duplicates
	    delete $db1{$tbl}{$col};
	    delete $db2{$tbl}{$col};
	}
    }
}


# Now Display the values left;
my $first = 0;
print "\n\nDatabase 1 - $db1\n";
if ( %db1 ) {
    foreach my $tbl ( sort keys %db1 ) {
	foreach my $col ( sort keys %{ $db1{$tbl} } ) {
	    my $db1val = $db1{$tbl}{$col};
	    my ($db1_type,$db1_length) = split(':', $db1val );

	    if ( $first ) {
		print qq{<h3>Database 1 - $db1</h3>\n};
		print qq{<table cellspacing="0" cellpadding="3" border="1">\n};
		print qq{<tr><th>Table</th><th>Column</th><th>Type</th>\n};
		$first = 0;
	    }

#	    print qq{<tr><td>$tbl</td><td>$col</td><td>$db1_type - $db1_length</td></tr>\n};
	    print qq{$tbl\t$col\t$db1_type - $db1_length\n};
	}
    }
}


my $first = 0;
print "\n\nDatabase 2 - $db2\n";
if ( %db2 ) {
    foreach my $tbl ( sort keys %db2 ) {
	foreach my $col ( sort keys %{ $db2{$tbl} } ) {
	    my $db2val = $db2{$tbl}{$col};
	    my ($db2_type,$db2_length) = split(':', $db2val );

	    if ( $first ) {
		print qq{<h3>Database 2 - $db2</h3>\n};
		print qq{<table cellspacing="0" cellpadding="3" border="1">\n};
		print qq{<tr><th>Table</th><th>Column</th><th>Type</th>\n};
		$first = 0;
	    }

#	    print qq{<tr><td>$tbl</td><td>$col</td><td>$db2_type - $db2_length</td></tr>\n};
	    print qq{$tbl\t$col\t$db2_type - $db2_length\n};
	}
    }
}
