#!/usr/bin/perl

use DBI;

eval require "admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}


my @dbase = sort keys %alldbase;

my $user = 'root';
my $password = 'sezme';


foreach $database (@dbase) { #defined in global config file.

    my $dsn = "DBI:mysql:$database";
    my $dbh = DBI->connect($dsn,$user,$password);

    # reset the readlevel field
    my $sth1 = $dbh->prepare("update read_test set readlevel = ? where id = ?");


    # Update the score values
    my $sth2 = $dbh->prepare("update read_test_score set seq = ? where id = ?");
    my $sth3 = $dbh->prepare("update read_test_score set seq = ?, name = ? where id = ?");

    my $sth4 = $dbh->prepare("select * from read_test_score where id = ?");
    
    my $sth5 = $dbh->prepare("select * from read_test_score where testid = ? and seq = ?");
    
    
    my $sth = $dbh->prepare("select * from read_test where readlevel = '38'");
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    $sth->execute;

    my $count = 1;
    
    while ( my $ref = $sth->fetchrow_hashref ) {
	my %r = %$ref;

#	print qq{Database:$database - Level:$r{readlevel} - Date:$r{tdate}<br>\n};
	
	my $testid = $r{id};

	# Read the 2 score records for this test.
	$sth5->execute($testid,70);  # Comprehension - Prediction
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my $refscore = $sth5->fetchrow_hashref;
	my %p = %$refscore;
	print qq{DB:$database TESTID:$testid SEQ:$p{seq} NAME:$p{name}\n};
	my $pid = $p{id};  # prediction id;

	$sth5->execute($testid,80);  # Comprehension - Nonfiction Text Features
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my $refscore = $sth5->fetchrow_hashref;
	my %f = %$refscore;
	print qq{DB:$database TESTID:$testid SEQ:$f{seq} NAME:$f{name}\n};
	my $fid = $f{id};


	# Check the ID the sequence
	$sth4->execute($pid);  # Prediction
	my $ref = $sth4->fetchrow_hashref;
	my %p = %$ref;
	print qq{$count. DB:$database TESTID:$testid SEQ:$p{seq} NAME:$p{name} ID:$pid\n};

	$sth4->execute($fid);  # Prediction
	my $ref = $sth4->fetchrow_hashref;
	my %f = %$ref;
	print qq{DB:$database TESTID:$testid SEQ:$f{seq} NAME:$f{name} ID:$fid\n\n};
	
	
	$sth2->execute(80, $pid);  # Prediction
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

	# Update the Fiction name and Seq
	$sth3->execute(70,'Use of Text Features', $fid);  # Fiction
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	

	# Update the reading Test reading level
	$sth1->execute('38F', $testid);
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

	$count++;
#	if ( $count == 5 ) { exit; }

    }

} # end of database loop

print "Done!\n";
