#!/usr/bin/perl

use DBI;


eval require "admin.conf";
if ( $@ ) {
    print "Error: $@<br>\n";
    die "Error: $@\n";
}


my $table = 'read_level'; # set this.
my $fields = 'readlevel,category,name,seq';

compareTables();



#-------------------
sub compareTables {
#-------------------

    my $user = 'root';
    my $password = 'sezme';


    foreach my $db ( keys %alldbase ) {
	if ( $db ne 'poundmaker' ) { next; }

	print "DB:$db\n";
	
	my %master; # from read_level;
	
	my $dsn = "DBI:mysql:$db";
	my $dbh = DBI->connect($dsn,$user,$password);

	my $sth = $dbh->prepare("select $fields from $table");
	$sth->execute;
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; };

	while ( my $ref = $sth->fetchrow_hashref ) {
	    my %r = %$ref;
	    $master{ $r{readlevel} }{ $r{category} }{ $r{seq} }{ $r{name} } = 1;
	}



	# Now compare with the reading tests to find any name anomalies.
	    
	my $sth1 = $dbh->prepare("select * from read_test_score where testid = ?");

    	my $sth = $dbh->prepare("select id, readlevel from read_test");
	$sth->execute;
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; };

	while ( my ($id, $readlevel) = $sth->fetchrow ) {
	    if ( $readlevel ne '28F' ) { next; }
	    
	    $sth1->execute($id);
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; };

	    while ( my $ref = $sth1->fetchrow_hashref ) {
		my %r = %$ref;

		if ( not  $master{ $readlevel }{ $r{category} }{ $r{seq} }{ $r{name} } ) { # no match
		    print qq{$db - $id -  No match found for: $r{id} - $readlevel - $r{category} - $r{name} - $r{seq}\n};
		    my @keys =  keys %{ $master{ $readlevel }{ $r{category} }{ $r{seq} } }; 
		    print qq{MATCH: @keys\n };
		    sleep 1;

		    
		}
	    }
	}

    } # end of database loop

    exit;
     
} # end of compareTables

