#!/usr/bin/perl
#  Copyright 2001-2011 Leslie Richardson


# This file can be used to populate the student table from a
# spreadsheet csv file. It is now easier to use the import student
# script directly from OA once you get it running. However this can do
# more 'data munging' if you want to mess with parts of fields, etc.


#  This file is part of Open Admin for Schools.

use DBI;
use CGI;
use Text::CSV_XS;


$user = "root";
$password = "password";
$dbase = "schooldb";
$studnum = "5000";  # Starting Student Number.

 
$csv = Text::CSV_XS->new();

%monlkup = ("JAN",1,"FEB",2,"MAR",3,"APR",4,"MAY",5,"JUN",6,"JUL",7,"AUG",
	    8,"SEP",9,"OCT",10,"NOV",11,"DEC",12);


#============MySql section ========================

$dsn = "DBI:mysql:$dbase";
$dbh = DBI->connect($dsn,$user,$password);

$ARGV = shift @ARGV;
open (INFILE,"<$ARGV") || die "Cannot open input file";
while (<INFILE>){
    if ($csv->parse($_)) {
	( $fullname, $grade,$transport_am_route, $foip, $mass, $religion, 
	  $dental, $lice, $bc, $allergies, $treaty, $healthid, $cust, $ipp, $birthdate) = $csv->fields;
    }


#This section below, until the SQL insert section can be used to "fix
#up" any data in the input to a more pleasing format for inclusion in
#the database.

    my @name = split(/ /, $fullname );
    foreach $n ( @name ) {
	$n = lc $n;
	$n = ucfirst $n;
    }

    $lastname = pop @name;
    $firstname = join(' ', @name);


    # Now fix birthdate;
    if ( $birthdate ) {
	my @bd = split('/', $birthdate);

	if ( $arr{grade} > 6 ) {
	    $bd[0] = '19'. $bd[0];
	    $birthdate = "$bd[0]-$bd[1]-$bd[2]";
	} else {
	    $birthdate = "$bd[2]-$bd[0]-$bd[1]";
	}
    }


    my $sth = $dbh->prepare("insert into student (studnum, lastname, firstname, grade, birthdate, trans_am_route, treaty, healthid ) 
      values (?, ?, ?, ?, ?, ?, ?, ?)");
    $sth->execute($studnum, $lastname, $firstname, $grade, $birthdate, $transport, $treaty, $healthid );
    if ($DBI::errstr) { print $DBI::errstr; die; }

    $studnum++;
}

print "Done!\n\n";

print "The next student number is: $studnum \n\n";
print "Please edit your /etc/studentnumber file and put in this\n";
print "number which is the next available student number.\n";

=cut
