#!/usr/bin/perl

# This script is only used to help with configuration updates for new
# releases. Not required to be used for installations or installation
# updates.

# Update Readonly values

# Configuration Values
my $directoryBase = '/opt/openadmin';
my $mysqlDataDir = '/var/lib/mysql';
my $backupDir = '/opt/openadmin/backup';
my $sqldir = '../sql';

my $apacheConfDir = '/etc/apache2/sites-available';
my $apacheTempConfFile = 'apacheTempConfFile.conf';
my $backupextension = 'bak';

my $mysqldumpexec = '/usr/bin/mysqldump';
my $mysqlexec = '/usr/bin/mysql';
my $dbtype = 'mysql';
my $apache2ctl = '/usr/sbin/apache2ctl';


use DBI;
use Cwd;
use Crypt::GeneratePassword qw(:all); # password generation.


my $g_staffpwd_minfreq = .001;
my $g_staffpwd_avgfreq = .001;
my $g_staffpwd_lang = 'en'; # only en or de available.
my $g_staffpwd_caps = 1;
my $g_staffpwd_genlen = 6;
my $g_staffpwd_maxlen = 0;
my $g_staffpwd_minlen = 6;
my $g_staffpwd_signs = 0;


# Now set password, other config values at top of script
my $pwd = word( $g_staffpwd_minlen, $g_staffpwd_genlen,
		$g_staffpwd_lang, $g_staffpwd_signs,
		$g_staffpwd_caps, $g_staffpwd_minfreq,
		$g_staffpwd_avgfreq );



# Check working directory
if ( getcwd() !~ m/install-debian/ ) {
    print "Script must run from install-debian directory!\n";
    print "Please change your working directory. \n";
    exit;
}


print "\nInstallation Base: $directoryBase\n\n";


my ( $schooldir, $noschoolflag,$mysqlroot );

# Get MySql Root password
print "\nEnter MySQL Root Password: ";
$mysqlroot = <STDIN>;
chomp $mysqlroot;
print "MySQL Root Password: $mysqlroot\n\n";

# Get the School Directory / Database Name
while ( not $schooldir ) {

    print "Enter Existing School Name to update(single word only): ";
    $schooldir = <STDIN>;
    chomp $schooldir;

    # strip any spaces
    $schooldir =~ s/\s//g;
    print "Entered School Directory: $schooldir\n";

    if ( not -e "$directoryBase/$schooldir" ) {
	print "$schooldir Directory Not Found\n";
	$noschoolflag = 1;
    }

    # Check for existing database;
    if ( not -e "$mysqlDataDir/$schooldir" ) {
	print "$schooldir Database Not Found\n";
	$noschoolflag = 1;
    }

    if ( $noschoolflag ) {
	$schooldir = '';
    }
}



# Now set the Local RO User Password and User Id in MySQL.
# Removed the global ro user, since not commonly used.
print "\nEnter New MySQL Local Read Only User Id: ";
$mysqlrouser = <STDIN>;
chomp $mysqlrouser;
print "\nMySQL Local Read Only User Id: $mysqlrouser\n";

# $pwd is the generated password


print "\nEnter New MySQL Local Read Only Password: ($pwd) ";
$mysqlropassword = <STDIN>;
chomp $mysqlropassword;
if ( not $mysqlropassword ) { $mysqlropassword = $pwd; }
print "\nMySQL Local Read Only Password: $mysqlropassword\n";


$error =  system("mysql -p$mysqlroot -u root -e \"grant select on $schooldir.* to $mysqlrouser\@localhost identified by '$mysqlropassword'\"");
if ( not $error ) {
    print "Local User and Password Added\n";
} else {
    print "ERROR: RO User/Password NOT added: $error\n";
}

my $dsn = "DBI:$dbtype:dbname=$schooldir";
my $dbh = DBI->connect($dsn,'root',$mysqlroot);



# Update the admin.conf.root
# Write admin.conf.root,
my $etcpath = "$directoryBase/$schooldir/etc";


unless ( open(IN, "<", "$etcpath/admin.conf.root") ) {
	print "Cannot open admin.conf.root (read): $!\n";
	exit "Cannot open admin.conf.root (read): $!\n";
}

unless ( open(OUT, ">", "$etcpath/admin.conf.temp") ) {
	print "Cannot open admin.conf.temp (write): $!\n";
	exit "Cannot open admin.conf.temp (write): $!\n";
}


my $userflag;
my $passwordflag;


while ( my $line = <IN> ) {

    if ( $line =~ m/rouser/ ) { 
	$userflag = 1;
	print OUT q{$rouser='}. $mysqlrouser. q{';}. "\n";
    } elsif ( $line =~ m/ropassword/ ) {
	$passwordflag = 1;
	print OUT q{$ropassword='}. $mysqlropassword. q{';}. "\n";
    } else {
	chomp $line; # strip trailing LF.
	if ( $line ) { # if not blank, print out
	    print OUT $line, "\n";
	}
    }
}

close IN;

if ( not $userflag ) {
    print OUT q{$rouser='}. $mysqlrouser. q{';}. "\n";
}

if ( not $passwordflag ) {
    print OUT q{$ropassword='}. $mysqlropassword. q{';}. "\n\n";
}
    
close OUT;

# Rename the files.
rename "$etcpath/admin.conf.root", "$etcpath/admin.conf.bak";
rename "$etcpath/admin.conf.temp", "$etcpath/admin.conf.root";
