#!/usr/bin/perl

# Update Version to the latest. This will ask for current school location (directory,dbase).
# Then install /opt/openadmin files and copy the etc directory into the new location. 

# Configuration Values

my $baseDirectory = '/opt/openadmin'; # full path
my $subdir = '';  # if desired to have any directory below, like opt/openadmin/batc


# Fields that should be renamed rather than delete and then add new (ie. data loss)
my %fieldmodify = ('staff:email' => 'emailwork:varchar(48)',
		   'staffwd:email' => 'emailwork:varchar(64)',
		   'staff_prereg:email' => 'emailwork:varchar(64)',
    );

my %skipfield; # skip fields that fieldmodify is going to change to.
foreach my $key ( keys %fieldmodify ) {
    my ( $field, $type) = split(':', $fieldmodify{$key});
    $skipfield{$field} = 1;
}


my @smonth = ('JAN','FEB','MAR','APR','MAY','JUN','JUL','AUG','SEP','OCT','NOV','DEC');
my @tim = localtime(time);
my $year = $tim[5] + 1900;
my $day = $tim[3];
if ( length( $day ) == 1 ) { $day = '0'. $day; }

# For Filename
my $filecurrdate = $year. $smonth[ $tim[4] ]. $day;

my $minutes = $tim[1];
if ( not $minutes ) { $minutes = '00'; }
my $filecurrtime = $tim[2]. $minutes;
my $tempinstalldir = 'OAUpdate_'. $filecurrdate. '_'. $filecurrtime;

my $sqlfile = 'databasediff.sql';
my $sqlconffile = 'configdiff.sql';
my $sqlmetafile = 'metadiff.sql';


# Apache 2.4 Teacher site
my $apacheConfFile = '../install-apache2conf/apache24-debian.conf';
my $apacheOutputDir = '/etc/apache2/sites-available';

my $a2ensite = '/usr/sbin/a2ensite';
my $a2enmod = '/usr/sbin/a2enmod';
my $apache2ctl = '/usr/sbin/apache2ctl';
my $htpasswd = '/usr/bin/htpasswd';

my $dbtype = 'mysql';
my $dbfile = 'fulldbase.sql';

use DBI;
use Cwd;

# Check working directory
if ( getcwd() !~ m/install-debian/ ) {
    print "Script must run from install-debian directory!\n";
    print "Please change your working directory. \n";
    exit;
}


# include subdirectory.
$installDirectory = $baseDirectory;
if ( $subdir ) {
    $installDirectory = $installDirectory. '/'. $subdir;
}
print "\nCurrent Installation Directory: $installDirectory\n\n";

# Check for existing installation directory; directory below it must exist.
if ( not -e $baseDirectory ) {
    print "Creating '$baseDirectory'\n\n";
    mkdir $baseDirectory;
}

# Check for existing subdir
if ( $subdir ) { # if defined
    if ( not -e $installDirectory ) {
	print "Creating '$installDirectory'\n\n";
	mkdir $installDirectory;
    }
}


# Get School Name
print "Enter School Name to update (single word only): ";
$schooldir = <STDIN>;
chomp $schooldir;

# strip any spaces
$schooldir =~ s/\s//g;
print "\nSchool Directory: $schooldir\n";


# Get MySql Root password
print "\nEnter Database ROOT Password: ";
$mysqlroot = <STDIN>;
chomp $mysqlroot;
print "\nDatabase ROOT Password: $mysqlroot\n";


# Get Database Handle - Current Database (to update)
my $dsn = "DBI:mysql:dbname=$schooldir";
my $dbh = DBI->connect($dsn,'root',$mysqlroot );


# Check that this directory and database exist!  Exit if not!
if ( not -e $installDirectory ) {
    print "This directory does not exist! Exiting!\n\n";
    exit;
}

if ( $DBI::errstr ) { # no database.
    print qq{Database Error for $schooldir: $DBI::errstr\n};
    print qq{Exiting!\n\n};
    exit;
}

# Rename current directory to an older version.
my $oldVersionInstall = $schooldir. '_old_'.  $filecurrdate. '_'. $filecurrtime;

my $error = system("mv $installDirectory/$schooldir $installDirectory/$oldVersionInstall");
if ( $error ) { 
    print qq{Error Moving/Renaming Directory: $error\n\n};
    exit;
} else {
    print qq{Current install renamed to $installDirectory/$oldVersionInstall\n\n};
}


# copy new files into a active location.
my $error = system("cp -rp ../../school  $installDirectory/$schooldir"); 
if ( not $error ) {
    print "Open Admin new version temporarily copied to $installDirectory/$tempinstalldir\n\n";
}


# copy over the etc configuration files.
my $error = system("cp -rp $installDirectory/$oldVersionInstall/etc $installDirectory/$schooldir"); 
if ( not $error ) {
    print "Open Admin etc configuration copied to $installDirectory/$tempinstalldir\n\n";
} else {
    print qq{Cannot copy etc folder to new OA version area\n\n};
}


# Copy the student picture files, if any
my $error = system("cp -rp $installDirectory/$oldVersionInstall/admin/pic-big $installDirectory/$schooldir/admin"); 
if ( not $error ) {
    print "Open Admin Big picture files copied to $installDirectory/$tempinstalldir\n\n";
} else {
    print qq{Cannot copy big picture folder to new OA version area\n\n};
}
# small picture files
my $error = system("cp -rp $installDirectory/$oldVersionInstall/admin/pic-sm $installDirectory/$schooldir/admin"); 
if ( not $error ) {
    print "Open Admin Small Picture files copied to $installDirectory/$tempinstalldir\n\n";
} else {
    print qq{Cannot copy small picture folder to new OA version area\n\n};
}
# logo files
my $error = system("cp -rp $installDirectory/$oldVersionInstall/admin/images $installDirectory/$schooldir/admin"); 
if ( not $error ) {
    print "Open Admin logo image files copied to $installDirectory/$tempinstalldir\n\n";
} else {
    print qq{Cannot copy logo image folder to new OA version area\n\n};
}



# Change ownership
my $error = system("chown -R www-data:www-data $installDirectory/$schooldir");
if ( not $error ) {
    print "Ownership for OA files changed to www-data:www-data\n\n";
}



# Create the new database and populate it.
my $error = system("mysql -p$mysqlroot -u root -e \"create database $tempinstalldir character set utf8\"");
if ( not $error ) {
    print "New TEMP Database Created (for comparison)\nNow adding tables. Please wait.\n\n";
}

my $error = system("mysql -p$mysqlroot -u root $tempinstalldir < ../sql/$dbfile");
if ( not $error ) {
    print "New TEMP Database/Data Added\n\n";
}


# Compare the new version database and the old version database

print qq{Creating an sql file to be used to update your current database to the latest OA version\n};

my $dbhcurr = $dbh; # the database handle for the database to update.

my $user = 'root';
my $database = 'information_schema';
my $dsn = "DBI:mysql:$database";
my $dbh = DBI->connect($dsn,$user,$mysqlroot ); # mysqlroot is root password for dbase.

my (%master, %db1, %db2);

my $sth = $dbh->prepare("select table_name, column_name, column_type from columns 
                        where table_schema = ?");

my $db1 = $tempinstalldir;
my $db2 = $schooldir;

# DB 1 - source table ( New Version )
$sth->execute( $db1 );
while ( my  ($tname, $cname, $ctype ) = $sth->fetchrow ) {
    $db1{$tname}{$cname} = $ctype;
    $master{$tname}{$cname} = 1;
}

# DB 2 - destination table ( Old Version to be updated)
$sth->execute( $db2 );
while ( my  ($tname, $cname, $ctype ) = $sth->fetchrow ) {
    $db2{$tname}{$cname} = $ctype;
    $master{$tname}{$cname} = 1;
}


# Open SQL file
open( my $fh, ">", $sqlfile ) or die "Can't open $sqlfile: $!\n";

my $sth1 = $dbh->prepare("select column_name, column_type from columns 
   where table_name = ? and table_schema = ?");

# Get Primary Key
my $sth2 = $dbh->prepare("select column_name from key_column_usage
   where table_name = ? and table_schema = ?");


# Do the table analysis and then remove/add tables and update %master, etc. hashes
foreach my $tbl ( keys %master ) {
    if ( $db1{$tbl} and not $db2{$tbl} ) {
	# we have to add the entire table for the db2 database
	
	# Write the table start
	print $fh qq{CREATE TABLE $tbl (\n};
	
	$sth1->execute( $tbl, $db1 );
	if ( $DBI::errstr ) { print qq{DBI Error:$DBI::errstr; die $DBI::errstr; } }
#	print "Table:$tbl DB:$db1<br>\n";
	
	while  ( my ( $cname, $ctype ) = $sth1->fetchrow ) {
	    #	    print qq{CNAME:$cname $ctype($clength),\n};
	    if ( $cname eq 'id' ) { $ctype = $ctype. qq{ NOT NULL AUTO_INCREMENT}; }
	    print $fh qq{  $cname $ctype,\n};
	}

	# Get the key
	$sth2->execute( $tbl, $db1 );
	if ( $DBI::errstr ) { print qq{DBI Error:$DBI::errstr; die $DBI::errstr; } }
	my $keyfield = $sth2->fetchrow;
	print $fh qq{PRIMARY KEY ($keyfield)\n};

	# Close DB with engine, charset
	print $fh qq{) ENGINE=MyISAM DEFAULT CHARSET=utf8;\n\n};

	delete $db1{$tbl};
	delete $master{$tbl};
	
			      
    } elsif ( $db2{$tbl} and not $db1{$tbl} ) {
	# We have to drop the table, since no longer in the primary db1 database.
	if ( $tbl eq 'studentall' ) { next; } # skip the studentall view.
	print $fh qq{DROP TABLE $tbl;\n\n};
	# print "Writing Drop TABLE:$tbl to the sql update file.\n";

	delete $db2{$tbl};
	delete $master{$tbl};
	
    }
    
}



# Get Field position in table.
my $sth3 = $dbh->prepare("select ordinal_position from columns
   where column_name= ? and table_name = ? and table_schema = ?");

my $sth4 = $dbh->prepare("select column_name from columns
   where ordinal_position = ? and table_name = ? and table_schema = ?");


# Now remove the common fields to leave the differences.
foreach my $tbl ( keys %master ) {
    # Skip studentall since it's a view; if present.
    if ( $tbl eq 'studentall' ) { next; }
    
    foreach my $col ( keys %{ $master{$tbl} } ) {

	if ( $skipfield{$col} ) { next; } # updated by fieldmodify section;
	
	my $db1type = $db1{$tbl}{$col};
	my $db2type = $db2{$tbl}{$col};

	my $fmkey = qq{$tbl:$col}; # field modify key
	if ( $fieldmodify{$fmkey} ) { # we will just update the field to preserve data;
		# ie. email changed to emailwork
	    print qq{\n\nINSIDE fieldmodify Table:$tbl Field:$col value:$fieldmodify{$fmkey}\n\n};
	    my ($newname,$newtype) = split(':', $fieldmodify{$fmkey}); # from hash at top of file.
	    my $sth10 = $dbhcurr->prepare("ALTER TABLE $tbl CHANGE COLUMN $col $newname $newtype");
	    $sth10->execute;
	    if ( $DBI::errstr ) { print qq{DBI Error:$DBI::errstr;}; die $DBI::errstr; }
	    next; # col
	}

	
#	print "Table $tbl Field $col New (1) Type:$db1type Curent Type(2) $db2type\n";

	if ( $db1type eq $db2type ) { # delete duplicates
	    delete $db1{$tbl}{$col};
	    delete $db2{$tbl}{$col};
	    
	} elsif ( $db1type and not $db2type ) { # add the field into correct position.
	    
	    # get name of field before field to add
	    $sth3->execute( $col, $tbl, $db1 );
	    if ( $DBI::errstr ) { print qq{DBI Error:$DBI::errstr; die $DBI::errstr; } }
	    my $ordvalue = $sth3->fetchrow;
	    $ordvalue--; # decrement.

	    $sth4->execute( $ordvalue, $tbl, $db1 );
	    if ( $DBI::errstr ) { print qq{DBI Error:$DBI::errstr; die $DBI::errstr; } }
	    my $prevcolname = $sth4->fetchrow;
	    my $coltype = $db1{$tbl}{$col};

#	    print qq{ADD Field:$col - ORD:$ordvalue Prev Field:$prevcolname\n};
	    
	    # Add the line into sql file.
	    # print $fh qq{ALTER TABLE $tbl ADD $col $coltype AFTER $prevcolname;\n};
	    print $fh qq{ALTER TABLE $tbl ADD $col $coltype;\n};


	} elsif ( $db2type and not $db1type ) { # delete the field

#	    print qq{DROP COLUMN $col from $tbl\n};
	    
	    # Add the line into sql file.
	    print $fh qq{ALTER TABLE $tbl DROP COLUMN $col;\n};


	} elsif ( $db1type ne $db2type ) { # update the record.

#	    print qq{MODIFY COLUMN $col $coltype from $tbl\n};

	    my $coltype = $db1{$tbl}{$col};
	    print $fh qq{ALTER TABLE $tbl MODIFY COLUMN $col $coltype;\n};
	    

	} else { # Error
	    print qq{Error:$tbl - $col - DB1 Type:$db1type DB2 Type:$db2type\n};
	    
	}
	
    }
}

# Update studentall View
print $fh qq{\nDROP VIEW IF EXISTS studentall;\n}; # not really needed, but you never know!
print $fh qq{CREATE VIEW studentall AS select * from student union select * from studentwd;\n};

close $fh;


# We don't yet have a DB handle for the new database;
my $user = 'root';
my $database = $tempinstalldir;
my $dsnnew = "DBI:mysql:$database";
my $dbhnew = DBI->connect($dsnnew,$user,$mysqlroot ); # mysqlroot is root password for dbase.


updateConfigurationFile( $dbhnew, $dbhcurr);

updateMetaFile( $dbhnew, $dbhcurr);


# my $error =  system("mysql -p$mysqlroot -u root -e \"drop database $tempinstalldir\"");
#if ( not $error ) {
#    print "New TEMP Database dropped. - $tempinstalldir\n\n";
#}

print qq{Created databasediff.sql file. If you have any additional tables, fields, etc, \n};
print qq{ please edit this file.\n};

print "Done!\n\n";


#--------------------------
sub updateConfigurationFile {
#--------------------------

    # Compare the configuration of 2 databases (Current and New) and
    # update Current structure to match New Structure

    # Open Configuration SQL file
    open( my $fh, ">", $sqlconffile ) or die "Can't open $sqlconffile: $!\n";

    
    # Passed New DB Handle and Current DB Handle
    my ( $newDBH, $currDBH ) = @_;
   

    # Get  Current conf_system data
    my %curr;
    my $sth = $currDBH->prepare("select * from conf_system");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $ref = $sth->fetchrow_hashref ) {
	my %r = %$ref;
	$curr{$r{filename}}{$r{dataname}} = $ref;
	$master{$r{filename}}{$r{dataname}} = 1;
    }

#    foreach my $fn ( sort keys %curr ) {
#	foreach my $dn ( sort keys %{ $curr{$fn}} ) {
#	    print qq{CURR File:$fn Dname:$dn VAL:$curr{$fn}{$dn}\n};
#	}
#    }


    # Get New conf_system data
    my %new;
    my $sth = $newDBH->prepare("select * from conf_system");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $ref = $sth->fetchrow_hashref ) {
	my %r = %$ref;
	$new{$r{filename}}{$r{dataname}} = $ref;
	$master{$r{filename}}{$r{dataname}} = 1;
    }

#    foreach my $fn ( sort keys %new ) {
#	foreach my $dn ( sort keys %{ $new{$fn}} ) {
#	    print qq{NEW File:$fn Dname:$dn VAL:$new{$fn}{$dn}\n};
#	}
#    }


    # Add or Delete Datavalues
    foreach my $filename ( sort keys %master ) {
	foreach my $dataname ( sort keys %{ $master{$filename}} ) {
	
	    my %t = %{ $new{$filename}{$dataname} }; # new conf_system
	    my %c = %{ $curr{$filename}{$dataname} }; # current conf_system

	    if ( not %t and not %c ) { next; }
#	    print "T Hash:", %t, "\n";
#	    print "C Hash:", %c, "\n\n";
	    
	    
	    if ( not %c ) { # ADD dataname

		delete $t{id}; # remove record id of record to add.
		my @fields = sort keys %t;

		my (@values, @qst);
		foreach my $field ( @fields ) {
		    push @values, $currDBH->quote( $t{$field} );
		    push @qst, '?';
		}
		
		my $fields = join(',',@fields);
		my $qst = join(',',@qst);
		my $values = join(',',@values);

		print $fh qq{INSERT INTO conf_system ($fields) values($values);\n};
		
		# my $sth = $currDBH->prepare("insert into conf_system ( $fields ) values( $qst )");
		# if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
		# $sth->execute( @values );
		# if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	    

	    } elsif ( not %t ) { # DELETE dataname since not in new configuration system.

		print $fh qq{\nDELETE from conf_system where id = $c{id};\n};
		
		# my $sth = $currDBH->prepare("delete from conf_system where id = $c{id}");
		# $sth->execute;
		# if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	    }
	} # end of dataname
    } # end of filename

    

    # Update individual records
    # Loop over all hash values
    foreach my $filename ( sort keys %master ) {
	foreach my $dataname ( sort keys %{ $master{$filename}} ) {
	
	    my %t = %{ $new{$filename}{$dataname} }; #  New conf_system
	    my %c = %{ $curr{$filename}{$dataname} }; # Curr conf_system

	    # Compare sectionname, sequenceval, datatype
	    if ( $c{sectionname} ne $t{sectionname} and $t{sectionname} and $c{id} ) {
		
		print $fh qq{UPDATE conf_system set sectionname = '$t{sectionname}' };
		print $fh qq{ where id = $c{id};\n};
		# my $sth = $currDBH->prepare("update conf_system set sectionname = 't{sectionname}'
                #  where id = $c{id} ");
		# $sth->execute;
		# if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

	    }
	
	    if ( $c{sequenceval} ne $t{sequenceval} and $t{sequenceval} and $c{id} ) {
		print $fh qq{UPDATE conf_system set sequenceval = '$t{sequenceval}' };
		print $fh qq{ where id = $c{id};\n} # $dataname - $c{sequenceval}\n\n};
		# my $sth = $currDBH->prepare("UPDATE conf_system set sequenceval = '$t{sequenceval}'
		#    where id = $c{id}");
		# $sth->execute;
		# if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

	    }
	
	    if ( $c{datatype} ne $t{datatype} and $t{datatype} and $c{id} ) {
		print $fh qq{UPDATE conf_system set datatype = '$t{datatype}' where id = $c{id};\n};
		# $dataname - $c{datatype}\n\n};
		# my $sth = $currDBH->prepare("UPDATE conf_system set datatype = '$t{datatype}' 
		#			    where id = $c{id}");
		# $sth->execute;
		# if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

	    }
	
	    if ( $c{description} ne $t{description} and $t{description} and $c{id} ) {
		$t{description} =~ s/'/\\'/g;
		$t{description} =~ s/\r|\n//g;
	    
		print $fh qq{UPDATE conf_system set description = '$t{description}' };
		print $fh qq{ where id = $c{id};\n};
		# $dataname - $c{description}\n\n};
		# my $sth = $currDBH->prepare("UPDATE conf_system set description = '$t{description}' 
		#  where id = $c{id}");
		# $sth->execute;
		# if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
		
	    }
	
	}
    }

    close $fh;
    print qq{\n\nConfiguration Update Done!\n\n};
    
    return;

} # end of updateConfiguration



#-----------------
sub updateMetaFile {
#-----------------

    # Open Meta SQL file
    open( my $fh, ">", $sqlmetafile ) or die "Can't open $sqlmetafile: $!\n";

    # Passed New DB Handle and Current DB Handle
    my ( $newDBH, $currDBH ) = @_;
    
    # Load both tables into hashes.
    my %meta;
    my %tempmeta;

    my ($ref, $tempref);
    $sth = $currDBH->prepare("select * from meta"); 
    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $ref = $sth->fetchrow_hashref ) {
	$meta{ $ref->{tableid} }{ $ref->{fieldid} } = $ref;
    }

    #use Data::Dumper;
    #print Dumper %meta;

    # New Distro version.
    $sth = $newDBH->prepare("select * from meta"); # new DB to compare records with
    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $ref = $sth->fetchrow_hashref ) {
	$tempmeta{ $ref->{tableid} }{ $ref->{fieldid} } = $ref;
    }

    
    # Update any Record Fields
    foreach my $tableid ( keys %tempmeta ) {
	foreach my $fieldid ( keys %{ $tempmeta{$tableid} } ) {

	    if ( not $meta{$tableid}{$fieldid} ) { # skip if no matching field in original
		next; 
	    } 

	    # Update values
	    if ( $tableid eq 'student_inac' or $tableid eq 'staff' ) { # a record to change value

		my %temprec = %{ $tempmeta{$tableid}{$fieldid} };
		my $id = $meta{$tableid}{$fieldid}->{id};
	    
		foreach my $field ( sort keys %temprec ) {
		    if ( $field eq 'id' or $field eq 'tableid' or 
			 $field eq 'fieldid' or $field eq 'dbaseid' ) {
			next; 
		    }
		    # my $sth = $currDBH->prepare("update meta set $field = ? where id = ?");
		    # $sth->execute( $temprec{$field}, $id );
		    # print $fh qq{Meta Update: Field:$field Value:$temprec{$field} \n};
		    my $value = $currDBH->quote($temprec{$field});
		    print $fh qq{UPDATE meta set $field = $value where id = $id;\n};
		}
	    }

	    
	    # Now erase the 2 values if identical keys (dataname) (for later record comparisons)
	    if ( $tempmeta{$tableid}{$fieldid} and $meta{$tableid}{$fieldid} ) {
		delete $tempmeta{$tableid}{$fieldid};
		delete $meta{$tableid}{$fieldid};
	    }
	}
    }



    # Delete Records (vars) from meta table
    # $sth = $currDBH->prepare("delete from meta where id = ?");
    foreach my $tableid ( keys %meta ) {
	foreach my $fieldid ( keys %{ $meta{$tableid} } ) {
	    # $sth->execute( $ref->{$key}->{id} );
	    # $sth->execute( $meta{$tableid}{$fieldid}->{id} );
	    # if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	    #	    print "Meta Delete $tableid - $fieldid\n";
	    my $tid = $currDBH->quote($tableid);
	    my $fid = $currDBH->quote($fieldid);
	    print $fh qq{DELETE from meta where tableid = $tid and fieldid = $fid;\n};
	}
    }

    
    # Add Records (vars) to meta table
    # foreach my $key ( sort keys %$tempref ) {
    foreach my $tableid ( keys %tempmeta ) {
	foreach my $fieldid ( keys %{ $tempmeta{$tableid} } ) {

	    my %temp = %{ $tempmeta{$tableid}{$fieldid} };
	    delete $temp{id};

	    my $keystring = join(',', keys %temp );
	    
	    my @vals = values %temp;
	    foreach my $idx ( 0 .. $#vals ) {
		$vals[$idx] = $currDBH->quote( $vals[$idx] );
	    }
	    my $values = join(',', @vals);
	    
	    # print "ADD: K:$keystring V:@vals<br>\n";

	    #$sth = $currDBH->prepare("insert into meta ( $keystring ) 
	    # values ( ?,?,?,?,?,?,?,?,?,?,?,? )");
	    # 12 fields n/c id.
	    # $sth->execute( @vals );
	    # if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

	    #print "Meta Add $tableid - $fieldid\n";
	    print $fh qq{INSERT into meta ($keystring) values( $values );\n};
	}
    }

    print qq{Meta Update done!\n\n};
    
    return;


} # end of updateMeta

