#!/usr/bin/perl
# Configuration Values
my $apacheConfFile = '../install-apache2conf/apache2-centos.conf';
my $apacheOutputDir = '/etc/httpd/conf.d';
my $apachePrimaryConfFile = '/etc/httpd/conf/httpd.conf';

# NOTE: Leave these commented out. They are just 'notes to Mysql' about how things are organized in these distros.
# Settings for CentOS/RHEL
#ServerRoot              ::      /etc/httpd
#Primary Config Fle      ::      /etc/httpd/conf/httpd.conf
#Other Config Files      ::      /etc/httpd/conf.d
#Module Locations        ::      /usr/lib/httpd/modules
#DocumentRoot            ::      /var/www/html
#ErrorLog                ::      /var/log/httpd/error_log
#AccessLog               ::      /var/log/httpd/access_log
#cgi-bin                 ::      /var/www/cgi-bin (empty and disabled by default)
#binary                  ::      /usr/sbin/httpd
#runtime directory       ::      /etc/httpd/run
# start/stop              ::      /sbin/service httpd {start|stop|restart|condrestart|reload|status|fullstatus|graceful|help|configtest}


# Not available on CentOS
# my $a2ensite = '/usr/sbin/a2ensite';
# my $a2enmod = '/usr/sbin/a2enmod';

my $apache2ctl = '/usr/sbin/apachectl';
my $htpasswd = '/usr/bin/htpasswd';

my $dbtype = 'mysql';
my $dbfile = 'fulldbase.sql';

use DBI;

print "\nEnter School Name (single word only): ";
$schooldir = <STDIN>;
chomp $schooldir;

# strip any spaces
$schooldir =~ s/\s//g;
print "\nSchool Directory: $schooldir\n\n";


# Check for existing /opt/openadmin
if ( not -e '/opt/openadmin' ) {
    print "Creating '/opt/openadmin'\n\n";
    mkdir '/opt/openadmin';
    system("chcon -R --type=httpd_sys_content_t /opt/openadmin");
}

my $error = system("cp -r ../../school  /opt/openadmin/$schooldir");
if ( not $error ) {
    print "Open Admin copied to /opt/openadmin/$schooldir\n";
}

my $error = system("chown -R apache:apache /opt/openadmin/$schooldir");
if ( not $error ) {
    print "Ownership for OA files changed to apache:apache\n\n";
}
my $error = system("chcon -R --type=httpd_sys_content_t /opt/openadmin/$schooldir");
if ( not $error ) {
    print "SE Linux permissions for OA files changed\n\n";
}


# Now create the database and populate it.
# Get MySql Root password
print "\n\nEnter MySQL Root Password: ";
$mysqlroot = <STDIN>;
chomp $mysqlroot;
print "\nMySQL Root Password: $mysqlroot\n";

$error =  system("mysql -p$mysqlroot -u root -e \"create database $schooldir character set utf8\"");
#$error = system("mysqladmin -p$mysqlroot -u root create $schooldir");
if ( not $error ) {
    print "MySQL Database Created\n";
}

$error =  system("mysql -p$mysqlroot -u root $schooldir < ../sql/$dbfile");
if ( not $error ) {
    print "MySQL Database Tables/Data Added\n\n";
}


# Add school userid and password for access to this school database.
print "\nEnter Desired SCHOOL MySQL Password: ";
$schoolmysqlpwd = <STDIN>;
chomp $schoolmysqlpwd;
print "\nSCHOOL MySQL Password: $schoolmysqlpwd\n";


$error =  system("mysql -p$mysqlroot -u root -e \"grant all on $schooldir.* to $schooldir\@localhost identified by '$schoolmysqlpwd'\"");
if ( not $error ) {
    print "Database user and password added\n\n";
}



# Now set the Local RO User Password and User Id in MySQL.
# Removed the global ro user, since not commonly used.
print "\nEnter New MySQL Local Read Only User Id: ";
$mysqlrouser = <STDIN>;
chomp $mysqlrouser;
print "\nMySQL Local Read Only User Id: $mysqlrouser\n";


print "\nEnter New MySQL Local Read Only Password: ";
$mysqlropassword = <STDIN>;
chomp $mysqlropassword;
print "\nMySQL Local Read Only Password: $mysqlropassword\n";

$error =  system("mysql -p$mysqlroot -u root -e \"grant select on $schooldir.* to $mysqlrouser\@localhost identified by '$mysqlropassword'\"");
if ( not $error ) {
    print "Local User and Password Added\n";
}



# Load Apache Configuration File
unless ( open(FH, "<$apacheConfFile") ) {
	print "Cannot open $apacheConfFile: $!\n";
	die "Cannot open $apacheConfFile: $!\n";
}
# slurp in file
my $apachefile;
{ local $/; $apachefile = <FH>; close FH;}
close FH;

# Get Domain Names 
print "\nEnter Domain Name for Admin site (no http://): ";
$adminsite = <STDIN>;
chomp $adminsite;
print "Admin Site: $adminsite\n\n";


print "Enter Domain Name for Teacher site (no http://): ";
$teachersite = <STDIN>;
chomp $teachersite;
print "Teacher Site: $teachersite\n\n";


print "Enter Domain Name for Parent site (no http://): ";
$parentsite = <STDIN>;
chomp $parentsite;
print "Parent Site: $parentsite\n\n";


# Update Apache File.
$apachefile =~ s/ADMINSITENAME/$adminsite/; 
$apachefile =~ s/TEACHERSITENAME/$teachersite/;
$apachefile =~ s/PARENTSITENAME/$parentsite/;

$apachefile =~ s/SCHOOLNAME/$schooldir/g;

$apachefile =~ s/USER/$schooldir/g; # same values for db user, database as schooldir
$apachefile =~ s/DBPASSWORD/$schoolmysqlpwd/g;


# Write Apache File into location.
unless ( open(FH, ">$apacheOutputDir/$schooldir.conf") ) {
	print "Cannot open $apacheOutputDir/$schooldir.conf: $!\n";
	die "Cannot open $apacheOutputDir/$schooldir.conf: $!\n";
}

print FH $apachefile;
close FH;

# We MUST uncomment the NameVirtualHost line in the httpd.conf file in /etc/httpd/conf dir.
# Slurp in Apache Primary Conf File.
unless ( open(FH, "<$apachePrimaryConfFile") ) {
	print "Cannot open $apachePrimaryConfFile: $!\n";
	die "Cannot open $apachePrimaryConfFile: $!\n";
}
# slurp in file
my $conffile;
{ local $/; $conffile = <FH>; close FH;}
close FH;

$conffile =~ s/\#NameVirtualHost/NameVirtualHost/g; # strip leading #

unless ( open(FH, ">$apachePrimaryConfFile") ) {
	print "Cannot open for writing $apachePrimaryConfFile: $!\n";
	die "Cannot open for writing $apachePrimaryConfFile: $!\n";
}
print FH $conffile;
close FH;
# Now done uncommenting virtual host setting.


# Check Config,  Restart Apache.
# Not required: system("$a2ensite $schooldir.conf ");
# Not available: no ssi,system("$a2enmod include"); # turn on server side includes for date on index page.

system("$apache2ctl configtest"); # test config
system("$apache2ctl graceful"); # gracefully restart


# Create the authorization file.
# Check for existing directory
if ( not -e '/etc/httpd/auth_users' ) {
    print "Creating '/etc/httpd/auth_users'\n\n";
    mkdir '/etc/httpd/auth_users';
    system("chcon 'system_u:object_r:httpd_config_t auth_users'");
}

print "\nEnter Admin Website User Id: ";
$adminuser = <STDIN>;
chomp $adminuser;
print "\nEnter Admin Website User Password: ";
$adminpassword = <STDIN>;
chomp $adminpassword;
print "\nUser:$adminuser  Password:$adminpassword\n\n";


my $authfile = $schooldir. 'admin';
my $teacherauthfile = $schooldir. 'teacher';

$error = system("$htpasswd -cb $authfile $adminuser $adminpassword");
if ( not $error ) {
    print "Apache Authorization File Created\n";
}
$error = system("mv $authfile /etc/httpd/auth_users/");
if ( not $error ) {
    print "Authorization File Moved into place.\n";
}
$error = system("cp -f /etc/httpd/auth_users/$authfile /etc/httpd/auth_users/$teacherauthfile ");
if ( not $error ) {
    print "Teacher Authorization File Copied.\n";
} else {
    print "ERROR: Teacher Authorization File NOT copied.\n";
}

$error = system("chcon system_u:object_r:httpd_config_t  /etc/httpd/auth_users/$authfile");
if ( not $error ) {
    print "SE Linux Security Update for Authorization File.\n";
} else {
    print "ERROR: SE Linux context change FAILED.\n";
}



# Now load the global conf file and reset values
unless ( open(FH, "</opt/openadmin/$schooldir/etc/global.conf") ) {
	print "Cannot open global.conf (read): $!\n";
	die "Cannot open global.conf (read): $!\n";
}
# slurp in file
my $globalfile;
{ local $/; $globalfile = <FH>; close FH;}
close FH;

$globalfile =~ s/GLOBALUSER/$mysqlglobaluser/;
$globalfile =~ s/GLOBALPASSWORD/$mysqlglobalpwd/;

$globalfile =~ s/YOURSCHOOLDATABASE/$schooldir/;
$globalfile =~ s/YOURSCHOOLNAME/$schooldir/;

unless ( open(FH, ">/opt/openadmin/$schooldir/etc/global.conf") ) {
	print "Cannot open global.conf (write): $!\n";
	die "Cannot open global.conf (write): $!\n";
}

print FH $globalfile;
close FH;



# Now write admin.conf.root, rewrite the admin.conf, after getting
# root password, and password for the database.

# now write all of the configuration files into location.
my $etcpath = "/opt/openadmin/$schooldir/etc";

# set admin.conf.root test, and then write file.
my $roottext = q{$user='}. $schooldir. q{';}. "\n".
q{$dbase='}. $schooldir. q{';}. "\n". 
q{$password='}. $schoolmysqlpwd. q{';}. "\n".
q{$sds_user='SDSUSER';}. "\n". 
q{$sds_password='SDSPASSWORD';}. "\n\n"; 

unless ( open(FH, ">$etcpath/admin.conf.root") ) {
	print "Cannot open admin.conf.root (write): $!\n";
	die "Cannot open admin.conf.root (write): $!\n";
}
print FH $roottext;
close FH;

$error =  system("cp -f $etcpath/admin.conf.root  $etcpath/admin.conf");
if ( not $error ) {
    print "COPY: admin.conf.root -> admin.conf\n\n";
}


# now open database and start writing files
my $dsn = "DBI:$dbtype:dbname=$schooldir";
my $dbh = DBI->connect($dsn,'root',$mysqlroot );
$dbh->{mysql_enable_utf8} = 1;

my $sth = $dbh->prepare("select distinct filename from conf_system 
  where filename != '' and filename is not NULL order by filename");

my $sth1 = $dbh->prepare("select id, datavalue from conf_system 
  where filename = ? order by datavalue");

my $sth2 = $dbh->prepare("update conf_system 
  set datavalue = ? where id = ?");



# loop through all filenames
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
while ( my $filename = $sth->fetchrow ) {

    if ( $filename eq 'admin' ) {

	unless ( open(FH, ">>$etcpath/admin.conf") ) {
	    print "Cannot open admin.conf (append): $!\n";
	    die "Cannot open admin.conf (append): $!\n";
	}

	$sth1->execute( $filename );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

	while ( my ($id, $datavalue) = $sth1->fetchrow ) {

	    if ( $datavalue =~ m/YOURSCHOOL/ ) {
		$datavalue =~ s/YOURSCHOOL/$schooldir/;

		print "MATCH:$datavalue\n";
		$sth2->execute( $datavalue, $id ); # update database
		if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
		print "UPDATE:$id - $datavalue\n";

	    }
	    print FH $datavalue, "\n";
	}
	print FH "\n1;\n";
	close FH;

    } else { # all other conf files

	unless ( open(FH, ">$etcpath/$filename.conf") ) {
	    print "Cannot open $filename.conf: $!\n";
	    die "Cannot open $filename.conf: $!\n";
	}

	$sth1->execute( $filename );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	while ( my ($id, $datavalue) = $sth1->fetchrow ) {
	    print FH $datavalue, "\n";
	}
	print FH "\n1;\n";
	close FH;
    }

} # end of writing conf file

print "Done!\n";
