#!/usr/bin/perl
#  Copyright 2001-2010 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

# Update External Users - (on other servers)
#  Copy a user file to compare with users on other servers.


my %lex = ('Main' => 'Main',
	   'Combine failed on input' => 'Combine failed on input',
	   'Error' => 'Error',
	   'Update External Users' => 'Update External Users',
	   'File Copy Complete' => 'File Copy Complete',

	   );

# Now imported from usermanage.conf
# my $remoteuser = 'openadmin'; # account on remote server
# my $remotepassword = 'PASSWORD'; # password on remote server
# my $remoteip = 'RemoteIP'; # IP Address of remote server


use DBI;
use CGI;
use Text::CSV_XS;
use Net::SCP::Expect;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

eval require "../../etc/usermanage.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}




my $q = CGI->new;
print $q->header( -charset, $charset );

my $csv = Text::CSV_XS->new( {binary => 1} );

# Write HTML Header
print "$doctype\n<html><head><title>". $lex{'Update External Users'}. "</title>
<link rel=\"stylesheet\" type=\"text/css\" href=\"$css\">
$chartype\n</head><body>\n";
print "[ <a href=\"$homepage\">". $lex{Main}. "</a> ]\n";
#print "<a href=\"$exppage\">". $lex{Export}. "</a> ]\n";

print "<center><h1>". $lex{'Update External Users'}. "</h1></center>\n";


# Open output file
my $filename = "addusers$$.csv";
open (EX,">$filename") || die "Can't open Export file $fileName";

# Open Database
my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);
$dbh->{mysql_enable_utf8} = 1;

# Select student fields
$sth = $dbh->prepare("select lastname, firstname, studnum, password,
  ldap_uid, ldap_uidnumber, ldap_gidnumber
  from student order by ldap_uidnumber"); # sort so file in uidnumber order.
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

# write to the csv file from database.
while ( my ( $lastname, $firstname, $studnum, $password, $uid, $uidnumber, $gidnumber )
	= $sth->fetchrow ) {

    print "$firstname $lastname \n";

    my @arr = ("$firstname $lastname ($studnum)", $studnum, $password, $uid, 
	       $uidnumber, $gidnumber );

    if ( $csv->combine(@arr) ) {
	my $record = $csv->string;
	print EX $record, "\r\n";
    } else {
	my $err = $csv->error_input;
	print $lex{'Combine failed on input'}. ": $err\n\n";
    }
}

print "<br><br>\n";

# now do Staff
$sth = $dbh->prepare("select lastname, firstname, userid, password,
  ldap_uid, ldap_uidnumber, ldap_gidnumber
  from staff order by lastname,firstname");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

while ( my ( $lastname, $firstname, $userid, $password, $uid, $uidnumber, $gidnumber )
	= $sth->fetchrow ) {

    my @arr = ("$firstname $lastname ($userid)", $userid, $password, $uid, 
	       $uidnumber, $gidnumber );

    print "$firstname $lastname \n";

    if ( $csv->combine(@arr) ) {
	my $record = $csv->string;
	print EX $record, "\r\n";
    } else {
	my $err = $csv->error_input;
	print $lex{'Combine failed on input'}. ": $err\n\n";
    }
}

close EX;

# Now copy to external server.
my $scpe = Net::SCP::Expect->new( auto_yes => 1, timeout => 30 );
$scpe->login( $remoteuser, $remotepassword );
$scpe->scp( $filename, $remoteip. ':useradd.csv' );

system("rm -f $filename");

print "<div style=\"font-size:130%;font-weight:bold;\">". $lex{'File Copy Complete'}. "</div>\n";
print "</body></html>\n";
