#!/usr/bin/perl
#  Copyright 2001-2010 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


my %lex = ('Main' => 'Main',
	   'Error' => 'Error',
	   'Google User Management' => 'Google User Management',
	   'No Staff Found' => 'No Staff Found',
	   'Students to Delete' => 'Students to Delete',
	   'No Students Found' => 'No Students Found',
	   'Students to Add' => 'Students to Add',
	   'Staff to Add' => 'Staff to Add',
	   'No Staff Found' => 'No Staff Found',
	   'Continue' => 'Continue',
	   'Deleted' => 'Deleted',
	   'No Password' => 'No Password',
	   'Added' => 'Added',
	   'Do not delete students that may be in other schools in this division' =>
	     'Do not delete students that may be in other schools in this division',

	   );

my $showStaff = 0;  # change to 1 if desired to allow staff to also be added to this google domain.

my $self = 'googleupdate.pl';

###################### 
# Now present in usermanage.conf

# my $google_username = 'admin';
# my $google_password = 'XXXX';
# my $google_domain = 'mymail.org';

# These are the grades to NOT add accounts for.
# my @gradeskip = ( 'K', 'PK', '1', '2' );

##########################


use REST::Google::Apps::Provisioning;
use DBI;
use CGI;


eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

eval require "../../etc/usermanage.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

# Setup Google Docs 
my $gd = REST::Google::Apps::Provisioning->new(domain => $google_domain );
$gd->authenticate( username => $google_username,
		   password => $google_password ) ||
    die "Authentication Failure!\n";


# Setup CGI
my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

# Setup Database
my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);
$dbh->{mysql_enable_utf8} = 1;

# Print Page Header
print "$doctype\n<html><head><title>". $lex{'Google User Management'};
print "</title><link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">\n";
print "<style type=\"text/css\">h1, table { text-align:center; }</style>\n";
print "$chartype\n</head><body>\n";

print "[ <a href=\"$homepage\">". $lex{Main}. "</a> ]\n";
#print "<a href=\"$exppage\">". $lex{Export}. "</a> ]\n";
print "<h1 style=\"text-align:center;\">". $lex{'Google User Management'}. "</h1>\n";



# Setup for Start Page
if ( not $arr{page} ) {
    showStartPage();
} else {
    delete $arr{page};
    processUsers();
}


#------------------
sub studentToGoogle {
#------------------
    # convert student number to google account format (as desired)
    my ( $lastname, $firstname, $studnum ) = @_;
    # other methods may be used.

    my $googleaccount = 's'. $studnum;

    return $googleaccount;

}

#------------------
sub staffToGoogle {
#------------------
    # convert staff userid to google account format (as desired)
    my $userid = shift;
    # Note $dbh has to be already open.
    my $sth = $dbh->prepare("select lastname, firstname from staff where userid = ?");
    $sth->execute( $userid );
    if ( $DBI::errstr ) { print $DBI::errst; die $DBI::errstr; }
    my ( $lastname, $firstname ) = $sth->fetchrow;
    if ( not $lastname ) {
	print $lex{'No Staff Found'}. ": $userid<br>\n";
	return;
    }

    my $googleaccount = lc(substr($firstname,0,1)). '.'. lc($lastname);
    # Les Richardson becomes  l.richardson
    
    # Check for existing accounts...


    return $googleaccount;

}



#----------------
sub showStartPage {
#----------------

    # Get all GDoc Users
    my %googleusers = ();
    my $users = $gd->getAllUsers();
    #use Data::Dumper;

    # Setup select for grades to skip
    my $select;
    if ( @gradeskip ) {
	$select = 'where ';
	$first = 1;
	foreach my $grade ( @gradeskip ) {
	    $grade = $dbh->quote( $grade );
	    if ( not $first ) { $select .= ' and '; }
	    $select .= "grade != $grade ";
	    $first = 0;
	}
    }
    #print "Select is: $select<br>\n";

    my @studentview = ();
    my @studentadd = ();
    my @studentdelete = ();

    my $sth = $dbh->prepare("select lastname, firstname, studnum, grade from student 
        $select order by lastname, firstname");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errst; die $DBI::errstr; }

    print "<form action=\"$self\" method=\"post\">\n";
    print "<input type=\"hidden\" name=\"page\" value=\"1\">\n";
    print "<input type=\"submit\" value=\"". $lex{Continue}. "\"><br>\n";
    
    print "<br>". $lex{'Do not delete students that may be in other schools in this division'}. "<br>\n";

    print "<table cellpadding=\"3\" cellspacing=\"0\" border=\"1\"";
    print " style=\"float:left;\">\n";
    print "<tr><th colspan=\"3\">". $lex{'Students to Add'}. "</th></tr>\n";

    while ( my ( $lastname, $firstname, $studnum, $grade ) = $sth->fetchrow ) {
	
	my $googleaccount = studentToGoogle( $lastname, $firstname, $studnum );
	#print "$firstname $lastname ($studnum) - $googleaccount<br>\n";
	
	if ( $$users{ $googleaccount } ) { # we have an existing account;
	    push @studentview, $studnum;
	} else {
	    push @studentadd, $studnum;
	    print "<tr><td>$firstname $lastname ($studnum)</td><td>$grade</td>\n";
	    print "<td><input type=\"checkbox\" name=\"studadd:$studnum\" value=\"1\">";
	    print "</td></tr>\n";
	}
    }

    if ( not @studentadd ) {
	print "<tr><td colspan=\"2\">". $lex{'No Students Found'}. "</td></tr>\n";
    }
    print "</table>\n";



    # Now find STUDENTS to DELETE from Google Apps  
    print "<table cellpadding=\"3\" cellspacing=\"0\" border=\"1\"";
    print " style=\"float:left;\">\n";
    print "<tr><th colspan=\"3\">". $lex{'Students to Delete'};
    print "</th></tr>\n";

    $sth = $dbh->prepare("select lastname, firstname, studnum, grade from studentwd 
        order by lastname, firstname");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errst; die $DBI::errstr; }    

    while ( my ( $lastname, $firstname, $studnum, $grade ) = $sth->fetchrow ) {
	my $googleaccount = studentToGoogle( $lastname, $firstname, $studnum );
	if ( $$users{ $googleaccount } ) { # we have an existing account;
	    push @studentdelete, $studnum;
	    print "<tr><td>$firstname $lastname ($studnum)</td><td>$grade</td>\n";
	    print "<td><input type=\"checkbox\" name=\"studdel:$studnum\" value=\"1\">";
	    print "</td></tr>\n";
	}
    }

    if ( not @studentdelete ) {
	print "<tr><td colspan=\"2\">". $lex{'No Students Found'}. "</td></tr>\n";
    }
    print "</table>\n";



    # Now find STAFF to ADD to Google Apps
    if ( $showStaff ) {
	print "<table cellpadding=\"3\" cellspacing=\"0\" border=\"1\" ";
	print " style=\"float:left;\">\n";
	print "<tr><th colspan=\"2\">". $lex{'Staff to Add'}. "</th></tr>\n";


	$sth = $dbh->prepare("select distinct userid, lastname, firstname from staff
          order by lastname, firstname");
	$sth->execute;
	if ( $DBI::errstr ) { print $DBI::errst; die $DBI::errstr; }

	while ( my ( $userid, $lastname, $firstname ) = $sth->fetchrow ) {
	    my $googleaccount = staffToGoogle( $userid );
	    if ( not $$users{ $googleaccount } ) { # we have an existing account;
		print "<tr><td>$firstname $lastname ($userid)</td>\n";
		print "<td><input type=\"checkbox\" name=\"staffadd:$userid\" value=\"1\">";
		print "</td></tr>\n";
		push @staffadd, $userid;
	    }
	}

	if ( not @staffadd ) {
	    print "<tr><td colspan=\"2\">". $lex{'No Staff Found'}. "</td></tr>\n";
	}
	print "</table>\n";

    } # end of showStaff option


    print "</form></body></html>\n";
    exit;


} # end of showStartPage



#-----------------------
sub googleToStudentStaff {
#-----------------------
    # convert google account to student/staff;
    # returns studnum:student  or userid:staff

    my $googleaccount = shift;
    my $usertype;

    if ( $googleaccount =~ m/s[0-9]+/ ) { # matches s12345 format
	$usertype = 'student';
	my $studnum = substr( $googleaccount, 1 );
	return "$usertype:$studnum";
    } else { # look for staff member.

	my $ref = $$users{ $googleaccount };
	my $firstname = $$ref{givenName};
	my $lastname = $$ref{familyName};

	my $sth = $dbh->prepare("select userid from staff 
          where lastname = ? and firstname = ?");
	$sth->execute( $firstname, $lastname );
	if ( $DBI::errstr ) { print $DBI::errst; die $DBI::errstr; }
	my $userid = $sth->fetchrow;
	if ( not $userid ) { $return; }
	$usertype = 'staff';
	return "$usertype:$userid";
    }
}



#---------------
sub processUsers {
#---------------

    #foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    # Setup Selects to get user data
    my $sth = $dbh->prepare("select lastname, firstname, password from student 
        where studnum = ?");

    my $sth1 = $dbh->prepare("select lastname, firstname, password from staff 
        where userid = ?");

    my $sth2 = $dbh->prepare("select lastname, firstname from studentwd 
        where studnum = ?");

    foreach my $key ( sort keys %arr ) { 
	my ( $type, $value ) = split( /:/, $key);

	# ADD STUDENT
	if ( $type eq 'studadd' ) {

	    my $studnum = $value;
	    $sth->execute( $studnum );
	    if ( $DBI::errstr ) { print $DBI::errst; die $DBI::errstr; }
	    my ( $lastname, $firstname, $password ) = $sth->fetchrow;
	    my $userid = studentToGoogle( $lastname, $firstname, $studnum );

	    # print "User:$userid Name:$firstname $lastname - $password<br>\n";

	    my $result = $gd->createUser('username' => $userid, 
					     'givenName' => $firstname, 
					     'familyName' => $lastname, 
					     'password' => $password 
					     );

	    if ( not $result ) {
		print $lex{Error}. " : $result $firstname $lastname ($userid)<br>\n";
	    } else {
		my $ref = $$result{$userid};
		print "<b>". $lex{Added};
		print "</b> $$ref{givenName} $$ref{familyname} ($userid)<br>\n";
	    }


        # DELETE STUDENT
	} elsif ( $type eq 'studdel' ) {

	    my $studnum = $value;
	    $sth2->execute( $studnum ); 
	    if ( $DBI::errstr ) { print $DBI::errst; die $DBI::errstr; }
	    my ( $lastname, $firstname ) = $sth2->fetchrow;
	    my $userid = studentToGoogle( $lastname, $firstname, $studnum );
	    
	    $result = $gd->deleteUser( username => $userid );
	    if ( not $result ) {
		print "$lex{Error}: $result $firstname $lastname ($userid)<br>\n";
	    } else {
		print "<b>$lex{Deleted}</b> $firstname $lastname ($userid)<br>\n";
	    }



	# ADD STAFF
	} elsif ( $type eq 'staffadd' ) {

	    my $userid = $value;
	    $sth1->execute( $userid ); 
	    if ( $DBI::errstr ) { print $DBI::errst; die $DBI::errstr; }
	    my ( $lastname, $firstname, $password ) = $sth1->fetchrow;
	    my $user = staffToGoogle( $userid );
	    if ( not $password ) {
		print $lex{'No Password'}. " : $firstname $lastname ($userid)<br>\n";
		next; 
	    }

	    my $result = $gd->createUser('username' => $user, 
					 'givenName' => $firstname, 
					 'familyName' => $lastname, 
					 'password' => $password 
					 );
	    if ( not $result ) {
		print $lex{Error}. " : $result $firstname $lastname ($user)<br>\n";
	    } else {
		my $ref = $$result{$user};
		print "<b>". $lex{Added};
		print "</b> $$ref{givenName} $$ref{familyName} ($user)<br>\n";
	    }


	} else { # Error
	    print $lex{Error}. "Type: $type  Value: $value<br>\n";
	}


    }


    print "</body></html>\n";
    exit;

}
