#!/usr/bin/perl
#  Copyright 2001-2011 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Import' => 'Import',
	   'Reading' => 'Reading',
	   'Tests' => 'Tests',
	   'Main' => 'Main',
	   'Eoy' => 'Eoy',
	   'No Student(s) Found' => 'No Student(s) Found',
	   'Error' => 'Error',
	   'Students' => 'Students',
	   'Grade' => 'Grade',
	   'Cannot open' => 'Cannot open',
	   'Tests' => 'Tests',
	   'Continue' => 'Continue',
	   'Export' => 'Export',
	   'Record(s) Stored' => 'Record(s) Stored',
	   'Contact' => 'Contact',
	   'Skip' => 'Skip',
	   'Date' => 'Date',
	   'Read Level' => 'Read Level',
	   'Insert' => 'Insert',

	   );

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


if ( not -e "$globdir/global.conf" ) {
    print $lex{'Cannot open'}. " global.conf file!";
    print "</body></html>\n";
    exit;
}

eval { require "$globdir/global.conf"; };
if ( $@ ) {
    print "<h3>$lex{'Cannot open'} global.conf:\n $@</h3>\n";
    die "$lex{'Cannot open'}global.conf: $@\n";
}


# Setup to Import Records from feeder school
my $importdbase;
if ( $dbase eq 'eagleview' ) {
    $importdbase = 'chieftaylor';
}

my $dsn1 = "DBI:$dbtype:dbname=$importdbase";
my $dbh1 = DBI->connect($dsn1,$guser,$gpassword);



my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);
$dbh->{mysql_enable_utf8} = 1;


my $title = "$lex{Import} $lex{Reading} $lex{Tests}";
print "$doctype\n<html><head><title>$title</title>\n";
print "<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">$chartype\n";
print "</head><body>\n";
print "[ <a href=\"$homepage\">$lex{Main}</a> |\n";
print " <a href=\"$exppage\">$lex{Eoy}</a> ]\n";

print "<center><h1>$title</h1>\n";


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    writeRecords();
}



#----------------
sub showStartPage {
#----------------

    my @grades = ();
    my $sth = $dbh->prepare("select distinct grade from student 
      where grade is not NULL and grade != ''");
    $sth->execute;
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
    while ( my $gr = $sth->fetchrow ) {
	push @grades, $gr;
    }
    @grades = sort { $a <=> $b } @grades;

    if ( not @grades ) {
	print "<h3>$lex{'No Student(s) Found'}</h3>\n";
	print "</body></html>\n";
	exit;
    }


    $sth = $dbh->prepare("select lastname, firstname, studnum
     from student where grade = ? order by lastname, firstname");

    # reading from feeder dbase.
    my $sth1 = $dbh1->prepare("select count(*) from read_test where studnum = ?");


    print "<form action=\"$self\" method=\"post\">\n";
    print "<input type=\"hidden\" name=\"page\" value=\"1\">\n";

    print "<p><input type=\"submit\" name=\"\" value=\"$lex{Continue}\"></p>\n";

    print "<table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">\n";
    print "<tr><th colspan=\"3\">$lex{Students}</th></tr>\n";


    foreach my $grade ( @grades ) {

	print "<tr><th colspan=\"3\" style=\"font-size:130%\">$lex{Grade} $grade</th></tr>\n";

	$sth->execute( $grade );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}

	my $count = 1;
	print "<tr>";

	while ( my ( $lastname, $firstname, $studnum ) = $sth->fetchrow ) {

	    # Check for reading records in feeder school.
	    $sth1->execute( $studnum );
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	    my $readcount = $sth1->fetchrow;

	    print "<td>";
	    if ( $readcount ) { print "<input type=\"checkbox\" name=\"$studnum\" value=\"1\"> "; }
	    print "<b>$lastname</b>, $firstname ($studnum) $lex{Tests}:$readcount</td>\n";
	    if ( not ($count % 3) ){ print "</tr>\n<tr>";}
	    $count++;
	}

	if ($count % 3 == 2){ print "<td></td><td></td></tr>\n"; }
	if ($count % 3 == 0){ print "<td></td></tr>\n"; }


    } # Grade Loop

    print "</table><p><input type=\"submit\" name=\"\" value=\"$lex{Continue}\"></p>\n";
    print "</form></center></body></html>\n";


} # end of showStartPage



#---------------
sub writeRecords {
#---------------

    # foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }


    # Local School
    my $sth = $dbh->prepare("select count(*) from read_test 
       where studnum = ? and readlevel = ? and tdate = ?");

    $sth1 = $dbh->prepare("insert into read_test ( studnum, readlevel, tdate, tauthor, tgrade ) 
       values ( ?, ?, ?, ?, ?) "); 

    $sth2 = $dbh->prepare("select id from read_test where studnum = ? and tdate = ? 
       and readlevel = ?");

    $sth3 = $dbh->prepare("insert into read_test_score ( testid, category, name, seq, score ) 
       values ( ?, ?, ?, ?, ?) ");

    my $sth10 = $dbh->prepare("select lastname, firstname, birthdate from student where studnum = ?");




    # Feeder School
    my $sth4 = $dbh1->prepare("select * from read_test where studnum = ?");

    my $sth5 = $dbh1->prepare("select * from read_test_score where testid = ?");


    foreach my $studnum ( keys %arr ) {

	# Get Name
	$sth10->execute($studnum);
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	my ($lastname, $firstname, $birthdate) = $sth10->fetchrow;

	# Get Records from Feeder School
	$sth4->execute( $studnum );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}

	while ( my $ref = $sth4->fetchrow_hashref ) {

	    # Check for an existing record for this student, readlevel, date
	    $sth->execute( $studnum, $ref->{readlevel}, $ref->{tdate} );
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	    my $dupcount = $sth->fetchrow;
	    if ( $dupcount ) {

		print "<div><b>$lex{Skip}:</b> $firstname $lastname ($studnum)";
		print " - $lex{'Read Level'}:$ref->{readlevel} - $lex{Date}:$ref->{tdate}</div>\n";
		next; 

	    } # skip to next feeder record

	    print "<div>$lex{Insert}: $firstname $lastname ($studnum)";
	    print " - $lex{'Read Level'}:$ref->{readlevel} - $lex{Date}:$ref->{tdate}</div>\n";


	    # Insert read_test record and get id for score entry for this test.
	    # First write the test record and get its testid.
	    $sth1->execute( $studnum, $ref->{readlevel}, $ref->{tdate}, $ref->{tauthor}, $ref->{tgrade} );
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    
	    # Now get the id
	    $sth2->execute( $studnum, $ref->{tdate}, $ref->{readlevel} );
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	    my $testid = $sth2->fetchrow;


	    # Loop through all read_test_score records for this read_test, copy to new school
	    $sth5->execute( $ref->{id} ); # read score records for this test
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	    while ( my $scoreref = $sth5->fetchrow_hashref ) {

		# print "Score: $scoreref->{score}<br>\n";

		# Insert the score records into current database.
		$sth3->execute( $testid, $scoreref->{category}, $scoreref->{name}, $scoreref->{seq}, $scoreref->{score} );
		if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

	    } # end of score insert loop

	} # reading test loop
    } # all student loop


    if ( not $DBI::errstr ) {
	print "<h3>$lex{'Record(s) Stored'}</h3>\n";

    } else {
	print "<h3>$lex{Error}:$DBI::errstr<br>\n";
	print "$lex{Contact} $adminname <a href=\"mailto:$adminemail\">$adminemail</a></h3>\n";
    }

    print "<p>[ <a href=\"$homepage\">$lex{Main}</a> | \n";
    print "<a href=\"$exppage\">$lex{Export}</a> | \n";
    print "<a href=\"$self\">$title</a> ]\n";


    print "</p></body></html>\n";

    exit;

}
