-- MySQL dump 10.11
--
-- Host: localhost    Database: tempdb
-- ------------------------------------------------------
-- Server version	5.0.51a-24+lenny3

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `attend`
--

DROP TABLE IF EXISTS `attend`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `attend` (
  `attid` int(11) NOT NULL auto_increment,
  `studentid` int(11) default NULL,
  `absdate` date default NULL,
  `reason` char(60) default NULL,
  `period` char(6) default NULL,
  `subjsec` char(32) default NULL,
  `late` smallint(5) unsigned default NULL,
  PRIMARY KEY  (`attid`)
) ENGINE=MyISAM AUTO_INCREMENT=30967 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `attend_lunch`
--

DROP TABLE IF EXISTS `attend_lunch`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `attend_lunch` (
  `id` int(11) NOT NULL auto_increment,
  `studnum` int(11) default NULL,
  `attdate` date default NULL,
  `fee_type` varchar(32) default NULL,
  `meal_type` varchar(32) default NULL,
  `amount` varchar(255) default NULL,
  `paid` char(1) default NULL,
  `posted` char(1) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `choices`
--

DROP TABLE IF EXISTS `choices`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `choices` (
  `id` int(11) NOT NULL auto_increment,
  `studnum` int(11) default NULL,
  `cdate` date default NULL,
  `category` varchar(255) default NULL,
  `ccode` varchar(255) default NULL,
  `points` int(11) default NULL,
  `comment` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `dates`
--

DROP TABLE IF EXISTS `dates`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `dates` (
  `id` int(11) NOT NULL auto_increment,
  `date` date default NULL,
  `type` varchar(60) default NULL,
  `desc1` varchar(60) default NULL,
  `desc2` varchar(60) default NULL,
  `dayincycle` char(1) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=125 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `dbkdata`
--

DROP TABLE IF EXISTS `dbkdata`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `dbkdata` (
  `id` int(11) NOT NULL auto_increment,
  `userid` varchar(40) default NULL,
  `date` date default NULL,
  `subjsec` varchar(32) default NULL,
  `period` smallint(6) default NULL,
  `topic` varchar(255) default NULL,
  `notes` text,
  `homework` varchar(255) default NULL,
  `hwdate` date default NULL,
  `category` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `discipline`
--

DROP TABLE IF EXISTS `discipline`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `discipline` (
  `id` int(11) NOT NULL auto_increment,
  `date` date default NULL,
  `userid` varchar(60) default NULL,
  `infraction` varchar(255) default NULL,
  `description` text,
  `action` text,
  `ifrepeat` text,
  `parent` varchar(60) default NULL,
  `author` varchar(60) default NULL,
  `private` char(1) default NULL,
  `demerit` tinyint(3) unsigned default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=400 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `eval`
--

DROP TABLE IF EXISTS `eval`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `eval` (
  `id` int(11) NOT NULL auto_increment,
  `subjcode` varchar(32) default NULL,
  `studnum` varchar(32) default NULL,
  `teacher` varchar(32) default NULL,
  `term` int(11) default NULL,
  `program` varchar(255) default NULL,
  `comment` text,
  `a1` varchar(12) default NULL,
  `a2` varchar(12) default NULL,
  `a3` varchar(12) default NULL,
  `a4` varchar(12) default NULL,
  `a5` varchar(12) default NULL,
  `a6` varchar(12) default NULL,
  `a7` varchar(12) default NULL,
  `a8` varchar(12) default NULL,
  `a9` varchar(12) default NULL,
  `a10` varchar(12) default NULL,
  `a11` varchar(12) default NULL,
  `a12` varchar(12) default NULL,
  `a13` varchar(12) default NULL,
  `a14` varchar(12) default NULL,
  `a15` varchar(12) default NULL,
  `a16` varchar(12) default NULL,
  `a17` varchar(12) default NULL,
  `a18` varchar(12) default NULL,
  `a19` varchar(12) default NULL,
  `a20` varchar(12) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=42588 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `evaljrl`
--

DROP TABLE IF EXISTS `evaljrl`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `evaljrl` (
  `id` int(11) NOT NULL auto_increment,
  `subjsec` varchar(32) default NULL,
  `studnum` int(11) default NULL,
  `tdate` date default NULL,
  `type` varchar(10) default NULL,
  `utag` char(1) default NULL,
  `lastname` varchar(40) default NULL,
  `firstname` varchar(40) default NULL,
  `middlename` varchar(40) default NULL,
  `birthdate` date default NULL,
  `identnum` varchar(32) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13496 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `fees_jrl`
--

DROP TABLE IF EXISTS `fees_jrl`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `fees_jrl` (
  `id` int(11) NOT NULL auto_increment,
  `studnum` int(11) default NULL,
  `trans_date` date default NULL,
  `trans_type` varchar(8) default NULL,
  `name` varchar(255) default NULL,
  `description` text,
  `subtotal` decimal(10,2) default NULL,
  `tax1` decimal(10,2) default NULL,
  `tax1_name` varchar(16) default NULL,
  `tax2` decimal(10,2) default NULL,
  `tax2_name` varchar(16) default NULL,
  `tax3` decimal(10,2) default NULL,
  `tax3_name` varchar(16) default NULL,
  `tax4` decimal(10,2) default NULL,
  `tax4_name` varchar(16) default NULL,
  `total` decimal(10,2) default NULL,
  `paid_id` int(11) default NULL,
  `receipt` int(11) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=378 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `fees_predefined`
--

DROP TABLE IF EXISTS `fees_predefined`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `fees_predefined` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(16) default NULL,
  `description` varchar(255) default NULL,
  `amount` double default NULL,
  `discount` double default NULL,
  `tax1_flag` char(1) default NULL,
  `tax2_flag` char(1) default NULL,
  `tax3_flag` char(1) default NULL,
  `tax4_flag` char(1) default NULL,
  `group_name` varchar(32) default NULL,
  `group_value` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `gbscore`
--

DROP TABLE IF EXISTS `gbscore`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `gbscore` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `studnum` mediumint(8) unsigned default NULL,
  `testid` int(10) unsigned default NULL,
  `score` varchar(16) default NULL,
  `comment` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `studtestidx` (`studnum`,`testid`)
) ENGINE=MyISAM AUTO_INCREMENT=257085 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `gbtest`
--

DROP TABLE IF EXISTS `gbtest`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `gbtest` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `subjsec` varchar(32) default NULL,
  `name` varchar(32) default NULL,
  `description` varchar(255) default NULL,
  `tdate` date default NULL,
  `score` varchar(8) default NULL,
  `scheme` varchar(8) default NULL,
  `weight` mediumint(8) unsigned default NULL,
  `grp` varchar(32) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17316 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `infraction`
--

DROP TABLE IF EXISTS `infraction`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `infraction` (
  `id` int(11) NOT NULL auto_increment,
  `name` char(60) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=56 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `lok_link`
--

DROP TABLE IF EXISTS `lok_link`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `lok_link` (
  `locker_num` varchar(8) NOT NULL default '',
  `lock_num` varchar(12) NOT NULL default '',
  PRIMARY KEY  (`locker_num`,`lock_num`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `lok_lock`
--

DROP TABLE IF EXISTS `lok_lock`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `lok_lock` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `lock_num` varchar(12) NOT NULL default '',
  `combination` varchar(12) NOT NULL default '',
  `pool` varchar(12) NOT NULL default '',
  `comment` varchar(64) NOT NULL default '',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `lock_num` (`lock_num`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `lok_locker`
--

DROP TABLE IF EXISTS `lok_locker`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `lok_locker` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `locker_num` varchar(8) NOT NULL default '',
  `cleaned` tinyint(1) default NULL,
  `location` varchar(64) default NULL,
  `comment` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `locker_num` (`locker_num`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `lok_rlink`
--

DROP TABLE IF EXISTS `lok_rlink`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `lok_rlink` (
  `locker_num` varchar(8) NOT NULL default '',
  `studnum` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`locker_num`,`studnum`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `meta`
--

DROP TABLE IF EXISTS `meta`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `meta` (
  `id` int(11) NOT NULL auto_increment,
  `dbaseid` varchar(64) default NULL,
  `tableid` varchar(64) default NULL,
  `fieldid` varchar(64) default NULL,
  `datatype` varchar(16) default NULL,
  `arrayidx` smallint(5) unsigned default NULL,
  `size` smallint(5) unsigned default NULL,
  `fieldname` varchar(255) default NULL,
  `defaultvalue` text,
  `formtype` varchar(255) default NULL,
  `viewsize` varchar(255) default NULL,
  `required` char(1) default NULL,
  `description` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=634 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `prereg`
--

DROP TABLE IF EXISTS `prereg`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `prereg` (
  `studid` int(11) NOT NULL auto_increment,
  `lastname` varchar(40) default NULL,
  `firstname` varchar(40) default NULL,
  `initial` varchar(40) default NULL,
  `studnum` int(11) default NULL,
  `grade` varchar(8) default NULL,
  `homeroom` varchar(8) default NULL,
  `sex` char(1) default NULL,
  `birthdate` date default NULL,
  `house` varchar(20) default NULL,
  `healthid` varchar(12) default NULL,
  `entry` varchar(255) default NULL,
  `ethnic` varchar(20) default NULL,
  `single` char(1) default NULL,
  `internet` char(1) default NULL,
  `youngest` char(1) default NULL,
  `owing` decimal(9,2) default NULL,
  `treaty` varchar(20) default NULL,
  `medical` text,
  `studrel` varchar(25) default NULL,
  `momrel` varchar(25) default NULL,
  `dadrel` varchar(25) default NULL,
  `parish` varchar(255) default NULL,
  `commun` char(1) default NULL,
  `recon` char(1) default NULL,
  `confirm` char(1) default NULL,
  `maiden` varchar(40) default NULL,
  `relation1` varchar(20) default NULL,
  `contact1` varchar(255) default NULL,
  `name1` varchar(255) default NULL,
  `hphone1` varchar(64) default NULL,
  `wphone1` varchar(64) default NULL,
  `cell1` varchar(64) default NULL,
  `fax1` varchar(64) default NULL,
  `address1` varchar(40) default NULL,
  `city1` varchar(40) default NULL,
  `pcode1` varchar(10) default NULL,
  `workplace1` varchar(60) default NULL,
  `relation2` varchar(20) default NULL,
  `contact2` varchar(255) default NULL,
  `name2` varchar(255) default NULL,
  `hphone2` varchar(64) default NULL,
  `wphone2` varchar(64) default NULL,
  `cell2` varchar(64) default NULL,
  `fax2` varchar(64) default NULL,
  `address2` varchar(40) default NULL,
  `city2` varchar(40) default NULL,
  `pcode2` varchar(10) default NULL,
  `workplace2` varchar(60) default NULL,
  `emrelation` varchar(20) default NULL,
  `emname` varchar(255) default NULL,
  `emhphone` varchar(64) default NULL,
  `emwphone` varchar(64) default NULL,
  `emcell` varchar(64) default NULL,
  `doctor` varchar(70) default NULL,
  `docphone` varchar(15) default NULL,
  `busroute` varchar(30) default NULL,
  `provnum` varchar(12) default NULL,
  `band` varchar(64) default NULL,
  `bandnum` varchar(32) default NULL,
  `baptism` char(1) default NULL,
  `contact` varchar(255) default NULL,
  `family` varchar(32) default NULL,
  `alias` varchar(16) default NULL,
  `pic` varchar(255) default NULL,
  `password` varchar(32) default NULL,
  `field1` varchar(255) default NULL,
  `field2` varchar(255) default NULL,
  `field3` varchar(255) default NULL,
  `prov1` varchar(32) default NULL,
  `prov2` varchar(32) default NULL,
  `reserveres` varchar(64) default NULL,
  `program` varchar(64) default NULL,
  `utag` varchar(255) default NULL,
  `email` varchar(255) default NULL,
  `trans_type` varchar(255) default NULL,
  `trans_name` varchar(255) default NULL,
  `trans_am_route` varchar(64) default NULL,
  `trans_pickup_time` varchar(16) default NULL,
  `trans_pm_route` varchar(64) default NULL,
  `trans_dropoff_time` varchar(16) default NULL,
  `trans_bus_stop_location` varchar(64) default NULL,
  `group_after_school_prog` char(1) default NULL,
  `lunchstatus` varchar(255) default NULL,
  `par1_email` varchar(64) default NULL,
  `par2_email` varchar(64) default NULL,
  `name_prefix` varchar(64) default NULL,
  `name_suffix` varchar(64) default NULL,
  `name_knownas` varchar(64) default NULL,
  `group_alt1` varchar(64) default NULL,
  `group_alt2` varchar(64) default NULL,
  `group_alt3` varchar(64) default NULL,
  `billet` varchar(255) default NULL,
  `childcare_name` varchar(255) default NULL,
  `childcare_address` varchar(255) default NULL,
  `childcare_phone1` varchar(255) default NULL,
  `childcare_phone2` varchar(255) default NULL,
  `internet_type` varchar(255) default NULL,
  `par1_firstname` varchar(255) default NULL,
  `par1_lastname` varchar(255) default NULL,
  `par2_firstname` varchar(255) default NULL,
  `par2_lastname` varchar(255) default NULL,
  `graddate` date default NULL,
  `ldap_uid` varchar(64) default NULL,
  `ldap_uidnumber` mediumint(9) default NULL,
  `ldap_gidnumber` mediumint(9) default NULL,
  `address_land` varchar(32) default NULL,
  `tuition_status` varchar(64) default NULL,
  `tuition_duration` varchar(64) default NULL,
  `tuition_program` varchar(128) default NULL,
  `tuition_collect` tinyint(4) default NULL,
  `tuition_country` varchar(8) default NULL,
  `immersion_type` varchar(32) default NULL,
  `cumfolder` tinyint(4) default NULL,
  `address1mailing` varchar(128) default NULL,
  `address2mailing` varchar(128) default NULL,
  PRIMARY KEY  (`studid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `prereg_staff`
--

DROP TABLE IF EXISTS `prereg_staff`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `prereg_staff` (
  `id` int(11) NOT NULL auto_increment,
  `sal` varchar(6) default NULL,
  `lastname` varchar(60) default NULL,
  `firstname` varchar(40) default NULL,
  `middlename` varchar(40) default NULL,
  `userid` varchar(40) default NULL,
  `password` varchar(255) default NULL,
  `email` varchar(255) default NULL,
  `tdate` date default NULL,
  `doatt` char(1) default NULL,
  `certification1` varchar(255) default NULL,
  `home_phone` varchar(64) default NULL,
  `cell_phone` varchar(64) default NULL,
  `street` varchar(64) default NULL,
  `city` varchar(32) default NULL,
  `prov` varchar(32) default NULL,
  `pcode` varchar(32) default NULL,
  `emergency_contact_name` varchar(255) default NULL,
  `emergency_contact_phone` varchar(255) default NULL,
  `driver_license` varchar(64) default NULL,
  `driver_class` varchar(64) default NULL,
  `vehicle_reg` varchar(64) default NULL,
  `vehicle_plate` varchar(64) default NULL,
  `citizenship` varchar(64) default NULL,
  `passport` varchar(64) default NULL,
  `alt_street` varchar(64) default NULL,
  `alt_city` varchar(32) default NULL,
  `alt_prov` varchar(32) default NULL,
  `alt_country` varchar(64) default NULL,
  `alt_pcode` varchar(32) default NULL,
  `alt_phone` varchar(64) default NULL,
  `alt_email` varchar(64) default NULL,
  `certification2` varchar(255) default NULL,
  `certification3` varchar(255) default NULL,
  `certification4` varchar(255) default NULL,
  `certification5` varchar(255) default NULL,
  `certification6` varchar(255) default NULL,
  `certification7` varchar(255) default NULL,
  `certification8` varchar(255) default NULL,
  `ldap_uid` varchar(64) default NULL,
  `ldap_uidnumber` mediumint(9) default NULL,
  `ldap_gidnumber` mediumint(9) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `prereg_staff_multi`
--

DROP TABLE IF EXISTS `prereg_staff_multi`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `prereg_staff_multi` (
  `id` int(11) NOT NULL auto_increment,
  `userid` varchar(32) default NULL,
  `field_name` varchar(255) default NULL,
  `field_value` varchar(255) default NULL,
  `field_additional` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `prereg_waitlist`
--

DROP TABLE IF EXISTS `prereg_waitlist`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `prereg_waitlist` (
  `id` int(11) NOT NULL auto_increment,
  `studnum` int(11) default NULL,
  `enroldate` date default NULL,
  `waitnumber` int(11) default NULL,
  `description` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `preset`
--

DROP TABLE IF EXISTS `preset`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `preset` (
  `id` int(11) NOT NULL auto_increment,
  `lastname` char(40) default NULL,
  `firstname` char(40) default NULL,
  `initial` char(2) default NULL,
  `studnum` int(11) default NULL,
  `grade` char(2) default NULL,
  `homeroom` char(4) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=494 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `preteacher`
--

DROP TABLE IF EXISTS `preteacher`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `preteacher` (
  `teachid` int(11) NOT NULL auto_increment,
  `sal` char(6) default NULL,
  `lname` char(60) default NULL,
  `fname` char(40) default NULL,
  `userid` char(40) default NULL,
  `passwd` char(255) default NULL,
  `homeroom` char(10) default NULL,
  `email` char(255) default NULL,
  `school` char(20) default NULL,
  `date` date default NULL,
  `grade` char(10) default NULL,
  `position` char(255) default NULL,
  `doatt` char(1) default NULL,
  `certif` char(32) default NULL,
  PRIMARY KEY  (`teachid`)
) ENGINE=MyISAM AUTO_INCREMENT=54 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `rc_obj_choice`
--

DROP TABLE IF EXISTS `rc_obj_choice`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `rc_obj_choice` (
  `id` int(11) NOT NULL auto_increment,
  `objid` int(11) default NULL,
  `choice` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=282 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `rc_obj_eval`
--

DROP TABLE IF EXISTS `rc_obj_eval`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `rc_obj_eval` (
  `id` int(11) NOT NULL auto_increment,
  `studnum` int(11) default NULL,
  `objid` int(11) default NULL,
  `term` tinyint(3) unsigned default NULL,
  `eval` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5779 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `rc_objective`
--

DROP TABLE IF EXISTS `rc_objective`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `rc_objective` (
  `id` int(11) NOT NULL auto_increment,
  `subjsec` varchar(32) default NULL,
  `description` text,
  `groupname` varchar(64) default NULL,
  `groupseq` int(11) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=84 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `rc_subject`
--

DROP TABLE IF EXISTS `rc_subject`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `rc_subject` (
  `id` int(11) NOT NULL auto_increment,
  `subjsec` varchar(32) default NULL,
  `description` varchar(255) default NULL,
  `smdesc` varchar(8) default NULL,
  `startterm` tinyint(3) unsigned default NULL,
  `endterm` tinyint(3) unsigned default NULL,
  `sequence` int(11) default NULL,
  `studgrpname` varchar(255) default NULL,
  `studgrpvalue` varchar(255) default NULL,
  `markscheme` text,
  `schedppc1` int(11) default NULL,
  `schedppc2` int(11) default NULL,
  `schedppc3` int(11) default NULL,
  `schedppc4` int(11) default NULL,
  `backwith` varchar(16) default NULL,
  `credit` varchar(8) default NULL,
  `difficulty` varchar(4) default NULL,
  `area` varchar(255) default NULL,
  `calcavg` char(1) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `rc_teacher`
--

DROP TABLE IF EXISTS `rc_teacher`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `rc_teacher` (
  `id` int(11) NOT NULL auto_increment,
  `subjsec` varchar(32) default NULL,
  `userid` varchar(40) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=58 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `read_test`
--

DROP TABLE IF EXISTS `read_test`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `read_test` (
  `id` int(11) NOT NULL auto_increment,
  `studnum` int(11) default NULL,
  `readlevel` varchar(4) default NULL,
  `tdate` date default NULL,
  `tauthor` varchar(40) default NULL,
  `tgrade` varchar(8) default NULL,
  `tstamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `read_test_score`
--

DROP TABLE IF EXISTS `read_test_score`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `read_test_score` (
  `id` int(11) NOT NULL auto_increment,
  `testid` int(11) default NULL,
  `category` text,
  `name` text,
  `seq` int(11) default NULL,
  `score` int(11) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `schedat`
--

DROP TABLE IF EXISTS `schedat`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `schedat` (
  `id` int(11) NOT NULL auto_increment,
  `day` tinyint(4) default NULL,
  `period` tinyint(4) default NULL,
  `subjsec` varchar(32) default NULL,
  `grade` varchar(32) default NULL,
  `term` tinyint(3) unsigned default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `sessions` (
  `id` varchar(32) NOT NULL default '',
  `a_session` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `staff`
--

DROP TABLE IF EXISTS `staff`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `staff` (
  `id` int(11) NOT NULL auto_increment,
  `sal` varchar(6) default NULL,
  `lastname` varchar(60) default NULL,
  `firstname` varchar(40) default NULL,
  `middlename` varchar(40) default NULL,
  `userid` varchar(40) default NULL,
  `password` varchar(255) default NULL,
  `email` varchar(255) default NULL,
  `tdate` date default NULL,
  `doatt` char(1) default NULL,
  `certification1` varchar(255) default NULL,
  `home_phone` varchar(64) default NULL,
  `cell_phone` varchar(64) default NULL,
  `street` varchar(64) default NULL,
  `city` varchar(32) default NULL,
  `prov` varchar(32) default NULL,
  `pcode` varchar(32) default NULL,
  `emergency_contact_name` varchar(255) default NULL,
  `emergency_contact_phone` varchar(255) default NULL,
  `driver_license` varchar(64) default NULL,
  `driver_class` varchar(64) default NULL,
  `vehicle_reg` varchar(64) default NULL,
  `vehicle_plate` varchar(64) default NULL,
  `citizenship` varchar(64) default NULL,
  `passport` varchar(64) default NULL,
  `alt_street` varchar(64) default NULL,
  `alt_city` varchar(32) default NULL,
  `alt_prov` varchar(32) default NULL,
  `alt_country` varchar(64) default NULL,
  `alt_pcode` varchar(32) default NULL,
  `alt_phone` varchar(64) default NULL,
  `alt_email` varchar(64) default NULL,
  `certification2` varchar(255) default NULL,
  `certification3` varchar(255) default NULL,
  `certification4` varchar(255) default NULL,
  `certification5` varchar(255) default NULL,
  `certification6` varchar(255) default NULL,
  `certification7` varchar(255) default NULL,
  `certification8` varchar(255) default NULL,
  `ldap_uid` varchar(64) default NULL,
  `ldap_uidnumber` mediumint(9) default NULL,
  `ldap_gidnumber` mediumint(9) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=51 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `staff_multi`
--

DROP TABLE IF EXISTS `staff_multi`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `staff_multi` (
  `id` int(11) NOT NULL auto_increment,
  `userid` varchar(32) default NULL,
  `field_name` varchar(255) default NULL,
  `field_value` varchar(255) default NULL,
  `field_additional` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=140 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `student`
--

DROP TABLE IF EXISTS `student`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `student` (
  `studid` int(11) NOT NULL auto_increment,
  `lastname` varchar(40) default NULL,
  `firstname` varchar(40) default NULL,
  `initial` varchar(40) default NULL,
  `studnum` int(11) default NULL,
  `grade` varchar(8) default NULL,
  `homeroom` varchar(8) default NULL,
  `sex` char(1) default NULL,
  `birthdate` date default NULL,
  `house` varchar(20) default NULL,
  `healthid` varchar(12) default NULL,
  `entry` varchar(255) default NULL,
  `ethnic` varchar(20) default NULL,
  `single` char(1) default NULL,
  `internet` char(1) default NULL,
  `youngest` char(1) default NULL,
  `owing` decimal(9,2) default NULL,
  `treaty` varchar(20) default NULL,
  `medical` text,
  `studrel` varchar(25) default NULL,
  `momrel` varchar(25) default NULL,
  `dadrel` varchar(25) default NULL,
  `parish` varchar(255) default NULL,
  `commun` char(1) default NULL,
  `recon` char(1) default NULL,
  `confirm` char(1) default NULL,
  `maiden` varchar(40) default NULL,
  `relation1` varchar(20) default NULL,
  `contact1` varchar(255) default NULL,
  `name1` varchar(255) default NULL,
  `hphone1` varchar(64) default NULL,
  `wphone1` varchar(64) default NULL,
  `cell1` varchar(64) default NULL,
  `fax1` varchar(64) default NULL,
  `address1` varchar(40) default NULL,
  `city1` varchar(40) default NULL,
  `pcode1` varchar(10) default NULL,
  `workplace1` varchar(60) default NULL,
  `relation2` varchar(20) default NULL,
  `contact2` varchar(255) default NULL,
  `name2` varchar(255) default NULL,
  `hphone2` varchar(64) default NULL,
  `wphone2` varchar(64) default NULL,
  `cell2` varchar(64) default NULL,
  `fax2` varchar(64) default NULL,
  `address2` varchar(40) default NULL,
  `city2` varchar(40) default NULL,
  `pcode2` varchar(10) default NULL,
  `workplace2` varchar(60) default NULL,
  `emrelation` varchar(20) default NULL,
  `emname` varchar(255) default NULL,
  `emhphone` varchar(64) default NULL,
  `emwphone` varchar(64) default NULL,
  `emcell` varchar(64) default NULL,
  `doctor` varchar(70) default NULL,
  `docphone` varchar(15) default NULL,
  `busroute` varchar(30) default NULL,
  `provnum` varchar(12) default NULL,
  `band` varchar(64) default NULL,
  `bandnum` varchar(32) default NULL,
  `baptism` char(1) default NULL,
  `contact` varchar(255) default NULL,
  `family` varchar(32) default NULL,
  `alias` varchar(16) default NULL,
  `pic` varchar(255) default NULL,
  `password` varchar(32) default NULL,
  `field1` varchar(255) default NULL,
  `field2` varchar(255) default NULL,
  `field3` varchar(255) default NULL,
  `prov1` varchar(32) default NULL,
  `prov2` varchar(32) default NULL,
  `reserveres` varchar(64) default NULL,
  `program` varchar(64) default NULL,
  `utag` varchar(255) default NULL,
  `email` varchar(255) default NULL,
  `trans_type` varchar(255) default NULL,
  `trans_name` varchar(255) default NULL,
  `trans_am_route` varchar(64) default NULL,
  `trans_pickup_time` varchar(16) default NULL,
  `trans_pm_route` varchar(64) default NULL,
  `trans_dropoff_time` varchar(16) default NULL,
  `trans_bus_stop_location` varchar(64) default NULL,
  `group_after_school_prog` char(1) default NULL,
  `lunchstatus` varchar(255) default NULL,
  `par1_email` varchar(64) default NULL,
  `par2_email` varchar(64) default NULL,
  `name_prefix` varchar(64) default NULL,
  `name_suffix` varchar(64) default NULL,
  `name_knownas` varchar(64) default NULL,
  `group_alt1` varchar(64) default NULL,
  `group_alt2` varchar(64) default NULL,
  `group_alt3` varchar(64) default NULL,
  `billet` varchar(255) default NULL,
  `childcare_name` varchar(255) default NULL,
  `childcare_address` varchar(255) default NULL,
  `childcare_phone1` varchar(255) default NULL,
  `childcare_phone2` varchar(255) default NULL,
  `internet_type` varchar(255) default NULL,
  `par1_firstname` varchar(255) default NULL,
  `par1_lastname` varchar(255) default NULL,
  `par2_firstname` varchar(255) default NULL,
  `par2_lastname` varchar(255) default NULL,
  `graddate` date default NULL,
  `ldap_uid` varchar(64) default NULL,
  `ldap_uidnumber` mediumint(9) default NULL,
  `ldap_gidnumber` mediumint(9) default NULL,
  `address_land` varchar(32) default NULL,
  `tuition_status` varchar(64) default NULL,
  `tuition_duration` varchar(64) default NULL,
  `tuition_program` varchar(128) default NULL,
  `tuition_collect` tinyint(4) default NULL,
  `tuition_country` varchar(8) default NULL,
  `immersion_type` varchar(32) default NULL,
  `cumfolder` tinyint(4) default NULL,
  `address1mailing` varchar(128) default NULL,
  `address2mailing` varchar(128) default NULL,
  PRIMARY KEY  (`studid`)
) ENGINE=MyISAM AUTO_INCREMENT=1258 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `student_inac`
--

DROP TABLE IF EXISTS `student_inac`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `student_inac` (
  `id` int(11) NOT NULL auto_increment,
  `studnum` varchar(32) default NULL,
  `status_code` varchar(255) default NULL,
  `fte` varchar(255) default NULL,
  `residence` varchar(255) default NULL,
  `accommodation` varchar(255) default NULL,
  `transportation_daily` varchar(255) default NULL,
  `transportation_other` varchar(255) default NULL,
  `language_home` varchar(255) default NULL,
  `language_instruction` varchar(255) default NULL,
  `language_extent` varchar(255) default NULL,
  `financial_edu` varchar(16) default NULL,
  `residence_band` varchar(16) default NULL,
  `residence_reserve` varchar(16) default NULL,
  `highcost` varchar(16) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `student_medical`
--

DROP TABLE IF EXISTS `student_medical`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `student_medical` (
  `id` int(11) NOT NULL auto_increment,
  `studnum` int(11) default NULL,
  `category` varchar(255) default NULL,
  `description` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Temporary table structure for view `studentall`
--

DROP TABLE IF EXISTS `studentall`;
/*!50001 DROP VIEW IF EXISTS `studentall`*/;
/*!50001 CREATE TABLE `studentall` (
  `studid` int(11),
  `lastname` varchar(40),
  `firstname` varchar(40),
  `initial` varchar(40),
  `studnum` int(11),
  `grade` varchar(8),
  `homeroom` varchar(8),
  `sex` char(1),
  `birthdate` date,
  `house` varchar(20),
  `healthid` varchar(12),
  `entry` varchar(255),
  `ethnic` varchar(20),
  `single` char(1),
  `internet` char(1),
  `youngest` char(1),
  `owing` decimal(9,2),
  `treaty` varchar(20),
  `medical` text,
  `studrel` varchar(25),
  `momrel` varchar(25),
  `dadrel` varchar(25),
  `parish` varchar(255),
  `commun` char(1),
  `recon` char(1),
  `confirm` char(1),
  `maiden` varchar(40),
  `relation1` varchar(20),
  `contact1` varchar(255),
  `name1` varchar(255),
  `hphone1` varchar(64),
  `wphone1` varchar(64),
  `cell1` varchar(64),
  `fax1` varchar(64),
  `address1` varchar(40),
  `city1` varchar(40),
  `pcode1` varchar(10),
  `workplace1` varchar(60),
  `relation2` varchar(20),
  `contact2` varchar(255),
  `name2` varchar(255),
  `hphone2` varchar(64),
  `wphone2` varchar(64),
  `cell2` varchar(64),
  `fax2` varchar(64),
  `address2` varchar(40),
  `city2` varchar(40),
  `pcode2` varchar(10),
  `workplace2` varchar(60),
  `emrelation` varchar(20),
  `emname` varchar(255),
  `emhphone` varchar(64),
  `emwphone` varchar(64),
  `emcell` varchar(64),
  `doctor` varchar(70),
  `docphone` varchar(15),
  `busroute` varchar(30),
  `provnum` varchar(12),
  `band` varchar(64),
  `bandnum` varchar(32),
  `baptism` char(1),
  `contact` varchar(255),
  `family` varchar(32),
  `alias` varchar(16),
  `pic` varchar(255),
  `password` varchar(32),
  `field1` varchar(255),
  `field2` varchar(255),
  `field3` varchar(255),
  `prov1` varchar(32),
  `prov2` varchar(32),
  `reserveres` varchar(64),
  `program` varchar(64),
  `utag` varchar(255),
  `email` varchar(255),
  `trans_type` varchar(255),
  `trans_name` varchar(255),
  `trans_am_route` varchar(64),
  `trans_pickup_time` varchar(16),
  `trans_pm_route` varchar(64),
  `trans_dropoff_time` varchar(16),
  `trans_bus_stop_location` varchar(64),
  `group_after_school_prog` char(1),
  `lunchstatus` varchar(255),
  `par1_email` varchar(64),
  `par2_email` varchar(64),
  `name_prefix` varchar(64),
  `name_suffix` varchar(64),
  `name_knownas` varchar(64),
  `group_alt1` varchar(64),
  `group_alt2` varchar(64),
  `group_alt3` varchar(64),
  `billet` varchar(255),
  `childcare_name` varchar(255),
  `childcare_address` varchar(255),
  `childcare_phone1` varchar(255),
  `childcare_phone2` varchar(255),
  `internet_type` varchar(255),
  `par1_firstname` varchar(255),
  `par1_lastname` varchar(255),
  `par2_firstname` varchar(255),
  `par2_lastname` varchar(255),
  `graddate` date,
  `ldap_uid` varchar(64),
  `ldap_uidnumber` mediumint(8),
  `ldap_gidnumber` mediumint(8),
  `address_land` varchar(32),
  `tuition_status` varchar(64),
  `tuition_duration` varchar(64),
  `tuition_program` varchar(128),
  `tuition_collect` tinyint(4),
  `tuition_country` varchar(8),
  `immersion_type` varchar(32),
  `cumfolder` tinyint(4),
  `address1mailing` varchar(128),
  `address2mailing` varchar(128)
) */;

--
-- Table structure for table `studentwd`
--

DROP TABLE IF EXISTS `studentwd`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `studentwd` (
  `studid` int(11) NOT NULL auto_increment,
  `lastname` varchar(40) default NULL,
  `firstname` varchar(40) default NULL,
  `initial` varchar(40) default NULL,
  `studnum` int(11) default NULL,
  `grade` varchar(8) default NULL,
  `homeroom` varchar(8) default NULL,
  `sex` char(1) default NULL,
  `birthdate` date default NULL,
  `house` varchar(20) default NULL,
  `healthid` varchar(12) default NULL,
  `entry` varchar(255) default NULL,
  `ethnic` varchar(20) default NULL,
  `single` char(1) default NULL,
  `internet` char(1) default NULL,
  `youngest` char(1) default NULL,
  `owing` decimal(9,2) default NULL,
  `treaty` varchar(20) default NULL,
  `medical` text,
  `studrel` varchar(25) default NULL,
  `momrel` varchar(25) default NULL,
  `dadrel` varchar(25) default NULL,
  `parish` varchar(255) default NULL,
  `commun` char(1) default NULL,
  `recon` char(1) default NULL,
  `confirm` char(1) default NULL,
  `maiden` varchar(40) default NULL,
  `relation1` varchar(20) default NULL,
  `contact1` varchar(255) default NULL,
  `name1` varchar(255) default NULL,
  `hphone1` varchar(64) default NULL,
  `wphone1` varchar(64) default NULL,
  `cell1` varchar(64) default NULL,
  `fax1` varchar(64) default NULL,
  `address1` varchar(40) default NULL,
  `city1` varchar(40) default NULL,
  `pcode1` varchar(10) default NULL,
  `workplace1` varchar(60) default NULL,
  `relation2` varchar(20) default NULL,
  `contact2` varchar(255) default NULL,
  `name2` varchar(255) default NULL,
  `hphone2` varchar(64) default NULL,
  `wphone2` varchar(64) default NULL,
  `cell2` varchar(64) default NULL,
  `fax2` varchar(64) default NULL,
  `address2` varchar(40) default NULL,
  `city2` varchar(40) default NULL,
  `pcode2` varchar(10) default NULL,
  `workplace2` varchar(60) default NULL,
  `emrelation` varchar(20) default NULL,
  `emname` varchar(255) default NULL,
  `emhphone` varchar(64) default NULL,
  `emwphone` varchar(64) default NULL,
  `emcell` varchar(64) default NULL,
  `doctor` varchar(70) default NULL,
  `docphone` varchar(15) default NULL,
  `busroute` varchar(30) default NULL,
  `provnum` varchar(12) default NULL,
  `band` varchar(64) default NULL,
  `bandnum` varchar(32) default NULL,
  `baptism` char(1) default NULL,
  `contact` varchar(255) default NULL,
  `family` varchar(32) default NULL,
  `alias` varchar(16) default NULL,
  `pic` varchar(255) default NULL,
  `password` varchar(32) default NULL,
  `field1` varchar(255) default NULL,
  `field2` varchar(255) default NULL,
  `field3` varchar(255) default NULL,
  `prov1` varchar(32) default NULL,
  `prov2` varchar(32) default NULL,
  `reserveres` varchar(64) default NULL,
  `program` varchar(64) default NULL,
  `utag` varchar(255) default NULL,
  `email` varchar(255) default NULL,
  `trans_type` varchar(255) default NULL,
  `trans_name` varchar(255) default NULL,
  `trans_am_route` varchar(64) default NULL,
  `trans_pickup_time` varchar(16) default NULL,
  `trans_pm_route` varchar(64) default NULL,
  `trans_dropoff_time` varchar(16) default NULL,
  `trans_bus_stop_location` varchar(64) default NULL,
  `group_after_school_prog` char(1) default NULL,
  `lunchstatus` varchar(255) default NULL,
  `par1_email` varchar(64) default NULL,
  `par2_email` varchar(64) default NULL,
  `name_prefix` varchar(64) default NULL,
  `name_suffix` varchar(64) default NULL,
  `name_knownas` varchar(64) default NULL,
  `group_alt1` varchar(64) default NULL,
  `group_alt2` varchar(64) default NULL,
  `group_alt3` varchar(64) default NULL,
  `billet` varchar(255) default NULL,
  `childcare_name` varchar(255) default NULL,
  `childcare_address` varchar(255) default NULL,
  `childcare_phone1` varchar(255) default NULL,
  `childcare_phone2` varchar(255) default NULL,
  `internet_type` varchar(255) default NULL,
  `par1_firstname` varchar(255) default NULL,
  `par1_lastname` varchar(255) default NULL,
  `par2_firstname` varchar(255) default NULL,
  `par2_lastname` varchar(255) default NULL,
  `graddate` date default NULL,
  `ldap_uid` varchar(64) default NULL,
  `ldap_uidnumber` mediumint(9) default NULL,
  `ldap_gidnumber` mediumint(9) default NULL,
  `address_land` varchar(32) default NULL,
  `tuition_status` varchar(64) default NULL,
  `tuition_duration` varchar(64) default NULL,
  `tuition_program` varchar(128) default NULL,
  `tuition_collect` tinyint(4) default NULL,
  `tuition_country` varchar(8) default NULL,
  `immersion_type` varchar(32) default NULL,
  `cumfolder` tinyint(4) default NULL,
  `address1mailing` varchar(128) default NULL,
  `address2mailing` varchar(128) default NULL,
  PRIMARY KEY  (`studid`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `subject`
--

DROP TABLE IF EXISTS `subject`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `subject` (
  `id` int(11) NOT NULL auto_increment,
  `subjcode` varchar(32) default NULL,
  `description` varchar(255) default NULL,
  `grade` varchar(8) default NULL,
  `teacher` varchar(255) default NULL,
  `modules` varchar(255) default NULL,
  `type` varchar(10) default NULL,
  `sequence` int(11) default NULL,
  `section` varchar(32) default NULL,
  `subjsec` varchar(32) default NULL,
  `q1` varchar(255) default NULL,
  `q2` varchar(255) default NULL,
  `q3` varchar(255) default NULL,
  `q4` varchar(255) default NULL,
  `q5` varchar(255) default NULL,
  `q6` varchar(255) default NULL,
  `q7` varchar(255) default NULL,
  `q8` varchar(255) default NULL,
  `q9` varchar(255) default NULL,
  `q10` varchar(255) default NULL,
  `q11` varchar(255) default NULL,
  `q12` varchar(255) default NULL,
  `q13` varchar(255) default NULL,
  `q14` varchar(255) default NULL,
  `q15` varchar(255) default NULL,
  `q16` varchar(255) default NULL,
  `q17` varchar(255) default NULL,
  `q18` varchar(255) default NULL,
  `q19` varchar(255) default NULL,
  `q20` varchar(255) default NULL,
  `alias` varchar(16) default NULL,
  `visible` char(1) default NULL,
  `startrptperiod` tinyint(3) unsigned default NULL,
  `endrptperiod` tinyint(3) unsigned default NULL,
  `markscheme` text,
  `faculty` varchar(255) default NULL,
  `location` varchar(255) default NULL,
  `smdesc` varchar(8) default NULL,
  `instmode` varchar(64) default NULL,
  `exammix` varchar(64) default NULL,
  `active` char(1) default NULL,
  `schedppc1` int(11) default NULL,
  `schedppc2` int(11) default NULL,
  `schedppc3` int(11) default NULL,
  `schedppc4` int(11) default NULL,
  `backwith` varchar(16) default NULL,
  `credit` varchar(8) default NULL,
  `difficulty` varchar(8) default NULL,
  `area` varchar(255) default NULL,
  `calcavg` char(1) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=292 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `tattend`
--

DROP TABLE IF EXISTS `tattend`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `tattend` (
  `attid` int(11) NOT NULL auto_increment,
  `techid` char(20) default NULL,
  `date` datetime default NULL,
  PRIMARY KEY  (`attid`)
) ENGINE=MyISAM AUTO_INCREMENT=18119 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `transfer`
--

DROP TABLE IF EXISTS `transfer`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `transfer` (
  `id` int(11) NOT NULL auto_increment,
  `studnum` int(11) default NULL,
  `date` date default NULL,
  `type` varchar(10) default NULL,
  `description` varchar(255) default NULL,
  `entrytype` varchar(8) default NULL,
  `exittype` varchar(8) default NULL,
  `prov` varchar(8) default NULL,
  `country` varchar(8) default NULL,
  `utag` char(1) default NULL,
  `lastname` varchar(40) default NULL,
  `firstname` varchar(40) default NULL,
  `middlename` varchar(40) default NULL,
  `birthdate` date default NULL,
  `provnum` varchar(12) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2272 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `tscriptdata`
--

DROP TABLE IF EXISTS `tscriptdata`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `tscriptdata` (
  `id` int(11) NOT NULL auto_increment,
  `studnum` int(11) default NULL,
  `subjectcode` char(32) default NULL,
  `subjecttext` char(255) default NULL,
  `subjectarea` char(255) default NULL,
  `score_mark` char(32) default NULL,
  `score_letter` char(4) default NULL,
  `score_diff` char(4) default NULL,
  `schoolyear` char(16) default NULL,
  `crdate` date default NULL,
  `credit` char(16) default NULL,
  `term` int(11) default NULL,
  `term_desc` char(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `tscriptident`
--

DROP TABLE IF EXISTS `tscriptident`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `tscriptident` (
  `id` int(11) NOT NULL auto_increment,
  `studnum` int(11) default NULL,
  `lastname` char(40) default NULL,
  `firstname` char(40) default NULL,
  `middlename` char(40) default NULL,
  `birthdate` date default NULL,
  `studentid` char(32) default NULL,
  `graddate` date default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `xlat_hint`
--

DROP TABLE IF EXISTS `xlat_hint`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `xlat_hint` (
  `id` int(11) NOT NULL auto_increment,
  `phrase` text,
  `description` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `xlat_lang`
--

DROP TABLE IF EXISTS `xlat_lang`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `xlat_lang` (
  `id` int(11) NOT NULL auto_increment,
  `language` varchar(64) default NULL,
  `encoding` varchar(64) default NULL,
  `author` varchar(64) default NULL,
  `phrase` text,
  `translation` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `xlat_phrase`
--

DROP TABLE IF EXISTS `xlat_phrase`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `xlat_phrase` (
  `id` int(11) NOT NULL auto_increment,
  `area` varchar(64) default NULL,
  `file` varchar(64) default NULL,
  `phrase` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5443 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Final view structure for view `studentall`
--

/*!50001 DROP TABLE `studentall`*/;
/*!50001 DROP VIEW IF EXISTS `studentall`*/;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `studentall` AS select `student`.`studid` AS `studid`,`student`.`lastname` AS `lastname`,`student`.`firstname` AS `firstname`,`student`.`initial` AS `initial`,`student`.`studnum` AS `studnum`,`student`.`grade` AS `grade`,`student`.`homeroom` AS `homeroom`,`student`.`sex` AS `sex`,`student`.`birthdate` AS `birthdate`,`student`.`house` AS `house`,`student`.`healthid` AS `healthid`,`student`.`entry` AS `entry`,`student`.`ethnic` AS `ethnic`,`student`.`single` AS `single`,`student`.`internet` AS `internet`,`student`.`youngest` AS `youngest`,`student`.`owing` AS `owing`,`student`.`treaty` AS `treaty`,`student`.`medical` AS `medical`,`student`.`studrel` AS `studrel`,`student`.`momrel` AS `momrel`,`student`.`dadrel` AS `dadrel`,`student`.`parish` AS `parish`,`student`.`commun` AS `commun`,`student`.`recon` AS `recon`,`student`.`confirm` AS `confirm`,`student`.`maiden` AS `maiden`,`student`.`relation1` AS `relation1`,`student`.`contact1` AS `contact1`,`student`.`name1` AS `name1`,`student`.`hphone1` AS `hphone1`,`student`.`wphone1` AS `wphone1`,`student`.`cell1` AS `cell1`,`student`.`fax1` AS `fax1`,`student`.`address1` AS `address1`,`student`.`city1` AS `city1`,`student`.`pcode1` AS `pcode1`,`student`.`workplace1` AS `workplace1`,`student`.`relation2` AS `relation2`,`student`.`contact2` AS `contact2`,`student`.`name2` AS `name2`,`student`.`hphone2` AS `hphone2`,`student`.`wphone2` AS `wphone2`,`student`.`cell2` AS `cell2`,`student`.`fax2` AS `fax2`,`student`.`address2` AS `address2`,`student`.`city2` AS `city2`,`student`.`pcode2` AS `pcode2`,`student`.`workplace2` AS `workplace2`,`student`.`emrelation` AS `emrelation`,`student`.`emname` AS `emname`,`student`.`emhphone` AS `emhphone`,`student`.`emwphone` AS `emwphone`,`student`.`emcell` AS `emcell`,`student`.`doctor` AS `doctor`,`student`.`docphone` AS `docphone`,`student`.`busroute` AS `busroute`,`student`.`provnum` AS `provnum`,`student`.`band` AS `band`,`student`.`bandnum` AS `bandnum`,`student`.`baptism` AS `baptism`,`student`.`contact` AS `contact`,`student`.`family` AS `family`,`student`.`alias` AS `alias`,`student`.`pic` AS `pic`,`student`.`password` AS `password`,`student`.`field1` AS `field1`,`student`.`field2` AS `field2`,`student`.`field3` AS `field3`,`student`.`prov1` AS `prov1`,`student`.`prov2` AS `prov2`,`student`.`reserveres` AS `reserveres`,`student`.`program` AS `program`,`student`.`utag` AS `utag`,`student`.`email` AS `email`,`student`.`trans_type` AS `trans_type`,`student`.`trans_name` AS `trans_name`,`student`.`trans_am_route` AS `trans_am_route`,`student`.`trans_pickup_time` AS `trans_pickup_time`,`student`.`trans_pm_route` AS `trans_pm_route`,`student`.`trans_dropoff_time` AS `trans_dropoff_time`,`student`.`trans_bus_stop_location` AS `trans_bus_stop_location`,`student`.`group_after_school_prog` AS `group_after_school_prog`,`student`.`lunchstatus` AS `lunchstatus`,`student`.`par1_email` AS `par1_email`,`student`.`par2_email` AS `par2_email`,`student`.`name_prefix` AS `name_prefix`,`student`.`name_suffix` AS `name_suffix`,`student`.`name_knownas` AS `name_knownas`,`student`.`group_alt1` AS `group_alt1`,`student`.`group_alt2` AS `group_alt2`,`student`.`group_alt3` AS `group_alt3`,`student`.`billet` AS `billet`,`student`.`childcare_name` AS `childcare_name`,`student`.`childcare_address` AS `childcare_address`,`student`.`childcare_phone1` AS `childcare_phone1`,`student`.`childcare_phone2` AS `childcare_phone2`,`student`.`internet_type` AS `internet_type`,`student`.`par1_firstname` AS `par1_firstname`,`student`.`par1_lastname` AS `par1_lastname`,`student`.`par2_firstname` AS `par2_firstname`,`student`.`par2_lastname` AS `par2_lastname`,`student`.`graddate` AS `graddate`,`student`.`ldap_uid` AS `ldap_uid`,`student`.`ldap_uidnumber` AS `ldap_uidnumber`,`student`.`ldap_gidnumber` AS `ldap_gidnumber`,`student`.`address_land` AS `address_land`,`student`.`tuition_status` AS `tuition_status`,`student`.`tuition_duration` AS `tuition_duration`,`student`.`tuition_program` AS `tuition_program`,`student`.`tuition_collect` AS `tuition_collect`,`student`.`tuition_country` AS `tuition_country`,`student`.`immersion_type` AS `immersion_type`,`student`.`cumfolder` AS `cumfolder`,`student`.`address1mailing` AS `address1mailing`,`student`.`address2mailing` AS `address2mailing` from `student` union select `studentwd`.`studid` AS `studid`,`studentwd`.`lastname` AS `lastname`,`studentwd`.`firstname` AS `firstname`,`studentwd`.`initial` AS `initial`,`studentwd`.`studnum` AS `studnum`,`studentwd`.`grade` AS `grade`,`studentwd`.`homeroom` AS `homeroom`,`studentwd`.`sex` AS `sex`,`studentwd`.`birthdate` AS `birthdate`,`studentwd`.`house` AS `house`,`studentwd`.`healthid` AS `healthid`,`studentwd`.`entry` AS `entry`,`studentwd`.`ethnic` AS `ethnic`,`studentwd`.`single` AS `single`,`studentwd`.`internet` AS `internet`,`studentwd`.`youngest` AS `youngest`,`studentwd`.`owing` AS `owing`,`studentwd`.`treaty` AS `treaty`,`studentwd`.`medical` AS `medical`,`studentwd`.`studrel` AS `studrel`,`studentwd`.`momrel` AS `momrel`,`studentwd`.`dadrel` AS `dadrel`,`studentwd`.`parish` AS `parish`,`studentwd`.`commun` AS `commun`,`studentwd`.`recon` AS `recon`,`studentwd`.`confirm` AS `confirm`,`studentwd`.`maiden` AS `maiden`,`studentwd`.`relation1` AS `relation1`,`studentwd`.`contact1` AS `contact1`,`studentwd`.`name1` AS `name1`,`studentwd`.`hphone1` AS `hphone1`,`studentwd`.`wphone1` AS `wphone1`,`studentwd`.`cell1` AS `cell1`,`studentwd`.`fax1` AS `fax1`,`studentwd`.`address1` AS `address1`,`studentwd`.`city1` AS `city1`,`studentwd`.`pcode1` AS `pcode1`,`studentwd`.`workplace1` AS `workplace1`,`studentwd`.`relation2` AS `relation2`,`studentwd`.`contact2` AS `contact2`,`studentwd`.`name2` AS `name2`,`studentwd`.`hphone2` AS `hphone2`,`studentwd`.`wphone2` AS `wphone2`,`studentwd`.`cell2` AS `cell2`,`studentwd`.`fax2` AS `fax2`,`studentwd`.`address2` AS `address2`,`studentwd`.`city2` AS `city2`,`studentwd`.`pcode2` AS `pcode2`,`studentwd`.`workplace2` AS `workplace2`,`studentwd`.`emrelation` AS `emrelation`,`studentwd`.`emname` AS `emname`,`studentwd`.`emhphone` AS `emhphone`,`studentwd`.`emwphone` AS `emwphone`,`studentwd`.`emcell` AS `emcell`,`studentwd`.`doctor` AS `doctor`,`studentwd`.`docphone` AS `docphone`,`studentwd`.`busroute` AS `busroute`,`studentwd`.`provnum` AS `provnum`,`studentwd`.`band` AS `band`,`studentwd`.`bandnum` AS `bandnum`,`studentwd`.`baptism` AS `baptism`,`studentwd`.`contact` AS `contact`,`studentwd`.`family` AS `family`,`studentwd`.`alias` AS `alias`,`studentwd`.`pic` AS `pic`,`studentwd`.`password` AS `password`,`studentwd`.`field1` AS `field1`,`studentwd`.`field2` AS `field2`,`studentwd`.`field3` AS `field3`,`studentwd`.`prov1` AS `prov1`,`studentwd`.`prov2` AS `prov2`,`studentwd`.`reserveres` AS `reserveres`,`studentwd`.`program` AS `program`,`studentwd`.`utag` AS `utag`,`studentwd`.`email` AS `email`,`studentwd`.`trans_type` AS `trans_type`,`studentwd`.`trans_name` AS `trans_name`,`studentwd`.`trans_am_route` AS `trans_am_route`,`studentwd`.`trans_pickup_time` AS `trans_pickup_time`,`studentwd`.`trans_pm_route` AS `trans_pm_route`,`studentwd`.`trans_dropoff_time` AS `trans_dropoff_time`,`studentwd`.`trans_bus_stop_location` AS `trans_bus_stop_location`,`studentwd`.`group_after_school_prog` AS `group_after_school_prog`,`studentwd`.`lunchstatus` AS `lunchstatus`,`studentwd`.`par1_email` AS `par1_email`,`studentwd`.`par2_email` AS `par2_email`,`studentwd`.`name_prefix` AS `name_prefix`,`studentwd`.`name_suffix` AS `name_suffix`,`studentwd`.`name_knownas` AS `name_knownas`,`studentwd`.`group_alt1` AS `group_alt1`,`studentwd`.`group_alt2` AS `group_alt2`,`studentwd`.`group_alt3` AS `group_alt3`,`studentwd`.`billet` AS `billet`,`studentwd`.`childcare_name` AS `childcare_name`,`studentwd`.`childcare_address` AS `childcare_address`,`studentwd`.`childcare_phone1` AS `childcare_phone1`,`studentwd`.`childcare_phone2` AS `childcare_phone2`,`studentwd`.`internet_type` AS `internet_type`,`studentwd`.`par1_firstname` AS `par1_firstname`,`studentwd`.`par1_lastname` AS `par1_lastname`,`studentwd`.`par2_firstname` AS `par2_firstname`,`studentwd`.`par2_lastname` AS `par2_lastname`,`studentwd`.`graddate` AS `graddate`,`studentwd`.`ldap_uid` AS `ldap_uid`,`studentwd`.`ldap_uidnumber` AS `ldap_uidnumber`,`studentwd`.`ldap_gidnumber` AS `ldap_gidnumber`,`studentwd`.`address_land` AS `address_land`,`studentwd`.`tuition_status` AS `tuition_status`,`studentwd`.`tuition_duration` AS `tuition_duration`,`studentwd`.`tuition_program` AS `tuition_program`,`studentwd`.`tuition_collect` AS `tuition_collect`,`studentwd`.`tuition_country` AS `tuition_country`,`studentwd`.`immersion_type` AS `immersion_type`,`studentwd`.`cumfolder` AS `cumfolder`,`studentwd`.`address1mailing` AS `address1mailing`,`studentwd`.`address2mailing` AS `address2mailing` from `studentwd` */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2010-11-13  2:24:49
