#!/usr/bin/perl

# This file is part of Open Administration for Schools
# Copyright Leslie Richardson 2001-2010
# Licensed under the GNU GPL version 3

my %lex = ( 'Cannot open file' => 'Cannot open file',

	    );

# If more than 1 server to update, this will run an /usr/bin/finish.sh
# script to update the authentication files on the other servers. 
# 1 = Update, 0 = No Updates on other servers.
my $updateMultiServer = 0;
my $updateServerCommand = '/usr/bin/finish.sh';
my $updateChainedServer = 1; # copy userfiles, etc. to new server.

my $remoteuser = 'openadmin'; # account on remote server
my $remotepassword = 'oa37x!'; # password on remote server
my $remoteip = '192.168.0.13'; # IP Address of remote server

my $studentfilelocation = '/home/openadmin';
my $studentaddfile = 'useradd.csv';
my $studentresetfile = 'studentreset.csv';

my $addfilename = "$studentfilelocation/$studentaddfile";
my $resetfilename = "$studentfilelocation/$studentresetfile";

my $useraddex = '/usr/sbin/useradd';
my $passwdex = '/usr/bin/passwd';
my $homedirsbase = '/home';
my $defshell = '/bin/bash';

my $defgroup = 'students'; # must already be defined.

my $response1 = 'New UNIX password: ';
my $response2 = "Retype new UNIX password: ";
my $response3 = "updated successfully.";

my $serverupdateflag;

# check for existence of student add file.
if ( not -e $addfilename and not -e $resetfilename ) {
    exit;
}

use Text::CSV_XS;
use Net::SCP::Expect;


my $csv = Text::CSV_XS->new( {binary => 1} );


#------------ Add Users ----------
if ( -e $addfilename ) { # add users

    print "Working...\n";

    # Open csv file for reading
    unless ( open ( FH,"<$addfilename" ) ) {
	print $lex{'Cannot open file'}. ": $!\n";
	die $lex{'Cannot open file'}. ": $!\n";
    }


    # Create %exists hash of existing accounts
    my %exists = ();
    while ( my ($useracct, $password, $uid, $gid, $quota, $comment, $gcos,
		$duration, $shell, $expire ) = getpwent() ) {
   
	#print "Name: $useracct $uid - $gcos - $shell - $expire\n";
	$exists{ $useracct } = $gcos. q{ - }. $uid;
    }


    my @records = ();
    my %fullname = ();
    my %password = ();

    my $count = 1;

    while ( my $line = <FH> ) {

	#print "LINE: $line<br>\n";

	if ( $csv->parse($line) ) {

	    my ( $fullname, $user, $password, $uid, $uidnumber, $gidnumber ) = $csv->fields;
	    # Only use the last 3 to find and/or create accounts.
	    print "$fullname $uid<br>\n";
	
	    if ( not $exists{ $uid } ) {

		print "$count: $fullname - $uid ($uidnumber - $gidnumber)\n";
		
		insertUser( $uid, $fullname, $password, $uidnumber, $gidnumber );

		$count++;

#		if ( $count > 1 ) { die; } # for testing...

	    }

	} else { # Failure to parse
	    print 'Error Reading Record'. ":<br>$line<br>\n";
	    die;
	}
    }

    close FH;

    if ( $count == 1) { # no users added
	print "Users are up to date\n";
    }

    system("rm -f $addfilename"); # remove OA uploaded file

    if ( $updateMultiServer ) {
	$serverupdateflag = 1;
    }

    # copy to chained server, if present
    if ( $updateChainedServer ) {

	# Copy to external server.
	my $scpe = Net::SCP::Expect->new( auto_yes => 1 );
	$scpe->login( $remoteuser, $remotepassword );
	$scpe->scp( $addfilename, $remoteip. ':useradd.csv' );

    }


} # end of adduserfile.


#----------- Reset Users ----------------
# Now do the resets: lock, unlock, password
if ( -e $resetfilename ) {
    print "Reset File Open \n";

    # Open csv file for reading
    unless ( open ( FH,"<$resetfilename" ) ) {
	print $lex{'Cannot open file'}. ": $!\n";
	die $lex{'Cannot open file'}. ": $!\n";
    }


    while ( my $line = <FH> ) {
	
	#print "LINE: $line<br>\n";

	my $studacct;
	my ( $studnum, $action, $password );
	if ( $csv->parse($line) ) {
	    ( $studnum, $action, $password ) = $csv->fields;
	    $studacct = 's'. $studnum; # prepend an 's' to the account.
	} else { # Failure to parse
	    print 'Error Reading Record'. ":<br>$line<br>\n";
	    die;
	}

	print "Stud: $studacct ($studnum) Action: $action Password: $password\n";

	if ( $action eq 'lock') {
	    system("$passwdex -l $studacct");
	    print "Did Lock\n";
	} elsif ( $action eq 'unlock' ) {
	    system("$passwdex -u $studacct");
	    print "Did Unlock\n";
	} elsif ( $action eq 'reset' ) {
	    # change password
	    changePassword( $studacct, $password );
	    print "Did password update\n";
	}
    }

    system("rm -f $resetfilename"); # remove file

    if ( $updateMultiServer ) {
	$serverupdateflag = 1;
    }

}

if ( $serverupdateflag ) {
    system("$updateServerCommand");
}



#-------------
sub insertUser {  # insert a new user
#-------------

    # Create a user account, passed values
    my ( $userid, $realname, $password, $uidnumber, $gidnumber ) = @_;

     print "User: $userid Real:$realname  Password:$password UID:$uidnumber GID:$gidnumber\n";


    # We only need to set group, homedir, shell, and comment. 

    $homedir = $homedirsbase. '/'. $userid;

    my @command = ();
    push @command, $useraddex;
    # push @command, " -g $defgroup ";
    push @command, " -d '$homedir' ";
    # push @command, " -s $defshell ";
    push @command, " -c '$realname' ";
    push @command, " --uid $uidnumber ";
    push @command, " --gid $gidnumber ";
    push @command, " $userid ";

     print @command;

    system(" @command ");

    print "\nDone!\n";

    # Now Change password
    use Expect;

    my $pobj = Expect->spawn( $passwdex, $userid );
    if ( not defined $pobj ) {
	die "Cannot create pwd object\n";
    }

    # $pobj->log_studout(0);

    $pobj->expect(10, $response1 );
    sleep 1;
    print $pobj "$password\n";

    $pobj->expect(10, $response2 );
    sleep 1;
    print $pobj "$password\n";

    my $result = ( defined ( $pobj->expect(10, $response3 )) ?
		   "" : "password change failed");

    $pobj->soft_close();

} # end of insertUser.



#-----------------
sub changePassword {
#-----------------

    my ( $userid, $password ) = @_;

    # Now Change password
    use Expect;

    my $pobj = Expect->spawn( $passwdex, $userid );
    if ( not defined $pobj ) {
	die "Cannot create pwd object\n";
    }

    # $pobj->log_studout(0);

    $pobj->expect(10, $response1 );
    sleep 1;
    print $pobj "$password\n";

    $pobj->expect(10, $response2 );
    sleep 1;
    print $pobj "$password\n";

    my $result = ( defined ( $pobj->expect(10, $response3 )) ?
		   "" : "password change failed");

    $pobj->soft_close();


}
