#!/usr/bin/perl
#  Copyright 2001-2011 Leslie Richardson

#  This file is part of Open Admin for Schools.

# Find Perl modules required. Place at root of 
# OA installation, below cgi and tcgi directories.

my %lex = ('Main' => 'Main',
	   'Error' => 'Error',
	   'Find Perl Modules' => 'Find Perl Modules',
	   'Cannot open file' => 'Cannot open file',
	   'Done' => 'Done',
	   );


use CGI;
use File::Find;

print $lex{'Find Perl Modules'}. "\n\n";

my %modules = ();
extractModule();
print "\n$lex{Done}!\n";

 

#---------------
sub extractModule {
#---------------

    my $cgipath = 'cgi';
    my $tcgipath = 'tcgi';

    find(\&parseFile, $cgipath );

    find(\&parseFile, $tcgipath );

    foreach my $module ( sort keys %modules ) {
	print "$module\n";
    }


    return;

} # end of extractModule



#------------
sub parseFile {  # extract version
#------------

    my $cgifile = $_;

    if ( $cgifile eq '.' or $cgifile eq '..' ) { return }
    if ( not $cgifile =~ m/.*\.pl/ ) { return }

    # Open File
    unless ( open (FH,"<$cgifile") ) {
	print $lex{'Cannot open file'}. ":$cgifile: $!\n";
	die $lex{'Cannot open file'}. ":$cgifile: $!\n";

    }

    while ( my $line = <FH> ) {
	if ( $line =~ m/^\s*use (.+)/ ){
	    my $temp = $1;
	    $temp =~ s/;//;
	    $temp =~ s/qw.+//;
	    $temp =~ s/\s+$//;
	    $modules{ $temp } = 1;
	}
    }

    return;

} # end of parseFile
