#!/usr/bin/perl

# Add Course Master
use DBI;


my ($password, $dbase) = @ARGV;

if ( not $password ) {
    print "Usage: ./addCourseMaster.pl password dbase\n";
    exit;
}

my $user = 'root';

my @grades = qw(K 1 2 3 4 5 6 7 8 9);
my @hsgrades = qw(10 11 12);


my $dsn = "DBI:MariaDB:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my %courses;
open(FH, "<", "courses.txt");
while (<FH>) {
    my ($gr, $val) = split(':', $_ );
    $val =~ s/\r|\n//;
    my @courses = split(',',$val);
    $courses{$gr} = \@courses;
}
close FH;

my $sth1 = $dbh->prepare("select title from sasked_courses where code = ?");

my $sth2 = $dbh->prepare("select s.userid from staff as s, staff_multi as sm where 
   s.userid = sm.userid and sm.field_name = 'grade' and sm.field_value = ?");

my $sth = $dbh->prepare("insert into subject ( subjcode, description, grade, section, 
subjsec, startrptperiod, endrptperiod, teacher ) values( ?, ?, ?, ?, ?, ?, ?, ?)");

# Elementary Grades
foreach my $grade ( @grades ) {
    my @courses = @{$courses{$grade}};

    # Get teacher
    $sth2->execute($grade);
    if ($DBI::errstr){ print "$lex{Error}: $DBI::errstr; $!\n"; die $DBI::errstr; }
    my $userid = $sth2->fetchrow;
    print qq{Grade $grade Teacher $userid\n};
    
    my $startterm = 1;
    my $endterm = 3;
    my $section = 1;
    
    foreach my $crs ( @courses ) {
	
	# Get description
	$sth1->execute($crs);
	if ($DBI::errstr){ print "$lex{Error}: $DBI::errstr; $!\n"; die $DBI::errstr; }
	my $title = $sth1->fetchrow;
	print qq{$title - $crs\n};
	
	my $subjsec = $crs. q{-}. $section;

	$sth->execute($crs,$title,$grade,$section,$subjsec,$startterm,$endterm, $userid);

    } # end of course loop
} # end of elementary grade loop

# High School
foreach my $grade ( @hsgrades ) {
    my @courses = @{$courses{$grade}};

    # Get teacher
    $sth2->execute($grade);
    if ($DBI::errstr){ print "$lex{Error}: $DBI::errstr; $!\n"; die $DBI::errstr; }
    my $userid = $sth2->fetchrow;
    print qq{Grade $grade Teacher $userid\n};
    
    my ($startterm, $endterm);
    my $section = 1;

    my $semester = 1;    
    foreach my $crs ( @courses ) {

	# toggle semester
	if ( $semester == 1 ){
	    $startterm = 1;
	    $endterm = 2;
	    $semester = 2;
	} else { # semester is 2
	    $startterm = 3;
	    $endterm = 4;
	    $semester = 1;
	}
	
	# Get description
	$sth1->execute($crs);
	if ($DBI::errstr){ print "$lex{Error}: $DBI::errstr; $!\n"; die $DBI::errstr; }
	my $title = $sth1->fetchrow;
	print qq{$title - $crs\n};
	
	my $subjsec = $crs. q{-}. $section;

	$sth->execute($crs,$title,$grade,$section,$subjsec,$startterm,$endterm, $userid);

    } # end of course loop
} # end of elementary grade loop








print "Done!\n";
