#!/usr/bin/perl

# Add Staff...
use DBI;
use Crypt::GeneratePassword qw(:all); # password generation.


my ($password, $dbase) = @ARGV;

if ( not $password ) {
    print "Usage: ./addstaff.pl password dbase\n";
    exit;
}

my $user = 'root';

my @grades = qw(K 1 2 3 4 5 6 7 8 9 10 11 12);
my $staffpergrade = 2;

# Password configuration
$g_studentpwd_caps = 1;
$g_studentpwd_genlen = 6;
$g_studentpwd_maxlen = 6;
$g_studentpwd_minlen = 4;
$g_studentpwd_signs = 0;
$g_studentpwd_minfreq = .001;
$g_studentpwd_avgfreq = .001;
$g_studentpwd_lang = 'en'; # only en or de available.


my $dsn = "DBI:MariaDB:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# Load the names
my @firstname = ();
my @lastname = ();

open(FH, "<firstname.txt");
while (<FH>) {
    chomp $_;
    push @firstname, $_;
}

open(FH, "<lastname.txt");
while (<FH>) {
    chomp $_;
    push @lastname, $_;
}

my $staffcount = $staffpergrade * ( $#grades + 1 );

print "Staffcount: $staffcount\n";


# Create an array of staff names
my %names = ();
for my $counter ( 1 .. $staffcount ) {

    my $newname;
    do {
	my $fnum = int( rand( $#firstname ));
	my $fname = $firstname[$fnum];

	my $lnum = int( rand( $#lastname ));
	my $lname = $lastname[$lnum];

	$newname = "$lname:$fname";

    } until ( not $names{$newname} );
    $names{$newname} = 1;

}

my @names = keys %names; # make a new name array out of hash.


my $sth = $dbh->prepare("insert into staff ( firstname, lastname, userid, password  ) 
 values( ?, ?, ?, ? )");

my $sth1 = $dbh->prepare("insert into staff_multi ( userid, field_name, field_value  ) 
 values( ?, ?, ? )");



foreach my $grade ( @grades ) {
    foreach my $hr ( 'a','b' ) {

	# Get Name
	my $n = pop @names;
	my ($lastname, $firstname ) = split(/:/, $n);


	# Get Password
	my $password = word( $g_studentpwd_minlen, $g_studentpwd_maxlen,
			     $g_studentpwd_lang, $g_studentpwd_signs,
			     $g_studentpwd_caps, $g_studentpwd_minfreq,
			     $g_studentpwd_avgfreq );

	my $fn = lc $firstname;
	my $ln = lc $lastname;
	$ln = substr( $ln, 0, 1);
	my $userid = $fn. $ln;

	my $homeroom = $grade. $hr;

	print "Name:$firstname $lastname ($userid) $grade - $password - $homeroom \n";


	$sth->execute( $firstname, $lastname, $userid, $password );
	if ($DBI::errstr){ print "$lex{Error}: $DBI::errstr; $!\n"; die $DBI::errstr; }

	$sth1->execute( $userid, 'homeroom', $homeroom );
	if ($DBI::errstr){ print "$lex{Error}: $DBI::errstr; $!\n"; die $DBI::errstr; }

	$sth1->execute( $userid, 'grade', $grade );
	if ($DBI::errstr){ print "$lex{Error}: $DBI::errstr; $!\n"; die $DBI::errstr; }

	$sth1->execute( $userid, 'position', 'Classroom Teacher' );
	if ($DBI::errstr){ print "$lex{Error}: $DBI::errstr; $!\n"; die $DBI::errstr; }


    } # end of homeroom loop
} # end of grade loop


print "Done!\n";
