#!/usr/bin/perl
#  Copyright 2001-2022 Leslie Richardson

#  This file is part of Open Admin for Schools.


my %lex = ('Update' => 'Update',
	   'Edit' => 'Edit',
	   'Attendance' => 'Attendance',
	   'Student' => 'Student',
	   'Date' => 'Date',
	   'Reason' => 'Reason',
	   'Record(s) Updated' => 'Record(s) Updated',
	   'Contact' => 'Contact',
	   'Another' => 'Another',
	   'Today' => 'Today',
	   'Yesterday' => 'Yesterday',
	   'All' => 'All',
	   'Period' => 'Period',
	   'Course' => 'Course',
	   'min' => 'min',
	   'Late' => 'Late',
	   'Main' => 'Main',
	   'Error' => 'Error',
	   'Delete' => 'Delete',
	   'Grade' => 'Grade',
	   
	   );

my $self = 'atted.pl';

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@<br>\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $sth = $dbh->prepare("select * from attend where attid = ?"); 
$sth->execute( $arr{id} );
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
my ($attid, $studnum, $absdate, $reason, $period, $subjsec, $late) = $sth->fetchrow;


# Print Page Head.
my $title = "$lex{Edit} $lex{Attendance}";
print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head><body style="padding:1em;">\n};

print qq{[ <a href="$homepage">$lex{Main}</a> | \n};
print qq{<a href="$attpage">$lex{Attendance}</a> ]\n};

print qq{<h1>$title</h1>\n};


if ( $arr{page} ) {
    delete $arr{page};
    updateRecord();
}


# Print Form Header
print qq{<form action="$self" method="post">
<input type="hidden" name="attid" value="$attid">
<input type="hidden" name="page" value="1">\n};

# Get Student Name
$sth = $dbh->prepare("select lastname, firstname, grade from studentall where studnum = ?");
$sth->execute( $studnum  );
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
my ( $lastname, $firstname, $grade ) = $sth->fetchrow;

my $ppd = $g_ppd{$grade};
if ( not $ppd ) { print qq{<h3>$lex{Error}: Periods per Day not defined for $lex{Grade} $grade</h3>\n}; }

# Name and Student Number
print qq{<table cellpadding="3" cellspacing="0" border="0" };
print qq{style="border:1px solid gray;padding:0.5em;">\n};
print qq{<tr><td class="bra">$lex{Student}</td>\n};
print qq{<td>$firstname $lastname ($studnum)</td></tr>\n};

# Date
print qq{<tr><td class="bra">$lex{Date}</td>\n};
print qq{<td class="la"><input type="text" Name="absdate" size="12" value="$absdate"></td></tr>\n};

# Reason
print qq{<tr><td class="bra">$lex{Reason}</td><td class="la">};
print qq{<select name="reason"><option>$reason</option>\n};
foreach my $reason ( @attend ) {  print qq{<option>$reason</option>\n}; }
print qq{</select></td></tr>\n};

# Period
print qq{<tr><td class="bra">$lex{Period}</td>\n};
print qq{<td class="la"><select name="period"><option>$period</option>};
for my $p (1..$ppd) {
    if ( $p == $period ) { next; }
    print qq{<option>$p</option>};
}
  
print qq{</select></td></tr>\n};

# Get Course Name
$sth1 = $dbh->prepare("select description from subject where subjsec = ?");
$sth1->execute( $subjsec  );
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
my $desc = $sth1->fetchrow;

# Course
print qq{<tr><td class="bra">$lex{Course}</td>\n<td class="la">};
print qq{<input type="text" Name="subjsec" style="width:12ch;" maxlength="32" value="$subjsec">};
print qq{ $desc</td></tr>\n};

# Late
print qq{<tr><td class="bra">$lex{Late} ($lex{min})</td>\n<td class="la">};
print qq{<input type="text" Name="late" size="4" value="$late"></td></tr>\n};

print qq{<tr><td></td><td class="la"><input type="submit" value="$lex{Update}"></td></tr>\n};
print qq{</table>\n};
print qq{</form></body></html>\n};



#---------------
sub updateRecord {
#---------------

    my $sth = $dbh->prepare("update attend set
      absdate = ?, reason = ?, period = ?, 
      subjsec = ?, late = ?  where attid = ?");


    if ( not $arr{late} ) { $arr{late} = undef; }
    if ( not $arr{subjsec} ) { $arr{subjsec} = undef; }


    $sth->execute( $arr{absdate}, $arr{reason}, $arr{period} ,
		   $arr{subjsec}, $arr{late}, $arr{attid} );


    if ( not $DBI::errstr ) {
	print qq{<h3>$lex{'Record(s) Updated'}</h3>};

    } else {
	print qq{<h3>$lex{Error}: $DBI::errstr<br>\n};
	print qq{$lex{Contact} $adminname };
	print qq{<a href="mailto:$adminemail">$adminemail</a></h3>\n };

    }

    print qq{<p>[ <a href="$attpage">$lex{Attendance}</a> ]</p>\n};

    # Another Form
    print qq{<p><form action="attdeled.pl" method="post">\n};
    print qq{<select name="date"><option>$lex{Today}</option>\n};
    print qq{<option>$lex{Yesterday}</option><option>$lex{All}</option></select>\n};
    print qq{<input type="submit" value="};
    print qq{$lex{Edit}/$lex{Delete} $lex{Another}"></form></p>\n};

    print qq{</center></body></html>\n};

    exit;

}
