#!/usr/bin/perl
#  Copyright 2001-2022 Leslie Richardson

#  This file is part of Open Admin for Schools.


use DBI;
use CGI;

my %lex = ('Power Delete Attendance' => 'Power Delete Attendance',
	   'Name' => 'Name',
	   'Subject' => 'Subject',
	   'Period' => 'Period',
	   'Reason' => 'Reason',
	   'Date' => 'Date',
	   'Delete' => 'Delete',
	   'Selected Records' => 'Selected Records',
	   'There will be no confirmation of deletion.' => 
	     'There will be no confirmation of deletion.',
	   'Record(s) Deleted' => 'Record(s) Deleted',
	   'Error' => 'Error',
	   'Main' => 'Main',
	   'Attendance' => 'Attendance',
	   'WD = Withdrawn' => 'WD = Withdrawn',
	   'Not Found' => 'Not Found',
	   'Continue' => 'Continue',
	   

    );


eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

# Get Date
my @tim = localtime(time);
my $year = @tim[5] + 1900;
my $month = @tim[4] + 1;
my $day = @tim[3];
my $currdate = "$year-$month-$day";
my $currdate1 = "@month[$month] $day, $year";


$dsn = "DBI:$dbtype:dbname=$dbase";
$dbh = DBI->connect($dsn,$user,$password);


my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;


# Print Page Head
my $title = $lex{'Power Delete Attendance'};
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};

if ( not $arr{page} ) {
    print qq{<link rel="stylesheet" type="text/css" media="all" };
    print qq{href="/js/calendar-blue.css" title="blue">\n};
    print qq{<script type="text/javascript" src="/js/calendar.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/lang/calendar-en.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/calendar-setup.js"></script>\n};
}

print qq{$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$attpage">$lex{Attendance}</a> ]\n};

my $date;
if ( not ($arr{date} =~ m/[-]/) ){ #We have a date, check for "-" presence
    $day = substr($arr{date},4,2);
    $month = substr($arr{date},2,2);
    $year = "20".substr($arr{date},0,2);
    $date = "$year-$month-$day";  # Date to reset
} else {
    $date = $arr{date};
}

print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    showRecords();

} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    deleteRecords();
}



#----------------
sub showStartPage {
#----------------


    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};
    
    print qq{<table cellpadding="0" cellspacing="3" border="0">};

    print qq{<tr><td class="bra">$lex{Attendance} $lex{Date}</td>\n};
    print qq{<td class="la"><input type="text" id="date" name="date" size="8">\n};
    print qq{<button type="reset" id="start_trigger">...</button></td></tr>\n};
    print qq{<tr><td></td><td class="la"><input type="submit" value="$lex{Continue}"></td></tr>\n};
    print qq{</table>\n};
    
    print qq{</form>\n};
    
    print qq{<script type="text/javascript">
 Calendar.setup({
  inputField  : "date",
  ifFormat    : "%Y-%m-%d",
  button      : "start_trigger",
  singleClick : false,
  step : 1
  });
</script>\n};

    print qq{</body></html>\n};

    exit;
}


#--------------
sub showRecords {
#--------------

    if ( not $date ) {
	print qq{<h3>$lex{Date} $lex{'Not Found'}</h3>\n};
	print qq{</body></html>\n};
	exit;
    }
    
    print qq{<h3>Date $date</h3>\n};

    # Setup Form
    print qq{<form action="attpwrdel.pl" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n};

    print qq{<input type="submit" value="$lex{Delete} $lex{'Selected Records'}">\n};
    print qq{<div style="color:red;margin-bottom:0.5em;">};
    print qq{$lex{'There will be no confirmation of deletion.'}</div>\n};


    $sth = $dbh->prepare("select a.* from attend as a, studentall as s 
      where absdate = ? and a.studentid = s.studnum order by s.lastname, 
      s.firstname, studentid, period");
    $sth->execute( $date );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}

    
    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
    print qq{<caption><font color="red">$lex{'WD = Withdrawn'}</font></caption>\n};
    print qq{<tr><th>$lex{Name}</th><th>$lex{Subject}</th>\n};
    print qq{<th>$lex{Period}</th><th>$lex{Reason}</th>\n};
    print qq{<th>$lex{Date}</th><th>$lex{Delete}</th></tr>\n};

    my $sth1 = $dbh->prepare("select lastname,firstname from student where studnum = ?");

    $currstud = -1;

    while ( my ($attid, $studnum, $absdate, $reason, $period, $subjsec,$late) = $sth->fetchrow ) {
	
	my $wd;

	# Get the Name from Student
	$sth1->execute( $studnum );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	my ( $lastname, $firstname ) = $sth1->fetchrow;

	if ( not $lastname ){
	    my $sth2 = $dbh->prepare("select lastname,firstname from studentwd where studnum = ?");
	    $sth2->execute( $studnum );
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	    ( $lastname, $firstname ) = $sth2->fetchrow;
	    if ( not $lastname ) { $lastname = $lex{'Not Found'}; }
	    $wd = qq{<span style="color:red">WD</span>};
	}

	my $name = "$wd <b>$lastname</b>, $firstname";
    
	$prevstud = $currstud; 
	$currstud = $studnum;
	if ($currstud != $prevstud){ # reset color
	    if ( $color eq 'blue' ){ $color = 'gray'; } else { $color = 'blue';} 
	}

	print qq{<tr class="$color"><td>$name ($studnum)</td>\n};
	print qq{<td>$subjsec</td><td>$period</td><td>$reason</td>\n};
	print qq{<td>$absdate</td><td><input type="checkbox" name="$attid" value="1">};
	print qq{</td></tr>\n};
    }

    print qq{</table>\n};
    print qq{<input type="submit" value="$lex{Delete} $lex{'Selected Records'}">\n};
    print qq{</form>\n};

    print qq{<div style="color:red;">};
    print qq{$lex{'There will be no confirmation of deletion.'}</div>\n};
    print qq{</body></html>\n};

    exit;
}


#---------------
sub deleteRecords {
#---------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    
    foreach my $key ( keys %arr ) { 

	#print qq{Key: $key  Value: $arr{$key}<br>\n} ;
	$sth = $dbh->prepare("delete from attend where attid = ?");
	$sth->execute( $key );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

    }

    if ( not $DBI::errstr ) {
	print qq{<h3>$lex{'Record(s) Deleted'}</h3>};
	
    } else {
	print qq{<h3>$lex{Error}: $DBI::errstr</h3>\n};
    }

    print qq{<p>[ <a href="$attpage">$lex{Attendance}</a> ]</p>\n};
    print qq{</body></html>\n};

    exit;

}
