#!/usr/bin/perl
#  Copyright 2001-2014 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my $color1 = '#DDF'; # blue
my $color2 = '#DFD'; # green
my $redcolor = '#FAA'; # red

my %lex = ('Teacher Attendance' => 'Teacher Attendance',
	   'Check' => 'Check',
	   'Main' => 'Main',
	   'Attendance' => 'Attendance',
	   'Not Found' => 'Not Found',
	   'Date' => 'Date',
	   'Name' => 'Name',
	   'Date/Time' => 'Date/Time',
	   'Error' => 'Error',
	   'Periods' => 'Periods',
	   'Subjects' => 'Subjects',
	   'Homeroom' => 'Homeroom',
	   'Entry' => 'Entry',

	   );

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $checkdate;
if (not $arr{date}) {
  my @tim = localtime(time);
  my $year = @tim[5] + 1900;
  my $month = @tim[4] + 1;
  my $day = @tim[3];
  $checkdate = "$year-$month-$day";
} else {
    $checkdate = $arr{date};
}


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $sth = $dbh->prepare("select lastname, firstname, userid from staff
  where doatt = 'Y' order by lastname, firstname");
$sth->execute;
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

my $title = "$lex{Check} $lex{'Teacher Attendance'}";
print "$doctype\n<html><head><title>$title</title>
 <link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">
 $chartype\n</head><body>\n";
print "[ <a href=\"$homepage\">$lex{Main}</a> | 
 <a href=\"$attpage\">$lex{Attendance}</a> ]
 <center><h1>$title</h1>\n";


print "<div style=\"padding:0.5em;\">$lex{Check} $lex{Date} $checkdate</div>\n";

print qq{<table cellpadding="3" border="1" cellspacing="0">\n};
print qq{<tr><th>$lex{Name}</th><th>$lex{Attendance}<br>$lex{Date}</th><th>$lex{Entry}<br>$lex{'Date/Time'}</th>};
print qq{<th>$lex{Homeroom}<br>$lex{Subjects}</th><th>$lex{Periods}</th></tr>\n};

my $backgroundcolor = $color1;


# Loop through all teachers doing attendance
while ( my ($lastname, $firstname, $userid) = $sth->fetchrow ) {

    # toggle background color;
    if ($backgroundcolor eq $color1 ) { $backgroundcolor = $color2 } else { $backgroundcolor = $color2; }

    $sth1 = $dbh->prepare("select * from tattend 
      where userid = ? and to_days(attdate) = to_days('$checkdate')");
    $sth1->execute( $userid ) ;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr;}

    my $first = 1;
    while ( my $ref = $sth1->fetchrow_hashref ) {
	$first = 0;
	print qq{<tr style="background-color:$backgroundcolor;"><td><b>$firstname $lastname ($userid)</b></td>};
	print "<td>$ref->{attdate}</td><td>$ref->{currdate}</td><td>$ref->{subjects}</td><td>$ref->{periods}</td></tr>\n";
	
    }

    if ( $first ) {
	print qq{<tr style="background-color:$redcolor;"><td><b>$firstname $lastname($userid)</b></td>};
	print qq{<td colspan="4">$lex{'Not Found'}</td></tr>\n};
    }

}

print "</table></body></html>\n";
