#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Eoy' => 'Eoy',
	   'Configuration' => 'Configuration',
	   'Entry' => 'Entry',
	   'Error' => 'Error',
	   'Section' => 'Section',
	   'Name' => 'Name',
	   'Value' => 'Value',
	   'Type' => 'Type',
	   'Version' => 'Version',
	   'Description' => 'Description',
	   'Sequence' => 'Sequence',
	   'File' => 'File',
	   'Linked' => 'Linked',
	   'Record' => 'Record',
	   'Save' => 'Save',
	   'Record(s) Added' => 'Record(s) Added',
	   'Eoy' => 'Eoy',

	   );

my $self = 'confadminadd.pl';

my @types = qw( scalar scalaronoff array hash hashofarray arrayofhash ); # data types

my %files = ( 'repcard' => 'Report Card', 
	      'admin' => 'Administration', 
	      'first_nation' => 'First Nation',
	      'transcript' => 'Transcript',
	      'gbook' => 'Grade Book',
	      'image' => 'Image Management',
	      'schedule' => 'Timetable',
	      'fees' => 'Fees',
	      'ldap' => 'LDAP - User Management',
	      'usermanage' => 'User Management',
	      'repcardOVR' => 'Report Card Override - Teacher',
    );

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}


my $q = CGI->new;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# Page Header
print qq{$doctype\n<html><head><title>$lex{Configuration} $lex{Entry}</title>
<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head><body>\n};

print qq{[ <a href="$eoypage">$lex{Eoy}</a> ]\n};
print qq{<h1>$lex{Configuration} $lex{Entry}</h1>\n};

#foreach my $key ( keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

if ( not $arr{page} ) {
    showStartPage();

} else {
    delete $arr{page};
    writeValues();
}


#----------------
sub showStartPage {
#----------------

    #foreach my $key ( sort keys %arr) { print qq{K:$key V:$arr{$key}<br>\n}; }

    # Start Form
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};
    print qq{<p><input type="submit" value="$lex{Save} "></p>\n};

    # Start Table
    print qq{<table cellpadding="3" cellspacing="0" border="0">\n};

    # File Name
    print qq{<tr><td class="ra">$lex{File}</td>\n<td>};
    print qq{<select name="filename"><option></option>\n};
    foreach my $key ( sort keys %files ) {
	print qq{<option value="$key">$files{$key}</option>\n};
    }
    print qq{</select></td></tr>\n};


    # Section Name
    print qq{<tr><td class="ra">$lex{Section}</td>\n};
    print qq{<td><input type="text" name="sectionname" size="20"></td></tr>\n};

    # Sequence Value
    print qq{<tr><td class="ra">$lex{Sequence}</td>\n<td>};
    print qq{<input type="text" name="sequenceval" size="5"></td></tr>\n};

    # Data Name
    print qq{<tr><td class="ra">$lex{Name}</td>\n<td>};
    print qq{<input type="text" name="dataname" size="20"></td></tr>\n};

    # Data Value
    print qq{<tr><td class="ra">$lex{Value}</td>\n<td>};
    print qq{<textarea name="datavalue" rows="4" cols="60"></textarea></td></tr>\n};


    # Datatype
    print qq{<tr><td class="ra">$lex{Type}</td>\n<td>};
    print qq{<select name="datatype"><option></option>\n};
    foreach my $type ( @types ) {
	if ( $type ne $rec{datatype} ) { print qq{<option>$type</option>\n}; }
    }
    print qq{<option></option></select>\n};


    # Linked Record (which supplies values)
    print qq{<tr><td class="ra">$lex{Linked} $lex{Record}</td>\n<td>};
    print qq{<input type="text" name="hashvar" size="8"></td></tr>\n};


    # Version
    print qq{<tr><td class="ra">$lex{Version}</td>\n<td>};
    print qq{<input type="text" name="version" size="20"></td></tr>\n};


    # Description
    print qq{<tr><td class="ra">$lex{Description}</td>\n<td>};
    print qq{<textarea rows="4" cols="80" name="description"></textarea></td></tr>\n};


    print qq{</table><p></p>\n};

    print qq{<input type="submit" value="$lex{Save} ">\n};
    print qq{</form></body></html>\n};

    exit;


} # end of showStartPage



#--------------
sub writeValues {
#--------------
    
    #foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $sth = $dbh->prepare("insert into conf_system 
     ( filename, sectionname, sequenceval, dataname, datatype, datavalue, hashvar, version, description )
     values ( ?, ?, ?, ?, ?, ?, ?, ?, ? )");
 
    $sth->execute( $arr{filename}, $arr{sectionname}, $arr{sequenceval}, 
      $arr{dataname}, $arr{datatype}, $arr{datavalue}, $arr{hashvar}, $arr{version}, $arr{description} );


    if ( not $DBI::errstr ) {
	print qq{<h3>$lex{'Record(s) Added'}</h3>\n};
    } else {
	print qq{<h3>$lex{Error}: $DBI::errstr</h3>\n};
    }

    print qq{<p>[ <a href="$eoypage">$lex{Eoy}</a> ]</p>\n};

    print qq{<p><form action="$self" method="post">\n};
    print qq{<input type="submit" value="$lex{Configuration} $lex{Entry}">\n};
    print qq{</form></p>\n};

    print qq{</body></html>\n};

    exit;

} # End of writeValues;

