#!/usr/bin/perl
#  Copyright 2001-2023 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Main' => 'Main',
	   'Export' => 'Export',
	   'Error' => 'Error',
	   'Add' => 'Add',
	   'Logo' => 'Logo',
	   'File' => 'File',
	   'Only' => 'Only',
	   'Cannot open file' => 'Cannot open file',
	   'Maximum File Upload size exceeded!' => 'Maximum File Upload size exceeded!',
	   'Uploaded' => 'Uploaded',
	   'Continue' => 'Continue',
	   'Alternate' => 'Alternate',
	   'Division' => 'Division',
	   'Report Card' => 'Report Card',
	   'Small' => 'Small',
	   'School' => 'School',
	   'Type' => 'Type',
	   'Name' => 'Name',
	   'Mistake' => 'Mistake',

	   );


use CGI;
use DBI;

my $self = 'logoadd.pl';

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

eval require "../../etc/image.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
my %arr= $q->Vars;
print $q->header( -charset, $charset );

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


print qq{$doctype\n<html><head><title>$lex{Add} $lex{Logo}</title>
<link rel="stylesheet" type="text/css" href="$css">
$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$eoypage">Eoy</a> ]\n};

print qq{<h1>$lex{Add} $lex{Logo}</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    getFileUpload();

}



#----------------
sub showStartPage {
#----------------

    print qq{<form action="$self" method="post"  enctype="multipart/form-data">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<table cellpadding="3" cellspacing="0" border="0">\n};
    
    print qq{<tr><td>$lex{File} $lex{Name}</td><td><input type="file" name="filename"></td></tr>\n};

    print qq{<tr><td>$lex{File} $lex{Type}</td><td>\n};
    print qq{<select name="filetype"><option value="1">$lex{School} Main Page $lex{Logo} ~200px gif};
    print qq{</option>\n};
    print qq{<option value="2">$lex{School} Admin Pages $lex{Small} $lex{Logo} ~100px gif</option>\n};
    print qq{<option value="3">$lex{'Report Card'} $lex{Logo} ~500px jpg</option>\n};
    print qq{<option value="4">$lex{'Report Card'} $lex{Division} $lex{Logo} ~500px jpg};
    print qq{</select></td></tr>\n};

    print qq{<tr><td colspan="2" class="la">};
    print qq{<input type="submit" value="$lex{Continue}">\n};
    print qq{</td></tr></table></form></body></html>\n};

    exit;

}


#----------------
sub getFileUpload {
#----------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # Passed: filename and filetype (numeric 1-4)

     if ( not $arr{filename} or not $arr{filetype} ) {
	print qq{<h3>No File or type Specified!</h3>\n};
	print qq{</body></html>\n};
	exit;
    }

    my $type = $arr{filetype};
    my $file = $q->param("filename"); 
    my ($name, $ext); 

    # this stuff is confused below, but it works. I'll leave for now. 
    if ( $file ) {
	$filename = $file;  # filename is output filename, file is input.
	$filename =~ s!^.*(\\|\/)!!;
	$filename =~ s/\s*//g; # strip any spaces.
	$filename = lc($filename);
	@name = split /\./, $filename; # split on dots.
	$ext = $name[$#name];  # last element is the extension.
	unless ($ext eq 'jpg' or $ext eq 'gif'){
	    print "<b>$lex{File} - jpg,gif $lex{Only}!</b>";
	    print "</body></html>\n";
	    exit;
	}

	pop(@name); # pull off extension.
	foreach $n (@name){ $name .= "$n.";} # assemble name 
	chop; # remove trailing dot
    
	# print "Name: $name Extension: $ext<br>\n";

	open (OUTFILE, ">$filename") || 
	die $lex{'Cannot open file'}. " $filename\n"; 
	my $bufcount = 0;
	while (my $bytesread = read($file, my $buffer, 1024)) { 
	    print OUTFILE $buffer;
	    $bufcount++;
	    if ($bufcount > $maxbufcount){
		print "<h1>". $lex{'Maximum File Upload size exceeded!'};
		print "($maxbufcount K)</h1>\n";
		print "</body></html>\n";
		die $lex{'Maximum File Upload size exceeded!'}. "\n";
	    }
	} 
	
	close (OUTFILE);
    }


#    my ($dud, $type) = split(/\(/, $arr{filetype});
#    chop $type;
    # print "Type:$type<br>\n";


    # Process File
    if ( $ext eq 'gif' ) { # move and link into admin/images

	my $imagedir = $downloaddir;
	$imagedir =~ s/download$/images/;
#	print qq{Imagedir: $imagedir<br>\n};

	system("mv -f $filename $imagedir");
	chdir $imagedir;

	if ( $type == 1 ) { # full logo
	    if ( $filename ne 'logo.gif' ) {
		unlink 'logo.gif';
		symlink $filename, 'logo.gif';
	    }

	} elsif ( $type == 2 ) { # thumbnail logo
	    if ( $filename ne 'logotn.gif' ) {
		unlink 'logotn.gif';
		symlink $filename, 'logotn.gif';
	    }

	} else { # mistake
	    unlink $filename;
	    print qq{$lex{Error}: <b>$lex{File} $lex{Type} $lex{Mistake}</b>:  $filename<br>\n};
	    print qq{</body></html>\n};
	    exit;
	}

    } elsif ($ext eq 'jpg') {  # move and link with etc/schoollogo.jpg

	my $imagedir = '../../etc';
	system("mv -f $filename $imagedir");
	chdir $imagedir;

	if ( $type == 3 ) { # logo for report card
	    if ( $filename ne 'schoollogo.jpg' ) {
		unlink 'schoollogo.jpg'; # remove existing file/link
		symlink $filename, 'schoollogo.jpg';
	    }
	} elsif ( $type == 4 ) { # division logo for report card
	    if ( $filename ne 'divisionlogo.jpg' ) {
		unlink 'divisionlogo.jpg';
		symlink $filename, 'divisionlogo.jpg';
	    }
	} else { # mistake
	    unlink $filename;
	    print qq{$lex{Error}: <b>$lex{File} $lex{Type} $lex{Mistake}</b>: $filename<br>\n};
	    print qq{</body></html>\n};
	    exit;
	}
	

    } else {
	
	print qq{$lex{Error}: $lex{'Cannot open file'}: $ext\n};
	print qq{</body></html>\n};
	exit;
    }


    print qq{<p style="font-size: 150%;">$filename $lex{Uploaded}</p>\n};
    print qq{</body></html>\n};


}
